package org.sireum {
  @datatype sealed trait Either[L, R] extends _root_.org.sireum.DatatypeSig {
    @pure def isLeft: B;
    @pure def isRight: B;
    @pure def leftOpt: Option[L];
    @pure def left: L;
    @pure def rightOpt: Option[R];
    @pure def right: R
  }

  object Either {
    object Left {
      def apply[L, R](value: L): Left[L, R] = new Left(value);
      def unapply[L, R](o: Left[L, R]): _root_.scala.Option[L] = _root_.scala.Some(o.value)
    };
    @datatype final class Left[L, R](__value: L) extends Either[L, R] with _root_.org.sireum.DatatypeSig {
      private[this] val _value = __value;
      def value = _value;
      def getValue = _value;
      override def toString: _root_.java.lang.String = if ($hasString)
        super.string.value
      else
        {
          val sb = new _root_.java.lang.StringBuilder();
          sb.append("Left");
          sb.append('(');
          sb.append(_root_.org.sireum.String.escape(this.value));
          sb.append(')');
          sb.toString
        };
      override def string: _root_.org.sireum.String = if ($hasString)
        super.string
      else
        toString;
      override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
        super.hashCode
      else
        _root_.scala.Seq(this.getClass, value).hashCode;
      override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
        super.equals(o)
      else
        if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
          true
        else
          o match {
            case (o @ ((_): Left[L, R] @unchecked)) => if (this.hashCode.!=(o.hashCode))
              false
            else
              this.value.==(o.value)
            case _ => false
          };
      def apply(value: L = this.value): Left[L, R] = new Left(value);
      override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Left")), scala.Tuple2("value", this.value));
      @pure override def isLeft: B = {
        StringContext(" ensures result ≡ T ").lUnit();
        return _root_.org.sireum.helper.$assign(T)
      };
      @pure override def isRight: B = {
        StringContext(" ensures result ≡ F ").lUnit();
        return _root_.org.sireum.helper.$assign(F)
      };
      @pure override def leftOpt: Option[L] = {
        StringContext(" ensures result ≡ Some(value) ").lUnit();
        return _root_.org.sireum.helper.$assign(Some(value))
      };
      @pure override def left: L = {
        StringContext(" ensures result ≡ value ").lUnit();
        return _root_.org.sireum.helper.$assign(value)
      };
      @pure override def rightOpt: Option[R] = {
        StringContext(" ensures result ≡ None[R]() ").lUnit();
        return _root_.org.sireum.helper.$assign(None())
      };
      @pure override def right: R = {
        StringContext(" requires F ").lUnit();
        halt(_root_.org.sireum.String("Invalid \'Either.Left\' operation \'right\'."))
      }
    };
    object Right {
      def apply[L, R](value: R): Right[L, R] = new Right(value);
      def unapply[L, R](o: Right[L, R]): _root_.scala.Option[R] = _root_.scala.Some(o.value)
    };
    @datatype final class Right[L, R](__value: R) extends Either[L, R] with _root_.org.sireum.DatatypeSig {
      private[this] val _value = __value;
      def value = _value;
      def getValue = _value;
      override def toString: _root_.java.lang.String = if ($hasString)
        super.string.value
      else
        {
          val sb = new _root_.java.lang.StringBuilder();
          sb.append("Right");
          sb.append('(');
          sb.append(_root_.org.sireum.String.escape(this.value));
          sb.append(')');
          sb.toString
        };
      override def string: _root_.org.sireum.String = if ($hasString)
        super.string
      else
        toString;
      override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
        super.hashCode
      else
        _root_.scala.Seq(this.getClass, value).hashCode;
      override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
        super.equals(o)
      else
        if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
          true
        else
          o match {
            case (o @ ((_): Right[L, R] @unchecked)) => if (this.hashCode.!=(o.hashCode))
              false
            else
              this.value.==(o.value)
            case _ => false
          };
      def apply(value: R = this.value): Right[L, R] = new Right(value);
      override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Right")), scala.Tuple2("value", this.value));
      @pure override def isLeft: B = {
        StringContext(" ensures result ≡ F ").lUnit();
        return _root_.org.sireum.helper.$assign(F)
      };
      @pure override def isRight: B = {
        StringContext(" ensures result ≡ T ").lUnit();
        return _root_.org.sireum.helper.$assign(T)
      };
      @pure override def leftOpt: Option[L] = {
        StringContext(" ensures result ≡ None[L]() ").lUnit();
        return _root_.org.sireum.helper.$assign(None())
      };
      @pure override def left: L = {
        StringContext(" requires F ").lUnit();
        halt(_root_.org.sireum.String("Invalid \'Either.Right\' operation \'left\'."))
      };
      @pure override def rightOpt: Option[R] = {
        StringContext(" ensures result ≡ Some(value) ").lUnit();
        return _root_.org.sireum.helper.$assign(Some(value))
      };
      @pure override def right: R = {
        StringContext(" ensures result ≡ value ").lUnit();
        return _root_.org.sireum.helper.$assign(value)
      }
    };
    @pure def left[L, R](value: L): Either[L, R] = return _root_.org.sireum.helper.$assign(Left(value));
    @pure def right[L, R](value: R): Either[L, R] = return _root_.org.sireum.helper.$assign(Right(value))
  }
}