package org.sireum {
  object Graph {
    type Index = Z;
    @datatype sealed trait Edge[V, E] extends _root_.org.sireum.DatatypeSig {
      @pure def source: V;
      @pure def dest: V;
      @pure def toInternal(map: HashMap[V, Graph.Index]): Internal.Edge[E]
    };
    object Edge {
      object Plain {
        def apply[V, E](source: V, dest: V): Plain[V, E] = new Plain(source, dest);
        def unapply[V, E](o: Plain[V, E]): _root_.scala.Option[scala.Tuple2[V, V]] = _root_.scala.Some(scala.Tuple2(o.source, o.dest))
      };
      @datatype final class Plain[V, E](__source: V, __dest: V) extends Edge[V, E] with _root_.org.sireum.DatatypeSig {
        private[this] val _source = __source;
        def source = _source;
        def getSource = _source;
        private[this] val _dest = __dest;
        def dest = _dest;
        def getDest = _dest;
        override def toString: _root_.java.lang.String = if ($hasString)
          super.string.value
        else
          {
            val sb = new _root_.java.lang.StringBuilder();
            sb.append("Plain");
            sb.append('(');
            sb.append(_root_.org.sireum.String.escape(this.source));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.dest));
            sb.append(')');
            sb.toString
          };
        override def string: _root_.org.sireum.String = if ($hasString)
          super.string
        else
          toString;
        override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
          super.hashCode
        else
          _root_.scala.Seq(this.getClass, source, dest).hashCode;
        override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
          super.equals(o)
        else
          if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
            true
          else
            o match {
              case (o @ ((_): Plain[V, E] @unchecked)) => if (this.hashCode.!=(o.hashCode))
                false
              else
                this.source.==(o.source).&&(this.dest.==(o.dest))
              case _ => false
            };
        def apply(source: V = this.source, dest: V = this.dest): Plain[V, E] = new Plain(source, dest);
        override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Plain")), scala.Tuple2("source", this.source), scala.Tuple2("dest", this.dest));
        @pure override def toInternal(map: HashMap[V, Graph.Index]): Internal.Edge[E] = return _root_.org.sireum.helper.$assign(Internal.Edge.Plain(map.get(source).get, map.get(dest).get))
      };
      object Data {
        def apply[V, E](source: V, dest: V, data: E): Data[V, E] = new Data(source, dest, data);
        def unapply[V, E](o: Data[V, E]): _root_.scala.Option[scala.Tuple3[V, V, E]] = _root_.scala.Some(scala.Tuple3(o.source, o.dest, o.data))
      };
      @datatype final class Data[V, E](__source: V, __dest: V, __data: E) extends Edge[V, E] with _root_.org.sireum.DatatypeSig {
        private[this] val _source = __source;
        def source = _source;
        def getSource = _source;
        private[this] val _dest = __dest;
        def dest = _dest;
        def getDest = _dest;
        private[this] val _data = __data;
        def data = _data;
        def getData = _data;
        override def toString: _root_.java.lang.String = if ($hasString)
          super.string.value
        else
          {
            val sb = new _root_.java.lang.StringBuilder();
            sb.append("Data");
            sb.append('(');
            sb.append(_root_.org.sireum.String.escape(this.source));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.dest));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.data));
            sb.append(')');
            sb.toString
          };
        override def string: _root_.org.sireum.String = if ($hasString)
          super.string
        else
          toString;
        override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
          super.hashCode
        else
          _root_.scala.Seq(this.getClass, source, dest, data).hashCode;
        override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
          super.equals(o)
        else
          if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
            true
          else
            o match {
              case (o @ ((_): Data[V, E] @unchecked)) => if (this.hashCode.!=(o.hashCode))
                false
              else
                this.source.==(o.source).&&(this.dest.==(o.dest)).&&(this.data.==(o.data))
              case _ => false
            };
        def apply(source: V = this.source, dest: V = this.dest, data: E = this.data): Data[V, E] = new Data(source, dest, data);
        override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Data")), scala.Tuple2("source", this.source), scala.Tuple2("dest", this.dest), scala.Tuple2("data", this.data));
        @pure override def toInternal(map: HashMap[V, Graph.Index]): Internal.Edge[E] = return _root_.org.sireum.helper.$assign(Internal.Edge.Data(map.get(source).get, map.get(dest).get, data))
      }
    };
    object Internal {
      @datatype sealed trait Edge[E] extends _root_.org.sireum.DatatypeSig {
        @pure def source: Graph.Index;
        @pure def dest: Graph.Index;
        @pure def toEdge[V](map: ISZ[V]): Graph.Edge[V, E]
      };
      @datatype sealed trait Edges[E] extends _root_.org.sireum.DatatypeSig {
        @pure def elements: ISZ[Internal.Edge[E]];
        @pure def size: Z;
        @pure def +(e: Internal.Edge[E]): Edges[E];
        @pure def ++(es: ISZ[Internal.Edge[E]]): Edges[E];
        @pure def -#(p: scala.Tuple2[Internal.Edge[E], Z]): Edges[E]
      };
      object Edges {
        object Set {
          def apply[E](set: HashSet[Internal.Edge[E]]): Set[E] = new Set(set);
          def unapply[E](o: Set[E]): _root_.scala.Option[HashSet[Internal.Edge[E]]] = _root_.scala.Some(o.set)
        };
        @datatype final class Set[E](__set: HashSet[Internal.Edge[E]]) extends Edges[E] with _root_.org.sireum.DatatypeSig {
          private[this] val _set = __set;
          def set = _set;
          def getSet = _set;
          override def toString: _root_.java.lang.String = if ($hasString)
            super.string.value
          else
            {
              val sb = new _root_.java.lang.StringBuilder();
              sb.append("Set");
              sb.append('(');
              sb.append(_root_.org.sireum.String.escape(this.set));
              sb.append(')');
              sb.toString
            };
          override def string: _root_.org.sireum.String = if ($hasString)
            super.string
          else
            toString;
          override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
            super.hashCode
          else
            _root_.scala.Seq(this.getClass, set).hashCode;
          override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
            super.equals(o)
          else
            if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
              true
            else
              o match {
                case (o @ ((_): Set[E] @unchecked)) => if (this.hashCode.!=(o.hashCode))
                  false
                else
                  this.set.==(o.set)
                case _ => false
              };
          def apply(set: HashSet[Internal.Edge[E]] = this.set): Set[E] = new Set(set);
          override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Set")), scala.Tuple2("set", this.set));
          @pure override def elements: ISZ[Internal.Edge[E]] = return _root_.org.sireum.helper.$assign(set.elements);
          @pure override def size: Z = return _root_.org.sireum.helper.$assign(set.size);
          @pure override def +(e: Graph.Internal.Edge[E]): Edges[E] = return _root_.org.sireum.helper.$assign(this(set.+(e)));
          @pure override def ++(es: ISZ[Internal.Edge[E]]): Edges[E] = return _root_.org.sireum.helper.$assign(this(set.++(es)));
          @pure override def -#(p: scala.Tuple2[Internal.Edge[E], Z]): Edges[E] = return _root_.org.sireum.helper.$assign(this(set.-(p._1)))
        };
        object Bag {
          def apply[E](set: HashBag[Internal.Edge[E]]): Bag[E] = new Bag(set);
          def unapply[E](o: Bag[E]): _root_.scala.Option[HashBag[Internal.Edge[E]]] = _root_.scala.Some(o.set)
        };
        @datatype final class Bag[E](__set: HashBag[Internal.Edge[E]]) extends Edges[E] with _root_.org.sireum.DatatypeSig {
          private[this] val _set = __set;
          def set = _set;
          def getSet = _set;
          override def toString: _root_.java.lang.String = if ($hasString)
            super.string.value
          else
            {
              val sb = new _root_.java.lang.StringBuilder();
              sb.append("Bag");
              sb.append('(');
              sb.append(_root_.org.sireum.String.escape(this.set));
              sb.append(')');
              sb.toString
            };
          override def string: _root_.org.sireum.String = if ($hasString)
            super.string
          else
            toString;
          override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
            super.hashCode
          else
            _root_.scala.Seq(this.getClass, set).hashCode;
          override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
            super.equals(o)
          else
            if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
              true
            else
              o match {
                case (o @ ((_): Bag[E] @unchecked)) => if (this.hashCode.!=(o.hashCode))
                  false
                else
                  this.set.==(o.set)
                case _ => false
              };
          def apply(set: HashBag[Internal.Edge[E]] = this.set): Bag[E] = new Bag(set);
          override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Bag")), scala.Tuple2("set", this.set));
          @pure override def elements: ISZ[Internal.Edge[E]] = return _root_.org.sireum.helper.$assign(set.elements);
          @pure override def size: Z = return _root_.org.sireum.helper.$assign(set.size);
          @pure override def +(e: Internal.Edge[E]): Edges[E] = return _root_.org.sireum.helper.$assign(this(set.+(e)));
          @pure override def ++(es: ISZ[Internal.Edge[E]]): Edges[E] = return _root_.org.sireum.helper.$assign(this(set.++(es)));
          @pure override def -#(p: scala.Tuple2[Internal.Edge[E], Z]): Edges[E] = return _root_.org.sireum.helper.$assign(this(set.-#(p)))
        };
        @pure def empty[E](multi: B): Edges[E] = return _root_.org.sireum.helper.$assign(if (multi)
          Bag(HashBag.empty)
        else
          Set(HashSet.empty))
      };
      object Edge {
        object Plain {
          def apply[E](source: Graph.Index, dest: Graph.Index): Plain[E] = new Plain(source, dest);
          def unapply[E](o: Plain[E]): _root_.scala.Option[scala.Tuple2[Graph.Index, Graph.Index]] = _root_.scala.Some(scala.Tuple2(o.source, o.dest))
        };
        @datatype final class Plain[E](__source: Graph.Index, __dest: Graph.Index) extends Edge[E] with _root_.org.sireum.DatatypeSig {
          private[this] val _source = __source;
          def source = _source;
          def getSource = _source;
          private[this] val _dest = __dest;
          def dest = _dest;
          def getDest = _dest;
          override def toString: _root_.java.lang.String = if ($hasString)
            super.string.value
          else
            {
              val sb = new _root_.java.lang.StringBuilder();
              sb.append("Plain");
              sb.append('(');
              sb.append(_root_.org.sireum.String.escape(this.source));
              sb.append(", ");
              sb.append(_root_.org.sireum.String.escape(this.dest));
              sb.append(')');
              sb.toString
            };
          override def string: _root_.org.sireum.String = if ($hasString)
            super.string
          else
            toString;
          override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
            super.hashCode
          else
            _root_.scala.Seq(this.getClass, source, dest).hashCode;
          override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
            super.equals(o)
          else
            if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
              true
            else
              o match {
                case (o @ ((_): Plain[E] @unchecked)) => if (this.hashCode.!=(o.hashCode))
                  false
                else
                  this.source.==(o.source).&&(this.dest.==(o.dest))
                case _ => false
              };
          def apply(source: Graph.Index = this.source, dest: Graph.Index = this.dest): Plain[E] = new Plain(source, dest);
          override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Plain")), scala.Tuple2("source", this.source), scala.Tuple2("dest", this.dest));
          @pure override def toEdge[V](map: ISZ[V]): Graph.Edge[V, E] = return _root_.org.sireum.helper.$assign(Graph.Edge.Plain(map(source), map(dest)))
        };
        object Data {
          def apply[E](source: Graph.Index, dest: Graph.Index, data: E): Data[E] = new Data(source, dest, data);
          def unapply[E](o: Data[E]): _root_.scala.Option[scala.Tuple3[Graph.Index, Graph.Index, E]] = _root_.scala.Some(scala.Tuple3(o.source, o.dest, o.data))
        };
        @datatype final class Data[E](__source: Graph.Index, __dest: Graph.Index, __data: E) extends Edge[E] with _root_.org.sireum.DatatypeSig {
          private[this] val _source = __source;
          def source = _source;
          def getSource = _source;
          private[this] val _dest = __dest;
          def dest = _dest;
          def getDest = _dest;
          private[this] val _data = __data;
          def data = _data;
          def getData = _data;
          override def toString: _root_.java.lang.String = if ($hasString)
            super.string.value
          else
            {
              val sb = new _root_.java.lang.StringBuilder();
              sb.append("Data");
              sb.append('(');
              sb.append(_root_.org.sireum.String.escape(this.source));
              sb.append(", ");
              sb.append(_root_.org.sireum.String.escape(this.dest));
              sb.append(", ");
              sb.append(_root_.org.sireum.String.escape(this.data));
              sb.append(')');
              sb.toString
            };
          override def string: _root_.org.sireum.String = if ($hasString)
            super.string
          else
            toString;
          override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
            super.hashCode
          else
            _root_.scala.Seq(this.getClass, source, dest, data).hashCode;
          override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
            super.equals(o)
          else
            if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
              true
            else
              o match {
                case (o @ ((_): Data[E] @unchecked)) => if (this.hashCode.!=(o.hashCode))
                  false
                else
                  this.source.==(o.source).&&(this.dest.==(o.dest)).&&(this.data.==(o.data))
                case _ => false
              };
          def apply(source: Graph.Index = this.source, dest: Graph.Index = this.dest, data: E = this.data): Data[E] = new Data(source, dest, data);
          override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Data")), scala.Tuple2("source", this.source), scala.Tuple2("dest", this.dest), scala.Tuple2("data", this.data));
          @pure override def toEdge[V](map: ISZ[V]): Graph.Edge[V, E] = return _root_.org.sireum.helper.$assign(Graph.Edge.Data(map(source), map(dest), data))
        }
      };
      @pure def addEdge[V, E](g: Graph[V, E], e: Internal.Edge[E]): Graph[V, E] = return _root_.org.sireum.helper.$assign(g(incomingEdges = g.incomingEdges.+(e.dest.~>(g.incomingEdges.get(e.dest).getOrElse(Edges.empty[E](g.multi)).+(e))), outgoingEdges = g.outgoingEdges.+(e.source.~>(g.outgoingEdges.get(e.source).getOrElse(Edges.empty[E](g.multi)).+(e)))));
      @pure def addPlainEdge[V, E](g: Graph[V, E], src: Graph.Index, dst: Graph.Index): Graph[V, E] = return _root_.org.sireum.helper.$assign(addEdge(g, Graph.Internal.Edge.Plain[E](src, dst)));
      @pure def addDataEdge[V, E](g: Graph[V, E], data: E, src: Graph.Index, dst: Graph.Index): Graph[V, E] = return _root_.org.sireum.helper.$assign(addEdge(g, Graph.Internal.Edge.Data(src, dst, data)));
      @pure def removeEdge[V, E](g: Graph[V, E], e: Graph.Internal.Edge[E], n: Z): Graph[V, E] = {
        if (g.incomingEdges.get(e.dest).isEmpty)
          return _root_.org.sireum.helper.$assign(g)
        else
          ();
        return _root_.org.sireum.helper.$assign(g(incomingEdges = g.incomingEdges.+(e.dest.~>(g.incomingEdges.get(e.dest).get.-#(e.~>(n)))), outgoingEdges = g.outgoingEdges.+(e.source.~>(g.outgoingEdges.get(e.source).get.-#(e.~>(n))))))
      };
      @pure def incoming[V, E](g: Graph[V, E], dst: Graph.Index): ISZ[Graph.Internal.Edge[E]] = _root_.org.sireum.helper.$tmatch(g.incomingEdges.get(dst)) match {
        case Some((s @ _)) => return _root_.org.sireum.helper.$assign(s.elements)
        case _ => return _root_.org.sireum.helper.$assign(ISZ())
      };
      @pure def outgoing[V, E](g: Graph[V, E], src: Graph.Index): ISZ[Graph.Internal.Edge[E]] = _root_.org.sireum.helper.$tmatch(g.outgoingEdges.get(src)) match {
        case Some((s @ _)) => return _root_.org.sireum.helper.$assign(s.elements)
        case _ => return _root_.org.sireum.helper.$assign(ISZ())
      }
    };
    @pure def empty[V, E]: Graph[V, E] = return _root_.org.sireum.helper.$assign(Graph(HashMap.empty, ISZ(), HashMap.empty, HashMap.empty, _root_.org.sireum.Z(0), F));
    @pure def emptyMulti[V, E]: Graph[V, E] = return _root_.org.sireum.helper.$assign(Graph(HashMap.empty, ISZ(), HashMap.empty, HashMap.empty, _root_.org.sireum.Z(0), T));
    def apply[V, E](nodes: HashMap[V, Graph.Index], nodesInverse: IS[Graph.Index, V], incomingEdges: HashMap[Graph.Index, Graph.Internal.Edges[E]], outgoingEdges: HashMap[Graph.Index, Graph.Internal.Edges[E]], nextNodeId: Graph.Index, multi: B): Graph[V, E] = new Graph(nodes, nodesInverse, incomingEdges, outgoingEdges, nextNodeId, multi);
    def unapply[V, E](o: Graph[V, E]): _root_.scala.Option[scala.Tuple6[HashMap[V, Graph.Index], IS[Graph.Index, V], HashMap[Graph.Index, Graph.Internal.Edges[E]], HashMap[Graph.Index, Graph.Internal.Edges[E]], Graph.Index, B]] = _root_.scala.Some(scala.Tuple6(o.nodes, o.nodesInverse, o.incomingEdges, o.outgoingEdges, o.nextNodeId, o.multi))
  }

  @datatype final class Graph[V, E](__nodes: HashMap[V, Graph.Index], __nodesInverse: IS[Graph.Index, V], __incomingEdges: HashMap[Graph.Index, Graph.Internal.Edges[E]], __outgoingEdges: HashMap[Graph.Index, Graph.Internal.Edges[E]], __nextNodeId: Graph.Index, __multi: B) extends _root_.org.sireum.DatatypeSig {
    private[this] val _nodes = __nodes;
    def nodes = _nodes;
    def getNodes = _nodes;
    private[this] val _nodesInverse = __nodesInverse;
    def nodesInverse = _nodesInverse;
    def getNodesInverse = _nodesInverse;
    private[this] val _incomingEdges = __incomingEdges;
    def incomingEdges = _incomingEdges;
    def getIncomingEdges = _incomingEdges;
    private[this] val _outgoingEdges = __outgoingEdges;
    def outgoingEdges = _outgoingEdges;
    def getOutgoingEdges = _outgoingEdges;
    private[this] val _nextNodeId = __nextNodeId;
    def nextNodeId = _nextNodeId;
    def getNextNodeId = _nextNodeId;
    private[this] val _multi = __multi;
    def multi = _multi;
    def getMulti = _multi;
    override def toString: _root_.java.lang.String = string.value;
    override lazy val hashCode: _root_.scala.Int = hash.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): Graph[V, E] @unchecked)) => isEqual(o)
        case _ => halt("Invalid equality test between ".+(this.getClass).+(" and ").+(o.getClass))
      };
    def apply(nodes: HashMap[V, Graph.Index] = this.nodes, nodesInverse: IS[Graph.Index, V] = this.nodesInverse, incomingEdges: HashMap[Graph.Index, Graph.Internal.Edges[E]] = this.incomingEdges, outgoingEdges: HashMap[Graph.Index, Graph.Internal.Edges[E]] = this.outgoingEdges, nextNodeId: Graph.Index = this.nextNodeId, multi: B = this.multi): Graph[V, E] = new Graph(nodes, nodesInverse, incomingEdges, outgoingEdges, nextNodeId, multi);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Graph")), scala.Tuple2("nodes", this.nodes), scala.Tuple2("nodesInverse", this.nodesInverse), scala.Tuple2("incomingEdges", this.incomingEdges), scala.Tuple2("outgoingEdges", this.outgoingEdges), scala.Tuple2("nextNodeId", this.nextNodeId), scala.Tuple2("multi", this.multi));
    @pure def *(node: V): Graph[V, E] = _root_.org.sireum.helper.$tmatch(nodes.get(node)) match {
      case Some(_) => return _root_.org.sireum.helper.$assign(this)
      case _ => return _root_.org.sireum.helper.$assign(this(nodes.+(node.~>(nextNodeId)), nodesInverse.:+(node), incomingEdges, outgoingEdges, nextNodeId.+(_root_.org.sireum.Z(1)), multi))
    };
    @pure def --*[I](ns: IS[I, V]): Graph[V, E] = {
      var r: Graph[V, E] = _root_.org.sireum.helper.$assign(if (multi)
        Graph.emptyMulti[V, E]
      else
        Graph.empty[V, E]);
      val ins = _root_.org.sireum.helper.$assign(HashSet.++(ns.map[Z](((n) => nodes.get(n).get))));
      incomingEdges.values.foreach(((es) => es.elements.foreach(((e) => if (ins.contains(e.source).&&(ins.contains(e.dest)))
        r = _root_.org.sireum.helper.$assign(r.addEdge(e.toEdge(nodesInverse)))
      else
        ()))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def +(edge: scala.Tuple2[V, V]): Graph[V, E] = return _root_.org.sireum.helper.$assign(addPlainEdge(edge._1, edge._2));
    @pure def +@(edge: scala.Tuple2[scala.Tuple2[V, V], E]): Graph[V, E] = return _root_.org.sireum.helper.$assign(addDataEdge(edge._2, edge._1._1, edge._1._2));
    @pure def -(edge: Graph.Edge[V, E]): Graph[V, E] = return _root_.org.sireum.helper.$assign(removeEdgeN(edge, _root_.org.sireum.Z(1)));
    @pure def -#(p: scala.Tuple2[Graph.Edge[V, E], Z]): Graph[V, E] = return _root_.org.sireum.helper.$assign(removeEdgeN(p._1, p._2));
    @pure def --[I](edges: IS[I, Graph.Edge[V, E]]): Graph[V, E] = {
      var r = _root_.org.sireum.helper.$assign(this);
      edges.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.-(e))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def incoming(dest: V): ISZ[Graph.Edge[V, E]] = _root_.org.sireum.helper.$tmatch(nodes.get(dest)) match {
      case Some((dst @ _)) => return _root_.org.sireum.helper.$assign(Graph.Internal.incoming(this, dst).map(((e) => e.toEdge(nodesInverse))))
      case _ => return _root_.org.sireum.helper.$assign(ISZ())
    };
    @pure def outgoing(source: V): ISZ[Graph.Edge[V, E]] = _root_.org.sireum.helper.$tmatch(nodes.get(source)) match {
      case Some((src @ _)) => Graph.Internal.outgoing(this, src).map[Graph.Edge[V, E]](((e) => e.toEdge(nodesInverse)))
      case _ => return _root_.org.sireum.helper.$assign(ISZ())
    };
    @pure def addEdge(edge: Graph.Edge[V, E]): Graph[V, E] = return _root_.org.sireum.helper.$assign(Graph.Internal.addEdge(this.*(edge.source).*(edge.dest), edge.toInternal(nodes)));
    @pure def addPlainEdge(source: V, dest: V): Graph[V, E] = {
      val r = _root_.org.sireum.helper.$assign(this.*(source).*(dest));
      return _root_.org.sireum.helper.$assign(Graph.Internal.addPlainEdge(r, r.nodes.get(source).get, r.nodes.get(dest).get))
    };
    @pure def addDataEdge(data: E, source: V, dest: V): Graph[V, E] = {
      val r = _root_.org.sireum.helper.$assign(this.*(source).*(dest));
      return _root_.org.sireum.helper.$assign(Graph.Internal.addDataEdge(r, data, r.nodes.get(source).get, r.nodes.get(dest).get))
    };
    @pure def allEdges: ISZ[Graph.Edge[V, E]] = return _root_.org.sireum.helper.$assign(incomingEdges.values.flatMap(((es) => es.elements.map(((e) => e.toEdge(nodesInverse))))));
    @pure def removeEdgeN(edge: Graph.Edge[V, E], n: Z): Graph[V, E] = return _root_.org.sireum.helper.$assign(Graph.Internal.removeEdge(this, edge.toInternal(nodes), n));
    @pure def edges(source: V, dest: V): ISZ[Graph.Edge[V, E]] = return _root_.org.sireum.helper.$assign(outgoing(source).withFilter(((e) => e.dest.==(dest))));
    @pure def numOfNodes: Z = return _root_.org.sireum.helper.$assign(nodes.size);
    @pure def numOfEdges: Z = {
      var r = StringContext("0").z();
      incomingEdges.values.map[Z](((s) => s.size)).foreach(((n) => r = _root_.org.sireum.helper.$assign(r.+(n))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure override def hash: Z = return _root_.org.sireum.helper.$assign(_root_.org.sireum.Z(scala.Tuple2(_root_.org.sireum.helper.$assign(numOfNodes), _root_.org.sireum.helper.$assign(numOfEdges)).hashCode));
    @pure def isEqual(other: Graph[V, E]): B = {
      if (nodes.size.!=(other.nodes.size).||(incomingEdges.size.!=(incomingEdges.size)))
        return _root_.org.sireum.helper.$assign(F)
      else
        ();
      if (nodes.keySet.!=(other.nodes.keySet))
        return _root_.org.sireum.helper.$assign(F)
      else
        ();
      val thisEdges: ISZ[Graph.Edge[V, E]] = _root_.org.sireum.helper.$assign(incomingEdges.values.flatMap(((ess) => ess.elements.map(((es) => es.toEdge(nodesInverse))))));
      val otherEdges: ISZ[Graph.Edge[V, E]] = _root_.org.sireum.helper.$assign(other.incomingEdges.values.flatMap(((ess) => ess.elements.map(((es) => es.toEdge(other.nodesInverse))))));
      return _root_.org.sireum.helper.$assign(HashSet.++(thisEdges).++(otherEdges).size.==(thisEdges.size))
    };
    @pure def toST(f: _root_.scala.Function1[V, ST @pure], g: _root_.scala.Function1[E, ST @pure]): ST = {
      @pure def e2st(e: Graph.Internal.Edge[E]): ST = _root_.org.sireum.helper.$tmatch(e) match {
        case Graph.Internal.Edge.Data((source @ _), (dest @ _), (data @ _)) => return StringContext("n", " -> n", " ", "").st(source, dest, g(data))
        case Graph.Internal.Edge.Plain((source @ _), (dest @ _)) => return StringContext("n", " -> n", "").st(source, dest)
      };
      val nodes: ISZ[ST] = _root_.org.sireum.helper.$assign(this.nodes.entries.map(((e) => StringContext("n", " ", "").st(e._2, f(e._1)))));
      val edges: ISZ[ST] = _root_.org.sireum.helper.$assign(incomingEdges.values.flatMap(((es) => es.elements.map(((e) => e2st(e))))));
      val r = StringContext("""digraph G {
      |
      |  """, """
      |
      |  """, """
      |
      |}""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(nodes), _root_.org.sireum.String("\n")), scala.Tuple2(_root_.org.sireum.helper.$assign(edges), _root_.org.sireum.String("\n")));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure override def string: String = return _root_.org.sireum.helper.$assign(toST(((v) => StringContext("[label=\"", "\"]").st(v)), ((e) => StringContext("[label=\"", "\"]").st(e))).render)
  }
}