package org.sireum {
  object HashMap {
    @pure def empty[K, V]: HashMap[K, V] = return _root_.org.sireum.helper.$assign(emptyInit[K, V](_root_.org.sireum.Z(12)));
    @pure def emptyInit[K, V](initialCapacity: Z): HashMap[K, V] = {
      val sz: Z = _root_.org.sireum.helper.$assign(if (initialCapacity.<=(_root_.org.sireum.Z(0)))
        _root_.org.sireum.Z(4)
      else
        initialCapacity.*(_root_.org.sireum.Z(4))./(_root_.org.sireum.Z(3)).+(_root_.org.sireum.Z(1)));
      return _root_.org.sireum.helper.$assign(HashMap[K, V](ISZ.create(sz, Map.empty), _root_.org.sireum.Z(0)))
    };
    @pure def ++[I, K, V](s: IS[I, scala.Tuple2[K, V]]): HashMap[K, V] = return _root_.org.sireum.helper.$assign(HashMap.emptyInit[K, V](s.zize).++(s));
    def apply[K, V](mapEntries: ISZ[Map[K, V]], size: Z): HashMap[K, V] = new HashMap(mapEntries, size);
    def unapply[K, V](o: HashMap[K, V]): _root_.scala.Option[scala.Tuple2[ISZ[Map[K, V]], Z]] = _root_.scala.Some(scala.Tuple2(o.mapEntries, o.size))
  }

  @datatype final class HashMap[K, V](__mapEntries: ISZ[Map[K, V]], __size: Z) extends _root_.org.sireum.DatatypeSig {
    private[this] val _mapEntries = __mapEntries;
    def mapEntries = _mapEntries;
    def getMapEntries = _mapEntries;
    private[this] val _size = __size;
    def size = _size;
    def getSize = _size;
    override def toString: _root_.java.lang.String = string.value;
    override lazy val hashCode: _root_.scala.Int = hash.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): HashMap[K, V] @unchecked)) => isEqual(o)
        case _ => halt("Invalid equality test between ".+(this.getClass).+(" and ").+(o.getClass))
      };
    def apply(mapEntries: ISZ[Map[K, V]] = this.mapEntries, size: Z = this.size): HashMap[K, V] = new HashMap(mapEntries, size);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "HashMap")), scala.Tuple2("mapEntries", this.mapEntries), scala.Tuple2("size", this.size));
    @pure def entries: ISZ[scala.Tuple2[K, V]] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[scala.Tuple2[K, V]]());
      mapEntries.foreach(((ms) => if (ms.nonEmpty)
        r = _root_.org.sireum.helper.$assign(r.++(ms.entries))
      else
        ()));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def keys: ISZ[K] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[K]());
      mapEntries.foreach(((ms) => if (ms.nonEmpty)
        r = _root_.org.sireum.helper.$assign(r.++(ms.keys))
      else
        ()));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def values: ISZ[V] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[V]());
      mapEntries.foreach(((ms) => if (ms.nonEmpty)
        r = _root_.org.sireum.helper.$assign(r.++(ms.values))
      else
        ()));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def keySet: Set[K] = return _root_.org.sireum.helper.$assign(Set.empty[K].++(keys));
    @pure def valueSet: Set[V] = return _root_.org.sireum.helper.$assign(Set.empty[V].++(values));
    @pure def +(p: scala.Tuple2[K, V]): HashMap[K, V] = {
      val x$1 = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(p: @scala.unchecked) match {
        case scala.Tuple2((key @ _), (value @ _)) => scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value))
      });
      val key = _root_.org.sireum.helper.$assign(x$1._1);
      val value = _root_.org.sireum.helper.$assign(x$1._2);
      val r = _root_.org.sireum.helper.$assign(ensureCapacity(size.+(_root_.org.sireum.Z(1))));
      val i = _root_.org.sireum.helper.$assign(r.hashIndex(key));
      val m = _root_.org.sireum.helper.$assign(r.mapEntries(i));
      val newSize: Z = _root_.org.sireum.helper.$assign(if (m.contains(key))
        size
      else
        size.+(_root_.org.sireum.Z(1)));
      return _root_.org.sireum.helper.$assign(r(mapEntries = r.mapEntries(i.~>(m.+(key.~>(value)))), size = newSize))
    };
    @pure def ++[I](entries: IS[I, scala.Tuple2[K, V]]): HashMap[K, V] = {
      if (entries.isEmpty)
        return _root_.org.sireum.helper.$assign(this)
      else
        ();
      var r = _root_.org.sireum.helper.$assign(ensureCapacity(size.+(entries.zize)));
      entries.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.+(kv._1.~>(kv._2)))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def ensureCapacity(sz: Z): HashMap[K, V] = {
      if (mapEntries.size.*(_root_.org.sireum.Z(3))./(_root_.org.sireum.Z(4)).>=(sz))
        return _root_.org.sireum.helper.$assign(this)
      else
        ();
      val init = _root_.org.sireum.helper.$assign(sz.*(_root_.org.sireum.Z(2)));
      var r = _root_.org.sireum.helper.$assign(HashMap.emptyInit[K, V](init));
      mapEntries.foreach(((ms) => ms.entries.foreach(((kv) => r = _root_.org.sireum.helper.$assign(r.+(kv._1.~>(kv._2)))))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def hashIndex(key: K): Z = {
      val sz = _root_.org.sireum.helper.$assign(mapEntries.size);
      val i = _root_.org.sireum.helper.$assign(_root_.org.sireum.Z(key.hashCode).%(sz));
      return _root_.org.sireum.helper.$assign(if (i.<(_root_.org.sireum.Z(0)))
        i.+(sz)
      else
        i)
    };
    @pure def get(key: K): Option[V] = {
      val m = _root_.org.sireum.helper.$assign(mapEntries(hashIndex(key)));
      return _root_.org.sireum.helper.$assign(m.get(key))
    };
    @pure def entry(key: K): Option[scala.Tuple2[K, V]] = {
      val m = _root_.org.sireum.helper.$assign(mapEntries(hashIndex(key)));
      return _root_.org.sireum.helper.$assign(m.entry(key))
    };
    @pure def --[I](keys: IS[I, K]): HashMap[K, V] = {
      var r = _root_.org.sireum.helper.$assign(this);
      keys.foreach(((k) => _root_.org.sireum.helper.$tmatch(r.get(k)) match {
        case Some((v @ _)) => r = _root_.org.sireum.helper.$assign(r.-(k.~>(v)))
        case _ => ()
      }));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def -(p: scala.Tuple2[K, V]): HashMap[K, V] = {
      val x$2 = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(p: @scala.unchecked) match {
        case scala.Tuple2((key @ _), (value @ _)) => scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value))
      });
      val key = _root_.org.sireum.helper.$assign(x$2._1);
      val value = _root_.org.sireum.helper.$assign(x$2._2);
      val i = _root_.org.sireum.helper.$assign(hashIndex(key));
      return _root_.org.sireum.helper.$assign(this(mapEntries(i.~>(mapEntries(i).-(key.~>(value)))), size.-(_root_.org.sireum.Z(1))))
    };
    @pure def contains(key: K): B = return _root_.org.sireum.helper.$assign(get(key).nonEmpty);
    @pure def isEmpty: B = return _root_.org.sireum.helper.$assign(size.==(StringContext("0").z()));
    @pure def nonEmpty: B = return _root_.org.sireum.helper.$assign(size.!=(StringContext("0").z()));
    @pure override def string: String = {
      val r = StringContext("""{
      |  """, """
      |}""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(entries.map(((e) => StringContext("", " -> ", "").st(e._1, e._2)))), _root_.org.sireum.String(",\n")));
      return _root_.org.sireum.helper.$assign(r.render)
    };
    @pure override def hash: Z = return _root_.org.sireum.helper.$assign(size);
    @pure def isEqual(other: HashMap[K, V]): B = {
      if (size.!=(other.size))
        return _root_.org.sireum.helper.$assign(F)
      else
        ();
      var comparedKeys = _root_.org.sireum.helper.$assign(ISZ[K]());
      mapEntries.foreach(((ms) => ms.entries.foreach(((kv) => {
        val k = _root_.org.sireum.helper.$assign(kv._1);
        comparedKeys = _root_.org.sireum.helper.$assign(comparedKeys.:+(k));
        _root_.org.sireum.helper.$tmatch(other.get(k)) match {
          case Some((v @ _)) => if (kv._2.!=(v))
            return _root_.org.sireum.helper.$assign(F)
          else
            ()
          case _ => return _root_.org.sireum.helper.$assign(F)
        }
      }))));
      other.--(comparedKeys).mapEntries.foreach(((ms) => ms.entries.foreach(((kv) => {
        val k = _root_.org.sireum.helper.$assign(kv._1);
        _root_.org.sireum.helper.$tmatch(get(k)) match {
          case Some((v @ _)) => if (kv._2.!=(v))
            return _root_.org.sireum.helper.$assign(F)
          else
            ()
          case _ => return _root_.org.sireum.helper.$assign(F)
        }
      }))));
      return _root_.org.sireum.helper.$assign(T)
    }
  }
}