package org.sireum {
  object MOption {
    @pure def some[T](value: T): MOption[T] = return _root_.org.sireum.helper.$assign(MSome(value));
    @pure def none[T](): MOption[T] = return _root_.org.sireum.helper.$assign(MNone())
  }

  @record sealed trait MOption[T] extends _root_.org.sireum.RecordSig {
    @pure def isEmpty: B;
    @pure def nonEmpty: B;
    @pure def map[T2](f: _root_.scala.Function1[T, T2 @pure]): MOption[T2];
    @pure def flatMap[T2](f: _root_.scala.Function1[T, MOption[T2] @pure]): MOption[T2];
    @pure def forall(f: _root_.scala.Function1[T, B @pure]): B;
    @pure def exists(f: _root_.scala.Function1[T, B @pure]): B;
    @pure def getOrElse(default: T): T;
    @pure def get: T;
    @pure def toMS: MS[Z, T];
    def foreach(f: _root_.scala.Function1[T, Unit]): Unit
  }

  object MNone {
    private[this] val $v: _root_.scala.AnyRef = new MNone[_root_.scala.Nothing]();
    def apply[T](): MNone[T] = $v.asInstanceOf[MNone[T]];
    def unapply[T](o: MNone[T]): _root_.scala.Boolean = true
  }

  @record final class MNone[T] extends MOption[T] with _root_.org.sireum.RecordSig {
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      "MNone()";
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      this.getClass.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): MNone[T] @unchecked)) => true
          case _ => halt("Invalid equality test between ".+(this.getClass).+(" and ").+(o.getClass))
        };
    override def $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "MNone")));
    override def $clone: MNone[T] = this;
    @pure def isEmpty: B = {
      StringContext(" ensures  result ≡ T ").lUnit();
      return _root_.org.sireum.helper.$assign(T)
    };
    @pure def nonEmpty: B = {
      StringContext(" ensures  result ≡ F ").lUnit();
      return _root_.org.sireum.helper.$assign(F)
    };
    @pure def map[T2](f: _root_.scala.Function1[T, T2 @pure]): MOption[T2] = {
      StringContext(" ensures  result ≡ MNone[T2]() ").lUnit();
      return _root_.org.sireum.helper.$assign(MNone[T2]())
    };
    @pure def flatMap[T2](f: _root_.scala.Function1[T, MOption[T2] @pure]): MOption[T2] = {
      StringContext(" ensures  result ≡ MNone[T2]() ").lUnit();
      return _root_.org.sireum.helper.$assign(MNone[T2]())
    };
    @pure def forall(f: _root_.scala.Function1[T, B @pure]): B = {
      StringContext(" ensures  result ≡ T ").lUnit();
      return _root_.org.sireum.helper.$assign(T)
    };
    @pure def exists(f: _root_.scala.Function1[T, B @pure]): B = {
      StringContext(" ensures  result ≡ F ").lUnit();
      return _root_.org.sireum.helper.$assign(F)
    };
    @pure def getOrElse(default: T): T = {
      StringContext(" ensures  result ≡ default ").lUnit();
      return _root_.org.sireum.helper.$assign(default)
    };
    @pure def get: T = {
      StringContext(" requires  F ").lUnit();
      halt(_root_.org.sireum.String("Invalid \'MNone\' operation \'get\'."))
    };
    @pure def toMS: MS[Z, T] = {
      StringContext(" ensures  result.size ≡ 0 ").lUnit();
      return _root_.org.sireum.helper.$assign(MS[Z, T]())
    };
    def foreach(f: _root_.scala.Function1[T, Unit]): Unit = ()
  }

  object MSome {
    def apply[T](value: T): MSome[T] = new MSome(value);
    def unapply[T](o: MSome[T]): _root_.scala.Option[T] = _root_.scala.Some(_root_.org.sireum.helper.clone(o.value))
  }

  @record final class MSome[T](__value: T) extends MOption[T] with _root_.org.sireum.RecordSig {
    private[this] var _value = __value;
    def value = _value;
    def getValue = _value;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("MSome");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.value));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override def hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, value).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): MSome[T] @unchecked)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.value.==(o.value)
          case _ => false
        };
    def apply(value: T = this.value): MSome[T] = new MSome(_root_.org.sireum.helper.$assign(value));
    override def $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "MSome")), scala.Tuple2("value", value));
    override def $clone: MSome[T] = {
      val r: MSome[T] = new MSome(_root_.org.sireum.helper.cloneAssign(this.value));
      r
    };
    @pure def isEmpty: B = {
      StringContext(" ensures  result ≡ F ").lUnit();
      return _root_.org.sireum.helper.$assign(F)
    };
    @pure def nonEmpty: B = {
      StringContext(" ensures  result ≡ T ").lUnit();
      return _root_.org.sireum.helper.$assign(T)
    };
    @pure def map[T2](f: _root_.scala.Function1[T, T2 @pure]): MOption[T2] = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return _root_.org.sireum.helper.$assign(MSome(f(value)))
    };
    @pure def flatMap[T2](f: _root_.scala.Function1[T, MOption[T2] @pure]): MOption[T2] = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return _root_.org.sireum.helper.$assign(f(value))
    };
    @pure def forall(f: _root_.scala.Function1[T, B @pure]): B = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return _root_.org.sireum.helper.$assign(f(value))
    };
    @pure def exists(f: _root_.scala.Function1[T, B @pure]): B = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return _root_.org.sireum.helper.$assign(f(value))
    };
    @pure def getOrElse(default: T): T = {
      StringContext(" ensures  result ≡ value ").lUnit();
      return _root_.org.sireum.helper.$assign(value)
    };
    @pure def get: T = {
      StringContext(" ensures  result ≡ value ").lUnit();
      return _root_.org.sireum.helper.$assign(value)
    };
    @pure def toMS: MS[Z, T] = {
      StringContext(""" ensures  result.size ≡ 1
                  result(0) ≡ value """).lUnit();
      return _root_.org.sireum.helper.$assign(MSZ(value))
    };
    def foreach(f: _root_.scala.Function1[T, Unit]): Unit = {
      StringContext(""" reads    f_reads
         requires f_requires(value)
         modifies f_modifies
         ensures  f_ensures(value) """).lUnit();
      f(value)
    }
  }
}