package org.sireum {
  object Option {
    @pure def some[T](value: T): Option[T] = return _root_.org.sireum.helper.$assign(Some(value));
    @pure def none[T](): Option[T] = return _root_.org.sireum.helper.$assign(None())
  }

  @datatype sealed trait Option[T] extends _root_.org.sireum.DatatypeSig {
    @pure def isEmpty: B;
    @pure def nonEmpty: B;
    @pure def map[T2](f: _root_.scala.Function1[T, T2 @pure]): Option[T2];
    @pure def flatMap[T2](f: _root_.scala.Function1[T, Option[T2] @pure]): Option[T2];
    @pure def forall(f: _root_.scala.Function1[T, B @pure]): B;
    @pure def exists(f: _root_.scala.Function1[T, B @pure]): B;
    @pure def get: T;
    @pure def getOrElse(default: => T): T;
    @pure def toIS: IS[Z, T];
    def foreach(f: _root_.scala.Function1[T, Unit]): Unit
  }

  object None {
    private[this] val $v: _root_.scala.AnyRef = new None[_root_.scala.Nothing]();
    def apply[T](): None[T] = $v.asInstanceOf[None[T]];
    def unapply[T](o: None[T]): _root_.scala.Boolean = true
  }

  @datatype final class None[T] extends Option[T] with _root_.org.sireum.DatatypeSig {
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      "None()";
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      this.getClass.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): None[T] @unchecked)) => true
          case _ => false
        };
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "None")));
    @pure def isEmpty: B = {
      StringContext(" ensures  result ≡ T ").lUnit();
      return _root_.org.sireum.helper.$assign(T)
    };
    @pure def nonEmpty: B = {
      StringContext(" ensures  result ≡ F ").lUnit();
      return _root_.org.sireum.helper.$assign(F)
    };
    @pure def map[T2](f: _root_.scala.Function1[T, T2 @pure]): Option[T2] = {
      StringContext(" ensures  result ≡ None[T2]() ").lUnit();
      return _root_.org.sireum.helper.$assign(None[T2]())
    };
    @pure def flatMap[T2](f: _root_.scala.Function1[T, Option[T2] @pure]): Option[T2] = {
      StringContext(" ensures  result ≡ None[T2]() ").lUnit();
      return _root_.org.sireum.helper.$assign(None[T2]())
    };
    @pure def forall(f: _root_.scala.Function1[T, B @pure]): B = {
      StringContext(" ensures  result ≡ T ").lUnit();
      return _root_.org.sireum.helper.$assign(T)
    };
    @pure def exists(f: _root_.scala.Function1[T, B @pure]): B = {
      StringContext(" ensures  result ≡ F ").lUnit();
      return _root_.org.sireum.helper.$assign(F)
    };
    @pure def getOrElse(default: => T): T = {
      StringContext(" ensures  result ≡ default ").lUnit();
      return _root_.org.sireum.helper.$assign(default)
    };
    @pure def get: T = {
      StringContext(" requires  F ").lUnit();
      halt(_root_.org.sireum.String("Invalid \'None\' operation \'get\'."))
    };
    @pure def toIS: IS[Z, T] = {
      StringContext(" ensures  result.size ≡ 0 ").lUnit();
      return _root_.org.sireum.helper.$assign(IS[Z, T]())
    };
    def foreach(f: _root_.scala.Function1[T, Unit]): Unit = ()
  }

  object Some {
    def apply[T](value: T): Some[T] = new Some(value);
    def unapply[T](o: Some[T]): _root_.scala.Option[T] = _root_.scala.Some(o.value)
  }

  @datatype final class Some[T](__value: T) extends Option[T] with _root_.org.sireum.DatatypeSig {
    private[this] val _value = __value;
    def value = _value;
    def getValue = _value;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("Some");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.value));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, value).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): Some[T] @unchecked)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.value.==(o.value)
          case _ => false
        };
    def apply(value: T = this.value): Some[T] = new Some(value);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Some")), scala.Tuple2("value", this.value));
    @pure def isEmpty: B = {
      StringContext(" ensures  result ≡ F ").lUnit();
      return _root_.org.sireum.helper.$assign(F)
    };
    @pure def nonEmpty: B = {
      StringContext(" ensures  result ≡ T ").lUnit();
      return _root_.org.sireum.helper.$assign(T)
    };
    @pure def map[T2](f: _root_.scala.Function1[T, T2 @pure]): Option[T2] = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return _root_.org.sireum.helper.$assign(Some(f(value)))
    };
    @pure def flatMap[T2](f: _root_.scala.Function1[T, Option[T2] @pure]): Option[T2] = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return _root_.org.sireum.helper.$assign(f(value))
    };
    @pure def forall(f: _root_.scala.Function1[T, B @pure]): B = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return _root_.org.sireum.helper.$assign(f(value))
    };
    @pure def exists(f: _root_.scala.Function1[T, B @pure]): B = {
      StringContext(" ensures  result ≡ f(value) ").lUnit();
      return _root_.org.sireum.helper.$assign(f(value))
    };
    @pure def getOrElse(default: => T): T = {
      StringContext(" ensures  result ≡ value ").lUnit();
      return _root_.org.sireum.helper.$assign(value)
    };
    @pure def get: T = {
      StringContext(" ensures  result ≡ value ").lUnit();
      return _root_.org.sireum.helper.$assign(value)
    };
    @pure def toIS: IS[Z, T] = {
      StringContext(""" ensures  result.size ≡ 1
                  result(0) ≡ value """).lUnit();
      return _root_.org.sireum.helper.$assign(ISZ(value))
    };
    def foreach(f: _root_.scala.Function1[T, Unit]): Unit = {
      StringContext(""" reads    f_reads
         requires f_requires(value)
         modifies f_modifies
         ensures  f_ensures(value) """).lUnit();
      f(value)
    }
  }
}