package org.sireum {
  import org.sireum.ops.ISZOps

  object Stack {
    @pure def empty[T]: Stack[T] = return _root_.org.sireum.helper.$assign(Stack[T](ISZ()));
    def apply[T](elements: ISZ[T]): Stack[T] = new Stack(elements);
    def unapply[T](o: Stack[T]): _root_.scala.Option[ISZ[T]] = _root_.scala.Some(o.elements)
  }

  @datatype final class Stack[T](__elements: ISZ[T]) extends _root_.org.sireum.DatatypeSig {
    private[this] val _elements = __elements;
    def elements = _elements;
    def getElements = _elements;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("Stack");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.elements));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, elements).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): Stack[T] @unchecked)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.elements.==(o.elements)
          case _ => false
        };
    def apply(elements: ISZ[T] = this.elements): Stack[T] = new Stack(elements);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Stack")), scala.Tuple2("elements", this.elements));
    @pure def size: Z = return _root_.org.sireum.helper.$assign(elements.size);
    @pure def isEmpty: B = return _root_.org.sireum.helper.$assign(elements.isEmpty);
    @pure def nonEmpty: B = return _root_.org.sireum.helper.$assign(elements.nonEmpty);
    @pure def peek: Option[T] = if (nonEmpty)
      return _root_.org.sireum.helper.$assign(Some(elements(elements.size.-(_root_.org.sireum.Z(1)))))
    else
      return _root_.org.sireum.helper.$assign(None());
    @pure def push(e: T): Stack[T] = return _root_.org.sireum.helper.$assign(Stack(elements.:+(e)));
    @pure def pop(): Option[scala.Tuple2[T, Stack[T]]] = if (nonEmpty)
      return _root_.org.sireum.helper.$assign(Some(scala.Tuple2(_root_.org.sireum.helper.$assign(elements(elements.size.-(_root_.org.sireum.Z(1)))), _root_.org.sireum.helper.$assign(Stack(ISZOps(elements).dropRight(_root_.org.sireum.Z(1)))))))
    else
      return _root_.org.sireum.helper.$assign(None())
  }
}