package org.sireum.conversions {
  import org.sireum._

  @ext object B {
    @pure def toB(b: B): B = B_Ext.toB(b);
    @pure def toZ(b: B): Z = B_Ext.toZ(b);
    @pure def toZ8(b: B): Z8 = B_Ext.toZ8(b);
    @pure def toZ16(b: B): Z16 = B_Ext.toZ16(b);
    @pure def toZ32(b: B): Z32 = B_Ext.toZ32(b);
    @pure def toZ64(b: B): Z64 = B_Ext.toZ64(b);
    @pure def toN(b: B): N = B_Ext.toN(b);
    @pure def toN8(b: B): N8 = B_Ext.toN8(b);
    @pure def toN16(b: B): N16 = B_Ext.toN16(b);
    @pure def toN32(b: B): N32 = B_Ext.toN32(b);
    @pure def toN64(b: B): N64 = B_Ext.toN64(b);
    @pure def toS8(b: B): S8 = B_Ext.toS8(b);
    @pure def toS16(b: B): S16 = B_Ext.toS16(b);
    @pure def toS32(b: B): S32 = B_Ext.toS32(b);
    @pure def toS64(b: B): S64 = B_Ext.toS64(b);
    @pure def toU8(b: B): U8 = B_Ext.toU8(b);
    @pure def toU16(b: B): U16 = B_Ext.toU16(b);
    @pure def toU32(b: B): U32 = B_Ext.toU32(b);
    @pure def toU64(b: B): U64 = B_Ext.toU64(b);
    @pure def toF32(b: B): F32 = B_Ext.toF32(b);
    @pure def toF64(b: B): F64 = B_Ext.toF64(b);
    @pure def toR(b: B): R = B_Ext.toR(b)
  }

  @ext object C {
    @pure def toU32(c: C): U32 = C_Ext.toU32(c)
  }

  @ext object Z {
    @pure def isInRangeSigned8(n: Z): B = Z_Ext.isInRangeSigned8(n);
    @pure def isInRangeSigned16(n: Z): B = Z_Ext.isInRangeSigned16(n);
    @pure def isInRangeSigned32(n: Z): B = Z_Ext.isInRangeSigned32(n);
    @pure def isInRangeSigned64(n: Z): B = Z_Ext.isInRangeSigned64(n);
    @pure def isInRangeUnsigned8(n: Z): B = Z_Ext.isInRangeUnsigned8(n);
    @pure def isInRangeUnsigned16(n: Z): B = Z_Ext.isInRangeUnsigned16(n);
    @pure def isInRangeUnsigned32(n: Z): B = Z_Ext.isInRangeUnsigned32(n);
    @pure def isInRangeUnsigned64(n: Z): B = Z_Ext.isInRangeUnsigned64(n);
    @pure def toB(n: Z): B = Z_Ext.toB(n);
    @pure def toZ(n: Z): Z = Z_Ext.toZ(n);
    @pure def toZ8(n: Z): Z8 = Z_Ext.toZ8(n);
    @pure def toZ16(n: Z): Z16 = Z_Ext.toZ16(n);
    @pure def toZ32(n: Z): Z32 = Z_Ext.toZ32(n);
    @pure def toZ64(n: Z): Z64 = Z_Ext.toZ64(n);
    @pure def toN(n: Z): N = Z_Ext.toN(n);
    @pure def toN8(n: Z): N8 = Z_Ext.toN8(n);
    @pure def toN16(n: Z): N16 = Z_Ext.toN16(n);
    @pure def toN32(n: Z): N32 = Z_Ext.toN32(n);
    @pure def toN64(n: Z): N64 = Z_Ext.toN64(n);
    @pure def toS8(n: Z): S8 = Z_Ext.toS8(n);
    @pure def toS16(n: Z): S16 = Z_Ext.toS16(n);
    @pure def toS32(n: Z): S32 = Z_Ext.toS32(n);
    @pure def toS64(n: Z): S64 = Z_Ext.toS64(n);
    @pure def toU8(n: Z): U8 = Z_Ext.toU8(n);
    @pure def toU16(n: Z): U16 = Z_Ext.toU16(n);
    @pure def toU32(n: Z): U32 = Z_Ext.toU32(n);
    @pure def toU64(n: Z): U64 = Z_Ext.toU64(n);
    @pure def toR(n: Z): R = Z_Ext.toR(n);
    @pure def toBinary(n: Z): ISZ[U8] = Z_Ext.toBinary(n);
    @pure def fromBinary(bin: ISZ[U8]): Z = Z_Ext.fromBinary(bin)
  }

  @ext object Z8 {
    @pure def toB(n: Z8): B = Z8_Ext.toB(n);
    @pure def toZ(n: Z8): Z = Z8_Ext.toZ(n);
    @pure def toZ8(n: Z8): Z8 = Z8_Ext.toZ8(n);
    @pure def toZ16(n: Z8): Z16 = Z8_Ext.toZ16(n);
    @pure def toZ32(n: Z8): Z32 = Z8_Ext.toZ32(n);
    @pure def toZ64(n: Z8): Z64 = Z8_Ext.toZ64(n);
    @pure def toN(n: Z8): N = Z8_Ext.toN(n);
    @pure def toN8(n: Z8): N8 = Z8_Ext.toN8(n);
    @pure def toN16(n: Z8): N16 = Z8_Ext.toN16(n);
    @pure def toN32(n: Z8): N32 = Z8_Ext.toN32(n);
    @pure def toN64(n: Z8): N64 = Z8_Ext.toN64(n);
    @pure def toS8(n: Z8): S8 = Z8_Ext.toS8(n);
    @pure def toS16(n: Z8): S16 = Z8_Ext.toS16(n);
    @pure def toS32(n: Z8): S32 = Z8_Ext.toS32(n);
    @pure def toS64(n: Z8): S64 = Z8_Ext.toS64(n);
    @pure def toU8(n: Z8): U8 = Z8_Ext.toU8(n);
    @pure def toU16(n: Z8): U16 = Z8_Ext.toU16(n);
    @pure def toU32(n: Z8): U32 = Z8_Ext.toU32(n);
    @pure def toU64(n: Z8): U64 = Z8_Ext.toU64(n);
    @pure def toR(n: Z8): R = Z8_Ext.toR(n)
  }

  @ext object Z16 {
    @pure def toB(n: Z16): B = Z16_Ext.toB(n);
    @pure def toZ(n: Z16): Z = Z16_Ext.toZ(n);
    @pure def toZ8(n: Z16): Z8 = Z16_Ext.toZ8(n);
    @pure def toZ16(n: Z16): Z16 = Z16_Ext.toZ16(n);
    @pure def toZ32(n: Z16): Z32 = Z16_Ext.toZ32(n);
    @pure def toZ64(n: Z16): Z64 = Z16_Ext.toZ64(n);
    @pure def toN(n: Z16): N = Z16_Ext.toN(n);
    @pure def toN8(n: Z16): N8 = Z16_Ext.toN8(n);
    @pure def toN16(n: Z16): N16 = Z16_Ext.toN16(n);
    @pure def toN32(n: Z16): N32 = Z16_Ext.toN32(n);
    @pure def toN64(n: Z16): N64 = Z16_Ext.toN64(n);
    @pure def toS8(n: Z16): S8 = Z16_Ext.toS8(n);
    @pure def toS16(n: Z16): S16 = Z16_Ext.toS16(n);
    @pure def toS32(n: Z16): S32 = Z16_Ext.toS32(n);
    @pure def toS64(n: Z16): S64 = Z16_Ext.toS64(n);
    @pure def toU8(n: Z16): U8 = Z16_Ext.toU8(n);
    @pure def toU16(n: Z16): U16 = Z16_Ext.toU16(n);
    @pure def toU32(n: Z16): U32 = Z16_Ext.toU32(n);
    @pure def toU64(n: Z16): U64 = Z16_Ext.toU64(n);
    @pure def toR(n: Z16): R = Z16_Ext.toR(n)
  }

  @ext object Z32 {
    @pure def toB(n: Z32): B = Z32_Ext.toB(n);
    @pure def toZ(n: Z32): Z = Z32_Ext.toZ(n);
    @pure def toZ8(n: Z32): Z8 = Z32_Ext.toZ8(n);
    @pure def toZ16(n: Z32): Z16 = Z32_Ext.toZ16(n);
    @pure def toZ32(n: Z32): Z32 = Z32_Ext.toZ32(n);
    @pure def toZ64(n: Z32): Z64 = Z32_Ext.toZ64(n);
    @pure def toN(n: Z32): N = Z32_Ext.toN(n);
    @pure def toN8(n: Z32): N8 = Z32_Ext.toN8(n);
    @pure def toN16(n: Z32): N16 = Z32_Ext.toN16(n);
    @pure def toN32(n: Z32): N32 = Z32_Ext.toN32(n);
    @pure def toN64(n: Z32): N64 = Z32_Ext.toN64(n);
    @pure def toS8(n: Z32): S8 = Z32_Ext.toS8(n);
    @pure def toS16(n: Z32): S16 = Z32_Ext.toS16(n);
    @pure def toS32(n: Z32): S32 = Z32_Ext.toS32(n);
    @pure def toS64(n: Z32): S64 = Z32_Ext.toS64(n);
    @pure def toU8(n: Z32): U8 = Z32_Ext.toU8(n);
    @pure def toU16(n: Z32): U16 = Z32_Ext.toU16(n);
    @pure def toU32(n: Z32): U32 = Z32_Ext.toU32(n);
    @pure def toU64(n: Z32): U64 = Z32_Ext.toU64(n);
    @pure def toR(n: Z32): R = Z32_Ext.toR(n)
  }

  @ext object Z64 {
    @pure def toB(n: Z64): B = Z64_Ext.toB(n);
    @pure def toZ(n: Z64): Z = Z64_Ext.toZ(n);
    @pure def toZ8(n: Z64): Z8 = Z64_Ext.toZ8(n);
    @pure def toZ16(n: Z64): Z16 = Z64_Ext.toZ16(n);
    @pure def toZ32(n: Z64): Z32 = Z64_Ext.toZ32(n);
    @pure def toZ64(n: Z64): Z64 = Z64_Ext.toZ64(n);
    @pure def toN(n: Z64): N = Z64_Ext.toN(n);
    @pure def toN8(n: Z64): N8 = Z64_Ext.toN8(n);
    @pure def toN16(n: Z64): N16 = Z64_Ext.toN16(n);
    @pure def toN32(n: Z64): N32 = Z64_Ext.toN32(n);
    @pure def toN64(n: Z64): N64 = Z64_Ext.toN64(n);
    @pure def toS8(n: Z64): S8 = Z64_Ext.toS8(n);
    @pure def toS16(n: Z64): S16 = Z64_Ext.toS16(n);
    @pure def toS32(n: Z64): S32 = Z64_Ext.toS32(n);
    @pure def toS64(n: Z64): S64 = Z64_Ext.toS64(n);
    @pure def toU8(n: Z64): U8 = Z64_Ext.toU8(n);
    @pure def toU16(n: Z64): U16 = Z64_Ext.toU16(n);
    @pure def toU32(n: Z64): U32 = Z64_Ext.toU32(n);
    @pure def toU64(n: Z64): U64 = Z64_Ext.toU64(n);
    @pure def toR(n: Z64): R = Z64_Ext.toR(n)
  }

  @ext object N {
    @pure def toB(n: N): B = N_Ext.toB(n);
    @pure def toZ(n: N): Z = N_Ext.toZ(n);
    @pure def toZ8(n: N): Z8 = N_Ext.toZ8(n);
    @pure def toZ16(n: N): Z16 = N_Ext.toZ16(n);
    @pure def toZ32(n: N): Z32 = N_Ext.toZ32(n);
    @pure def toZ64(n: N): Z64 = N_Ext.toZ64(n);
    @pure def toN(n: N): N = N_Ext.toN(n);
    @pure def toN8(n: N): N8 = N_Ext.toN8(n);
    @pure def toN16(n: N): N16 = N_Ext.toN16(n);
    @pure def toN32(n: N): N32 = N_Ext.toN32(n);
    @pure def toN64(n: N): N64 = N_Ext.toN64(n);
    @pure def toS8(n: N): S8 = N_Ext.toS8(n);
    @pure def toS16(n: N): S16 = N_Ext.toS16(n);
    @pure def toS32(n: N): S32 = N_Ext.toS32(n);
    @pure def toS64(n: N): S64 = N_Ext.toS64(n);
    @pure def toU8(n: N): U8 = N_Ext.toU8(n);
    @pure def toU16(n: N): U16 = N_Ext.toU16(n);
    @pure def toU32(n: N): U32 = N_Ext.toU32(n);
    @pure def toU64(n: N): U64 = N_Ext.toU64(n);
    @pure def toR(n: N): R = N_Ext.toR(n)
  }

  @ext object N8 {
    @pure def toB(n: N8): B = N8_Ext.toB(n);
    @pure def toZ(n: N8): Z = N8_Ext.toZ(n);
    @pure def toZ8(n: N8): Z8 = N8_Ext.toZ8(n);
    @pure def toZ16(n: N8): Z16 = N8_Ext.toZ16(n);
    @pure def toZ32(n: N8): Z32 = N8_Ext.toZ32(n);
    @pure def toZ64(n: N8): Z64 = N8_Ext.toZ64(n);
    @pure def toN(n: N8): N = N8_Ext.toN(n);
    @pure def toN8(n: N8): N8 = N8_Ext.toN8(n);
    @pure def toN16(n: N8): N16 = N8_Ext.toN16(n);
    @pure def toN32(n: N8): N32 = N8_Ext.toN32(n);
    @pure def toN64(n: N8): N64 = N8_Ext.toN64(n);
    @pure def toS8(n: N8): S8 = N8_Ext.toS8(n);
    @pure def toS16(n: N8): S16 = N8_Ext.toS16(n);
    @pure def toS32(n: N8): S32 = N8_Ext.toS32(n);
    @pure def toS64(n: N8): S64 = N8_Ext.toS64(n);
    @pure def toU8(n: N8): U8 = N8_Ext.toU8(n);
    @pure def toU16(n: N8): U16 = N8_Ext.toU16(n);
    @pure def toU32(n: N8): U32 = N8_Ext.toU32(n);
    @pure def toU64(n: N8): U64 = N8_Ext.toU64(n);
    @pure def toR(n: N8): R = N8_Ext.toR(n)
  }

  @ext object N16 {
    @pure def toB(n: N16): B = N16_Ext.toB(n);
    @pure def toZ(n: N16): Z = N16_Ext.toZ(n);
    @pure def toZ8(n: N16): Z8 = N16_Ext.toZ8(n);
    @pure def toZ16(n: N16): Z16 = N16_Ext.toZ16(n);
    @pure def toZ32(n: N16): Z32 = N16_Ext.toZ32(n);
    @pure def toZ64(n: N16): Z64 = N16_Ext.toZ64(n);
    @pure def toN(n: N16): N = N16_Ext.toN(n);
    @pure def toN8(n: N16): N8 = N16_Ext.toN8(n);
    @pure def toN16(n: N16): N16 = N16_Ext.toN16(n);
    @pure def toN32(n: N16): N32 = N16_Ext.toN32(n);
    @pure def toN64(n: N16): N64 = N16_Ext.toN64(n);
    @pure def toS8(n: N16): S8 = N16_Ext.toS8(n);
    @pure def toS16(n: N16): S16 = N16_Ext.toS16(n);
    @pure def toS32(n: N16): S32 = N16_Ext.toS32(n);
    @pure def toS64(n: N16): S64 = N16_Ext.toS64(n);
    @pure def toU8(n: N16): U8 = N16_Ext.toU8(n);
    @pure def toU16(n: N16): U16 = N16_Ext.toU16(n);
    @pure def toU32(n: N16): U32 = N16_Ext.toU32(n);
    @pure def toU64(n: N16): U64 = N16_Ext.toU64(n);
    @pure def toR(n: N16): R = N16_Ext.toR(n)
  }

  @ext object N32 {
    @pure def toB(n: N32): B = N32_Ext.toB(n);
    @pure def toZ(n: N32): Z = N32_Ext.toZ(n);
    @pure def toZ8(n: N32): Z8 = N32_Ext.toZ8(n);
    @pure def toZ16(n: N32): Z16 = N32_Ext.toZ16(n);
    @pure def toZ32(n: N32): Z32 = N32_Ext.toZ32(n);
    @pure def toZ64(n: N32): Z64 = N32_Ext.toZ64(n);
    @pure def toN(n: N32): N = N32_Ext.toN(n);
    @pure def toN8(n: N32): N8 = N32_Ext.toN8(n);
    @pure def toN16(n: N32): N16 = N32_Ext.toN16(n);
    @pure def toN32(n: N32): N32 = N32_Ext.toN32(n);
    @pure def toN64(n: N32): N64 = N32_Ext.toN64(n);
    @pure def toS8(n: N32): S8 = N32_Ext.toS8(n);
    @pure def toS16(n: N32): S16 = N32_Ext.toS16(n);
    @pure def toS32(n: N32): S32 = N32_Ext.toS32(n);
    @pure def toS64(n: N32): S64 = N32_Ext.toS64(n);
    @pure def toU8(n: N32): U8 = N32_Ext.toU8(n);
    @pure def toU16(n: N32): U16 = N32_Ext.toU16(n);
    @pure def toU32(n: N32): U32 = N32_Ext.toU32(n);
    @pure def toU64(n: N32): U64 = N32_Ext.toU64(n);
    @pure def toR(n: N32): R = N32_Ext.toR(n)
  }

  @ext object N64 {
    @pure def toB(n: N64): B = N64_Ext.toB(n);
    @pure def toZ(n: N64): Z = N64_Ext.toZ(n);
    @pure def toZ8(n: N64): Z8 = N64_Ext.toZ8(n);
    @pure def toZ16(n: N64): Z16 = N64_Ext.toZ16(n);
    @pure def toZ32(n: N64): Z32 = N64_Ext.toZ32(n);
    @pure def toZ64(n: N64): Z64 = N64_Ext.toZ64(n);
    @pure def toN(n: N64): N = N64_Ext.toN(n);
    @pure def toN8(n: N64): N8 = N64_Ext.toN8(n);
    @pure def toN16(n: N64): N16 = N64_Ext.toN16(n);
    @pure def toN32(n: N64): N32 = N64_Ext.toN32(n);
    @pure def toN64(n: N64): N64 = N64_Ext.toN64(n);
    @pure def toS8(n: N64): S8 = N64_Ext.toS8(n);
    @pure def toS16(n: N64): S16 = N64_Ext.toS16(n);
    @pure def toS32(n: N64): S32 = N64_Ext.toS32(n);
    @pure def toS64(n: N64): S64 = N64_Ext.toS64(n);
    @pure def toU8(n: N64): U8 = N64_Ext.toU8(n);
    @pure def toU16(n: N64): U16 = N64_Ext.toU16(n);
    @pure def toU32(n: N64): U32 = N64_Ext.toU32(n);
    @pure def toU64(n: N64): U64 = N64_Ext.toU64(n);
    @pure def toR(n: N64): R = N64_Ext.toR(n)
  }

  @ext object S8 {
    @pure def toB(n: S8): B = S8_Ext.toB(n);
    @pure def toZ(n: S8): Z = S8_Ext.toZ(n);
    @pure def toZ8(n: S8): Z8 = S8_Ext.toZ8(n);
    @pure def toZ16(n: S8): Z16 = S8_Ext.toZ16(n);
    @pure def toZ32(n: S8): Z32 = S8_Ext.toZ32(n);
    @pure def toZ64(n: S8): Z64 = S8_Ext.toZ64(n);
    @pure def toN(n: S8): N = S8_Ext.toN(n);
    @pure def toN8(n: S8): N8 = S8_Ext.toN8(n);
    @pure def toN16(n: S8): N16 = S8_Ext.toN16(n);
    @pure def toN32(n: S8): N32 = S8_Ext.toN32(n);
    @pure def toN64(n: S8): N64 = S8_Ext.toN64(n);
    @pure def toS8(n: S8): S8 = S8_Ext.toS8(n);
    @pure def toS16(n: S8): S16 = S8_Ext.toS16(n);
    @pure def toS32(n: S8): S32 = S8_Ext.toS32(n);
    @pure def toS64(n: S8): S64 = S8_Ext.toS64(n);
    @pure def toU8(n: S8): U8 = S8_Ext.toU8(n);
    @pure def toRawU8(n: S8): U8 = S8_Ext.toRawU8(n);
    @pure def toU16(n: S8): U16 = S8_Ext.toU16(n);
    @pure def toU32(n: S8): U32 = S8_Ext.toU32(n);
    @pure def toU64(n: S8): U64 = S8_Ext.toU64(n)
  }

  @ext object S16 {
    @pure def toB(n: S16): B = S16_Ext.toB(n);
    @pure def toZ(n: S16): Z = S16_Ext.toZ(n);
    @pure def toZ8(n: S16): Z8 = S16_Ext.toZ8(n);
    @pure def toZ16(n: S16): Z16 = S16_Ext.toZ16(n);
    @pure def toZ32(n: S16): Z32 = S16_Ext.toZ32(n);
    @pure def toZ64(n: S16): Z64 = S16_Ext.toZ64(n);
    @pure def toN(n: S16): N = S16_Ext.toN(n);
    @pure def toN8(n: S16): N8 = S16_Ext.toN8(n);
    @pure def toN16(n: S16): N16 = S16_Ext.toN16(n);
    @pure def toN32(n: S16): N32 = S16_Ext.toN32(n);
    @pure def toN64(n: S16): N64 = S16_Ext.toN64(n);
    @pure def toS8(n: S16): S8 = S16_Ext.toS8(n);
    @pure def toS16(n: S16): S16 = S16_Ext.toS16(n);
    @pure def toS32(n: S16): S32 = S16_Ext.toS32(n);
    @pure def toS64(n: S16): S64 = S16_Ext.toS64(n);
    @pure def toU8(n: S16): U8 = S16_Ext.toU8(n);
    @pure def toU16(n: S16): U16 = S16_Ext.toU16(n);
    @pure def toRawU16(n: S16): U16 = S16_Ext.toRawU16(n);
    @pure def toU32(n: S16): U32 = S16_Ext.toU32(n);
    @pure def toU64(n: S16): U64 = S16_Ext.toU64(n)
  }

  @ext object S32 {
    @pure def toB(n: S32): B = S32_Ext.toB(n);
    @pure def toZ(n: S32): Z = S32_Ext.toZ(n);
    @pure def toZ8(n: S32): Z8 = S32_Ext.toZ8(n);
    @pure def toZ16(n: S32): Z16 = S32_Ext.toZ16(n);
    @pure def toZ32(n: S32): Z32 = S32_Ext.toZ32(n);
    @pure def toZ64(n: S32): Z64 = S32_Ext.toZ64(n);
    @pure def toN(n: S32): N = S32_Ext.toN(n);
    @pure def toN8(n: S32): N8 = S32_Ext.toN8(n);
    @pure def toN16(n: S32): N16 = S32_Ext.toN16(n);
    @pure def toN32(n: S32): N32 = S32_Ext.toN32(n);
    @pure def toN64(n: S32): N64 = S32_Ext.toN64(n);
    @pure def toS8(n: S32): S8 = S32_Ext.toS8(n);
    @pure def toS16(n: S32): S16 = S32_Ext.toS16(n);
    @pure def toS32(n: S32): S32 = S32_Ext.toS32(n);
    @pure def toS64(n: S32): S64 = S32_Ext.toS64(n);
    @pure def toU8(n: S32): U8 = S32_Ext.toU8(n);
    @pure def toU16(n: S32): U16 = S32_Ext.toU16(n);
    @pure def toU32(n: S32): U32 = S32_Ext.toU32(n);
    @pure def toRawU32(n: S32): U32 = S32_Ext.toRawU32(n);
    @pure def toU64(n: S32): U64 = S32_Ext.toU64(n)
  }

  @ext object S64 {
    @pure def toB(n: S64): B = S64_Ext.toB(n);
    @pure def toZ(n: S64): Z = S64_Ext.toZ(n);
    @pure def toZ8(n: S64): Z8 = S64_Ext.toZ8(n);
    @pure def toZ16(n: S64): Z16 = S64_Ext.toZ16(n);
    @pure def toZ32(n: S64): Z32 = S64_Ext.toZ32(n);
    @pure def toZ64(n: S64): Z64 = S64_Ext.toZ64(n);
    @pure def toN(n: S64): N = S64_Ext.toN(n);
    @pure def toN8(n: S64): N8 = S64_Ext.toN8(n);
    @pure def toN16(n: S64): N16 = S64_Ext.toN16(n);
    @pure def toN32(n: S64): N32 = S64_Ext.toN32(n);
    @pure def toN64(n: S64): N64 = S64_Ext.toN64(n);
    @pure def toS8(n: S64): S8 = S64_Ext.toS8(n);
    @pure def toS16(n: S64): S16 = S64_Ext.toS16(n);
    @pure def toS32(n: S64): S32 = S64_Ext.toS32(n);
    @pure def toS64(n: S64): S64 = S64_Ext.toS64(n);
    @pure def toU8(n: S64): U8 = S64_Ext.toU8(n);
    @pure def toU16(n: S64): U16 = S64_Ext.toU16(n);
    @pure def toU32(n: S64): U32 = S64_Ext.toU32(n);
    @pure def toU64(n: S64): U64 = S64_Ext.toU64(n);
    @pure def toRawU64(n: S64): U64 = S64_Ext.toRawU64(n)
  }

  @ext object U8 {
    @pure def toB(n: U8): B = U8_Ext.toB(n);
    @pure def toZ(n: U8): Z = U8_Ext.toZ(n);
    @pure def toZ8(n: U8): Z8 = U8_Ext.toZ8(n);
    @pure def toZ16(n: U8): Z16 = U8_Ext.toZ16(n);
    @pure def toZ32(n: U8): Z32 = U8_Ext.toZ32(n);
    @pure def toZ64(n: U8): Z64 = U8_Ext.toZ64(n);
    @pure def toN(n: U8): N = U8_Ext.toN(n);
    @pure def toN8(n: U8): N8 = U8_Ext.toN8(n);
    @pure def toN16(n: U8): N16 = U8_Ext.toN16(n);
    @pure def toN32(n: U8): N32 = U8_Ext.toN32(n);
    @pure def toN64(n: U8): N64 = U8_Ext.toN64(n);
    @pure def toS8(n: U8): S8 = U8_Ext.toS8(n);
    @pure def toRawS8(n: U8): S8 = U8_Ext.toRawS8(n);
    @pure def toS16(n: U8): S16 = U8_Ext.toS16(n);
    @pure def toS32(n: U8): S32 = U8_Ext.toS32(n);
    @pure def toS64(n: U8): S64 = U8_Ext.toS64(n);
    @pure def toU8(n: U8): U8 = U8_Ext.toU8(n);
    @pure def toU16(n: U8): U16 = U8_Ext.toU16(n);
    @pure def toU32(n: U8): U32 = U8_Ext.toU32(n);
    @pure def toU64(n: U8): U64 = U8_Ext.toU64(n)
  }

  @ext object U16 {
    @pure def toB(n: U16): B = U16_Ext.toB(n);
    @pure def toZ(n: U16): Z = U16_Ext.toZ(n);
    @pure def toZ8(n: U16): Z8 = U16_Ext.toZ8(n);
    @pure def toZ16(n: U16): Z16 = U16_Ext.toZ16(n);
    @pure def toZ32(n: U16): Z32 = U16_Ext.toZ32(n);
    @pure def toZ64(n: U16): Z64 = U16_Ext.toZ64(n);
    @pure def toN(n: U16): N = U16_Ext.toN(n);
    @pure def toN8(n: U16): N8 = U16_Ext.toN8(n);
    @pure def toN16(n: U16): N16 = U16_Ext.toN16(n);
    @pure def toN32(n: U16): N32 = U16_Ext.toN32(n);
    @pure def toN64(n: U16): N64 = U16_Ext.toN64(n);
    @pure def toS8(n: U16): S8 = U16_Ext.toS8(n);
    @pure def toS16(n: U16): S16 = U16_Ext.toS16(n);
    @pure def toRawS16(n: U16): S16 = U16_Ext.toRawS16(n);
    @pure def toS32(n: U16): S32 = U16_Ext.toS32(n);
    @pure def toS64(n: U16): S64 = U16_Ext.toS64(n);
    @pure def toU8(n: U16): U8 = U16_Ext.toU8(n);
    @pure def toU16(n: U16): U16 = U16_Ext.toU16(n);
    @pure def toU32(n: U16): U32 = U16_Ext.toU32(n);
    @pure def toU64(n: U16): U64 = U16_Ext.toU64(n)
  }

  @ext object U32 {
    @pure def toB(n: U32): B = U32_Ext.toB(n);
    @pure def toZ(n: U32): Z = U32_Ext.toZ(n);
    @pure def toZ8(n: U32): Z8 = U32_Ext.toZ8(n);
    @pure def toZ16(n: U32): Z16 = U32_Ext.toZ16(n);
    @pure def toZ32(n: U32): Z32 = U32_Ext.toZ32(n);
    @pure def toZ64(n: U32): Z64 = U32_Ext.toZ64(n);
    @pure def toN(n: U32): N = U32_Ext.toN(n);
    @pure def toN8(n: U32): N8 = U32_Ext.toN8(n);
    @pure def toN16(n: U32): N16 = U32_Ext.toN16(n);
    @pure def toN32(n: U32): N32 = U32_Ext.toN32(n);
    @pure def toN64(n: U32): N64 = U32_Ext.toN64(n);
    @pure def toS8(n: U32): S8 = U32_Ext.toS8(n);
    @pure def toS16(n: U32): S16 = U32_Ext.toS16(n);
    @pure def toS32(n: U32): S32 = U32_Ext.toS32(n);
    @pure def toRawS32(n: U32): S32 = U32_Ext.toRawS32(n);
    @pure def toS64(n: U32): S64 = U32_Ext.toS64(n);
    @pure def toU8(n: U32): U8 = U32_Ext.toU8(n);
    @pure def toU16(n: U32): U16 = U32_Ext.toU16(n);
    @pure def toU32(n: U32): U32 = U32_Ext.toU32(n);
    @pure def toU64(n: U32): U64 = U32_Ext.toU64(n);
    @pure def toRawF32(n: U32): F32 = U32_Ext.toRawF32(n);
    @pure def toC(n: U32): C = U32_Ext.toC(n)
  }

  @ext object U64 {
    @pure def toB(n: U64): B = U64_Ext.toB(n);
    @pure def toZ(n: U64): Z = U64_Ext.toZ(n);
    @pure def toZ8(n: U64): Z8 = U64_Ext.toZ8(n);
    @pure def toZ16(n: U64): Z16 = U64_Ext.toZ16(n);
    @pure def toZ32(n: U64): Z32 = U64_Ext.toZ32(n);
    @pure def toZ64(n: U64): Z64 = U64_Ext.toZ64(n);
    @pure def toN(n: U64): N = U64_Ext.toN(n);
    @pure def toN8(n: U64): N8 = U64_Ext.toN8(n);
    @pure def toN16(n: U64): N16 = U64_Ext.toN16(n);
    @pure def toN32(n: U64): N32 = U64_Ext.toN32(n);
    @pure def toN64(n: U64): N64 = U64_Ext.toN64(n);
    @pure def toS8(n: U64): S8 = U64_Ext.toS8(n);
    @pure def toS16(n: U64): S16 = U64_Ext.toS16(n);
    @pure def toS32(n: U64): S32 = U64_Ext.toS32(n);
    @pure def toS64(n: U64): S64 = U64_Ext.toS64(n);
    @pure def toRawS64(n: U64): S64 = U64_Ext.toRawS64(n);
    @pure def toU8(n: U64): U8 = U64_Ext.toU8(n);
    @pure def toU16(n: U64): U16 = U64_Ext.toU16(n);
    @pure def toU32(n: U64): U32 = U64_Ext.toU32(n);
    @pure def toU64(n: U64): U64 = U64_Ext.toU64(n);
    @pure def toRawF64(n: U64): F64 = U64_Ext.toRawF64(n)
  }

  @ext object F32 {
    @pure def toB(n: F32): B = F32_Ext.toB(n);
    @pure def toRawU32(n: F32): U32 = F32_Ext.toRawU32(n);
    @pure def toF32(n: F32): F32 = F32_Ext.toF32(n)
  }

  @ext object F64 {
    @pure def toB(n: F64): B = F64_Ext.toB(n);
    @pure def toRawU64(n: F64): U64 = F64_Ext.toRawU64(n);
    @pure def toF64(n: F64): F64 = F64_Ext.toF64(n)
  }

  @ext object R {
    @pure def toB(n: R): B = R_Ext.toB(n);
    @pure def toZ(n: R): Z = R_Ext.toZ(n);
    @pure def toN(n: R): N = R_Ext.toN(n);
    @pure def toR(n: R): R = R_Ext.toR(n)
  }

  @ext object String {
    @pure def fromBase64(s: String): Either[IS[Z, U8], String] = String_Ext.fromBase64(s);
    @pure def toBase64(data: IS[Z, U8]): String = String_Ext.toBase64(data);
    @pure def fromCis[I](cs: IS[I, C]): String = String_Ext.fromCis[I](cs);
    @pure def fromCms[I](cs: MS[I, C]): String = String_Ext.fromCms[I](cs);
    @pure def toCis(s: String): IS[Z, C] = String_Ext.toCis(s);
    @pure def toCms(s: String): MS[Z, C] = String_Ext.toCms(s)
  }
}