package org.sireum.message {
  import org.sireum._

  import org.sireum.U64._

  @enum object Level extends _root_.org.sireum.EnumSig {
    scala.Symbol("InternalError");
    scala.Symbol("Error");
    scala.Symbol("Warning");
    scala.Symbol("Info");
    sealed trait Type extends _root_.org.sireum.Immutable with _root_.scala.Ordered[Type] {
      def ordinal: _root_.org.sireum.Z;
      def name: _root_.org.sireum.String;
      final def hash: _root_.org.sireum.Z = hashCode;
      final def isEqual(other: Type): _root_.org.sireum.B = this.==(other);
      final def compare(that: Type): _root_.scala.Int = this.ordinal.compareTo(that.ordinal);
      final def string: _root_.org.sireum.String = toString
    };
    final def byName(name: _root_.org.sireum.String): _root_.org.sireum.Option[Type] = elements.elements.find(((x$1) => x$1.name.==(name))) match {
      case _root_.scala.Some((v @ _)) => _root_.org.sireum.Some(v)
      case _ => _root_.org.sireum.None()
    };
    final def byOrdinal(n: _root_.org.sireum.Z): _root_.org.sireum.Option[Type] = if ((0).<=(n).&&(n.<(elements.size)))
      _root_.org.sireum.Some(elements(n))
    else
      _root_.org.sireum.None();
    final case object InternalError extends Type with scala.Product with scala.Serializable {
      def ordinal: _root_.org.sireum.Z = 0;
      def name: _root_.org.sireum.String = "InternalError"
    };
    final case object Error extends Type with scala.Product with scala.Serializable {
      def ordinal: _root_.org.sireum.Z = 1;
      def name: _root_.org.sireum.String = "Error"
    };
    final case object Warning extends Type with scala.Product with scala.Serializable {
      def ordinal: _root_.org.sireum.Z = 2;
      def name: _root_.org.sireum.String = "Warning"
    };
    final case object Info extends Type with scala.Product with scala.Serializable {
      def ordinal: _root_.org.sireum.Z = 3;
      def name: _root_.org.sireum.String = "Info"
    };
    val numOfElements: _root_.org.sireum.Z = 4;
    val elements: _root_.org.sireum.ISZ[Type] = _root_.org.sireum.ISZ[Type](InternalError, Error, Warning, Info)
  }

  object Message {
    def apply(level: Level.Type, posOpt: Option[Position], kind: String, text: String): Message = new Message(level, posOpt, kind, text);
    def unapply(o: Message): _root_.scala.Option[scala.Tuple4[Level.Type, Option[Position], String, String]] = _root_.scala.Some(scala.Tuple4(o.level, o.posOpt, o.kind, o.text))
  }

  @datatype final class Message(__level: Level.Type, __posOpt: Option[Position], __kind: String, __text: String) extends _root_.org.sireum.DatatypeSig {
    private[this] val _level = __level;
    def level = _level;
    def getLevel = _level;
    private[this] val _bposOpt: _root_.scala.Boolean = __posOpt.isEmpty.value;
    private[this] val _posOpt: Position = __posOpt.getOrElse(null.asInstanceOf[Position]);
    def posOpt: Option[Position] = if (_bposOpt)
      None()
    else
      Some(_posOpt);
    def getPosOpt: Option[Position] = posOpt;
    private[this] val _kind = __kind;
    def kind = _kind;
    def getKind = _kind;
    private[this] val _text = __text;
    def text = _text;
    def getText = _text;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("Message");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.level));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(this.posOpt));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(this.kind));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(this.text));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, level, posOpt, kind, text).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): Message)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.level.==(o.level).&&(this.posOpt.==(o.posOpt)).&&(this.kind.==(o.kind)).&&(this.text.==(o.text))
          case _ => false
        };
    def apply(level: Level.Type = this.level, posOpt: Option[Position] = this.posOpt, kind: String = this.kind, text: String = this.text): Message = new Message(level, posOpt, kind, text);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "message", "Message")), scala.Tuple2("level", this.level), scala.Tuple2("posOpt", this.posOpt), scala.Tuple2("kind", this.kind), scala.Tuple2("text", this.text));
    def isInternalError: B = return _root_.org.sireum.helper.$assign(level.==(Level.InternalError));
    def isError: B = return _root_.org.sireum.helper.$assign(level.==(Level.Error));
    def isWarning: B = return _root_.org.sireum.helper.$assign(level.==(Level.Warning));
    def isInfo: B = return _root_.org.sireum.helper.$assign(level.==(Level.Info));
    def fileUriOpt: Option[String] = _root_.org.sireum.helper.$tmatch(posOpt) match {
      case Some((pos @ _)) => return _root_.org.sireum.helper.$assign(pos.uriOpt)
      case _ => return _root_.org.sireum.helper.$assign(None())
    }
  }

  @datatype sealed trait Position extends _root_.org.sireum.DatatypeSig {
    override def hashCode: _root_.scala.Int = hash.hashCode;
    final override protected val $hasEquals = true;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = o match {
      case (o @ ((_): Position)) => isEqual(o)
      case _ => halt("Invalid equality test between ".+(this.getClass).+(" and ").+(o.getClass))
    };
    final override protected val $hasString = true;
    override def toString: _root_.java.lang.String = string.value;
    StringContext(""" invariant beginLine ≥ 1
                 beginColumn ≥ 1
                 endLine ≥ 1
                 endColumn ≥ 1
                 offset ≥ 0
                 length ≥ 0 """).lUnit();
    @pure def uriOpt: Option[String];
    @pure def beginLine: Z;
    @pure def beginColumn: Z;
    @pure def endLine: Z;
    @pure def endColumn: Z;
    @pure def offset: Z;
    @pure def length: Z;
    @pure override def hash: Z = return _root_.org.sireum.helper.$assign(_root_.org.sireum.Z(scala.Tuple6(_root_.org.sireum.helper.$assign(uriOpt), _root_.org.sireum.helper.$assign(beginLine), _root_.org.sireum.helper.$assign(endLine), _root_.org.sireum.helper.$assign(endColumn), _root_.org.sireum.helper.$assign(offset), _root_.org.sireum.helper.$assign(length)).hashCode));
    @pure def isEqual(other: Position): B = return _root_.org.sireum.helper.$assign(uriOpt.==(other.uriOpt).&&(beginLine.==(other.beginLine)).&&(beginColumn.==(other.beginColumn)).&&(endLine.==(other.endLine)).&&(endColumn.==(other.endColumn)).&&(offset.==(other.offset)).&&(length.==(other.length)));
    @pure override def string: String = _root_.org.sireum.helper.$tmatch(uriOpt) match {
      case Some((fileUri @ _)) => {
        var i = _root_.org.sireum.helper.$assign(ops.StringOps(fileUri).lastIndexOf(_root_.org.sireum.C('/')));
        if (i.<(_root_.org.sireum.Z(0)))
          i = _root_.org.sireum.Z(0)
        else
          ();
        return StringContext("[", ", ", ", ", "]").s(ops.StringOps(fileUri).substring(i, fileUri.size), beginLine, beginColumn)
      }
      case _ => return StringContext("[", ", ", "]").s(beginLine, beginColumn)
    }
  }

  object FlatPos {
    def apply(uriOpt: Option[String], beginLine32: U32, beginColumn32: U32, endLine32: U32, endColumn32: U32, offset32: U32, length32: U32): FlatPos = new FlatPos(uriOpt, beginLine32, beginColumn32, endLine32, endColumn32, offset32, length32);
    def unapply(o: FlatPos): _root_.scala.Option[scala.Tuple7[Option[String], U32, U32, U32, U32, U32, U32]] = _root_.scala.Some(scala.Tuple7(o.uriOpt, o.beginLine32, o.beginColumn32, o.endLine32, o.endColumn32, o.offset32, o.length32))
  }

  @datatype final class FlatPos(__uriOpt: Option[String], __beginLine32: U32, __beginColumn32: U32, __endLine32: U32, __endColumn32: U32, __offset32: U32, __length32: U32) extends Position with _root_.org.sireum.DatatypeSig {
    private[this] val _buriOpt: _root_.scala.Boolean = __uriOpt.isEmpty.value;
    private[this] val _uriOpt: String = __uriOpt.getOrElse(null.asInstanceOf[String]);
    def uriOpt: Option[String] = if (_buriOpt)
      None()
    else
      Some(_uriOpt);
    def getUriOpt: Option[String] = uriOpt;
    private[this] val _beginLine32 = __beginLine32;
    def beginLine32 = _beginLine32;
    def getBeginLine32 = _beginLine32;
    private[this] val _beginColumn32 = __beginColumn32;
    def beginColumn32 = _beginColumn32;
    def getBeginColumn32 = _beginColumn32;
    private[this] val _endLine32 = __endLine32;
    def endLine32 = _endLine32;
    def getEndLine32 = _endLine32;
    private[this] val _endColumn32 = __endColumn32;
    def endColumn32 = _endColumn32;
    def getEndColumn32 = _endColumn32;
    private[this] val _offset32 = __offset32;
    def offset32 = _offset32;
    def getOffset32 = _offset32;
    private[this] val _length32 = __length32;
    def length32 = _length32;
    def getLength32 = _length32;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("FlatPos");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.uriOpt));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(this.beginLine32));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(this.beginColumn32));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(this.endLine32));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(this.endColumn32));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(this.offset32));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(this.length32));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, uriOpt, beginLine32, beginColumn32, endLine32, endColumn32, offset32, length32).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): FlatPos)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.uriOpt.==(o.uriOpt).&&(this.beginLine32.==(o.beginLine32)).&&(this.beginColumn32.==(o.beginColumn32)).&&(this.endLine32.==(o.endLine32)).&&(this.endColumn32.==(o.endColumn32)).&&(this.offset32.==(o.offset32)).&&(this.length32.==(o.length32))
          case _ => false
        };
    def apply(uriOpt: Option[String] = this.uriOpt, beginLine32: U32 = this.beginLine32, beginColumn32: U32 = this.beginColumn32, endLine32: U32 = this.endLine32, endColumn32: U32 = this.endColumn32, offset32: U32 = this.offset32, length32: U32 = this.length32): FlatPos = new FlatPos(uriOpt, beginLine32, beginColumn32, endLine32, endColumn32, offset32, length32);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "message", "FlatPos")), scala.Tuple2("uriOpt", this.uriOpt), scala.Tuple2("beginLine32", this.beginLine32), scala.Tuple2("beginColumn32", this.beginColumn32), scala.Tuple2("endLine32", this.endLine32), scala.Tuple2("endColumn32", this.endColumn32), scala.Tuple2("offset32", this.offset32), scala.Tuple2("length32", this.length32));
    @pure override def beginLine: Z = return _root_.org.sireum.helper.$assign(conversions.U32.toZ(beginLine32));
    @pure override def beginColumn: Z = return _root_.org.sireum.helper.$assign(conversions.U32.toZ(beginColumn32));
    @pure override def endLine: Z = return _root_.org.sireum.helper.$assign(conversions.U32.toZ(endLine32));
    @pure override def endColumn: Z = return _root_.org.sireum.helper.$assign(conversions.U32.toZ(endColumn32));
    @pure override def offset: Z = return _root_.org.sireum.helper.$assign(conversions.U32.toZ(offset32));
    @pure override def length: Z = return _root_.org.sireum.helper.$assign(conversions.U32.toZ(length32))
  }

  object PosInfo {
    def apply(info: DocInfo, offsetLength: U64): PosInfo = new PosInfo(info, offsetLength);
    def unapply(o: PosInfo): _root_.scala.Option[scala.Tuple2[DocInfo, U64]] = _root_.scala.Some(scala.Tuple2(o.info, o.offsetLength))
  }

  @datatype final class PosInfo(__info: DocInfo, __offsetLength: U64) extends Position with _root_.org.sireum.DatatypeSig {
    private[this] val _info = __info;
    def info = _info;
    def getInfo = _info;
    private[this] val _offsetLength = __offsetLength;
    def offsetLength = _offsetLength;
    def getOffsetLength = _offsetLength;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("PosInfo");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.info));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(this.offsetLength));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, info, offsetLength).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): PosInfo)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.info.==(o.info).&&(this.offsetLength.==(o.offsetLength))
          case _ => false
        };
    def apply(info: DocInfo = this.info, offsetLength: U64 = this.offsetLength): PosInfo = new PosInfo(info, offsetLength);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "message", "PosInfo")), scala.Tuple2("info", this.info), scala.Tuple2("offsetLength", this.offsetLength));
    @pure override def uriOpt: Option[String] = return _root_.org.sireum.helper.$assign(info.uriOpt);
    @pure override def beginLine: Z = return _root_.org.sireum.helper.$assign(conversions.U64.toZ(info.lineColumn(offsetLength).>>>(StringContext("32").u64())));
    @pure override def beginColumn: Z = return _root_.org.sireum.helper.$assign(conversions.U64.toZ(info.lineColumn(offsetLength).&(StringContext("0xFFFFFFFF").u64())));
    @pure override def endLine: Z = {
      val endOffset = _root_.org.sireum.helper.$assign(offsetLength.+(offsetLength.-(StringContext("1").u64()).<<(StringContext("32").u64())));
      return _root_.org.sireum.helper.$assign(conversions.U64.toZ(info.lineColumn(endOffset).>>>(StringContext("32").u64())))
    };
    @pure override def endColumn: Z = {
      val endOffset = _root_.org.sireum.helper.$assign(offsetLength.+(offsetLength.-(StringContext("1").u64()).<<(StringContext("32").u64())));
      return _root_.org.sireum.helper.$assign(conversions.U64.toZ(info.lineColumn(endOffset).&(StringContext("0xFFFFFFFF").u64())))
    };
    @pure override def offset: Z = return _root_.org.sireum.helper.$assign(conversions.U64.toZ(offsetLength.>>>(StringContext("32").u64())));
    @pure override def length: Z = return _root_.org.sireum.helper.$assign(conversions.U64.toZ(offsetLength.&(StringContext("0xFFFFFFFF").u64())))
  }

  object DocInfo {
    def apply(uriOpt: Option[String], lineOffsets: ISZ[U32]): DocInfo = new DocInfo(uriOpt, lineOffsets);
    def unapply(o: DocInfo): _root_.scala.Option[scala.Tuple2[Option[String], ISZ[U32]]] = _root_.scala.Some(scala.Tuple2(o.uriOpt, o.lineOffsets))
  }

  @datatype final class DocInfo(__uriOpt: Option[String], __lineOffsets: ISZ[U32]) extends _root_.org.sireum.DatatypeSig {
    private[this] val _buriOpt: _root_.scala.Boolean = __uriOpt.isEmpty.value;
    private[this] val _uriOpt: String = __uriOpt.getOrElse(null.asInstanceOf[String]);
    def uriOpt: Option[String] = if (_buriOpt)
      None()
    else
      Some(_uriOpt);
    def getUriOpt: Option[String] = uriOpt;
    private[this] val _lineOffsets = __lineOffsets;
    def lineOffsets = _lineOffsets;
    def getLineOffsets = _lineOffsets;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("DocInfo");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.uriOpt));
        sb.append(", ");
        sb.append(_root_.org.sireum.String.escape(this.lineOffsets));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, uriOpt, lineOffsets).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): DocInfo)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.uriOpt.==(o.uriOpt).&&(this.lineOffsets.==(o.lineOffsets))
          case _ => false
        };
    def apply(uriOpt: Option[String] = this.uriOpt, lineOffsets: ISZ[U32] = this.lineOffsets): DocInfo = new DocInfo(uriOpt, lineOffsets);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "message", "DocInfo")), scala.Tuple2("uriOpt", this.uriOpt), scala.Tuple2("lineOffsets", this.lineOffsets));
    @pure def lineColumn(offsetLength: U64): U64 = {
      val offsetLine = _root_.org.sireum.helper.$assign(conversions.U64.toU32(offsetLength.>>>(StringContext("32").u64())));
      @pure def computeLC(i: Z): U64 = {
        val line = _root_.org.sireum.helper.$assign(conversions.Z.toU64(i.+(_root_.org.sireum.Z(1))).<<(StringContext("32").u64()));
        val column = _root_.org.sireum.helper.$assign(conversions.U32.toU64(offsetLine.-(lineOffsets(i))).+(StringContext("1").u64()));
        return _root_.org.sireum.helper.$assign(line.|(column))
      };
      val size = _root_.org.sireum.helper.$assign(lineOffsets.size);
      var i = _root_.org.sireum.helper.$assign(size./(_root_.org.sireum.Z(2)));
      var max = _root_.org.sireum.helper.$assign(size.-(_root_.org.sireum.Z(1)));
      var min = StringContext("0").z();
      while (min.<(i).&&(i.<=(max))) 
        {
          val lineOffsetsI = _root_.org.sireum.helper.$assign(lineOffsets(i));
          if (offsetLine.<(lineOffsetsI))
            {
              if (lineOffsets(i.-(_root_.org.sireum.Z(1))).<=(offsetLine))
                return _root_.org.sireum.helper.$assign(computeLC(i.-(_root_.org.sireum.Z(1))))
              else
                ();
              max = _root_.org.sireum.helper.$assign(i);
              i = _root_.org.sireum.helper.$assign(i.-(i.-(min)./(_root_.org.sireum.Z(2))))
            }
          else
            if (offsetLine.==(lineOffsetsI))
              return _root_.org.sireum.helper.$assign(computeLC(i))
            else
              {
                min = _root_.org.sireum.helper.$assign(i);
                i = _root_.org.sireum.helper.$assign(i.+(max.-(i)./(_root_.org.sireum.Z(2))))
              }
        }
      ;
      return _root_.org.sireum.helper.$assign(if (i.<=(min))
        computeLC(min)
      else
        computeLC(max))
    }
  }
}