package org.sireum.ops {
  import org.sireum._

  @sig trait SOps[I, V] extends _root_.org.sireum.Immutable {
    @pure def contains(e: V): B;
    @pure def exists(p: _root_.scala.Function1[V, B @pure]): B;
    @pure def first: V;
    @pure def foldLeft[R](f: _root_.scala.Function2[R, V, R @pure], init: R): R;
    @pure def foldRight[R](f: _root_.scala.Function2[R, V, R @pure], init: R): R;
    @pure def parMapFoldLeft[U, R](f: _root_.scala.Function1[V, U @pure], g: _root_.scala.Function2[R, U, R @pure], init: R): R;
    def mParMapFoldLeft[U, R](f: _root_.scala.Function1[V, U], g: _root_.scala.Function2[R, U, R], init: R): R;
    @pure def parMapFoldRight[U, R](f: _root_.scala.Function1[V, U @pure], g: _root_.scala.Function2[R, U, R @pure], init: R): R;
    def mParMapFoldRight[U, R](f: _root_.scala.Function1[V, U], g: _root_.scala.Function2[R, U, R], init: R): R;
    @pure def forall(p: _root_.scala.Function1[V, B @pure]): B;
    @pure def indexOf(e: V): I;
    @pure def last: V
  }

  @sig trait ISOps[I, V] extends _root_.org.sireum.Immutable {
    @pure def :+(e: V): IS[I, V];
    @pure def +:(e: V): IS[I, V];
    @pure def ++(other: IS[I, V]): IS[I, V];
    @pure def chunk(size: Z): IS[Z, IS[I, V]];
    @pure def drop(size: Z): IS[I, V];
    @pure def dropRight(size: Z): IS[I, V];
    @pure def insert(i: I, e: V): IS[I, V];
    @pure def laxSlice(from: I, til: I): IS[I, V];
    @pure def map[U](f: _root_.scala.Function1[V, U @pure]): IS[I, U];
    @pure def remove(i: I): IS[I, V];
    @pure def reverse: IS[I, V];
    @pure def slice(from: I, til: I): IS[I, V];
    @pure def sortWith(lt: _root_.scala.Function2[V, V, B @pure]): IS[I, V];
    @pure def tail: IS[I, V];
    @pure def take(size: Z): IS[I, V];
    @pure def takeRight(size: Z): IS[Z, V]
  }

  @sig trait MSOps[I, V] extends _root_.org.sireum.Immutable {
    @pure def :+(e: V): MS[I, V];
    @pure def +:(e: V): MS[I, V];
    @pure def ++(other: MS[I, V]): MS[I, V];
    @pure def chunk(size: Z): MS[Z, MS[I, V]];
    @pure def drop(size: Z): MS[I, V];
    @pure def dropRight(size: Z): MS[I, V];
    @pure def insert(i: I, e: V): MS[I, V];
    @pure def laxSlice(from: I, til: I): MS[I, V];
    @pure def map[U](f: _root_.scala.Function1[V, U @pure]): MS[I, U];
    @pure def remove(i: I): MS[I, V];
    @pure def reverse: MS[I, V];
    @pure def slice(from: I, til: I): MS[I, V];
    @pure def sortWith(lt: _root_.scala.Function2[V, V, B @pure]): MS[I, V];
    @pure def tail: MS[I, V];
    @pure def take(size: Z): MS[I, V];
    @pure def takeRight(size: Z): MS[Z, V]
  }

  @ext object ISZOpsUtil {
    @pure def parMapFoldLeft[V, U, R](s: IS[Z, V], f: _root_.scala.Function1[V, U @pure], g: _root_.scala.Function2[R, U, R @pure], init: R): R = ISZOpsUtil_Ext.parMapFoldLeft[V, U, R](s, f, g, init);
    def mParMapFoldLeft[V, U, R](s: IS[Z, V], f: _root_.scala.Function1[V, U @pure], g: _root_.scala.Function2[R, U, R @pure], init: R): R = ISZOpsUtil_Ext.mParMapFoldLeft[V, U, R](s, f, g, init);
    @pure def parMapFoldRight[V, U, R](s: IS[Z, V], f: _root_.scala.Function1[V, U @pure], g: _root_.scala.Function2[R, U, R @pure], init: R): R = ISZOpsUtil_Ext.parMapFoldRight[V, U, R](s, f, g, init);
    def mParMapFoldRight[V, U, R](s: IS[Z, V], f: _root_.scala.Function1[V, U @pure], g: _root_.scala.Function2[R, U, R @pure], init: R): R = ISZOpsUtil_Ext.mParMapFoldRight[V, U, R](s, f, g, init);
    @pure def sortWith[V](s: IS[Z, V], lt: _root_.scala.Function2[V, V, B @pure]): IS[Z, V] = ISZOpsUtil_Ext.sortWith[V](s, lt)
  }

  object ISZOps {
    def apply[V](s: IS[Z, V]): ISZOps[V] = new ISZOps(s);
    def unapply[V](o: ISZOps[V]): _root_.scala.Option[IS[Z, V]] = _root_.scala.Some(o.s)
  }

  @datatype final class ISZOps[V](__s: IS[Z, V]) extends SOps[Z, V] with ISOps[Z, V] with _root_.org.sireum.DatatypeSig {
    private[this] val _s = __s;
    def s = _s;
    def getS = _s;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("ISZOps");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.s));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, s).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): ISZOps[V] @unchecked)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.s.==(o.s)
          case _ => false
        };
    def apply(s: IS[Z, V] = this.s): ISZOps[V] = new ISZOps(s);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "ops", "ISZOps")), scala.Tuple2("s", this.s));
    @pure def :+(e: V): IS[Z, V] = {
      StringContext(""" ensures result.size ≡ s.size + 1
                 ∀i: [0, result.size)  result(i) ≡ s(i)
                 result(result.size - 1) ≡ e            """).lUnit();
      return _root_.org.sireum.helper.$assign(s.:+(e))
    };
    @pure def +:(e: V): IS[Z, V] = {
      StringContext(""" ensures result.size ≡ s.size + 1
                 ∀i: [1, result.size)  result(i) ≡ s(i - 1)
                 result(0) ≡ e                              """).lUnit();
      return _root_.org.sireum.helper.$assign({
        val x$1 = _root_.org.sireum.helper.$assign(e);
        s.+:(x$1)
      })
    };
    @pure def ++(other: IS[Z, V]): IS[Z, V] = {
      StringContext(""" ensures result.size ≡ s.size + other.size
                 ∀i: [0, s.size)  result(i) ≡ s(i)
                 ∀i: [0, other.size)  result(s.size + i) ≡ other(i) """).lUnit();
      return _root_.org.sireum.helper.$assign(s.++(other))
    };
    @pure def chunk(size: Z): IS[Z, IS[Z, V]] = {
      StringContext(""" requires 0 < size
                  size <= s.size
         ensures  if (s.size % size ≡ 0) result.size * size ≡ s.size
                    else (result.size - 1) * size + s.size % size ≡ s.size
                  if (s.size % size ≡ 0) ∀i: [0, result.size)  result(i).size ≡ size
                    else ∀i: [0, result.size - 1)  result(i).size ≡ size
                  s.size % size ≠ 0 → result(result.size - 1).size ≡ s.size % size
                  ∀i: [0, result.size)
                    ∀j: [0, result(i).size)
                      s(i * result.size + j) ≡ result(i)(j)                          """).lUnit();
      var r = _root_.org.sireum.helper.$assign(IS[Z, IS[Z, V]]());
      var chunk = _root_.org.sireum.helper.$assign(IS[Z, V]());
      s.foreach(((e) => {
        if (chunk.size.==(size))
          {
            r = _root_.org.sireum.helper.$assign(r.:+(chunk));
            chunk = _root_.org.sireum.helper.$assign(IS[Z, V]())
          }
        else
          ();
        chunk = _root_.org.sireum.helper.$assign(chunk.:+(e))
      }));
      if (chunk.nonEmpty)
        r = _root_.org.sireum.helper.$assign(r.:+(chunk))
      else
        ();
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def contains(e: V): B = {
      StringContext(" ensures result ≡ (∃i: [0, s.size) s(i) ≡ e) ").lUnit();
      return _root_.org.sireum.helper.$assign(exists(((x: V) => x.==(e))))
    };
    @pure def drop(size: Z): IS[Z, V] = {
      StringContext(""" requires 0 ≤ size
                  size ≤ s.size
         ensures  result.size ≡ s.size - size
                  ∀i: [0, s.size - size)  result(i) ≡ s(size + i) """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(size, s.size))
    };
    @pure def dropRight(size: Z): IS[Z, V] = {
      StringContext(""" requires 0 ≤ size
                  size ≤ s.size
         ensures  result.size ≡ s.size - size
                  ∀i: [0, s.size - size)  result(i) ≡ s(i) """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(_root_.org.sireum.Z(0), s.size.-(size)))
    };
    @pure def exists(p: _root_.scala.Function1[V, B @pure]): B = {
      StringContext(" ensures result ≡ (∃i: [0, s.size) p(i)) ").lUnit();
      s.foreach(((e) => if (p(e))
        return _root_.org.sireum.helper.$assign(T)
      else
        ()));
      return _root_.org.sireum.helper.$assign(F)
    };
    @pure def first: V = {
      StringContext(""" requires s.size > 0
         ensures  result ≡ s(0) """).lUnit();
      return _root_.org.sireum.helper.$assign(s(_root_.org.sireum.Z(0)))
    };
    @pure def forall(p: _root_.scala.Function1[V, B @pure]): B = {
      StringContext(" ensures result ≡ (∀i: [0, s.size) p(i)) ").lUnit();
      s.foreach(((e) => if (p(e).`unary_!`)
        return _root_.org.sireum.helper.$assign(F)
      else
        ()));
      return _root_.org.sireum.helper.$assign(T)
    };
    @pure def foldLeft[R](f: _root_.scala.Function2[R, V, R @pure], init: R): R = {
      StringContext(" ensures result ≡ ISOps.foldLeftSpec(s, f, init, s.size - 1) ").lUnit();
      var r = _root_.org.sireum.helper.$assign(init);
      s.foreach(((e) => r = _root_.org.sireum.helper.$assign(f(r, e))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def foldRight[R](f: _root_.scala.Function2[R, V, R @pure], init: R): R = {
      StringContext(" ensures result ≡ ISOps.foldRightSpec(s, f, init, s.size - 1) ").lUnit();
      var r = _root_.org.sireum.helper.$assign(init);
      s.indices.reverse.foreach(((i) => r = _root_.org.sireum.helper.$assign(f(r, s(i)))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def insert(i: Z, e: V): IS[Z, V] = {
      StringContext(""" requires 0 ≤ i
                  i <= s.size
         ensures  result.size ≡ s.size + 1
                  ∀j: [0, i) result(j) ≡ s(j)
                  result(i) ≡ e
                  ∀j: [j, s.size) result(j + 1) ≡ s(j) """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(_root_.org.sireum.Z(0), i).:+(e).++(laxSlice(i, s.size)))
    };
    @pure def last: V = {
      StringContext(""" requires s.size > 0
         ensures  result ≡ s(s.size - 1) """).lUnit();
      return _root_.org.sireum.helper.$assign(s(s.size.-(_root_.org.sireum.Z(1))))
    };
    @pure def indexOf(e: V): Z = {
      StringContext(""" ensures (0 ≤ result ∧ result < s.size) → s(result) ≡ e
                 (result ≡ s.size) ≡ (∀i: [0, s.size) s(i) ≠ e)
                 ∃i: [0, s.size) s(i) ≡ e ∧ (∀j: [0, i) s(j) ≠ e) → result ≡ i
                 0 ≤ result
                 result ≤ s.size                                """).lUnit();
      StringContext("0").z().until(s.size).withFilter(((i) => e.==(s(i)))).foreach(((i) => return _root_.org.sireum.helper.$assign(i)));
      return _root_.org.sireum.helper.$assign(s.size)
    };
    @pure def laxSlice(from: Z, til: Z): IS[Z, V] = {
      StringContext(""" ensures if (til > from) result.size ≡ NO(til).min(s.size) - NO(0).max(from)
                   else result.size ≡ 0
                 ∀i: [i, result.size) result(i) ≡ s(NO(0).max(from) + i)               """).lUnit();
      var r = _root_.org.sireum.helper.$assign(IS[Z, V]());
      from.until(til).withFilter(((i) => _root_.org.sireum.Z(0).<=(i).&&(i.<(s.size)))).foreach(((i) => r = _root_.org.sireum.helper.$assign(r.:+(s(i)))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def map[U](f: _root_.scala.Function1[V, U @pure]): IS[Z, U] = {
      StringContext(""" ensures result.size ≡ s.size
                 ∀i: [0, result.size)  result(i) ≡ f(s(i)) """).lUnit();
      return _root_.org.sireum.helper.$assign(s.map(f))
    };
    @pure def parMapFoldLeft[U, R](f: _root_.scala.Function1[V, U @pure], g: _root_.scala.Function2[R, U, R @pure], init: R): R = {
      val r = _root_.org.sireum.helper.$assign(ISZOpsUtil.parMapFoldLeft(s, f, g, init));
      return _root_.org.sireum.helper.$assign(r)
    };
    def mParMapFoldLeft[U, R](f: _root_.scala.Function1[V, U], g: _root_.scala.Function2[R, U, R], init: R): R = {
      val r = _root_.org.sireum.helper.$assign(ISZOpsUtil.mParMapFoldLeft(s, f, g, init));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def parMapFoldRight[U, R](f: _root_.scala.Function1[V, U @pure], g: _root_.scala.Function2[R, U, R @pure], init: R): R = {
      val r = _root_.org.sireum.helper.$assign(ISZOpsUtil.parMapFoldRight(s, f, g, init));
      return _root_.org.sireum.helper.$assign(r)
    };
    def mParMapFoldRight[U, R](f: _root_.scala.Function1[V, U], g: _root_.scala.Function2[R, U, R], init: R): R = {
      val r = _root_.org.sireum.helper.$assign(ISZOpsUtil.mParMapFoldRight(s, f, g, init));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def remove(i: Z): IS[Z, V] = {
      StringContext(""" requires 0 ≤ i
                  i < s.size
         ensures  result.size ≡ s.size - 1
                  ∀j: [0, i)  result(j) ≡ s(j)
                  ∀j: [i, result.size)  result(j) ≡ s(j + 1)
     """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(_root_.org.sireum.Z(0), i).++(laxSlice(i.+(_root_.org.sireum.Z(1)), s.size)))
    };
    @pure def reverse: IS[Z, V] = {
      StringContext(""" ensures  result.size ≡ s.size
                  ∀i: [0, s.size)  result(i) ≡ s(s.size - 1 - i)
     """).lUnit();
      return _root_.org.sireum.helper.$assign(s.indices.reverse.map(((i) => s(i))))
    };
    @pure def slice(from: Z, til: Z): IS[Z, V] = {
      StringContext(""" requires 0 ≤ from
                  from < s.size
                  0 ≤ til
                  til ≤ s.size
                  from ≤ til
         ensures  result.size ≡ til - from
                  ∀i: [0, result.size) result(i) ≡ s(from + i) """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(from, til))
    };
    @pure def sortWith(lt: _root_.scala.Function2[V, V, B @pure]): IS[Z, V] = return _root_.org.sireum.helper.$assign(ISZOpsUtil.sortWith(s, lt));
    @pure def tail: IS[Z, V] = {
      StringContext(""" requires s.size > 0
         ensures  result.size ≡ s.size - 1
                  ∀i: [0, result.size)  result(i) ≡ s(i + 1) """).lUnit();
      return _root_.org.sireum.helper.$assign(drop(_root_.org.sireum.Z(1)))
    };
    @pure def take(size: Z): IS[Z, V] = {
      StringContext(""" requires 0 ≤ size
                  size ≤ s.size
         ensures  result.size ≡ size
                  ∀i: [0, result.size)  result(i) ≡ s(i) """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(_root_.org.sireum.Z(0), size))
    };
    @pure def takeRight(size: Z): IS[Z, V] = {
      StringContext(""" requires 0 ≤ size
                  size ≤ s.size
         ensures  result.size ≡ size
                  ∀i: [0, result.size)  result(i) ≡ s(s.size - size + i) """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(s.size.-(size), s.size))
    }
  }

  @ext object MSZOpsUtil {
    @pure def parMapFoldLeft[V, U, R](s: MS[Z, V], f: _root_.scala.Function1[V, U @pure], g: _root_.scala.Function2[R, U, R @pure], init: R): R = MSZOpsUtil_Ext.parMapFoldLeft[V, U, R](s, f, g, init);
    def mParMapFoldLeft[V, U, R](s: MS[Z, V], f: _root_.scala.Function1[V, U], g: _root_.scala.Function2[R, U, R], init: R): R = MSZOpsUtil_Ext.mParMapFoldLeft[V, U, R](s, f, g, init);
    @pure def parMapFoldRight[V, U, R](s: MS[Z, V], f: _root_.scala.Function1[V, U @pure], g: _root_.scala.Function2[R, U, R @pure], init: R): R = MSZOpsUtil_Ext.parMapFoldRight[V, U, R](s, f, g, init);
    def mParMapFoldRight[V, U, R](s: MS[Z, V], f: _root_.scala.Function1[V, U], g: _root_.scala.Function2[R, U, R], init: R): R = MSZOpsUtil_Ext.mParMapFoldRight[V, U, R](s, f, g, init);
    @pure def sortWith[V](s: MS[Z, V], lt: _root_.scala.Function2[V, V, B @pure]): MS[Z, V] = MSZOpsUtil_Ext.sortWith[V](s, lt)
  }

  object MSZOps {
    def apply[V](s: MS[Z, V]): MSZOps[V] = new MSZOps(s);
    def unapply[V](o: MSZOps[V]): _root_.scala.Option[MS[Z, V]] = _root_.scala.Some(o.s)
  }

  @datatype final class MSZOps[V](__s: MS[Z, V]) extends SOps[Z, V] with MSOps[Z, V] with _root_.org.sireum.DatatypeSig {
    private[this] val _s = __s;
    def s = _s;
    def getS = _s;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("MSZOps");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.s));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, s).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): MSZOps[V] @unchecked)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.s.==(o.s)
          case _ => false
        };
    def apply(s: MS[Z, V] = this.s): MSZOps[V] = new MSZOps(s);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "ops", "MSZOps")), scala.Tuple2("s", this.s));
    @pure def :+(e: V): MS[Z, V] = {
      StringContext(""" ensures result.size ≡ s.size + 1
                 ∀i: [0, result.size)  result(i) ≡ s(i)
                 result(result.size - 1) ≡ e            """).lUnit();
      return _root_.org.sireum.helper.$assign(s.:+(e))
    };
    @pure def +:(e: V): MS[Z, V] = {
      StringContext(""" ensures result.size ≡ s.size + 1
                 ∀i: [1, result.size)  result(i) ≡ s(i - 1)
                 result(0) ≡ e                              """).lUnit();
      return _root_.org.sireum.helper.$assign({
        val x$2 = _root_.org.sireum.helper.$assign(e);
        s.+:(x$2)
      })
    };
    @pure def ++(other: MS[Z, V]): MS[Z, V] = {
      StringContext(""" ensures result.size ≡ s.size + other.size
                 ∀i: [0, s.size)  result(i) ≡ s(i)
                 ∀i: [0, other.size)  result(s.size + i) ≡ other(i) """).lUnit();
      return _root_.org.sireum.helper.$assign(s.++(other))
    };
    @pure def chunk(size: Z): MS[Z, MS[Z, V]] = {
      StringContext(""" requires 0 < size
                  size <= s.size
         ensures  if (s.size % size ≡ 0) result.size * size ≡ s.size
                    else (result.size - 1) * size + s.size % size ≡ s.size
                  if (s.size % size ≡ 0) ∀i: [0, result.size)  result(i).size ≡ size
                    else ∀i: [0, result.size - 1)  result(i).size ≡ size
                  s.size % size ≠ 0 → result(result.size - 1).size ≡ s.size % size
                  ∀i: [0, result.size)
                    ∀j: [0, result(i).size)
                      s(i * result.size + j) ≡ result(i)(j)                          """).lUnit();
      var r = _root_.org.sireum.helper.$assign(MS[Z, MS[Z, V]]());
      var chunk = _root_.org.sireum.helper.$assign(MS[Z, V]());
      s.foreach(((e) => {
        if (chunk.size.==(size))
          {
            r = _root_.org.sireum.helper.$assign(r.:+(chunk));
            chunk = _root_.org.sireum.helper.$assign(MS[Z, V]())
          }
        else
          ();
        chunk = _root_.org.sireum.helper.$assign(chunk.:+(e))
      }));
      if (chunk.nonEmpty)
        r = _root_.org.sireum.helper.$assign(r.:+(chunk))
      else
        ();
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def contains(e: V): B = {
      StringContext(" ensures result ≡ (∃i: [0, s.size) s(i) ≡ e) ").lUnit();
      return _root_.org.sireum.helper.$assign(exists(((x: V) => x.==(e))))
    };
    @pure def drop(size: Z): MS[Z, V] = {
      StringContext(""" requires 0 ≤ size
                  size ≤ s.size
         ensures  result.size ≡ s.size - size
                  ∀i: [0, s.size - size)  result(i) ≡ s(size + i) """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(size, s.size))
    };
    @pure def dropRight(size: Z): MS[Z, V] = {
      StringContext(""" requires 0 ≤ size
                  size ≤ s.size
         ensures  result.size ≡ s.size - size
                  ∀i: [0, s.size - size)  result(i) ≡ s(i) """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(_root_.org.sireum.Z(0), s.size.-(size)))
    };
    @pure def exists(p: _root_.scala.Function1[V, B @pure]): B = {
      StringContext(" ensures result ≡ (∃i: [0, s.size) p(i)) ").lUnit();
      s.foreach(((e) => if (p(e))
        return _root_.org.sireum.helper.$assign(T)
      else
        ()));
      return _root_.org.sireum.helper.$assign(F)
    };
    @pure def first: V = {
      StringContext(""" requires s.size > 0
         ensures  result ≡ s(0) """).lUnit();
      return _root_.org.sireum.helper.$assign(s(_root_.org.sireum.Z(0)))
    };
    @pure def forall(p: _root_.scala.Function1[V, B @pure]): B = {
      StringContext(" ensures result ≡ (∀i: [0, s.size) p(i)) ").lUnit();
      s.foreach(((e) => if (p(e).`unary_!`)
        return _root_.org.sireum.helper.$assign(F)
      else
        ()));
      return _root_.org.sireum.helper.$assign(T)
    };
    @pure def foldLeft[R](f: _root_.scala.Function2[R, V, R @pure], init: R): R = {
      StringContext(" ensures result ≡ ISOps.foldLeftSpec(s, f, init, s.size - 1) ").lUnit();
      var r = _root_.org.sireum.helper.$assign(init);
      s.foreach(((e) => r = _root_.org.sireum.helper.$assign(f(r, e))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def foldRight[R](f: _root_.scala.Function2[R, V, R @pure], init: R): R = {
      StringContext(" ensures result ≡ ISOps.foldRightSpec(s, f, init, s.size - 1) ").lUnit();
      var r = _root_.org.sireum.helper.$assign(init);
      s.indices.reverse.foreach(((i) => r = _root_.org.sireum.helper.$assign(f(r, s(i)))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def insert(i: Z, e: V): MS[Z, V] = {
      StringContext(""" requires 0 ≤ i
                  i <= s.size
         ensures  result.size ≡ s.size + 1
                  ∀j: [0, i) result(j) ≡ s(j)
                  result(i) ≡ e
                  ∀j: [j, s.size) result(j + 1) ≡ s(j) """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(_root_.org.sireum.Z(0), i).:+(e).++(laxSlice(i, s.size)))
    };
    @pure def last: V = {
      StringContext(""" requires s.size > 0
         ensures  result ≡ s(s.size - 1) """).lUnit();
      return _root_.org.sireum.helper.$assign(s(s.size.-(_root_.org.sireum.Z(1))))
    };
    @pure def indexOf(e: V): Z = {
      StringContext(""" ensures (0 ≤ result ∧ result < s.size) → s(result) ≡ e
                 (result ≡ s.size) ≡ (∀i: [0, s.size) s(i) ≠ e)
                 ∃i: [0, s.size) s(i) ≡ e ∧ (∀j: [0, i) s(j) ≠ e) → result ≡ i
                 0 ≤ result
                 result ≤ s.size                                """).lUnit();
      StringContext("0").z().until(s.size).withFilter(((i) => e.==(s(i)))).foreach(((i) => return _root_.org.sireum.helper.$assign(i)));
      return _root_.org.sireum.helper.$assign(s.size)
    };
    @pure def laxSlice(from: Z, til: Z): MS[Z, V] = {
      StringContext(""" ensures if (til > from) result.size ≡ NO(til).min(s.size) - NO(0).max(from)
                   else result.size ≡ 0
                 ∀i: [i, result.size) result(i) ≡ s(NO(0).max(from) + i)               """).lUnit();
      var r = _root_.org.sireum.helper.$assign(MS[Z, V]());
      from.until(til).withFilter(((i) => _root_.org.sireum.Z(0).<=(i).&&(i.<(s.size)))).foreach(((i) => r = _root_.org.sireum.helper.$assign(r.:+(s(i)))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def map[U](f: _root_.scala.Function1[V, U @pure]): MS[Z, U] = {
      StringContext(""" ensures result.size ≡ s.size
                 ∀i: [0, result.size)  result(i) ≡ f(s(i)) """).lUnit();
      return _root_.org.sireum.helper.$assign(s.map(f))
    };
    @pure def parMapFoldLeft[U, R](f: _root_.scala.Function1[V, U @pure], g: _root_.scala.Function2[R, U, R @pure], init: R): R = {
      val r = _root_.org.sireum.helper.$assign(MSZOpsUtil.parMapFoldLeft(s, f, g, init));
      return _root_.org.sireum.helper.$assign(r)
    };
    def mParMapFoldLeft[U, R](f: _root_.scala.Function1[V, U], g: _root_.scala.Function2[R, U, R], init: R): R = {
      val r = _root_.org.sireum.helper.$assign(MSZOpsUtil.mParMapFoldLeft(s, f, g, init));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def parMapFoldRight[U, R](f: _root_.scala.Function1[V, U @pure], g: _root_.scala.Function2[R, U, R @pure], init: R): R = {
      val r = _root_.org.sireum.helper.$assign(MSZOpsUtil.parMapFoldRight(s, f, g, init));
      return _root_.org.sireum.helper.$assign(r)
    };
    def mParMapFoldRight[U, R](f: _root_.scala.Function1[V, U], g: _root_.scala.Function2[R, U, R], init: R): R = {
      val r = _root_.org.sireum.helper.$assign(MSZOpsUtil.mParMapFoldRight(s, f, g, init));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def remove(i: Z): MS[Z, V] = {
      StringContext(""" requires 0 ≤ i
                  i < s.size
         ensures  result.size ≡ s.size - 1
                  ∀j: [0, i)  result(j) ≡ s(j)
                  ∀j: [i, result.size)  result(j) ≡ s(j + 1)
     """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(_root_.org.sireum.Z(0), i).++(laxSlice(i.+(_root_.org.sireum.Z(1)), s.size)))
    };
    @pure def reverse: MS[Z, V] = {
      StringContext(""" ensures  result.size ≡ s.size
                  ∀i: [0, s.size)  result(i) ≡ s(s.size - 1 - i)
     """).lUnit();
      val r = _root_.org.sireum.helper.$assign(s);
      var i = _root_.org.sireum.Z(0);
      var j = _root_.org.sireum.helper.$assign(s.size.-(_root_.org.sireum.Z(1)));
      val half = _root_.org.sireum.helper.$assign(s.size./(_root_.org.sireum.Z(2)));
      while (i.<(half)) 
        {
          val t = _root_.org.sireum.helper.$assign(r(i));
          r.update(i, _root_.org.sireum.helper.$assign(r(j)));
          r.update(j, _root_.org.sireum.helper.$assign(t));
          i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)));
          j = _root_.org.sireum.helper.$assign(j.-(_root_.org.sireum.Z(1)))
        }
      ;
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def slice(from: Z, til: Z): MS[Z, V] = {
      StringContext(""" requires 0 ≤ from
                  from < s.size
                  0 ≤ til
                  til ≤ s.size
                  from ≤ til
         ensures  result.size ≡ til - from
                  ∀i: [0, result.size) result(i) ≡ s(from + i) """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(from, til))
    };
    @pure def sortWith(lt: _root_.scala.Function2[V, V, B @pure]): MS[Z, V] = return _root_.org.sireum.helper.$assign(MSZOpsUtil.sortWith(s, lt));
    @pure def tail: MS[Z, V] = {
      StringContext(""" requires s.size > 0
         ensures  result.size ≡ s.size - 1
                  ∀i: [0, result.size)  result(i) ≡ s(i + 1) """).lUnit();
      return _root_.org.sireum.helper.$assign(drop(_root_.org.sireum.Z(1)))
    };
    @pure def take(size: Z): MS[Z, V] = {
      StringContext(""" requires 0 ≤ size
                  size ≤ s.size
         ensures  result.size ≡ size
                  ∀i: [0, result.size)  result(i) ≡ s(i) """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(_root_.org.sireum.Z(0), size))
    };
    @pure def takeRight(size: Z): MS[Z, V] = {
      StringContext(""" requires 0 ≤ size
                  size ≤ s.size
         ensures  result.size ≡ size
                  ∀i: [0, result.size)  result(i) ≡ s(s.size - size + i) """).lUnit();
      return _root_.org.sireum.helper.$assign(laxSlice(s.size.-(size), s.size))
    }
  }

  @sig trait SBOps[I] extends _root_.org.sireum.Immutable {
    @pure def toU8: U8;
    @pure def toU16: U16;
    @pure def toU32: U32;
    @pure def toU64: U64
  }

  import org.sireum.U8._

  import org.sireum.U16._

  import org.sireum.U32._

  import org.sireum.U64._

  object ISZBOps {
    @pure def fromU8(n: U8): IS[Z, B] = {
      StringContext(""" ensures result.size ≡ 8
                 result(0) ≡ ((n & u8"0x01") ≠ u8"0x01") ∧
                 result(1) ≡ ((n & u8"0x02") ≠ u8"0x02") ∧
                 result(2) ≡ ((n & u8"0x04") ≠ u8"0x04") ∧
                 result(3) ≡ ((n & u8"0x08") ≠ u8"0x08") ∧
                 result(4) ≡ ((n & u8"0x10") ≠ u8"0x10") ∧
                 result(5) ≡ ((n & u8"0x20") ≠ u8"0x20") ∧
                 result(6) ≡ ((n & u8"0x40") ≠ u8"0x40") ∧
                 result(7) ≡ ((n & u8"0x80") ≠ u8"0x80")   """).lUnit();
      return _root_.org.sireum.helper.$assign(IS[Z, B](n.&(StringContext("0x01").u8()).!=(StringContext("0x01").u8()), n.&(StringContext("0x02").u8()).!=(StringContext("0x02").u8()), n.&(StringContext("0x04").u8()).!=(StringContext("0x04").u8()), n.&(StringContext("0x08").u8()).!=(StringContext("0x08").u8()), n.&(StringContext("0x10").u8()).!=(StringContext("0x10").u8()), n.&(StringContext("0x20").u8()).!=(StringContext("0x20").u8()), n.&(StringContext("0x40").u8()).!=(StringContext("0x40").u8()), n.&(StringContext("0x80").u8()).!=(StringContext("0x80").u8())))
    };
    @pure def fromU16(n: U16): IS[Z, B] = {
      StringContext(""" ensures result.size ≡ 16
                 result( 0) ≡ ((n & u16"0x0001") ≠ u16"0x0001") ∧
                 result( 1) ≡ ((n & u16"0x0002") ≠ u16"0x0002") ∧
                 result( 2) ≡ ((n & u16"0x0004") ≠ u16"0x0004") ∧
                 result( 3) ≡ ((n & u16"0x0008") ≠ u16"0x0008") ∧
                 result( 4) ≡ ((n & u16"0x0010") ≠ u16"0x0010") ∧
                 result( 5) ≡ ((n & u16"0x0020") ≠ u16"0x0020") ∧
                 result( 6) ≡ ((n & u16"0x0040") ≠ u16"0x0040") ∧
                 result( 7) ≡ ((n & u16"0x0080") ≠ u16"0x0080") ∧
                 result( 8) ≡ ((n & u16"0x0100") ≠ u16"0x0100") ∧
                 result( 9) ≡ ((n & u16"0x0200") ≠ u16"0x0200") ∧
                 result(10) ≡ ((n & u16"0x0400") ≠ u16"0x0400") ∧
                 result(11) ≡ ((n & u16"0x0800") ≠ u16"0x0800") ∧
                 result(12) ≡ ((n & u16"0x1000") ≠ u16"0x1000") ∧
                 result(13) ≡ ((n & u16"0x2000") ≠ u16"0x2000") ∧
                 result(14) ≡ ((n & u16"0x4000") ≠ u16"0x4000") ∧
                 result(15) ≡ ((n & u16"0x8000") ≠ u16"0x8000")   """).lUnit();
      return _root_.org.sireum.helper.$assign(IS[Z, B](n.&(StringContext("0x0001").u16()).!=(StringContext("0x0001").u16()), n.&(StringContext("0x0002").u16()).!=(StringContext("0x0002").u16()), n.&(StringContext("0x0004").u16()).!=(StringContext("0x0004").u16()), n.&(StringContext("0x0008").u16()).!=(StringContext("0x0008").u16()), n.&(StringContext("0x0010").u16()).!=(StringContext("0x0010").u16()), n.&(StringContext("0x0020").u16()).!=(StringContext("0x0020").u16()), n.&(StringContext("0x0040").u16()).!=(StringContext("0x0040").u16()), n.&(StringContext("0x0080").u16()).!=(StringContext("0x0080").u16()), n.&(StringContext("0x0100").u16()).!=(StringContext("0x0100").u16()), n.&(StringContext("0x0200").u16()).!=(StringContext("0x0200").u16()), n.&(StringContext("0x0400").u16()).!=(StringContext("0x0400").u16()), n.&(StringContext("0x0800").u16()).!=(StringContext("0x0800").u16()), n.&(StringContext("0x1000").u16()).!=(StringContext("0x1000").u16()), n.&(StringContext("0x2000").u16()).!=(StringContext("0x2000").u16()), n.&(StringContext("0x4000").u16()).!=(StringContext("0x4000").u16()), n.&(StringContext("0x8000").u16()).!=(StringContext("0x8000").u16())))
    };
    @pure def fromU32(s: IS[Z, B], n: U32): IS[Z, B] = {
      StringContext(""" ensures result.size ≡ 32
                 result( 0) ≡ ((n & u32"0x00000001") ≠ u32"0x00000001") ∧
                 result( 1) ≡ ((n & u32"0x00000002") ≠ u32"0x00000002") ∧
                 result( 2) ≡ ((n & u32"0x00000004") ≠ u32"0x00000004") ∧
                 result( 3) ≡ ((n & u32"0x00000008") ≠ u32"0x00000008") ∧
                 result( 4) ≡ ((n & u32"0x00000010") ≠ u32"0x00000010") ∧
                 result( 5) ≡ ((n & u32"0x00000020") ≠ u32"0x00000020") ∧
                 result( 6) ≡ ((n & u32"0x00000040") ≠ u32"0x00000040") ∧
                 result( 7) ≡ ((n & u32"0x00000080") ≠ u32"0x00000080") ∧
                 result( 8) ≡ ((n & u32"0x00000100") ≠ u32"0x00000100") ∧
                 result( 9) ≡ ((n & u32"0x00000200") ≠ u32"0x00000200") ∧
                 result(10) ≡ ((n & u32"0x00000400") ≠ u32"0x00000400") ∧
                 result(11) ≡ ((n & u32"0x00000800") ≠ u32"0x00000800") ∧
                 result(12) ≡ ((n & u32"0x00001000") ≠ u32"0x00001000") ∧
                 result(13) ≡ ((n & u32"0x00002000") ≠ u32"0x00002000") ∧
                 result(14) ≡ ((n & u32"0x00004000") ≠ u32"0x00004000") ∧
                 result(15) ≡ ((n & u32"0x00008000") ≠ u32"0x00008000") ∧
                 result(16) ≡ ((n & u32"0x00010000") ≠ u32"0x00010000") ∧
                 result(17) ≡ ((n & u32"0x00020000") ≠ u32"0x00020000") ∧
                 result(18) ≡ ((n & u32"0x00040000") ≠ u32"0x00040000") ∧
                 result(19) ≡ ((n & u32"0x00080000") ≠ u32"0x00080000") ∧
                 result(20) ≡ ((n & u32"0x00100000") ≠ u32"0x00100000") ∧
                 result(21) ≡ ((n & u32"0x00200000") ≠ u32"0x00200000") ∧
                 result(22) ≡ ((n & u32"0x00400000") ≠ u32"0x00400000") ∧
                 result(23) ≡ ((n & u32"0x00800000") ≠ u32"0x00800000") ∧
                 result(24) ≡ ((n & u32"0x01000000") ≠ u32"0x01000000") ∧
                 result(25) ≡ ((n & u32"0x02000000") ≠ u32"0x02000000") ∧
                 result(26) ≡ ((n & u32"0x04000000") ≠ u32"0x04000000") ∧
                 result(27) ≡ ((n & u32"0x08000000") ≠ u32"0x08000000") ∧
                 result(28) ≡ ((n & u32"0x10000000") ≠ u32"0x10000000") ∧
                 result(29) ≡ ((n & u32"0x20000000") ≠ u32"0x20000000") ∧
                 result(30) ≡ ((n & u32"0x40000000") ≠ u32"0x40000000") ∧
                 result(31) ≡ ((n & u32"0x80000000") ≠ u32"0x80000000")   """).lUnit();
      return _root_.org.sireum.helper.$assign(IS[Z, B](n.&(StringContext("0x00000001").u32()).!=(StringContext("0x00000001").u32()), n.&(StringContext("0x00000002").u32()).!=(StringContext("0x00000002").u32()), n.&(StringContext("0x00000004").u32()).!=(StringContext("0x00000004").u32()), n.&(StringContext("0x00000008").u32()).!=(StringContext("0x00000008").u32()), n.&(StringContext("0x00000010").u32()).!=(StringContext("0x00000010").u32()), n.&(StringContext("0x00000020").u32()).!=(StringContext("0x00000020").u32()), n.&(StringContext("0x00000040").u32()).!=(StringContext("0x00000040").u32()), n.&(StringContext("0x00000080").u32()).!=(StringContext("0x00000080").u32()), n.&(StringContext("0x00000100").u32()).!=(StringContext("0x00000100").u32()), n.&(StringContext("0x00000200").u32()).!=(StringContext("0x00000200").u32()), n.&(StringContext("0x00000400").u32()).!=(StringContext("0x00000400").u32()), n.&(StringContext("0x00000800").u32()).!=(StringContext("0x00000800").u32()), n.&(StringContext("0x00001000").u32()).!=(StringContext("0x00001000").u32()), n.&(StringContext("0x00002000").u32()).!=(StringContext("0x00002000").u32()), n.&(StringContext("0x00004000").u32()).!=(StringContext("0x00004000").u32()), n.&(StringContext("0x00008000").u32()).!=(StringContext("0x00008000").u32()), n.&(StringContext("0x00010000").u32()).!=(StringContext("0x00010000").u32()), n.&(StringContext("0x00020000").u32()).!=(StringContext("0x00020000").u32()), n.&(StringContext("0x00040000").u32()).!=(StringContext("0x00040000").u32()), n.&(StringContext("0x00080000").u32()).!=(StringContext("0x00080000").u32()), n.&(StringContext("0x00100000").u32()).!=(StringContext("0x00100000").u32()), n.&(StringContext("0x00200000").u32()).!=(StringContext("0x00200000").u32()), n.&(StringContext("0x00400000").u32()).!=(StringContext("0x00400000").u32()), n.&(StringContext("0x00800000").u32()).!=(StringContext("0x00800000").u32()), n.&(StringContext("0x01000000").u32()).!=(StringContext("0x01000000").u32()), n.&(StringContext("0x02000000").u32()).!=(StringContext("0x02000000").u32()), n.&(StringContext("0x04000000").u32()).!=(StringContext("0x04000000").u32()), n.&(StringContext("0x08000000").u32()).!=(StringContext("0x08000000").u32()), n.&(StringContext("0x10000000").u32()).!=(StringContext("0x10000000").u32()), n.&(StringContext("0x20000000").u32()).!=(StringContext("0x20000000").u32()), n.&(StringContext("0x40000000").u32()).!=(StringContext("0x40000000").u32()), n.&(StringContext("0x80000000").u32()).!=(StringContext("0x80000000").u32())))
    };
    @pure def fromU64(s: IS[Z, B], n: U64): IS[Z, B] = {
      StringContext(""" ensures result.size ≡ 64
                 result(  ) ≡ ((n & u64"0x0000000000000001") ≠ u64"0x0000000000000001") ∧
                 result( 1) ≡ ((n & u64"0x0000000000000002") ≠ u64"0x0000000000000002") ∧
                 result( 2) ≡ ((n & u64"0x0000000000000004") ≠ u64"0x0000000000000004") ∧
                 result( 3) ≡ ((n & u64"0x0000000000000008") ≠ u64"0x0000000000000008") ∧
                 result( 4) ≡ ((n & u64"0x0000000000000010") ≠ u64"0x0000000000000010") ∧
                 result( 5) ≡ ((n & u64"0x0000000000000020") ≠ u64"0x0000000000000020") ∧
                 result( 6) ≡ ((n & u64"0x0000000000000040") ≠ u64"0x0000000000000040") ∧
                 result( 7) ≡ ((n & u64"0x0000000000000080") ≠ u64"0x0000000000000080") ∧
                 result( 8) ≡ ((n & u64"0x0000000000000100") ≠ u64"0x0000000000000100") ∧
                 result( 9) ≡ ((n & u64"0x0000000000000200") ≠ u64"0x0000000000000200") ∧
                 result(10) ≡ ((n & u64"0x0000000000000400") ≠ u64"0x0000000000000400") ∧
                 result(11) ≡ ((n & u64"0x0000000000000800") ≠ u64"0x0000000000000800") ∧
                 result(12) ≡ ((n & u64"0x0000000000001000") ≠ u64"0x0000000000001000") ∧
                 result(13) ≡ ((n & u64"0x0000000000002000") ≠ u64"0x0000000000002000") ∧
                 result(14) ≡ ((n & u64"0x0000000000004000") ≠ u64"0x0000000000004000") ∧
                 result(15) ≡ ((n & u64"0x0000000000008000") ≠ u64"0x0000000000008000") ∧
                 result(16) ≡ ((n & u64"0x0000000000010000") ≠ u64"0x0000000000010000") ∧
                 result(17) ≡ ((n & u64"0x0000000000020000") ≠ u64"0x0000000000020000") ∧
                 result(18) ≡ ((n & u64"0x0000000000040000") ≠ u64"0x0000000000040000") ∧
                 result(19) ≡ ((n & u64"0x0000000000080000") ≠ u64"0x0000000000080000") ∧
                 result(20) ≡ ((n & u64"0x0000000000100000") ≠ u64"0x0000000000100000") ∧
                 result(21) ≡ ((n & u64"0x0000000000200000") ≠ u64"0x0000000000200000") ∧
                 result(22) ≡ ((n & u64"0x0000000000400000") ≠ u64"0x0000000000400000") ∧
                 result(23) ≡ ((n & u64"0x0000000000800000") ≠ u64"0x0000000000800000") ∧
                 result(24) ≡ ((n & u64"0x0000000001000000") ≠ u64"0x0000000001000000") ∧
                 result(25) ≡ ((n & u64"0x0000000002000000") ≠ u64"0x0000000002000000") ∧
                 result(26) ≡ ((n & u64"0x0000000004000000") ≠ u64"0x0000000004000000") ∧
                 result(27) ≡ ((n & u64"0x0000000008000000") ≠ u64"0x0000000008000000") ∧
                 result(28) ≡ ((n & u64"0x0000000010000000") ≠ u64"0x0000000010000000") ∧
                 result(29) ≡ ((n & u64"0x0000000020000000") ≠ u64"0x0000000020000000") ∧
                 result(30) ≡ ((n & u64"0x0000000040000000") ≠ u64"0x0000000040000000") ∧
                 result(31) ≡ ((n & u64"0x0000000080000000") ≠ u64"0x0000000080000000") ∧
                 result(32) ≡ ((n & u64"0x0000000100000000") ≠ u64"0x0000000100000000") ∧
                 result(33) ≡ ((n & u64"0x0000000200000000") ≠ u64"0x0000000200000000") ∧
                 result(34) ≡ ((n & u64"0x0000000400000000") ≠ u64"0x0000000400000000") ∧
                 result(35) ≡ ((n & u64"0x0000000800000000") ≠ u64"0x0000000800000000") ∧
                 result(36) ≡ ((n & u64"0x0000001000000000") ≠ u64"0x0000001000000000") ∧
                 result(37) ≡ ((n & u64"0x0000002000000000") ≠ u64"0x0000002000000000") ∧
                 result(38) ≡ ((n & u64"0x0000004000000000") ≠ u64"0x0000004000000000") ∧
                 result(39) ≡ ((n & u64"0x0000008000000000") ≠ u64"0x0000008000000000") ∧
                 result(40) ≡ ((n & u64"0x0000010000000000") ≠ u64"0x0000010000000000") ∧
                 result(41) ≡ ((n & u64"0x0000020000000000") ≠ u64"0x0000020000000000") ∧
                 result(42) ≡ ((n & u64"0x0000040000000000") ≠ u64"0x0000040000000000") ∧
                 result(43) ≡ ((n & u64"0x0000080000000000") ≠ u64"0x0000080000000000") ∧
                 result(44) ≡ ((n & u64"0x0000100000000000") ≠ u64"0x0000100000000000") ∧
                 result(45) ≡ ((n & u64"0x0000200000000000") ≠ u64"0x0000200000000000") ∧
                 result(46) ≡ ((n & u64"0x0000400000000000") ≠ u64"0x0000400000000000") ∧
                 result(47) ≡ ((n & u64"0x0000800000000000") ≠ u64"0x0000800000000000") ∧
                 result(48) ≡ ((n & u64"0x0001000000000000") ≠ u64"0x0001000000000000") ∧
                 result(49) ≡ ((n & u64"0x0002000000000000") ≠ u64"0x0002000000000000") ∧
                 result(50) ≡ ((n & u64"0x0004000000000000") ≠ u64"0x0004000000000000") ∧
                 result(51) ≡ ((n & u64"0x0008000000000000") ≠ u64"0x0008000000000000") ∧
                 result(52) ≡ ((n & u64"0x0010000000000000") ≠ u64"0x0010000000000000") ∧
                 result(53) ≡ ((n & u64"0x0020000000000000") ≠ u64"0x0020000000000000") ∧
                 result(54) ≡ ((n & u64"0x0040000000000000") ≠ u64"0x0040000000000000") ∧
                 result(55) ≡ ((n & u64"0x0080000000000000") ≠ u64"0x0080000000000000") ∧
                 result(56) ≡ ((n & u64"0x0100000000000000") ≠ u64"0x0100000000000000") ∧
                 result(57) ≡ ((n & u64"0x0200000000000000") ≠ u64"0x0200000000000000") ∧
                 result(58) ≡ ((n & u64"0x0400000000000000") ≠ u64"0x0400000000000000") ∧
                 result(59) ≡ ((n & u64"0x0800000000000000") ≠ u64"0x0800000000000000") ∧
                 result(60) ≡ ((n & u64"0x1000000000000000") ≠ u64"0x1000000000000000") ∧
                 result(61) ≡ ((n & u64"0x2000000000000000") ≠ u64"0x2000000000000000") ∧
                 result(62) ≡ ((n & u64"0x4000000000000000") ≠ u64"0x4000000000000000") ∧
                 result(63) ≡ ((n & u64"0x8000000000000000") ≠ u64"0x8000000000000000")   """).lUnit();
      IS[Z, B](n.&(StringContext("0x0000000000000001").u64()).!=(StringContext("0x0000000000000001").u64()), n.&(StringContext("0x0000000000000002").u64()).!=(StringContext("0x0000000000000002").u64()), n.&(StringContext("0x0000000000000004").u64()).!=(StringContext("0x0000000000000004").u64()), n.&(StringContext("0x0000000000000008").u64()).!=(StringContext("0x0000000000000008").u64()), n.&(StringContext("0x0000000000000010").u64()).!=(StringContext("0x0000000000000010").u64()), n.&(StringContext("0x0000000000000020").u64()).!=(StringContext("0x0000000000000020").u64()), n.&(StringContext("0x0000000000000040").u64()).!=(StringContext("0x0000000000000040").u64()), n.&(StringContext("0x0000000000000080").u64()).!=(StringContext("0x0000000000000080").u64()), n.&(StringContext("0x0000000000000100").u64()).!=(StringContext("0x0000000000000100").u64()), n.&(StringContext("0x0000000000000200").u64()).!=(StringContext("0x0000000000000200").u64()), n.&(StringContext("0x0000000000000400").u64()).!=(StringContext("0x0000000000000400").u64()), n.&(StringContext("0x0000000000000800").u64()).!=(StringContext("0x0000000000000800").u64()), n.&(StringContext("0x0000000000001000").u64()).!=(StringContext("0x0000000000001000").u64()), n.&(StringContext("0x0000000000002000").u64()).!=(StringContext("0x0000000000002000").u64()), n.&(StringContext("0x0000000000004000").u64()).!=(StringContext("0x0000000000004000").u64()), n.&(StringContext("0x0000000000008000").u64()).!=(StringContext("0x0000000000008000").u64()), n.&(StringContext("0x0000000000010000").u64()).!=(StringContext("0x0000000000010000").u64()), n.&(StringContext("0x0000000000020000").u64()).!=(StringContext("0x0000000000020000").u64()), n.&(StringContext("0x0000000000040000").u64()).!=(StringContext("0x0000000000040000").u64()), n.&(StringContext("0x0000000000080000").u64()).!=(StringContext("0x0000000000080000").u64()), n.&(StringContext("0x0000000000100000").u64()).!=(StringContext("0x0000000000100000").u64()), n.&(StringContext("0x0000000000200000").u64()).!=(StringContext("0x0000000000200000").u64()), n.&(StringContext("0x0000000000400000").u64()).!=(StringContext("0x0000000000400000").u64()), n.&(StringContext("0x0000000000800000").u64()).!=(StringContext("0x0000000000800000").u64()), n.&(StringContext("0x0000000001000000").u64()).!=(StringContext("0x0000000001000000").u64()), n.&(StringContext("0x0000000002000000").u64()).!=(StringContext("0x0000000002000000").u64()), n.&(StringContext("0x0000000004000000").u64()).!=(StringContext("0x0000000004000000").u64()), n.&(StringContext("0x0000000008000000").u64()).!=(StringContext("0x0000000008000000").u64()), n.&(StringContext("0x0000000010000000").u64()).!=(StringContext("0x0000000010000000").u64()), n.&(StringContext("0x0000000020000000").u64()).!=(StringContext("0x0000000020000000").u64()), n.&(StringContext("0x0000000040000000").u64()).!=(StringContext("0x0000000040000000").u64()), n.&(StringContext("0x0000000080000000").u64()).!=(StringContext("0x0000000080000000").u64()), n.&(StringContext("0x0000000100000000").u64()).!=(StringContext("0x0000000100000000").u64()), n.&(StringContext("0x0000000200000000").u64()).!=(StringContext("0x0000000200000000").u64()), n.&(StringContext("0x0000000400000000").u64()).!=(StringContext("0x0000000400000000").u64()), n.&(StringContext("0x0000000800000000").u64()).!=(StringContext("0x0000000800000000").u64()), n.&(StringContext("0x0000001000000000").u64()).!=(StringContext("0x0000001000000000").u64()), n.&(StringContext("0x0000002000000000").u64()).!=(StringContext("0x0000002000000000").u64()), n.&(StringContext("0x0000004000000000").u64()).!=(StringContext("0x0000004000000000").u64()), n.&(StringContext("0x0000008000000000").u64()).!=(StringContext("0x0000008000000000").u64()), n.&(StringContext("0x0000010000000000").u64()).!=(StringContext("0x0000010000000000").u64()), n.&(StringContext("0x0000020000000000").u64()).!=(StringContext("0x0000020000000000").u64()), n.&(StringContext("0x0000040000000000").u64()).!=(StringContext("0x0000040000000000").u64()), n.&(StringContext("0x0000080000000000").u64()).!=(StringContext("0x0000080000000000").u64()), n.&(StringContext("0x0000100000000000").u64()).!=(StringContext("0x0000100000000000").u64()), n.&(StringContext("0x0000200000000000").u64()).!=(StringContext("0x0000200000000000").u64()), n.&(StringContext("0x0000400000000000").u64()).!=(StringContext("0x0000400000000000").u64()), n.&(StringContext("0x0000800000000000").u64()).!=(StringContext("0x0000800000000000").u64()), n.&(StringContext("0x0001000000000000").u64()).!=(StringContext("0x0001000000000000").u64()), n.&(StringContext("0x0002000000000000").u64()).!=(StringContext("0x0002000000000000").u64()), n.&(StringContext("0x0004000000000000").u64()).!=(StringContext("0x0004000000000000").u64()), n.&(StringContext("0x0008000000000000").u64()).!=(StringContext("0x0008000000000000").u64()), n.&(StringContext("0x0010000000000000").u64()).!=(StringContext("0x0010000000000000").u64()), n.&(StringContext("0x0020000000000000").u64()).!=(StringContext("0x0020000000000000").u64()), n.&(StringContext("0x0040000000000000").u64()).!=(StringContext("0x0040000000000000").u64()), n.&(StringContext("0x0080000000000000").u64()).!=(StringContext("0x0080000000000000").u64()), n.&(StringContext("0x0100000000000000").u64()).!=(StringContext("0x0100000000000000").u64()), n.&(StringContext("0x0200000000000000").u64()).!=(StringContext("0x0200000000000000").u64()), n.&(StringContext("0x0400000000000000").u64()).!=(StringContext("0x0400000000000000").u64()), n.&(StringContext("0x0800000000000000").u64()).!=(StringContext("0x0800000000000000").u64()), n.&(StringContext("0x1000000000000000").u64()).!=(StringContext("0x1000000000000000").u64()), n.&(StringContext("0x2000000000000000").u64()).!=(StringContext("0x2000000000000000").u64()), n.&(StringContext("0x4000000000000000").u64()).!=(StringContext("0x4000000000000000").u64()), n.&(StringContext("0x8000000000000000").u64()).!=(StringContext("0x8000000000000000").u64()))
    };
    def apply(s: IS[Z, B]): ISZBOps = new ISZBOps(s);
    def unapply(o: ISZBOps): _root_.scala.Option[IS[Z, B]] = _root_.scala.Some(o.s)
  }

  @datatype final class ISZBOps(__s: IS[Z, B]) extends SBOps[Z] with _root_.org.sireum.DatatypeSig {
    private[this] val _s = __s;
    def s = _s;
    def getS = _s;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("ISZBOps");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.s));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, s).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): ISZBOps)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.s.==(o.s)
          case _ => false
        };
    def apply(s: IS[Z, B] = this.s): ISZBOps = new ISZBOps(s);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "ops", "ISZBOps")), scala.Tuple2("s", this.s));
    @pure def toU8: U8 = {
      StringContext(""" requires s.size ≡ 8
         ensures  fromU8(result) ≡ s """).lUnit();
      var r = StringContext("0").u8();
      var mask = StringContext("1").u8();
      _root_.org.sireum.Z(0).until(_root_.org.sireum.Z(8)).foreach(((i) => {
        if (s(i))
          r = _root_.org.sireum.helper.$assign(r.|(mask))
        else
          ();
        mask = _root_.org.sireum.helper.$assign(mask.<<(StringContext("1").u8()))
      }));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def toU16: U16 = {
      StringContext(""" requires s.size ≡ 16
         ensures  fromU16(result) ≡ s """).lUnit();
      var r = StringContext("0").u16();
      var mask = StringContext("1").u16();
      _root_.org.sireum.Z(0).until(_root_.org.sireum.Z(16)).foreach(((i) => {
        if (s(i))
          r = _root_.org.sireum.helper.$assign(r.|(mask))
        else
          ();
        mask = _root_.org.sireum.helper.$assign(mask.<<(StringContext("1").u16()))
      }));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def toU32: U32 = {
      StringContext(""" requires s.size ≡ 32
         ensures  fromU32(result) ≡ s """).lUnit();
      var r = StringContext("0").u32();
      var mask = StringContext("1").u32();
      _root_.org.sireum.Z(0).until(_root_.org.sireum.Z(32)).foreach(((i) => {
        if (s(i))
          r = _root_.org.sireum.helper.$assign(r.|(mask))
        else
          ();
        mask = _root_.org.sireum.helper.$assign(mask.<<(StringContext("1").u32()))
      }));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def toU64: U64 = {
      StringContext(""" requires s.size ≡ 64
         ensures  fromU64(result) ≡ s """).lUnit();
      var r = StringContext("0").u64();
      var mask = StringContext("1").u64();
      _root_.org.sireum.Z(0).until(_root_.org.sireum.Z(64)).foreach(((i) => {
        if (s(i))
          r = _root_.org.sireum.helper.$assign(r.|(mask))
        else
          ();
        mask = _root_.org.sireum.helper.$assign(mask.<<(StringContext("1").u64()))
      }));
      return _root_.org.sireum.helper.$assign(r)
    }
  }
}