package org.sireum {
  object Bag {
    @pure def empty[T]: Bag[T] = return _root_.org.sireum.helper.$assign(Bag(Map.empty[T, Z]));
    @pure def ++[I, T](s: IS[I, T]): Bag[T] = return _root_.org.sireum.helper.$assign(Bag.empty[T].++(s));
    def apply[T](map: Map[T, Z]): Bag[T] = new Bag(map);
    def unapply[T](o: Bag[T]): _root_.scala.Option[Map[T, Z]] = _root_.scala.Some(o.map)
  }

  @datatype final class Bag[T](__map: Map[T, Z]) extends _root_.org.sireum.DatatypeSig {
    private[this] val _map = __map;
    def map = _map;
    def getMap = _map;
    override def toString: _root_.java.lang.String = string.value;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, map).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): Bag[T] @unchecked)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.map.==(o.map)
          case _ => false
        };
    def apply(map: Map[T, Z] = this.map): Bag[T] = new Bag(map);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Bag")), scala.Tuple2("map", this.map));
    @pure def size: Z = {
      var r = StringContext("0").z();
      map.values.foreach(((n) => r = _root_.org.sireum.helper.$assign(r.+(n))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def elements: ISZ[T] = {
      var r = _root_.org.sireum.helper.$assign(ISZ[T]());
      entries.foreach(((entry) => {
        val x$1 = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(entry: @scala.unchecked) match {
          case scala.Tuple2((e @ _), (size @ _)) => scala.Tuple2(_root_.org.sireum.helper.$assign(e), _root_.org.sireum.helper.$assign(size))
        });
        val e = _root_.org.sireum.helper.$assign(x$1._1);
        val size = _root_.org.sireum.helper.$assign(x$1._2);
        r = _root_.org.sireum.helper.$assign(r.++(StringContext("0").z().until(size).map(((_ ) => e))))
      }));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def isEmpty: B = return _root_.org.sireum.helper.$assign(size.==(_root_.org.sireum.Z(0)));
    @pure def nonEmpty: B = return _root_.org.sireum.helper.$assign(isEmpty.`unary_!`);
    @pure def count(e: T): Z = _root_.org.sireum.helper.$tmatch(map.get(e)) match {
      case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
      case _ => return _root_.org.sireum.Z(0)
    };
    @pure def contains(e: T): B = return _root_.org.sireum.helper.$assign(count(e).>(_root_.org.sireum.Z(0)));
    @pure def +(e: T): Bag[T] = return _root_.org.sireum.helper.$assign(addN(e, _root_.org.sireum.Z(1)));
    @pure def addN(e: T, n: Z): Bag[T] = {
      if (n.<=(_root_.org.sireum.Z(0)))
        return _root_.org.sireum.helper.$assign(this)
      else
        ();
      return _root_.org.sireum.helper.$assign(this(map.+(e.~>(count(e).+(n)))))
    };
    @pure def +#(p: scala.Tuple2[T, Z]): Bag[T] = {
      val x$2 = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(p: @scala.unchecked) match {
        case scala.Tuple2((e @ _), (n @ _)) => scala.Tuple2(_root_.org.sireum.helper.$assign(e), _root_.org.sireum.helper.$assign(n))
      });
      val e = _root_.org.sireum.helper.$assign(x$2._1);
      val n = _root_.org.sireum.helper.$assign(x$2._2);
      return _root_.org.sireum.helper.$assign(addN(e, n))
    };
    @pure def ++[I](es: IS[I, T]): Bag[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      es.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.+(e))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def -(e: T): Bag[T] = return _root_.org.sireum.helper.$assign(removeN(e, _root_.org.sireum.Z(1)));
    @pure def --[I](es: IS[I, T]): Bag[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      es.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.-(e))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def \(other: Bag[T]): Bag[T] = return _root_.org.sireum.helper.$assign(this.--(other.elements));
    @pure def -#(p: scala.Tuple2[T, Z]): Bag[T] = {
      val x$3 = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(p: @scala.unchecked) match {
        case scala.Tuple2((e @ _), (n @ _)) => scala.Tuple2(_root_.org.sireum.helper.$assign(e), _root_.org.sireum.helper.$assign(n))
      });
      val e = _root_.org.sireum.helper.$assign(x$3._1);
      val n = _root_.org.sireum.helper.$assign(x$3._2);
      return _root_.org.sireum.helper.$assign(removeN(e, n))
    };
    @pure def removeN(e: T, n: Z): Bag[T] = {
      val current = _root_.org.sireum.helper.$assign(count(e));
      val newN = _root_.org.sireum.helper.$assign(current.-(n));
      if (newN.<=(_root_.org.sireum.Z(0)))
        return _root_.org.sireum.helper.$assign(this(map.-(e.~>(current))))
      else
        return _root_.org.sireum.helper.$assign(this(map.+(e.~>(newN))))
    };
    @pure def entries: ISZ[scala.Tuple2[T, Z]] = return _root_.org.sireum.helper.$assign(map.entries);
    @pure def union(other: Bag[T]): Bag[T] = return _root_.org.sireum.helper.$assign(this.∪(other));
    @pure def ∪(other: Bag[T]): Bag[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      other.entries.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.+#(e._1.~>(e._2)))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def intersect(other: Bag[T]): Bag[T] = return _root_.org.sireum.helper.$assign(this.∩(other));
    @pure def ∩(other: Bag[T]): Bag[T] = {
      var r = _root_.org.sireum.helper.$assign(Bag.empty[T]);
      entries.foreach(((e) => {
        val n = _root_.org.sireum.helper.$assign(e._2);
        val m = _root_.org.sireum.helper.$assign(other.count(e._1));
        if (n.<(m))
          r = _root_.org.sireum.helper.$assign(r.+#(e._1.~>(n)))
        else
          r = _root_.org.sireum.helper.$assign(r.+#(e._1.~>(m)))
      }));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure override def string: String = return _root_.org.sireum.helper.$assign(map.string)
  }
}