package org.sireum {
  import org.sireum.ops._

  import Z8._

  import Z16._

  import Z32._

  import Z64._

  import N._

  import N8._

  import N16._

  import N32._

  import N64._

  import S8._

  import S16._

  import S32._

  import S64._

  import U8._

  import U16._

  import U32._

  import U64._

  object Json {
    @sig trait JsonAstBinding[V] extends _root_.org.sireum.Immutable {
      @pure def toObject(fields: ISZ[scala.Tuple2[String, V]]): V;
      @pure def toArray(elements: ISZ[V]): V;
      @pure def toNumber(s: String): V;
      @pure def toString(s: String): V;
      @pure def toNull: V;
      @pure def toBoolean(b: B): V;
      @pure def kind(o: V): ValueKind.Type;
      @pure def fromObject(o: V): ISZ[scala.Tuple2[String, V]];
      @pure def fromArray(o: V): ISZ[V];
      @pure def fromNumber(o: V): String;
      @pure def fromString(o: V): String;
      @pure def fromBoolean(o: V): B
    };
    object ErrorMsg {
      def apply(line: Z, column: Z, message: String): ErrorMsg = new ErrorMsg(line, column, message);
      def unapply(o: ErrorMsg): _root_.scala.Option[scala.Tuple3[Z, Z, String]] = _root_.scala.Some(scala.Tuple3(o.line, o.column, o.message))
    };
    @datatype final class ErrorMsg(__line: Z, __column: Z, __message: String) extends _root_.org.sireum.DatatypeSig {
      private[this] val _line = __line;
      def line = _line;
      def getLine = _line;
      private[this] val _column = __column;
      def column = _column;
      def getColumn = _column;
      private[this] val _message = __message;
      def message = _message;
      def getMessage = _message;
      override def toString: _root_.java.lang.String = if ($hasString)
        super.string.value
      else
        {
          val sb = new _root_.java.lang.StringBuilder();
          sb.append("ErrorMsg");
          sb.append('(');
          sb.append(_root_.org.sireum.String.escape(this.line));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.column));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.message));
          sb.append(')');
          sb.toString
        };
      override def string: _root_.org.sireum.String = if ($hasString)
        super.string
      else
        toString;
      override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
        super.hashCode
      else
        _root_.scala.Seq(this.getClass, line, column, message).hashCode;
      override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
        super.equals(o)
      else
        if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
          true
        else
          o match {
            case (o @ ((_): ErrorMsg)) => if (this.hashCode.!=(o.hashCode))
              false
            else
              this.line.==(o.line).&&(this.column.==(o.column)).&&(this.message.==(o.message))
            case _ => false
          };
      def apply(line: Z = this.line, column: Z = this.column, message: String = this.message): ErrorMsg = new ErrorMsg(line, column, message);
      override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "ErrorMsg")), scala.Tuple2("line", this.line), scala.Tuple2("column", this.column), scala.Tuple2("message", this.message))
    };
    @enum object ValueKind extends _root_.org.sireum.EnumSig {
      scala.Symbol("String");
      scala.Symbol("Number");
      scala.Symbol("Object");
      scala.Symbol("Array");
      scala.Symbol("True");
      scala.Symbol("False");
      scala.Symbol("Null");
      sealed trait Type extends _root_.org.sireum.Immutable with _root_.scala.Ordered[Type] {
        def ordinal: _root_.org.sireum.Z;
        def name: _root_.org.sireum.String;
        final def hash: _root_.org.sireum.Z = hashCode;
        final def isEqual(other: Type): _root_.org.sireum.B = this.==(other);
        final def compare(that: Type): _root_.scala.Int = this.ordinal.compareTo(that.ordinal);
        final def string: _root_.org.sireum.String = toString
      };
      final def byName(name: _root_.org.sireum.String): _root_.org.sireum.Option[Type] = elements.elements.find(((x$1) => x$1.name.==(name))) match {
        case _root_.scala.Some((v @ _)) => _root_.org.sireum.Some(v)
        case _ => _root_.org.sireum.None()
      };
      final def byOrdinal(n: _root_.org.sireum.Z): _root_.org.sireum.Option[Type] = if ((0).<=(n).&&(n.<(elements.size)))
        _root_.org.sireum.Some(elements(n))
      else
        _root_.org.sireum.None();
      final case object String extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 0;
        def name: _root_.org.sireum.String = "String"
      };
      final case object Number extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 1;
        def name: _root_.org.sireum.String = "Number"
      };
      final case object Object extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 2;
        def name: _root_.org.sireum.String = "Object"
      };
      final case object Array extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 3;
        def name: _root_.org.sireum.String = "Array"
      };
      final case object True extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 4;
        def name: _root_.org.sireum.String = "True"
      };
      final case object False extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 5;
        def name: _root_.org.sireum.String = "False"
      };
      final case object Null extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 6;
        def name: _root_.org.sireum.String = "Null"
      };
      val numOfElements: _root_.org.sireum.Z = 7;
      val elements: _root_.org.sireum.ISZ[Type] = _root_.org.sireum.ISZ[Type](String, Number, Object, Array, True, False, Null)
    };
    object Printer {
      val trueSt: ST = StringContext("true").st();
      val falseSt: ST = StringContext("false").st();
      val nullSt: ST = StringContext("null").st();
      @pure def printB(b: B): ST = if (b)
        return _root_.org.sireum.helper.$assign(trueSt)
      else
        return _root_.org.sireum.helper.$assign(falseSt);
      @pure def printC(c: C): ST = return _root_.org.sireum.helper.$assign(printString(c.string));
      @pure def printZ(n: Z): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printZ8(n: Z8): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printZ16(n: Z16): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printZ32(n: Z32): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printZ64(n: Z64): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printN(n: N): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printN8(n: N8): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printN16(n: N16): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printN32(n: N32): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printN64(n: N64): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printS8(n: S8): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printS16(n: S16): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printS32(n: S32): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printS64(n: S64): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printU8(n: U8): ST = return _root_.org.sireum.helper.$assign(printNumber(conversions.U8.toZ(n).string));
      @pure def printU16(n: U16): ST = return _root_.org.sireum.helper.$assign(printNumber(conversions.U16.toZ(n).string));
      @pure def printU32(n: U32): ST = return _root_.org.sireum.helper.$assign(printNumber(conversions.U32.toZ(n).string));
      @pure def printU64(n: U64): ST = return _root_.org.sireum.helper.$assign(printNumber(conversions.U64.toZ(n).string));
      @pure def printF32(n: F32): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printF64(n: F64): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printR(n: R): ST = return _root_.org.sireum.helper.$assign(printNumber(n.string));
      @pure def printISZ[T](isSimple: B, s: IS[Z, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISZ8[T](isSimple: B, s: IS[Z8, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISZ16[T](isSimple: B, s: IS[Z16, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISZ32[T](isSimple: B, s: IS[Z32, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISZ64[T](isSimple: B, s: IS[Z64, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISN[T](isSimple: B, s: IS[N, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISN8[T](isSimple: B, s: IS[N8, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISN16[T](isSimple: B, s: IS[N16, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISN32[T](isSimple: B, s: IS[N32, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISN64[T](isSimple: B, s: IS[N64, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISS8[T](isSimple: B, s: IS[S8, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISS16[T](isSimple: B, s: IS[S16, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISS32[T](isSimple: B, s: IS[S32, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISS64[T](isSimple: B, s: IS[S64, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISU8[T](isSimple: B, s: IS[U8, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISU16[T](isSimple: B, s: IS[U16, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISU32[T](isSimple: B, s: IS[U32, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printISU64[T](isSimple: B, s: IS[U64, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printIS(isSimple, s.map(f)));
      @pure def printMSZ[T](isSimple: B, s: MS[Z, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSZ8[T](isSimple: B, s: MS[Z8, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSZ16[T](isSimple: B, s: MS[Z16, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSZ32[T](isSimple: B, s: MS[Z32, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSZ64[T](isSimple: B, s: MS[Z64, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSN[T](isSimple: B, s: MS[N, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSN8[T](isSimple: B, s: MS[N8, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSN16[T](isSimple: B, s: MS[N16, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSN32[T](isSimple: B, s: MS[N32, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSN64[T](isSimple: B, s: MS[N64, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSS8[T](isSimple: B, s: MS[S8, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSS16[T](isSimple: B, s: MS[S16, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSS32[T](isSimple: B, s: MS[S32, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSS64[T](isSimple: B, s: MS[S64, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSU8[T](isSimple: B, s: MS[U8, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSU16[T](isSimple: B, s: MS[U16, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSU32[T](isSimple: B, s: MS[U32, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printMSU64[T](isSimple: B, s: MS[U64, T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map(f)));
      @pure def printZS(isSimple: B, s: ZS): ST = return _root_.org.sireum.helper.$assign(printMS(isSimple, s.map((printZ _))));
      @pure def printOption[T](isSimple: B, o: Option[T], f: _root_.scala.Function1[T, ST]): ST = _root_.org.sireum.helper.$tmatch(o) match {
        case Some((t @ _)) => return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Some")))), scala.Tuple2(_root_.org.sireum.String("value"), _root_.org.sireum.helper.$assign(f(t))))))
        case _ => return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("None")))))))
      };
      @pure def printMOption[T](isSimple: B, o: MOption[T], f: _root_.scala.Function1[T, ST]): ST = _root_.org.sireum.helper.$tmatch(o) match {
        case MSome((t @ _)) => return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Some")))), scala.Tuple2(_root_.org.sireum.String("value"), _root_.org.sireum.helper.$assign(f(t))))))
        case _ => return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("None")))))))
      };
      @pure def printEither[L, R](isSimple: B, o: Either[L, R], f0: _root_.scala.Function1[L, ST], f1: _root_.scala.Function1[R, ST]): ST = _root_.org.sireum.helper.$tmatch(o) match {
        case Either.Left((l @ _)) => return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Or")))), scala.Tuple2(_root_.org.sireum.String("i"), _root_.org.sireum.helper.$assign(printZ(_root_.org.sireum.Z(0)))), scala.Tuple2(_root_.org.sireum.String("value"), _root_.org.sireum.helper.$assign(f0(l))))))
        case Either.Right((r @ _)) => return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Or")))), scala.Tuple2(_root_.org.sireum.String("i"), _root_.org.sireum.helper.$assign(printZ(_root_.org.sireum.Z(1)))), scala.Tuple2(_root_.org.sireum.String("value"), _root_.org.sireum.helper.$assign(f1(r))))))
        case _ => {
          assume(F);
          return _root_.org.sireum.helper.$assign(nullSt)
        }
      };
      @pure def printMEither[L, R](isSimple: B, o: MEither[L, R], f0: _root_.scala.Function1[L, ST], f1: _root_.scala.Function1[R, ST]): ST = _root_.org.sireum.helper.$tmatch(o) match {
        case MEither.Left((l @ _)) => return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Or")))), scala.Tuple2(_root_.org.sireum.String("i"), _root_.org.sireum.helper.$assign(printZ(_root_.org.sireum.Z(0)))), scala.Tuple2(_root_.org.sireum.String("value"), _root_.org.sireum.helper.$assign(f0(l))))))
        case MEither.Right((r @ _)) => return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Or")))), scala.Tuple2(_root_.org.sireum.String("i"), _root_.org.sireum.helper.$assign(printZ(_root_.org.sireum.Z(1)))), scala.Tuple2(_root_.org.sireum.String("value"), _root_.org.sireum.helper.$assign(f1(r))))))
        case _ => {
          assume(F);
          return _root_.org.sireum.helper.$assign(nullSt)
        }
      };
      @pure def printMap[K, V](isSimple: B, o: Map[K, V], k: _root_.scala.Function1[K, ST], v: _root_.scala.Function1[V, ST]): ST = {
        val entries: ST = _root_.org.sireum.helper.$assign(if (isSimple)
          {
            var es = _root_.org.sireum.helper.$assign(ISZ[ST]());
            o.entries.foreach(((e) => {
              val key = _root_.org.sireum.helper.$assign(k(e._1));
              val value = _root_.org.sireum.helper.$assign(v(e._2));
              es = _root_.org.sireum.helper.$assign(es.:+(StringContext("[ ", ", ", " ]").st(key, value)))
            }));
            StringContext("[ ", " ]").st(scala.Tuple2(_root_.org.sireum.helper.$assign(es), _root_.org.sireum.String(",")))
          }
        else
          {
            var es = _root_.org.sireum.helper.$assign(ISZ[ST]());
            o.entries.foreach(((e) => {
              val key = _root_.org.sireum.helper.$assign(k(e._1));
              val value = _root_.org.sireum.helper.$assign(v(e._2));
              es = _root_.org.sireum.helper.$assign(es.:+(StringContext("""[
            |  """, """,
            |  """, """
            |]""").st(key, value)))
            }));
            StringContext("""[
        |  """, """
        |]""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(es), _root_.org.sireum.String(",\n")))
          });
        return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Map")))), scala.Tuple2(_root_.org.sireum.String("entries"), _root_.org.sireum.helper.$assign(entries)))))
      };
      @pure def printSet[T](isSimple: B, o: Set[T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Set")))), scala.Tuple2(_root_.org.sireum.String("elements"), _root_.org.sireum.helper.$assign(if (isSimple)
        StringContext("[", "]").st(scala.Tuple2(_root_.org.sireum.helper.$assign(o.elements.map(f)), _root_.org.sireum.String(", ")))
      else
        StringContext("""[
            |  """, """
            |]""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(o.elements.map(f)), _root_.org.sireum.String(",\n"))))))));
      @pure def printHashMap[K, V](isSimple: B, o: HashMap[K, V], k: _root_.scala.Function1[K, ST], v: _root_.scala.Function1[V, ST]): ST = {
        val entries: ST = _root_.org.sireum.helper.$assign(if (isSimple)
          {
            var es = _root_.org.sireum.helper.$assign(ISZ[ST]());
            o.entries.foreach(((e) => {
              val key = _root_.org.sireum.helper.$assign(k(e._1));
              val value = _root_.org.sireum.helper.$assign(v(e._2));
              es = _root_.org.sireum.helper.$assign(es.:+(StringContext("[ ", ", ", " ]").st(key, value)))
            }));
            StringContext("[ ", " ]").st(scala.Tuple2(_root_.org.sireum.helper.$assign(es), _root_.org.sireum.String(",")))
          }
        else
          {
            var es = _root_.org.sireum.helper.$assign(ISZ[ST]());
            o.entries.foreach(((e) => {
              val key = _root_.org.sireum.helper.$assign(k(e._1));
              val value = _root_.org.sireum.helper.$assign(v(e._2));
              es = _root_.org.sireum.helper.$assign(es.:+(StringContext("""[
            |  """, """,
            |  """, """
            |]""").st(key, value)))
            }));
            StringContext("""[
        |  """, """
        |]""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(es), _root_.org.sireum.String(",\n")))
          });
        return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("HashMap")))), scala.Tuple2(_root_.org.sireum.String("size"), _root_.org.sireum.helper.$assign(printZ(o.size))), scala.Tuple2(_root_.org.sireum.String("entries"), _root_.org.sireum.helper.$assign(entries)))))
      };
      @pure def printHashSet[T](isSimple: B, o: HashSet[T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("HashSet")))), scala.Tuple2(_root_.org.sireum.String("size"), _root_.org.sireum.helper.$assign(printZ(o.size))), scala.Tuple2(_root_.org.sireum.String("elements"), _root_.org.sireum.helper.$assign(if (isSimple)
        StringContext("[", "]").st(scala.Tuple2(_root_.org.sireum.helper.$assign(o.elements.map(f)), _root_.org.sireum.String(", ")))
      else
        StringContext("""[
            |  """, """
            |]""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(o.elements.map(f)), _root_.org.sireum.String(",\n"))))))));
      @pure def printHashSMap[K, V](isSimple: B, o: HashSMap[K, V], k: _root_.scala.Function1[K, ST], v: _root_.scala.Function1[V, ST]): ST = {
        val entries: ST = _root_.org.sireum.helper.$assign(if (isSimple)
          {
            var es = _root_.org.sireum.helper.$assign(ISZ[ST]());
            o.entries.foreach(((e) => {
              val key = _root_.org.sireum.helper.$assign(k(e._1));
              val value = _root_.org.sireum.helper.$assign(v(e._2));
              es = _root_.org.sireum.helper.$assign(es.:+(StringContext("[ ", ", ", " ]").st(key, value)))
            }));
            StringContext("[ ", " ]").st(scala.Tuple2(_root_.org.sireum.helper.$assign(es), _root_.org.sireum.String(",")))
          }
        else
          {
            var es = _root_.org.sireum.helper.$assign(ISZ[ST]());
            o.entries.foreach(((e) => {
              val key = _root_.org.sireum.helper.$assign(k(e._1));
              val value = _root_.org.sireum.helper.$assign(v(e._2));
              es = _root_.org.sireum.helper.$assign(es.:+(StringContext("""[
            |  """, """,
            |  """, """
            |]""").st(key, value)))
            }));
            StringContext("""[
        |  """, """
        |]""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(es), _root_.org.sireum.String(",\n")))
          });
        return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("HashSMap")))), scala.Tuple2(_root_.org.sireum.String("size"), _root_.org.sireum.helper.$assign(printZ(o.size))), scala.Tuple2(_root_.org.sireum.String("entries"), _root_.org.sireum.helper.$assign(entries)))))
      };
      @pure def printHashSSet[T](isSimple: B, o: HashSSet[T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("HashSSet")))), scala.Tuple2(_root_.org.sireum.String("size"), _root_.org.sireum.helper.$assign(printZ(o.size))), scala.Tuple2(_root_.org.sireum.String("elements"), _root_.org.sireum.helper.$assign(if (isSimple)
        StringContext("[", "]").st(scala.Tuple2(_root_.org.sireum.helper.$assign(o.elements.map(f)), _root_.org.sireum.String(", ")))
      else
        StringContext("""[
            |  """, """
            |]""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(o.elements.map(f)), _root_.org.sireum.String(",\n"))))))));
      @pure def printStack[T](isSimple: B, o: Stack[T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printISZ(isSimple, o.elements, f));
      @pure def printBag[T](isSimple: B, o: Bag[T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printMap(isSimple, o.map, f, (printZ _)));
      @pure def printHashBag[T](isSimple: B, o: HashBag[T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printHashMap(isSimple, o.map, f, (printZ _)));
      @pure def printPoset[T](isSimple: B, o: Poset[T], f: _root_.scala.Function1[T, ST]): ST = {
        val g: _root_.scala.Function1[HashSet[Poset.Index], ST] = ((s) => printHashSet(isSimple, s, (printZ _)));
        return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Poset")))), scala.Tuple2(_root_.org.sireum.String("nodes"), _root_.org.sireum.helper.$assign(printISZ(isSimple, o.nodesInverse, f))), scala.Tuple2(_root_.org.sireum.String("parents"), _root_.org.sireum.helper.$assign(printHashMap(isSimple, o.parents, (printZ _), g))))))
      };
      @pure def printGraph[V, E](isSimple: B, o: Graph[V, E], f: _root_.scala.Function1[V, ST], g: _root_.scala.Function1[E, ST]): ST = {
        @pure def printEdge(edge: Graph.Internal.Edge[E]): ST = _root_.org.sireum.helper.$tmatch(edge) match {
          case Graph.Internal.Edge.Plain((src @ _), (dest @ _)) => return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("src"), _root_.org.sireum.helper.$assign(printZ(src))), scala.Tuple2(_root_.org.sireum.String("dest"), _root_.org.sireum.helper.$assign(printZ(dest))))))
          case Graph.Internal.Edge.Data((src @ _), (dest @ _), (data @ _)) => return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("src"), _root_.org.sireum.helper.$assign(printZ(src))), scala.Tuple2(_root_.org.sireum.String("dest"), _root_.org.sireum.helper.$assign(printZ(dest))), scala.Tuple2(_root_.org.sireum.String("data"), _root_.org.sireum.helper.$assign(g(data))))))
        };
        val edges: ISZ[Graph.Internal.Edge[E]] = _root_.org.sireum.helper.$assign(o.outgoingEdges.values.flatMap(((es) => es.elements.map(((e) => e)))));
        return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(if (o.multi)
          _root_.org.sireum.String("MultiGraph")
        else
          _root_.org.sireum.String("Graph")))), scala.Tuple2(_root_.org.sireum.String("nodes"), _root_.org.sireum.helper.$assign(printISZ(isSimple, o.nodesInverse, f))), scala.Tuple2(_root_.org.sireum.String("edges"), _root_.org.sireum.helper.$assign(printISZ(isSimple, edges, (printEdge _)))))))
      };
      @pure def printUnionFind[T](isSimple: B, o: UnionFind[T], f: _root_.scala.Function1[T, ST]): ST = return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("UnionFind")))), scala.Tuple2(_root_.org.sireum.String("elements"), _root_.org.sireum.helper.$assign(printISZ(isSimple, o.elementsInverse, f))), scala.Tuple2(_root_.org.sireum.String("parentOf"), _root_.org.sireum.helper.$assign(printISZ(T, o.parentOf, (printZ _)))), scala.Tuple2(_root_.org.sireum.String("sizeOf"), _root_.org.sireum.helper.$assign(printISZ(T, o.sizeOf, (printZ _)))))));
      @pure def printMessage(o: message.Message): ST = return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Message")))), scala.Tuple2(_root_.org.sireum.String("level"), _root_.org.sireum.helper.$assign(printZ(o.level.ordinal))), scala.Tuple2(_root_.org.sireum.String("posOpt"), _root_.org.sireum.helper.$assign(printOption(F, o.posOpt, (printPosition _)))), scala.Tuple2(_root_.org.sireum.String("kind"), _root_.org.sireum.helper.$assign(printString(o.kind))), scala.Tuple2(_root_.org.sireum.String("message"), _root_.org.sireum.helper.$assign(printString(o.text))))));
      @pure def printPosition(o: message.Position): ST = return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Position")))), scala.Tuple2(_root_.org.sireum.String("uriOpt"), _root_.org.sireum.helper.$assign(printOption(T, o.uriOpt, (printString _)))), scala.Tuple2(_root_.org.sireum.String("beginLine"), _root_.org.sireum.helper.$assign(printZ(o.beginLine))), scala.Tuple2(_root_.org.sireum.String("beginColumn"), _root_.org.sireum.helper.$assign(printZ(o.beginColumn))), scala.Tuple2(_root_.org.sireum.String("endLine"), _root_.org.sireum.helper.$assign(printZ(o.endLine))), scala.Tuple2(_root_.org.sireum.String("endColumn"), _root_.org.sireum.helper.$assign(printZ(o.endColumn))), scala.Tuple2(_root_.org.sireum.String("offset"), _root_.org.sireum.helper.$assign(printZ(o.offset))), scala.Tuple2(_root_.org.sireum.String("length"), _root_.org.sireum.helper.$assign(printZ(o.length))))));
      @pure def printDocInfo(o: message.DocInfo): ST = return _root_.org.sireum.helper.$assign(printObject(ISZ(scala.Tuple2(_root_.org.sireum.String("type"), _root_.org.sireum.helper.$assign(printString(_root_.org.sireum.String("Position")))), scala.Tuple2(_root_.org.sireum.String("uriOpt"), _root_.org.sireum.helper.$assign(printOption(T, o.uriOpt, (printString _)))), scala.Tuple2(_root_.org.sireum.String("lineOffsets"), _root_.org.sireum.helper.$assign(printISZ(T, o.lineOffsets, (printU32 _)))))));
      @pure def printString(s: String): ST = {
        var r = _root_.org.sireum.helper.$assign(ISZ[C]());
        conversions.String.toCis(s).foreach(((c) => _root_.org.sireum.helper.$tmatch(c.native) match {
          case '\"' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('\"')))
          case '\\' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('\\')))
          case '/' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('/')))
          case '\b' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('b')))
          case '\f' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('f')))
          case '\n' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('n')))
          case '\r' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('r')))
          case '\t' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('t')))
          case _ if _root_.org.sireum.C(' ').<=(c).&&(c.<(_root_.org.sireum.C('ÿ'))).&&(c.!=(_root_.org.sireum.C('\u007F'))) => r = _root_.org.sireum.helper.$assign(r.:+(c))
          case _ => {
            val q = _root_.org.sireum.helper.$assign(COps(c).toUnicodeHex);
            r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')).:+(_root_.org.sireum.C('u')).:+(q._1).:+(q._2).:+(q._3).:+(q._4))
          }
        }));
        return StringContext("\"", "\"").st(conversions.String.fromCis(r))
      };
      @pure def printConstant(s: String): ST = _root_.org.sireum.helper.$tmatch(s.native) match {
        case "true" => return _root_.org.sireum.helper.$assign(trueSt)
        case "false" => return _root_.org.sireum.helper.$assign(falseSt)
        case "null" => return _root_.org.sireum.helper.$assign(nullSt)
      };
      @pure def printNumber(s: String): ST = return StringContext("", "").st(s);
      @pure def printObject(fields: ISZ[scala.Tuple2[String, ST]]): ST = {
        val fs: ISZ[ST] = _root_.org.sireum.helper.$assign(fields.map(((p) => StringContext("\"", "\" : ", "").st(p._1, p._2))));
        return StringContext("""{
      |  """, """
      |}""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(fs), _root_.org.sireum.String(",\n")))
      };
      @pure def printIS[I](isSimple: B, elements: IS[I, ST]): ST = return _root_.org.sireum.helper.$assign(if (isSimple)
        StringContext("[", "]").st(scala.Tuple2(_root_.org.sireum.helper.$assign(elements), _root_.org.sireum.String(", ")))
      else
        StringContext("""[
      |  """, """
      |]""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(elements), _root_.org.sireum.String(",\n"))));
      @pure def printMS[I](isSimple: B, elements: MS[I, ST]): ST = return _root_.org.sireum.helper.$assign(if (isSimple)
        StringContext("[", "]").st(scala.Tuple2(_root_.org.sireum.helper.$assign(elements), _root_.org.sireum.String(", ")))
      else
        StringContext("""[
      |  """, """
      |]""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(elements), _root_.org.sireum.String(",\n"))))
    };
    object Parser {
      @pure def create(input: String): Parser = return _root_.org.sireum.helper.$assign(Parser(conversions.String.toCis(input), _root_.org.sireum.Z(0), None()));
      def apply(input: ISZ[C], offset: Z, errorOpt: Option[ErrorMsg]): Parser = new Parser(_root_.org.sireum.helper.$assign(input), _root_.org.sireum.helper.$assign(offset), _root_.org.sireum.helper.$assign(errorOpt));
      def unapply(o: Parser): _root_.scala.Option[scala.Tuple3[ISZ[C], Z, Option[ErrorMsg]]] = _root_.scala.Some(scala.Tuple3(_root_.org.sireum.helper.clone(o.input), _root_.org.sireum.helper.clone(o.offset), _root_.org.sireum.helper.clone(o.errorOpt)))
    };
    @record final class Parser(__input: ISZ[C], __offset: Z, __errorOpt: Option[ErrorMsg]) extends _root_.org.sireum.RecordSig {
      private[this] var _input = __input;
      def input = _input;
      def getInput = _input;
      private[this] var _offset = __offset;
      def offset = _offset;
      def getOffset = _offset;
      def `offset_=`(offset: Z): this.type = {
        _offset = offset;
        this
      };
      def setOffset(offset: Z): this.type = {
        _offset = offset;
        this
      };
      private[this] var _berrorOpt: _root_.scala.Boolean = __errorOpt.isEmpty.value;
      private[this] var _errorOpt: ErrorMsg = __errorOpt.getOrElse(null.asInstanceOf[ErrorMsg]);
      def errorOpt: Option[ErrorMsg] = if (_berrorOpt)
        None()
      else
        Some(_errorOpt);
      def getErrorOpt: Option[ErrorMsg] = errorOpt;
      def `errorOpt_=`(errorOpt: Option[ErrorMsg]): this.type = {
        _berrorOpt = errorOpt.isEmpty.value;
        _errorOpt = errorOpt.getOrElse(null.asInstanceOf[ErrorMsg]);
        this
      };
      def setErrorOpt(errorOpt: Option[ErrorMsg]): this.type = {
        _berrorOpt = errorOpt.isEmpty.value;
        _errorOpt = errorOpt.getOrElse(null.asInstanceOf[ErrorMsg]);
        this
      };
      override def toString: _root_.java.lang.String = if ($hasString)
        super.string.value
      else
        {
          val sb = new _root_.java.lang.StringBuilder();
          sb.append("Parser");
          sb.append('(');
          sb.append(_root_.org.sireum.String.escape(this.input));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.offset));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.errorOpt));
          sb.append(')');
          sb.toString
        };
      override def string: _root_.org.sireum.String = if ($hasString)
        super.string
      else
        toString;
      override def hashCode: _root_.scala.Int = if ($hasEquals)
        super.hashCode
      else
        _root_.scala.Seq(this.getClass, input, offset, errorOpt).hashCode;
      override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
        super.equals(o)
      else
        if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
          true
        else
          o match {
            case (o @ ((_): Parser)) => if (this.hashCode.!=(o.hashCode))
              false
            else
              this.input.==(o.input).&&(this.offset.==(o.offset)).&&(this.errorOpt.==(o.errorOpt))
            case _ => false
          };
      def apply(input: ISZ[C] = this.input, offset: Z = this.offset, errorOpt: Option[ErrorMsg] = this.errorOpt): Parser = new Parser(_root_.org.sireum.helper.$assign(input), _root_.org.sireum.helper.$assign(offset), _root_.org.sireum.helper.$assign(errorOpt));
      override def $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Parser")), scala.Tuple2("input", input), scala.Tuple2("offset", offset), scala.Tuple2("errorOpt", errorOpt));
      override def $clone: Parser = {
        val r: Parser = new Parser(_root_.org.sireum.helper.cloneAssign(this.input), _root_.org.sireum.helper.cloneAssign(this.offset), _root_.org.sireum.helper.cloneAssign(this.errorOpt));
        r
      };
      val typesOption: ISZ[String] = _root_.org.sireum.helper.$assign(ISZ(_root_.org.sireum.String("Some"), _root_.org.sireum.String("None")));
      def errorMessage: String = _root_.org.sireum.helper.$tmatch(errorOpt) match {
        case Some((e @ _)) => return StringContext("[", ", ", "] ", "").s(e.line, e.column, e.message)
        case _ => return _root_.org.sireum.String("")
      };
      def eof(): B = if (input.size.!=(offset))
        {
          if (errorOpt.nonEmpty)
            return _root_.org.sireum.helper.$assign(F)
          else
            ();
          val p = _root_.org.sireum.helper.$assign(computeLineColumn(offset));
          errorOpt = _root_.org.sireum.helper.$assign(Some(ErrorMsg(p._1, p._2, StringContext("Expected end-of-file, but \'", "\' found.").s(input(offset)))));
          return _root_.org.sireum.helper.$assign(F)
        }
      else
        return _root_.org.sireum.helper.$assign(T);
      def parseB(): B = {
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case 't' => {
            parseConstant(_root_.org.sireum.String("true"));
            return _root_.org.sireum.helper.$assign(T)
          }
          case 'f' => {
            parseConstant(_root_.org.sireum.String("false"));
            return _root_.org.sireum.helper.$assign(F)
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \'true\' or \'false\', but \'", "...\' found.").s(c));
            return _root_.org.sireum.helper.$assign(F)
          }
        }
      };
      def parseC(): C = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(conversions.String.toCis(parseString()));
        if (s.size.!=(_root_.org.sireum.Z(1)))
          {
            parseException(i, StringContext("Expected a C, but \'", "\' found.").s(s));
            return _root_.org.sireum.C(' ')
          }
        else
          return _root_.org.sireum.helper.$assign(s(_root_.org.sireum.Z(0)))
      };
      def parseZ(): Z = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(Z(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a Z, but \'", "\' found.").s(s));
            return _root_.org.sireum.Z(0)
          }
        }
      };
      def parseZ8(): Z8 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(Z8(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a Z8, but \'", "\' found.").s(s));
            return StringContext("0").z8()
          }
        }
      };
      def parseZ16(): Z16 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(Z16(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a Z16, but \'", "\' found.").s(s));
            return StringContext("0").z16()
          }
        }
      };
      def parseZ32(): Z32 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(Z32(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a Z32, but \'", "\' found.").s(s));
            return StringContext("0").z32()
          }
        }
      };
      def parseZ64(): Z64 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(Z64(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a Z64, but \'", "\' found.").s(s));
            return StringContext("0").z64()
          }
        }
      };
      def parseN(): N = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(N(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a N, but \'", "\' found.").s(s));
            return StringContext("0").n()
          }
        }
      };
      def parseN8(): N8 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(N8(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a N8, but \'", "\' found.").s(s));
            return StringContext("0").n8()
          }
        }
      };
      def parseN16(): N16 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(N16(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a N16, but \'", "\' found.").s(s));
            return StringContext("0").n16()
          }
        }
      };
      def parseN32(): N32 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(N32(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a N32, but \'", "\' found.").s(s));
            return StringContext("0").n32()
          }
        }
      };
      def parseN64(): N64 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(N64(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a N64, but \'", "\' found.").s(s));
            return StringContext("0").n64()
          }
        }
      };
      def parseS8(): S8 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(S8(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a S8, but \'", "\' found.").s(s));
            return StringContext("0").s8()
          }
        }
      };
      def parseS16(): S16 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(S16(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a S16, but \'", "\' found.").s(s));
            return StringContext("0").s16()
          }
        }
      };
      def parseS32(): S32 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(S32(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a S32, but \'", "\' found.").s(s));
            return StringContext("0").s32()
          }
        }
      };
      def parseS64(): S64 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(S64(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a S64, but \'", "\' found.").s(s));
            return StringContext("0").s64()
          }
        }
      };
      def parseU8(): U8 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(U8(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a U8, but \'", "\' found.").s(s));
            return StringContext("0").u8()
          }
        }
      };
      def parseU16(): U16 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(U16(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a U16, but \'", "\' found.").s(s));
            return StringContext("0").u16()
          }
        }
      };
      def parseU32(): U32 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(U32(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a U32, but \'", "\' found.").s(s));
            return StringContext("0").u32()
          }
        }
      };
      def parseU64(): U64 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(U64(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a U64, but \'", "\' found.").s(s));
            return StringContext("0").u64()
          }
        }
      };
      def parseF32(): F32 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(F32(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a F32, but \'", "\' found.").s(s));
            return _root_.org.sireum.F32(0.0F)
          }
        }
      };
      def parseF64(): F64 = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(F64(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a F64, but \'", "\' found.").s(s));
            return _root_.org.sireum.F64(0.0)
          }
        }
      };
      def parseR(): R = {
        val i = _root_.org.sireum.helper.$assign(offset);
        val s = _root_.org.sireum.helper.$assign(parseNumber());
        _root_.org.sireum.helper.$tmatch(R(s)) match {
          case Some((n @ _)) => return _root_.org.sireum.helper.$assign(n)
          case _ => {
            parseException(i, StringContext("Expected a R, but \'", "\' found.").s(s));
            return StringContext("0").r()
          }
        }
      };
      def parseISZ[T](f: _root_.scala.Function0[T]): IS[Z, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[Z, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISZ8[T](f: _root_.scala.Function0[T]): IS[Z8, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[Z8, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[Z8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISZ16[T](f: _root_.scala.Function0[T]): IS[Z16, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[Z16, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[Z16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISZ32[T](f: _root_.scala.Function0[T]): IS[Z32, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[Z32, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[Z32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISZ64[T](f: _root_.scala.Function0[T]): IS[Z64, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[Z64, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[Z64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISN[T](f: _root_.scala.Function0[T]): IS[N, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[N, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[N, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISN8[T](f: _root_.scala.Function0[T]): IS[N8, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[N8, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[N8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISN16[T](f: _root_.scala.Function0[T]): IS[N16, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[N16, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[N16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISN32[T](f: _root_.scala.Function0[T]): IS[N32, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[N32, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[N32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISN64[T](f: _root_.scala.Function0[T]): IS[N64, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[N64, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[N64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISS8[T](f: _root_.scala.Function0[T]): IS[S8, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[S8, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[S8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISS16[T](f: _root_.scala.Function0[T]): IS[S16, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[S16, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[S16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISS32[T](f: _root_.scala.Function0[T]): IS[S32, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[S32, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[S32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISS64[T](f: _root_.scala.Function0[T]): IS[S64, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[S64, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[S64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISU8[T](f: _root_.scala.Function0[T]): IS[U8, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[U8, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[U8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISU16[T](f: _root_.scala.Function0[T]): IS[U16, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[U16, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[U16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISU32[T](f: _root_.scala.Function0[T]): IS[U32, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[U32, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[U32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseISU64[T](f: _root_.scala.Function0[T]): IS[U64, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(IS[U64, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(IS[U64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSZ[T](f: _root_.scala.Function0[T]): MS[Z, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[Z, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[Z, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSZ8[T](f: _root_.scala.Function0[T]): MS[Z8, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[Z8, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[Z8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSZ16[T](f: _root_.scala.Function0[T]): MS[Z16, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[Z16, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[Z16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSZ32[T](f: _root_.scala.Function0[T]): MS[Z32, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[Z32, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[Z32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSZ64[T](f: _root_.scala.Function0[T]): MS[Z64, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[Z64, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[Z64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSN[T](f: _root_.scala.Function0[T]): MS[N, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[N, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[N, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSN8[T](f: _root_.scala.Function0[T]): MS[N8, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[N8, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[N8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSN16[T](f: _root_.scala.Function0[T]): MS[N16, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[N16, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[N16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSN32[T](f: _root_.scala.Function0[T]): MS[N32, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[N32, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[N32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSN64[T](f: _root_.scala.Function0[T]): MS[N64, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[N64, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[N64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSS8[T](f: _root_.scala.Function0[T]): MS[S8, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[S8, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[S8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSS16[T](f: _root_.scala.Function0[T]): MS[S16, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[S16, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[S16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSS32[T](f: _root_.scala.Function0[T]): MS[S32, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[S32, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[S32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSS64[T](f: _root_.scala.Function0[T]): MS[S64, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[S64, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[S64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSU8[T](f: _root_.scala.Function0[T]): MS[U8, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[U8, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[U8, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSU16[T](f: _root_.scala.Function0[T]): MS[U16, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[U16, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[U16, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSU32[T](f: _root_.scala.Function0[T]): MS[U32, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[U32, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[U32, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseMSU64[T](f: _root_.scala.Function0[T]): MS[U64, T] = {
        if (parseArrayBegin().`unary_!`)
          return _root_.org.sireum.helper.$assign(MS[U64, T]())
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        var r = _root_.org.sireum.helper.$assign(MS[U64, T](e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseZS(): ZS = {
        val r = _root_.org.sireum.helper.$assign(parseMSZ((parseZ _)));
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseOption[T](f: _root_.scala.Function0[T]): Option[T] = {
        val tpe = _root_.org.sireum.helper.$assign(parseObjectTypes(typesOption));
        _root_.org.sireum.helper.$tmatch(tpe.native) match {
          case "Some" => {
            parseObjectKey(_root_.org.sireum.String("value"));
            val v = _root_.org.sireum.helper.$assign(f());
            parseObjectNext();
            return _root_.org.sireum.helper.$assign(Some(v))
          }
          case "None" => return _root_.org.sireum.helper.$assign(None())
        }
      };
      def parseMOption[T](f: _root_.scala.Function0[T]): MOption[T] = {
        val tpe = _root_.org.sireum.helper.$assign(parseObjectTypes(typesOption));
        _root_.org.sireum.helper.$tmatch(tpe.native) match {
          case "Some" => {
            parseObjectKey(_root_.org.sireum.String("value"));
            val v = _root_.org.sireum.helper.$assign(f());
            parseObjectNext();
            return _root_.org.sireum.helper.$assign(MSome(v))
          }
          case "None" => return _root_.org.sireum.helper.$assign(MNone())
        }
      };
      def parseEither[L, R](f0: _root_.scala.Function0[L], f1: _root_.scala.Function0[R]): Either[L, R] = {
        parseObjectType(_root_.org.sireum.String("Or"));
        parseObjectKey(_root_.org.sireum.String("i"));
        val i = _root_.org.sireum.helper.$assign(parseZ());
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("value"));
        _root_.org.sireum.helper.$tmatch(i) match {
          case StringContext("0").z() => {
            val l = _root_.org.sireum.helper.$assign(f0());
            parseObjectNext();
            return _root_.org.sireum.helper.$assign(Either.Left(l))
          }
          case StringContext("1").z() => {
            val r = _root_.org.sireum.helper.$assign(f1());
            parseObjectNext();
            return _root_.org.sireum.helper.$assign(Either.Right(r))
          }
        }
      };
      def parseMEither[L, R](f0: _root_.scala.Function0[L], f1: _root_.scala.Function0[R]): MEither[L, R] = {
        parseObjectType(_root_.org.sireum.String("Or"));
        parseObjectKey(_root_.org.sireum.String("i"));
        val i = _root_.org.sireum.helper.$assign(parseZ());
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("value"));
        _root_.org.sireum.helper.$tmatch(i) match {
          case StringContext("0").z() => {
            val l = _root_.org.sireum.helper.$assign(f0());
            parseObjectNext();
            return _root_.org.sireum.helper.$assign(MEither.Left(l))
          }
          case StringContext("1").z() => {
            val r = _root_.org.sireum.helper.$assign(f1());
            parseObjectNext();
            return _root_.org.sireum.helper.$assign(MEither.Right(r))
          }
        }
      };
      def parseMap[K, V](k: _root_.scala.Function0[K], v: _root_.scala.Function0[V]): Map[K, V] = {
        parseObjectType(_root_.org.sireum.String("Map"));
        var r = _root_.org.sireum.helper.$assign(Map.empty[K, V]);
        parseObjectKey(_root_.org.sireum.String("entries"));
        if (parseArrayBegin().`unary_!`)
          {
            parseObjectNext();
            return _root_.org.sireum.helper.$assign(r)
          }
        else
          ();
        def parseEntry(): Unit = {
          parseArrayBegin();
          val key = _root_.org.sireum.helper.$assign(k());
          parseArrayNext();
          val value = _root_.org.sireum.helper.$assign(v());
          parseArrayNext();
          r = _root_.org.sireum.helper.$assign(r.+(key.~>(value)))
        };
        parseEntry();
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            parseEntry();
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        parseObjectNext();
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseSet[T](f: _root_.scala.Function0[T]): Set[T] = {
        parseObjectType(_root_.org.sireum.String("Set"));
        var r = _root_.org.sireum.helper.$assign(Set.empty[T]);
        parseObjectKey(_root_.org.sireum.String("elements"));
        if (parseArrayBegin().`unary_!`)
          {
            parseObjectNext();
            return _root_.org.sireum.helper.$assign(r)
          }
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        r = _root_.org.sireum.helper.$assign(r.+(e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        parseObjectNext();
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseHashMap[K, V](k: _root_.scala.Function0[K], v: _root_.scala.Function0[V]): HashMap[K, V] = {
        parseObjectType(_root_.org.sireum.String("HashMap"));
        parseObjectKey(_root_.org.sireum.String("size"));
        val size = _root_.org.sireum.helper.$assign(parseZ());
        parseObjectNext();
        var r = _root_.org.sireum.helper.$assign(HashMap.emptyInit[K, V](size));
        parseObjectKey(_root_.org.sireum.String("entries"));
        if (parseArrayBegin().`unary_!`)
          {
            parseObjectNext();
            return _root_.org.sireum.helper.$assign(r)
          }
        else
          ();
        def parseEntry(): Unit = {
          parseArrayBegin();
          val key = _root_.org.sireum.helper.$assign(k());
          parseArrayNext();
          val value = _root_.org.sireum.helper.$assign(v());
          parseArrayNext();
          r = _root_.org.sireum.helper.$assign(r.+(key.~>(value)))
        };
        parseEntry();
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            parseEntry();
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        parseObjectNext();
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseHashSet[T](f: _root_.scala.Function0[T]): HashSet[T] = {
        parseObjectType(_root_.org.sireum.String("HashSet"));
        parseObjectKey(_root_.org.sireum.String("size"));
        val size = _root_.org.sireum.helper.$assign(parseZ());
        parseObjectNext();
        var r = _root_.org.sireum.helper.$assign(HashSet.emptyInit[T](size));
        parseObjectKey(_root_.org.sireum.String("elements"));
        if (parseArrayBegin().`unary_!`)
          {
            parseObjectNext();
            return _root_.org.sireum.helper.$assign(r)
          }
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        r = _root_.org.sireum.helper.$assign(r.+(e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        parseObjectNext();
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseHashSMap[K, V](k: _root_.scala.Function0[K], v: _root_.scala.Function0[V]): HashSMap[K, V] = {
        parseObjectType(_root_.org.sireum.String("HashSMap"));
        parseObjectKey(_root_.org.sireum.String("size"));
        val size = _root_.org.sireum.helper.$assign(parseZ());
        parseObjectNext();
        var r = _root_.org.sireum.helper.$assign(HashSMap.emptyInit[K, V](size));
        parseObjectKey(_root_.org.sireum.String("entries"));
        if (parseArrayBegin().`unary_!`)
          {
            parseObjectNext();
            return _root_.org.sireum.helper.$assign(r)
          }
        else
          ();
        def parseEntry(): Unit = {
          parseArrayBegin();
          val key = _root_.org.sireum.helper.$assign(k());
          parseArrayNext();
          val value = _root_.org.sireum.helper.$assign(v());
          parseArrayNext();
          r = _root_.org.sireum.helper.$assign(r.+(key.~>(value)))
        };
        parseEntry();
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            parseEntry();
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        parseObjectNext();
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseHashSSet[T](f: _root_.scala.Function0[T]): HashSSet[T] = {
        parseObjectType(_root_.org.sireum.String("HashSSet"));
        parseObjectKey(_root_.org.sireum.String("size"));
        val size = _root_.org.sireum.helper.$assign(parseZ());
        parseObjectNext();
        var r = _root_.org.sireum.helper.$assign(HashSSet.emptyInit[T](size));
        parseObjectKey(_root_.org.sireum.String("elements"));
        if (parseArrayBegin().`unary_!`)
          {
            parseObjectNext();
            return _root_.org.sireum.helper.$assign(r)
          }
        else
          ();
        var e = _root_.org.sireum.helper.$assign(f());
        r = _root_.org.sireum.helper.$assign(r.+(e));
        var continue = _root_.org.sireum.helper.$assign(parseArrayNext());
        while (continue) 
          {
            e = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.+(e));
            continue = _root_.org.sireum.helper.$assign(parseArrayNext())
          }
        ;
        parseObjectNext();
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseStack[T](f: _root_.scala.Function0[T]): Stack[T] = {
        val is = _root_.org.sireum.helper.$assign(parseISZ(f));
        return _root_.org.sireum.helper.$assign(Stack(is))
      };
      def parseBag[T](f: _root_.scala.Function0[T]): Bag[T] = {
        val map = _root_.org.sireum.helper.$assign(parseMap(f, (parseZ _)));
        return _root_.org.sireum.helper.$assign(Bag(map))
      };
      def parseHashBag[T](f: _root_.scala.Function0[T]): HashBag[T] = {
        val map = _root_.org.sireum.helper.$assign(parseHashMap(f, (parseZ _)));
        return _root_.org.sireum.helper.$assign(HashBag(map))
      };
      def parsePoset[T](f: _root_.scala.Function0[T]): Poset[T] = {
        def g(): HashSet[Poset.Index] = {
          val r = _root_.org.sireum.helper.$assign(parseHashSet((parseZ _)));
          return _root_.org.sireum.helper.$assign(r)
        };
        parseObjectType(_root_.org.sireum.String("Poset"));
        parseObjectKey(_root_.org.sireum.String("nodes"));
        val nodesInverse = _root_.org.sireum.helper.$assign(parseISZ(f));
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("parents"));
        val map = _root_.org.sireum.helper.$assign(parseHashMap((parseZ _), (g _)));
        parseObjectNext();
        val size = _root_.org.sireum.helper.$assign(nodesInverse.size);
        var nodes = _root_.org.sireum.helper.$assign(HashMap.emptyInit[T, Poset.Index](size));
        var parents = _root_.org.sireum.helper.$assign(HashMap.emptyInit[Poset.Index, HashSet[Poset.Index]](size));
        var children = _root_.org.sireum.helper.$assign(HashMap.emptyInit[Poset.Index, HashSet[Poset.Index]](size));
        var i: Z = _root_.org.sireum.Z(0);
        nodesInverse.foreach(((node) => {
          nodes = _root_.org.sireum.helper.$assign(nodes.+(node.~>(nodes.size)));
          parents = _root_.org.sireum.helper.$assign(parents.+(i.~>(Poset.Internal.emptySet)));
          children = _root_.org.sireum.helper.$assign(children.+(i.~>(Poset.Internal.emptySet)));
          i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
        }));
        var r = _root_.org.sireum.helper.$assign(Poset[T](nodes, nodesInverse, parents, children));
        map.entries.foreach(((e) => {
          val x$1 = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(e: @scala.unchecked) match {
            case scala.Tuple2((n @ _), (s @ _)) => scala.Tuple2(_root_.org.sireum.helper.$assign(n), _root_.org.sireum.helper.$assign(s))
          });
          val n = _root_.org.sireum.helper.$assign(x$1._1);
          val s = _root_.org.sireum.helper.$assign(x$1._2);
          r = _root_.org.sireum.helper.$assign(Poset.Internal.addParents(r, n, s.elements))
        }));
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseGraph[V, E](f: _root_.scala.Function0[V], g: _root_.scala.Function0[E]): Graph[V, E] = {
        def parseEdge(): Graph.Internal.Edge[E] = {
          parseObjectBegin();
          parseObjectKey(_root_.org.sireum.String("src"));
          val src = _root_.org.sireum.helper.$assign(parseZ());
          parseObjectNext();
          parseObjectKey(_root_.org.sireum.String("dest"));
          val dest = _root_.org.sireum.helper.$assign(parseZ());
          val hasData = _root_.org.sireum.helper.$assign(parseObjectNext());
          if (hasData)
            {
              val data = _root_.org.sireum.helper.$assign(g());
              return _root_.org.sireum.helper.$assign(Graph.Internal.Edge.Data(src, dest, data))
            }
          else
            return _root_.org.sireum.helper.$assign(Graph.Internal.Edge.Plain(src, dest))
        };
        parseObjectBegin();
        parseObjectKey(_root_.org.sireum.String("type"));
        val tipe = _root_.org.sireum.helper.$assign(parseString());
        parseObjectNext();
        val multi = _root_.org.sireum.helper.$assign(tipe.==(_root_.org.sireum.String("Graph")));
        parseObjectKey(_root_.org.sireum.String("nodes"));
        val nodesInverse = _root_.org.sireum.helper.$assign(parseISZ(f));
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("edges"));
        val edges = _root_.org.sireum.helper.$assign(parseISZ((parseEdge _)));
        parseObjectNext();
        var r: Graph[V, E] = _root_.org.sireum.helper.$assign(if (multi)
          Graph.emptyMulti
        else
          Graph.empty);
        nodesInverse.foreach(((node) => r = _root_.org.sireum.helper.$assign(r.*(node))));
        edges.foreach(((e) => r = _root_.org.sireum.helper.$assign(Graph.Internal.addEdge(r, e))));
        return _root_.org.sireum.helper.$assign(r)
      };
      def parseUnionFind[T](f: _root_.scala.Function0[T]): UnionFind[T] = {
        parseObjectType(_root_.org.sireum.String("UnionFind"));
        parseObjectKey(_root_.org.sireum.String("elements"));
        val elementsInverse = _root_.org.sireum.helper.$assign(parseISZ(f));
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("parentOf"));
        val parentOf = _root_.org.sireum.helper.$assign(parseISZ((parseZ _)));
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("sizeOf"));
        val sizeOf = _root_.org.sireum.helper.$assign(parseISZ((parseZ _)));
        parseObjectNext();
        var elements = _root_.org.sireum.helper.$assign(HashMap.emptyInit[T, UnionFind.Index](elementsInverse.size));
        elementsInverse.foreach(((e) => elements = _root_.org.sireum.helper.$assign(elements.+(e.~>(elements.size)))));
        return _root_.org.sireum.helper.$assign(UnionFind(elements, elementsInverse, parentOf, sizeOf))
      };
      def parseMessage(): message.Message = {
        parseObjectType(_root_.org.sireum.String("Message"));
        parseObjectKey(_root_.org.sireum.String("level"));
        val level = _root_.org.sireum.helper.$assign(message.Level.byOrdinal(parseZ()).getOrElse(message.Level.InternalError));
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("posOpt"));
        val posOpt = _root_.org.sireum.helper.$assign(parseOption((parsePosition _)));
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("kind"));
        val kind = _root_.org.sireum.helper.$assign(parseString());
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("message"));
        val msg = _root_.org.sireum.helper.$assign(parseString());
        return _root_.org.sireum.helper.$assign(message.Message(level, posOpt, kind, msg))
      };
      def parsePosition(): message.Position = {
        parseObjectType(_root_.org.sireum.String("Position"));
        parseObjectKey(_root_.org.sireum.String("uriOpt"));
        val uriOpt = _root_.org.sireum.helper.$assign(parseOption((parseString _)));
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("beginLine"));
        val beginLine = _root_.org.sireum.helper.$assign(parseU32());
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("beginColumn"));
        val beginColumn = _root_.org.sireum.helper.$assign(parseU32());
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("endLine"));
        val endLine = _root_.org.sireum.helper.$assign(parseU32());
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("endColumn"));
        val endColumn = _root_.org.sireum.helper.$assign(parseU32());
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("offset"));
        val offset = _root_.org.sireum.helper.$assign(parseU32());
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("length"));
        val length = _root_.org.sireum.helper.$assign(parseU32());
        parseObjectNext();
        return _root_.org.sireum.helper.$assign(message.FlatPos(uriOpt, beginLine, beginColumn, endLine, endColumn, offset, length))
      };
      def parseDocInfo(): message.DocInfo = {
        parseObjectType(_root_.org.sireum.String("Position"));
        parseObjectKey(_root_.org.sireum.String("uriOpt"));
        val uriOpt = _root_.org.sireum.helper.$assign(parseOption((parseString _)));
        parseObjectNext();
        parseObjectKey(_root_.org.sireum.String("lineOffsets"));
        val lineOffsets = _root_.org.sireum.helper.$assign(parseISZ((parseU32 _)));
        parseObjectNext();
        return _root_.org.sireum.helper.$assign(message.DocInfo(uriOpt, lineOffsets))
      };
      def at(i: Z): C = {
        if (_root_.org.sireum.Z(0).<=(i).&&(i.<(input.size)).&&(errorOpt.isEmpty))
          return _root_.org.sireum.helper.$assign(input(i))
        else
          ();
        return _root_.org.sireum.C('\u0000')
      };
      def detect(): ValueKind.Type = {
        parseWhitespace();
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case '\"' => return _root_.org.sireum.helper.$assign(ValueKind.String)
          case '{' => return _root_.org.sireum.helper.$assign(ValueKind.Object)
          case '[' => return _root_.org.sireum.helper.$assign(ValueKind.Array)
          case 't' => return _root_.org.sireum.helper.$assign(ValueKind.True)
          case 'f' => return _root_.org.sireum.helper.$assign(ValueKind.False)
          case 'n' => return _root_.org.sireum.helper.$assign(ValueKind.Null)
          case '-' => return _root_.org.sireum.helper.$assign(ValueKind.Number)
          case '0' => return _root_.org.sireum.helper.$assign(ValueKind.Number)
          case '1' => return _root_.org.sireum.helper.$assign(ValueKind.Number)
          case '2' => return _root_.org.sireum.helper.$assign(ValueKind.Number)
          case '3' => return _root_.org.sireum.helper.$assign(ValueKind.Number)
          case '4' => return _root_.org.sireum.helper.$assign(ValueKind.Number)
          case '5' => return _root_.org.sireum.helper.$assign(ValueKind.Number)
          case '6' => return _root_.org.sireum.helper.$assign(ValueKind.Number)
          case '7' => return _root_.org.sireum.helper.$assign(ValueKind.Number)
          case '8' => return _root_.org.sireum.helper.$assign(ValueKind.Number)
          case '9' => return _root_.org.sireum.helper.$assign(ValueKind.Number)
          case _ => {
            parseException(offset, _root_.org.sireum.String("Unexpected end-of-file."));
            return _root_.org.sireum.helper.$assign(ValueKind.Null)
          }
        }
      };
      def parseObjectType(expectedType: String): String = {
        parseObjectBegin();
        parseObjectKey(_root_.org.sireum.String("type"));
        val i = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
        val value = _root_.org.sireum.helper.$assign(parseString());
        parseObjectNext();
        if (value.!=(expectedType))
          parseException(i, StringContext("Expected \'", "\', but \'", "\' found.").s(expectedType, value))
        else
          ();
        return _root_.org.sireum.helper.$assign(value)
      };
      def parseObjectTypes(expectedTypes: ISZ[String]): String = {
        parseObjectBegin();
        parseObjectKey(_root_.org.sireum.String("type"));
        val i = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
        val value = _root_.org.sireum.helper.$assign(parseString());
        parseObjectNext();
        if (expectedTypes.nonEmpty.&&(ISZOps(expectedTypes).contains(value).`unary_!`))
          _root_.org.sireum.helper.$tmatch(expectedTypes.size) match {
            case StringContext("1").z() => parseException(i, StringContext("Expected \'", "\', but \'", "\' found.").s(expectedTypes(_root_.org.sireum.Z(0)), value))
            case StringContext("2").z() => parseException(i, StringContext("Expected \'", "\' or \'", "\' , but \'", "\' found.").s(expectedTypes(_root_.org.sireum.Z(0)), expectedTypes(_root_.org.sireum.Z(1)), value))
            case _ => parseException(i, StringContext("Expected ", " , but \'", "\' found.").s(StringContext("\'", "\', or \'", "\'").st(scala.Tuple2(_root_.org.sireum.helper.$assign(ISZOps(expectedTypes).dropRight(_root_.org.sireum.Z(1))), _root_.org.sireum.String("\', \'")), expectedTypes(expectedTypes.size.-(_root_.org.sireum.Z(1)))).render, value))
          }
        else
          ();
        return _root_.org.sireum.helper.$assign(value)
      };
      def parseObjectKey(expectedKey: String): String = {
        errorIfEof(offset);
        val i = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
        val key = _root_.org.sireum.helper.$assign(parseString());
        if (key.!=(expectedKey))
          parseException(i, StringContext("Expected \'", "\', but \'", "\' found.").s(expectedKey, key))
        else
          ();
        parseWhitespace();
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case ':' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            return _root_.org.sireum.helper.$assign(key)
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \':\', but \'", "\' found.").s(c));
            return _root_.org.sireum.String("")
          }
        }
      };
      def parseObjectKeys(expectedKeys: ISZ[String]): String = {
        errorIfEof(offset);
        val i = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
        val key = _root_.org.sireum.helper.$assign(parseString());
        if (expectedKeys.nonEmpty.&&(ISZOps(expectedKeys).contains(key).`unary_!`))
          _root_.org.sireum.helper.$tmatch(expectedKeys.size) match {
            case StringContext("1").z() => parseException(i, StringContext("Expected \'", "\', but \'", "\' found.").s(expectedKeys(_root_.org.sireum.Z(0)), key))
            case StringContext("2").z() => parseException(i, StringContext("Expected \'", "\' or \'", "\' , but \'", "\' found.").s(expectedKeys(_root_.org.sireum.Z(0)), expectedKeys(_root_.org.sireum.Z(1)), key))
            case _ => parseException(i, StringContext("Expected ", " , but \'", "\' found.").s(StringContext("\'", "\', or \'", "\'").st(scala.Tuple2(_root_.org.sireum.helper.$assign(ISZOps(expectedKeys).dropRight(_root_.org.sireum.Z(1))), _root_.org.sireum.String("\', \'")), expectedKeys(expectedKeys.size.-(_root_.org.sireum.Z(1)))).render, key))
          }
        else
          ();
        parseWhitespace();
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case ':' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            return _root_.org.sireum.helper.$assign(key)
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \':\', but \'", "\' found.").s(c));
            return _root_.org.sireum.String("")
          }
        }
      };
      def parseObjectBegin(): B = {
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case '{' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            errorIfEof(offset);
            (_root_.org.sireum.helper.$tmatch(at(offset).native) match {
              case '}' => {
                offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                return _root_.org.sireum.helper.$assign(F)
              }
              case _ => return _root_.org.sireum.helper.$assign(T)
            })
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \'{\', but \'", "\' found.").s(c));
            return _root_.org.sireum.helper.$assign(F)
          }
        }
      };
      def parseObjectNext(): B = {
        parseWhitespace();
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case ',' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            return _root_.org.sireum.helper.$assign(T)
          }
          case '}' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            return _root_.org.sireum.helper.$assign(F)
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \',\' or \'}\', but \'", "\' found.").s(c));
            return _root_.org.sireum.helper.$assign(F)
          }
        }
      };
      def parseArrayBegin(): B = {
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case '[' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            errorIfEof(offset);
            (_root_.org.sireum.helper.$tmatch(at(offset).native) match {
              case ']' => {
                offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                return _root_.org.sireum.helper.$assign(F)
              }
              case _ => return _root_.org.sireum.helper.$assign(T)
            })
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \'[\', but \'", "\' found.").s(c));
            return _root_.org.sireum.helper.$assign(F)
          }
        }
      };
      def parseArrayNext(): B = {
        parseWhitespace();
        errorIfEof(offset);
        _root_.org.sireum.helper.$tmatch(at(offset).native) match {
          case ',' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            return _root_.org.sireum.helper.$assign(T)
          }
          case ']' => {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            parseWhitespace();
            return _root_.org.sireum.helper.$assign(F)
          }
          case (c @ _) => {
            parseException(offset, StringContext("Expected \',\' or \']\', but \'", "\' found.").s(c));
            return _root_.org.sireum.helper.$assign(F)
          }
        }
      };
      def parseNumber(): String = {
        var r = _root_.org.sireum.helper.$assign(ISZ[C]());
        errorIfEof(offset);
        var c = _root_.org.sireum.helper.$assign(at(offset));
        _root_.org.sireum.helper.$tmatch(c.native) match {
          case '-' => {
            r = _root_.org.sireum.helper.$assign(r.:+(c));
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
          }
          case _ => if (isDigit(c).`unary_!`)
            parseException(offset, StringContext("Expected a \'-\' or a digit but \'", "\' found.").s(c))
          else
            ()
        };
        _root_.org.sireum.helper.$tmatch(c.native) match {
          case '0' => {
            r = _root_.org.sireum.helper.$assign(r.:+(c));
            if (offset.+(_root_.org.sireum.Z(1)).==(input.size))
              {
                offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                return _root_.org.sireum.helper.$assign(conversions.String.fromCis(r))
              }
            else
              ();
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
          }
          case _ => {
            r = _root_.org.sireum.helper.$assign(r.:+(c));
            if (offset.+(_root_.org.sireum.Z(1)).==(input.size))
              {
                offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                return _root_.org.sireum.helper.$assign(conversions.String.fromCis(r))
              }
            else
              ();
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)));
            while (isDigit(c)) 
              {
                r = _root_.org.sireum.helper.$assign(r.:+(c));
                if (offset.+(_root_.org.sireum.Z(1)).==(input.size))
                  {
                    offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                    return _root_.org.sireum.helper.$assign(conversions.String.fromCis(r))
                  }
                else
                  ();
                c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
              }
            
          }
        };
        _root_.org.sireum.helper.$tmatch(c.native) match {
          case '.' => {
            r = _root_.org.sireum.helper.$assign(r.:+(c));
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)));
            while (isDigit(c)) 
              {
                r = _root_.org.sireum.helper.$assign(r.:+(c));
                if (offset.+(_root_.org.sireum.Z(1)).==(input.size))
                  {
                    offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                    return _root_.org.sireum.helper.$assign(conversions.String.fromCis(r))
                  }
                else
                  ();
                c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
              }
            
          }
          case _ => ()
        };
        _root_.org.sireum.helper.$tmatch(c.native) match {
          case 'e' => ()
          case 'E' => ()
          case _ => return _root_.org.sireum.helper.$assign(conversions.String.fromCis(r))
        };
        r = _root_.org.sireum.helper.$assign(r.:+(c));
        c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)));
        val hasPlusMinus: B = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(c.native) match {
          case '+' => T
          case '-' => T
          case _ => F
        });
        if (hasPlusMinus)
          {
            r = _root_.org.sireum.helper.$assign(r.:+(c));
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
          }
        else
          ();
        while (isDigit(c)) 
          {
            r = _root_.org.sireum.helper.$assign(r.:+(c));
            if (offset.+(_root_.org.sireum.Z(1)).==(input.size))
              {
                offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
                return _root_.org.sireum.helper.$assign(conversions.String.fromCis(r))
              }
            else
              ();
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(conversions.String.fromCis(r))
      };
      def parseString(): String = {
        errorIfEof(offset);
        var r = _root_.org.sireum.helper.$assign(ISZ[C]());
        var c = _root_.org.sireum.helper.$assign(at(offset));
        _root_.org.sireum.helper.$tmatch(c.native) match {
          case '\"' => {
            c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)));
            while (c.!=(_root_.org.sireum.C('\"'))) 
              {
                (_root_.org.sireum.helper.$tmatch(c.native) match {
                  case '\\' => {
                    c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)));
                    (_root_.org.sireum.helper.$tmatch(c.native) match {
                      case '\"' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\"')))
                      case '\\' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\\')))
                      case '/' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('/')))
                      case 'b' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\b')))
                      case 'f' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\f')))
                      case 'n' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\n')))
                      case 'r' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\r')))
                      case 't' => r = _root_.org.sireum.helper.$assign(r.:+(_root_.org.sireum.C('\t')))
                      case 'u' => {
                        incOffset(_root_.org.sireum.Z(4));
                        val hex = _root_.org.sireum.helper.$assign(slice(offset.-(_root_.org.sireum.Z(3)), offset.+(_root_.org.sireum.Z(1))));
                        (_root_.org.sireum.helper.$tmatch(COps.fromUnicodeHex(hex)) match {
                          case Some((ch @ _)) => r = _root_.org.sireum.helper.$assign(r.:+(ch))
                          case _ => parseException(offset.-(_root_.org.sireum.Z(3)), StringContext("Expected a character hex but \'", "\' found.").s(hex))
                        })
                      }
                      case _ => parseException(offset, StringContext("Expected an escaped character but \'", "\' found.").s(c))
                    })
                  }
                  case _ => r = _root_.org.sireum.helper.$assign(r.:+(c))
                });
                c = _root_.org.sireum.helper.$assign(incOffset(_root_.org.sireum.Z(1)))
              }
            ;
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            return _root_.org.sireum.helper.$assign(conversions.String.fromCis(r))
          }
          case _ => {
            parseException(offset, StringContext("Expected \'\"\' but \'", "\' found.").s(c));
            return _root_.org.sireum.String("")
          }
        }
      };
      def parseConstant(text: String): Unit = {
        errorIfEof(offset.+(text.size).-(_root_.org.sireum.Z(1)));
        val t = _root_.org.sireum.helper.$assign(conversions.String.fromCis(slice(offset, offset.+(text.size))));
        if (t.!=(text))
          parseException(offset, StringContext("Expected \'", "\', but \'", "\' found.").s(text, t))
        else
          ();
        offset = _root_.org.sireum.helper.$assign(offset.+(text.size));
        _root_.org.sireum.helper.$tmatch(text.native) match {
          case "true" => ()
          case "false" => ()
          case "null" => ()
          case _ => parseException(offset, StringContext("Invalid constant value \'", "\'.").s(text))
        }
      };
      def computeLineColumn(i: Z): scala.Tuple2[Z, Z] = {
        var line: Z = _root_.org.sireum.Z(1);
        var column: Z = _root_.org.sireum.Z(1);
        var j: Z = _root_.org.sireum.Z(0);
        while (j.!=(i)) 
          {
            _root_.org.sireum.helper.$tmatch(at(j).native) match {
              case '\n' => {
                line = _root_.org.sireum.helper.$assign(line.+(_root_.org.sireum.Z(1)));
                column = _root_.org.sireum.Z(1)
              }
              case _ => column = _root_.org.sireum.helper.$assign(column.+(_root_.org.sireum.Z(1)))
            };
            j = _root_.org.sireum.helper.$assign(j.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(scala.Tuple2(_root_.org.sireum.helper.$assign(line), _root_.org.sireum.helper.$assign(column)))
      };
      def parseException(i: Z, msg: String): Unit = {
        if (errorOpt.nonEmpty)
          return ()
        else
          ();
        val p = _root_.org.sireum.helper.$assign(computeLineColumn(i));
        errorOpt = _root_.org.sireum.helper.$assign(Some(ErrorMsg(p._1, p._2, msg)))
      };
      def errorIfEof(i: Z): Unit = if (i.>=(input.size).||(errorOpt.nonEmpty))
        parseException(offset, _root_.org.sireum.String("Unexpected end-of-file."))
      else
        ();
      def incOffset(n: Z): C = {
        offset = _root_.org.sireum.helper.$assign(offset.+(n));
        errorIfEof(offset);
        return _root_.org.sireum.helper.$assign(at(offset))
      };
      def parseWhitespace(): Unit = {
        if (errorOpt.nonEmpty)
          {
            offset = _root_.org.sireum.helper.$assign(input.size);
            return ()
          }
        else
          ();
        if (offset.>=(input.size))
          return ()
        else
          ();
        var c = _root_.org.sireum.helper.$assign(at(offset));
        while (isWhitespace(c)) 
          {
            offset = _root_.org.sireum.helper.$assign(offset.+(_root_.org.sireum.Z(1)));
            if (offset.>=(input.size))
              return ()
            else
              ();
            c = _root_.org.sireum.helper.$assign(at(offset))
          }
        
      };
      @pure def isDigit(c: C): B = _root_.org.sireum.helper.$tmatch(c.native) match {
        case '0' => return _root_.org.sireum.helper.$assign(T)
        case '1' => return _root_.org.sireum.helper.$assign(T)
        case '2' => return _root_.org.sireum.helper.$assign(T)
        case '3' => return _root_.org.sireum.helper.$assign(T)
        case '4' => return _root_.org.sireum.helper.$assign(T)
        case '5' => return _root_.org.sireum.helper.$assign(T)
        case '6' => return _root_.org.sireum.helper.$assign(T)
        case '7' => return _root_.org.sireum.helper.$assign(T)
        case '8' => return _root_.org.sireum.helper.$assign(T)
        case '9' => return _root_.org.sireum.helper.$assign(T)
        case _ => return _root_.org.sireum.helper.$assign(F)
      };
      @pure def isWhitespace(c: C): B = _root_.org.sireum.helper.$tmatch(c.native) match {
        case ' ' => return _root_.org.sireum.helper.$assign(T)
        case '\n' => return _root_.org.sireum.helper.$assign(T)
        case '\r' => return _root_.org.sireum.helper.$assign(T)
        case '\t' => return _root_.org.sireum.helper.$assign(T)
        case _ => return _root_.org.sireum.helper.$assign(F)
      };
      @pure def slice(start: Z, til: Z): ISZ[C] = {
        var r = _root_.org.sireum.helper.$assign(ISZ[C]());
        start.until(til).foreach(((i) => r = _root_.org.sireum.helper.$assign(r.:+(at(i)))));
        return _root_.org.sireum.helper.$assign(r)
      }
    };
    def parseAst[V](binding: JsonAstBinding[V], input: String): Either[V, ErrorMsg] = {
      val parser = _root_.org.sireum.helper.$assign(Parser.create(input));
      val emptyKeys = _root_.org.sireum.helper.$assign(ISZ[String]());
      def parseString(): V = {
        val s = _root_.org.sireum.helper.$assign(parser.parseString());
        return _root_.org.sireum.helper.$assign(binding.toString(s))
      };
      def parseNumber(): V = {
        val n = _root_.org.sireum.helper.$assign(parser.parseNumber());
        return _root_.org.sireum.helper.$assign(binding.toNumber(n))
      };
      def parseTrue(): V = {
        parser.parseConstant(_root_.org.sireum.String("true"));
        return _root_.org.sireum.helper.$assign(binding.toBoolean(T))
      };
      def parseFalse(): V = {
        parser.parseConstant(_root_.org.sireum.String("false"));
        return _root_.org.sireum.helper.$assign(binding.toBoolean(F))
      };
      def parseNull(): V = {
        parser.parseConstant(_root_.org.sireum.String("null"));
        return _root_.org.sireum.helper.$assign(binding.toNull)
      };
      def parseArray(): V = {
        var continue = _root_.org.sireum.helper.$assign(parser.parseArrayBegin());
        if (continue.`unary_!`)
          return _root_.org.sireum.helper.$assign(binding.toArray(ISZ()))
        else
          ();
        var v = _root_.org.sireum.helper.$assign(parseValue());
        var values = _root_.org.sireum.helper.$assign(ISZ[V](v));
        continue = _root_.org.sireum.helper.$assign(parser.parseArrayNext());
        while (continue) 
          {
            v = _root_.org.sireum.helper.$assign(parseValue());
            values = _root_.org.sireum.helper.$assign(values.:+(v));
            continue = _root_.org.sireum.helper.$assign(parser.parseArrayNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(binding.toArray(values))
      };
      def parseObject(): V = {
        var continue = _root_.org.sireum.helper.$assign(parser.parseObjectBegin());
        if (continue.`unary_!`)
          return _root_.org.sireum.helper.$assign(binding.toObject(ISZ()))
        else
          ();
        var key = _root_.org.sireum.helper.$assign(parser.parseObjectKeys(emptyKeys));
        var value = _root_.org.sireum.helper.$assign(parseValue());
        var fields = _root_.org.sireum.helper.$assign(ISZ[scala.Tuple2[String, V]](scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value))));
        continue = _root_.org.sireum.helper.$assign(parser.parseObjectNext());
        while (continue) 
          {
            key = _root_.org.sireum.helper.$assign(parser.parseObjectKeys(emptyKeys));
            value = _root_.org.sireum.helper.$assign(parseValue());
            fields = _root_.org.sireum.helper.$assign(fields.:+(scala.Tuple2(_root_.org.sireum.helper.$assign(key), _root_.org.sireum.helper.$assign(value))));
            continue = _root_.org.sireum.helper.$assign(parser.parseObjectNext())
          }
        ;
        return _root_.org.sireum.helper.$assign(binding.toObject(fields))
      };
      def parseValue(): V = {
        val k = _root_.org.sireum.helper.$assign(parser.detect());
        _root_.org.sireum.helper.$tmatch(k) match {
          case ValueKind.String => {
            val r = _root_.org.sireum.helper.$assign(parseString());
            return _root_.org.sireum.helper.$assign(r)
          }
          case ValueKind.Object => {
            val r = _root_.org.sireum.helper.$assign(parseObject());
            return _root_.org.sireum.helper.$assign(r)
          }
          case ValueKind.Array => {
            val r = _root_.org.sireum.helper.$assign(parseArray());
            return _root_.org.sireum.helper.$assign(r)
          }
          case ValueKind.True => {
            val r = _root_.org.sireum.helper.$assign(parseTrue());
            return _root_.org.sireum.helper.$assign(r)
          }
          case ValueKind.False => {
            val r = _root_.org.sireum.helper.$assign(parseFalse());
            return _root_.org.sireum.helper.$assign(r)
          }
          case ValueKind.Null => {
            val r = _root_.org.sireum.helper.$assign(parseNull());
            return _root_.org.sireum.helper.$assign(r)
          }
          case ValueKind.Number => {
            val r = _root_.org.sireum.helper.$assign(parseNumber());
            return _root_.org.sireum.helper.$assign(r)
          }
        }
      };
      val r = _root_.org.sireum.helper.$assign(parseValue());
      parser.eof();
      _root_.org.sireum.helper.$tmatch(parser.errorOpt) match {
        case Some((e @ _)) => return _root_.org.sireum.helper.$assign(Either.Right(e))
        case _ => return _root_.org.sireum.helper.$assign(Either.Left(r))
      }
    };
    def printAst[V](binding: JsonAstBinding[V], v: V): ST = {
      @pure def isSimple(o: V): B = _root_.org.sireum.helper.$tmatch(binding.kind(o)) match {
        case ValueKind.Object => return _root_.org.sireum.helper.$assign(F)
        case ValueKind.Array => return _root_.org.sireum.helper.$assign(F)
        case _ => return _root_.org.sireum.helper.$assign(T)
      };
      @pure def printValue(o: V): ST = _root_.org.sireum.helper.$tmatch(binding.kind(o)) match {
        case ValueKind.String => return _root_.org.sireum.helper.$assign(Printer.printString(binding.fromString(o)))
        case ValueKind.Number => return _root_.org.sireum.helper.$assign(Printer.printNumber(binding.fromNumber(o)))
        case ValueKind.Object => return _root_.org.sireum.helper.$assign(Printer.printObject(binding.fromObject(o).map(((p) => scala.Tuple2(_root_.org.sireum.helper.$assign(p._1), _root_.org.sireum.helper.$assign(printValue(p._2)))))))
        case ValueKind.Array => {
          val es = _root_.org.sireum.helper.$assign(binding.fromArray(o));
          return _root_.org.sireum.helper.$assign(Printer.printIS(ISZOps(es).forall(isSimple), es.map((printValue _))))
        }
        case ValueKind.True => return _root_.org.sireum.helper.$assign(Printer.trueSt)
        case ValueKind.False => return _root_.org.sireum.helper.$assign(Printer.falseSt)
        case ValueKind.Null => return _root_.org.sireum.helper.$assign(Printer.nullSt)
      };
      return _root_.org.sireum.helper.$assign(printValue(v))
    }
  }
}