package org.sireum {
  import U8._

  import U16._

  import U32._

  import U64._

  import S8._

  import S16._

  import S32._

  import S64._

  object MessagePack {
    @enum object Kind extends _root_.org.sireum.EnumSig {
      scala.Symbol("NIL");
      scala.Symbol("BOOLEAN");
      scala.Symbol("INTEGER");
      scala.Symbol("FLOAT");
      scala.Symbol("STRING");
      scala.Symbol("ARRAY");
      scala.Symbol("MAP");
      scala.Symbol("BINARY");
      scala.Symbol("EXTENSION");
      scala.Symbol("NONE");
      sealed trait Type extends _root_.org.sireum.Immutable with _root_.scala.Ordered[Type] {
        def ordinal: _root_.org.sireum.Z;
        def name: _root_.org.sireum.String;
        final def hash: _root_.org.sireum.Z = hashCode;
        final def isEqual(other: Type): _root_.org.sireum.B = this.==(other);
        final def compare(that: Type): _root_.scala.Int = this.ordinal.compareTo(that.ordinal);
        final def string: _root_.org.sireum.String = toString
      };
      final def byName(name: _root_.org.sireum.String): _root_.org.sireum.Option[Type] = elements.elements.find(((x$1) => x$1.name.==(name))) match {
        case _root_.scala.Some((v @ _)) => _root_.org.sireum.Some(v)
        case _ => _root_.org.sireum.None()
      };
      final def byOrdinal(n: _root_.org.sireum.Z): _root_.org.sireum.Option[Type] = if ((0).<=(n).&&(n.<(elements.size)))
        _root_.org.sireum.Some(elements(n))
      else
        _root_.org.sireum.None();
      final case object NIL extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 0;
        def name: _root_.org.sireum.String = "NIL"
      };
      final case object BOOLEAN extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 1;
        def name: _root_.org.sireum.String = "BOOLEAN"
      };
      final case object INTEGER extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 2;
        def name: _root_.org.sireum.String = "INTEGER"
      };
      final case object FLOAT extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 3;
        def name: _root_.org.sireum.String = "FLOAT"
      };
      final case object STRING extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 4;
        def name: _root_.org.sireum.String = "STRING"
      };
      final case object ARRAY extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 5;
        def name: _root_.org.sireum.String = "ARRAY"
      };
      final case object MAP extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 6;
        def name: _root_.org.sireum.String = "MAP"
      };
      final case object BINARY extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 7;
        def name: _root_.org.sireum.String = "BINARY"
      };
      final case object EXTENSION extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 8;
        def name: _root_.org.sireum.String = "EXTENSION"
      };
      final case object NONE extends Type with scala.Product with scala.Serializable {
        def ordinal: _root_.org.sireum.Z = 9;
        def name: _root_.org.sireum.String = "NONE"
      };
      val numOfElements: _root_.org.sireum.Z = 10;
      val elements: _root_.org.sireum.ISZ[Type] = _root_.org.sireum.ISZ[Type](NIL, BOOLEAN, INTEGER, FLOAT, STRING, ARRAY, MAP, BINARY, EXTENSION, NONE)
    };
    val TimestampExtType: S8 = StringContext("-1").s8();
    val StringPoolExtType: S8 = StringContext("0").s8();
    val DocInfoExtType: S8 = StringContext("1").s8();
    val LastExtType: S8 = _root_.org.sireum.helper.$assign(DocInfoExtType);
    object Code {
      val POSFIXINT_MASK: U8 = StringContext("0x80").u8();
      val FIXMAP_PREFIX: U8 = StringContext("0x80").u8();
      val FIXARRAY_PREFIX: U8 = StringContext("0x90").u8();
      val FIXSTR_PREFIX: U8 = StringContext("0xA0").u8();
      val NIL: U8 = StringContext("0xC0").u8();
      val FALSE: U8 = StringContext("0xC2").u8();
      val TRUE: U8 = StringContext("0xC3").u8();
      val BIN8: U8 = StringContext("0xC4").u8();
      val BIN16: U8 = StringContext("0xC5").u8();
      val BIN32: U8 = StringContext("0xC6").u8();
      val EXT8: U8 = StringContext("0xC7").u8();
      val EXT16: U8 = StringContext("0xC8").u8();
      val EXT32: U8 = StringContext("0xC9").u8();
      val FLOAT32: U8 = StringContext("0xCA").u8();
      val FLOAT64: U8 = StringContext("0xCB").u8();
      val UINT8: U8 = StringContext("0xCC").u8();
      val UINT16: U8 = StringContext("0xCD").u8();
      val UINT32: U8 = StringContext("0xCE").u8();
      val UINT64: U8 = StringContext("0xCF").u8();
      val INT8: U8 = StringContext("0xD0").u8();
      val INT16: U8 = StringContext("0xD1").u8();
      val INT32: U8 = StringContext("0xD2").u8();
      val INT64: U8 = StringContext("0xD3").u8();
      val FIXEXT1: U8 = StringContext("0xD4").u8();
      val FIXEXT2: U8 = StringContext("0xD5").u8();
      val FIXEXT4: U8 = StringContext("0xD6").u8();
      val FIXEXT8: U8 = StringContext("0xD7").u8();
      val FIXEXT16: U8 = StringContext("0xD8").u8();
      val STR8: U8 = StringContext("0xD9").u8();
      val STR16: U8 = StringContext("0xDA").u8();
      val STR32: U8 = StringContext("0xDB").u8();
      val ARRAY16: U8 = StringContext("0xDC").u8();
      val ARRAY32: U8 = StringContext("0xDD").u8();
      val MAP16: U8 = StringContext("0xDE").u8();
      val MAP32: U8 = StringContext("0xDF").u8();
      val NEGFIXINT_PREFIX: U8 = StringContext("0xE0").u8();
      val formatTable: IS[U8, Kind.Type] = _root_.org.sireum.helper.$assign({
        @pure def getType0(n: U8): Kind.Type = if (isPosFixInt(n).||(isNegFixInt(n)))
          return _root_.org.sireum.helper.$assign(Kind.INTEGER)
        else
          if (Code.isFixStr(n))
            return _root_.org.sireum.helper.$assign(Kind.STRING)
          else
            if (Code.isFixedArray(n))
              return _root_.org.sireum.helper.$assign(Kind.ARRAY)
            else
              if (Code.isFixedMap(n))
                return _root_.org.sireum.helper.$assign(Kind.MAP)
              else
                _root_.org.sireum.helper.$tmatch(n) match {
                  case Code.NIL => return _root_.org.sireum.helper.$assign(Kind.NIL)
                  case Code.FALSE => return _root_.org.sireum.helper.$assign(Kind.BOOLEAN)
                  case Code.TRUE => return _root_.org.sireum.helper.$assign(Kind.BOOLEAN)
                  case Code.BIN8 => return _root_.org.sireum.helper.$assign(Kind.BINARY)
                  case Code.BIN16 => return _root_.org.sireum.helper.$assign(Kind.BINARY)
                  case Code.BIN32 => return _root_.org.sireum.helper.$assign(Kind.BINARY)
                  case Code.FLOAT32 => return _root_.org.sireum.helper.$assign(Kind.FLOAT)
                  case Code.FLOAT64 => return _root_.org.sireum.helper.$assign(Kind.FLOAT)
                  case Code.UINT8 => return _root_.org.sireum.helper.$assign(Kind.INTEGER)
                  case Code.UINT16 => return _root_.org.sireum.helper.$assign(Kind.INTEGER)
                  case Code.UINT32 => return _root_.org.sireum.helper.$assign(Kind.INTEGER)
                  case Code.UINT64 => return _root_.org.sireum.helper.$assign(Kind.INTEGER)
                  case Code.INT8 => return _root_.org.sireum.helper.$assign(Kind.INTEGER)
                  case Code.INT16 => return _root_.org.sireum.helper.$assign(Kind.INTEGER)
                  case Code.INT32 => return _root_.org.sireum.helper.$assign(Kind.INTEGER)
                  case Code.INT64 => return _root_.org.sireum.helper.$assign(Kind.INTEGER)
                  case Code.STR8 => return _root_.org.sireum.helper.$assign(Kind.STRING)
                  case Code.STR16 => return _root_.org.sireum.helper.$assign(Kind.STRING)
                  case Code.STR32 => return _root_.org.sireum.helper.$assign(Kind.STRING)
                  case Code.ARRAY16 => return _root_.org.sireum.helper.$assign(Kind.ARRAY)
                  case Code.ARRAY32 => return _root_.org.sireum.helper.$assign(Kind.ARRAY)
                  case Code.MAP16 => return _root_.org.sireum.helper.$assign(Kind.MAP)
                  case Code.MAP32 => return _root_.org.sireum.helper.$assign(Kind.MAP)
                  case Code.FIXEXT1 => return _root_.org.sireum.helper.$assign(Kind.EXTENSION)
                  case Code.FIXEXT2 => return _root_.org.sireum.helper.$assign(Kind.EXTENSION)
                  case Code.FIXEXT4 => return _root_.org.sireum.helper.$assign(Kind.EXTENSION)
                  case Code.FIXEXT8 => return _root_.org.sireum.helper.$assign(Kind.EXTENSION)
                  case Code.FIXEXT16 => return _root_.org.sireum.helper.$assign(Kind.EXTENSION)
                  case Code.EXT8 => return _root_.org.sireum.helper.$assign(Kind.EXTENSION)
                  case Code.EXT16 => return _root_.org.sireum.helper.$assign(Kind.EXTENSION)
                  case Code.EXT32 => return _root_.org.sireum.helper.$assign(Kind.EXTENSION)
                  case _ => return _root_.org.sireum.helper.$assign(Kind.NONE)
                };
        var a = _root_.org.sireum.helper.$assign(IS[U8, Kind.Type]());
        var n = _root_.org.sireum.Z(0);
        var i = StringContext("0").u8();
        while (n.<=(_root_.org.sireum.Z(256))) 
          {
            a = _root_.org.sireum.helper.$assign(a.:+(getType0(i)));
            n = _root_.org.sireum.helper.$assign(n.+(_root_.org.sireum.Z(1)));
            i = _root_.org.sireum.helper.$assign(i.+(StringContext("1").u8()))
          }
        ;
        a
      });
      @pure def getType(n: U8): Kind.Type = return _root_.org.sireum.helper.$assign(formatTable(n));
      @pure def isFixInt(n: U8): B = {
        val v = _root_.org.sireum.helper.$assign(n.&(StringContext("0xFF").u8()));
        return _root_.org.sireum.helper.$assign(v.<=(StringContext("0x7F").u8()).||(v.>=(StringContext("0xE0").u8())))
      };
      @pure def isPosFixInt(n: U8): B = return _root_.org.sireum.helper.$assign(n.&(POSFIXINT_MASK).==(StringContext("0").u8()));
      @pure def isNegFixInt(n: U8): B = return _root_.org.sireum.helper.$assign(n.&(NEGFIXINT_PREFIX).==(NEGFIXINT_PREFIX));
      @pure def isFixStr(n: U8): B = return _root_.org.sireum.helper.$assign(n.&(StringContext("0xE0").u8()).==(Code.FIXSTR_PREFIX));
      @pure def isFixedArray(n: U8): B = return _root_.org.sireum.helper.$assign(n.&(StringContext("0xF0").u8()).==(Code.FIXARRAY_PREFIX));
      @pure def isFixedMap(n: U8): B = return _root_.org.sireum.helper.$assign(n.&(StringContext("0xF0").u8()).==(Code.FIXMAP_PREFIX));
      @pure def isFixedRaw(n: U8): B = return _root_.org.sireum.helper.$assign(n.&(StringContext("0xE0").u8()).==(Code.FIXSTR_PREFIX));
      @pure def isExt(n: U8): B = _root_.org.sireum.helper.$tmatch(n) match {
        case Code.EXT8 => return _root_.org.sireum.helper.$assign(T)
        case Code.EXT16 => return _root_.org.sireum.helper.$assign(T)
        case Code.EXT32 => return _root_.org.sireum.helper.$assign(T)
        case Code.FIXEXT1 => return _root_.org.sireum.helper.$assign(T)
        case Code.FIXEXT2 => return _root_.org.sireum.helper.$assign(T)
        case Code.FIXEXT4 => return _root_.org.sireum.helper.$assign(T)
        case Code.FIXEXT8 => return _root_.org.sireum.helper.$assign(T)
        case Code.FIXEXT16 => return _root_.org.sireum.helper.$assign(T)
        case _ => return _root_.org.sireum.helper.$assign(F)
      }
    };
    @record sealed trait Writer extends _root_.org.sireum.RecordSig {
      def result: ISZ[U8];
      def writeB(b: B): Unit;
      def writeC(c: C): Unit = writeU32(conversions.C.toU32(c));
      def writeZ(n: Z): Unit;
      def writeZ8(n: Z8): Unit = writeS8(conversions.Z8.toS8(n));
      def writeZ16(n: Z16): Unit = writeS16(conversions.Z16.toS16(n));
      def writeZ32(n: Z32): Unit = writeS32(conversions.Z32.toS32(n));
      def writeZ64(n: Z64): Unit = writeS64(conversions.Z64.toS64(n));
      def writeN(n: N): Unit = writeZ(conversions.N.toZ(n));
      def writeN8(n: N8): Unit = writeU8(conversions.N8.toU8(n));
      def writeN16(n: N16): Unit = writeU16(conversions.N16.toU16(n));
      def writeN32(n: N32): Unit = writeU32(conversions.N32.toU32(n));
      def writeN64(n: N64): Unit = writeU64(conversions.N64.toU64(n));
      def writeS8(n: S8): Unit;
      def writeS16(n: S16): Unit;
      def writeS32(n: S32): Unit;
      def writeS64(n: S64): Unit;
      def writeU8(n: U8): Unit;
      def writeU16(n: U16): Unit;
      def writeU32(n: U32): Unit;
      def writeU64(n: U64): Unit;
      def writeR(n: R): Unit = writeString(n.string);
      def writeF32(n: F32): Unit;
      def writeF64(n: F64): Unit;
      def writeString(s: String): Unit;
      def writeOption[T](o: Option[T], f: _root_.scala.Function1[T, Unit]): Unit = _root_.org.sireum.helper.$tmatch(o) match {
        case Some((e @ _)) => f(e)
        case _ => writeNil()
      };
      def writeMOption[T](o: MOption[T], f: _root_.scala.Function1[T, Unit]): Unit = _root_.org.sireum.helper.$tmatch(o) match {
        case MSome((e @ _)) => f(e)
        case _ => writeNil()
      };
      def writeEither[L, R](o: Either[L, R], l: _root_.scala.Function1[L, Unit], r: _root_.scala.Function1[R, Unit]): Unit = _root_.org.sireum.helper.$tmatch(o) match {
        case Either.Left((e @ _)) => l(e)
        case Either.Right((e @ _)) => {
          writeNil();
          r(e)
        }
      };
      def writeMEither[L, R](o: MEither[L, R], l: _root_.scala.Function1[L, Unit], r: _root_.scala.Function1[R, Unit]): Unit = _root_.org.sireum.helper.$tmatch(o) match {
        case MEither.Left((e @ _)) => l(e)
        case MEither.Right((e @ _)) => {
          writeNil();
          r(e)
        }
      };
      def writeISZ[V](s: IS[Z, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(s.size);
        s.foreach(((e) => f(e)))
      };
      def writeISZ8[V](s: IS[Z8, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.Z8.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISZ16[V](s: IS[Z16, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.Z16.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISZ32[V](s: IS[Z32, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.Z32.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISZ64[V](s: IS[Z64, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.Z64.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISN[V](s: IS[N, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.N.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISN8[V](s: IS[N8, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.N8.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISN16[V](s: IS[N16, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.N16.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISN32[V](s: IS[N32, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.N32.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISN64[V](s: IS[N64, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.N64.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISS8[V](s: IS[S8, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.S8.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISS16[V](s: IS[S16, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.S16.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISS32[V](s: IS[S32, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.S32.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISS64[V](s: IS[S64, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.S64.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISU8[V](s: IS[U8, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.U8.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISU16[V](s: IS[U16, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.U16.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISU32[V](s: IS[U32, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.U32.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeISU64[V](s: IS[U64, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.U64.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSZ[V](s: MS[Z, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(s.size);
        s.foreach(((e) => f(e)))
      };
      def writeMSZ8[V](s: MS[Z8, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.Z8.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSZ16[V](s: MS[Z16, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.Z16.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSZ32[V](s: MS[Z32, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.Z32.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSZ64[V](s: MS[Z64, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.Z64.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSN[V](s: MS[N, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.N.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSN8[V](s: MS[N8, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.N8.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSN16[V](s: MS[N16, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.N16.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSN32[V](s: MS[N32, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.N32.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSN64[V](s: MS[N64, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.N64.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSS8[V](s: MS[S8, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.S8.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSS16[V](s: MS[S16, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.S16.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSS32[V](s: MS[S32, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.S32.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSS64[V](s: MS[S64, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.S64.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSU8[V](s: MS[U8, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.U8.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSU16[V](s: MS[U16, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.U16.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSU32[V](s: MS[U32, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.U32.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeMSU64[V](s: MS[U64, V], f: _root_.scala.Function1[V, Unit]): Unit = {
        writeArrayHeader(conversions.U64.toZ(s.size));
        s.foreach(((e) => f(e)))
      };
      def writeZS(s: ZS): Unit = writeMSZ(s, (writeZ _));
      def writeMap[K, V](o: Map[K, V], f: _root_.scala.Function1[K, Unit], g: _root_.scala.Function1[V, Unit]): Unit = {
        writeMapHeader(o.size);
        o.entries.foreach(((e) => {
          f(e._1);
          g(e._2)
        }))
      };
      def writeSet[T](o: Set[T], f: _root_.scala.Function1[T, Unit]): Unit = writeISZ(o.elements, f);
      def writeHashMap[K, V](o: HashMap[K, V], f: _root_.scala.Function1[K, Unit], g: _root_.scala.Function1[V, Unit]): Unit = {
        writeMapHeader(o.size);
        o.entries.foreach(((e) => {
          f(e._1);
          g(e._2)
        }))
      };
      def writeHashSet[T](o: HashSet[T], f: _root_.scala.Function1[T, Unit]): Unit = writeISZ(o.elements, f);
      def writeHashSMap[K, V](o: HashSMap[K, V], f: _root_.scala.Function1[K, Unit], g: _root_.scala.Function1[V, Unit]): Unit = {
        writeMapHeader(o.size);
        o.entries.foreach(((e) => {
          f(e._1);
          g(e._2)
        }))
      };
      def writeHashSSet[T](o: HashSSet[T], f: _root_.scala.Function1[T, Unit]): Unit = writeISZ(o.elements, f);
      def writeStack[T](o: Stack[T], f: _root_.scala.Function1[T, Unit]): Unit = writeISZ(o.elements, f);
      def writeBag[T](o: Bag[T], f: _root_.scala.Function1[T, Unit]): Unit = writeMap(o.map, f, (writeZ _));
      def writeHashBag[T](o: HashBag[T], f: _root_.scala.Function1[T, Unit]): Unit = writeHashMap(o.map, f, (writeZ _));
      def writePoset[T](o: Poset[T], f: _root_.scala.Function1[T, Unit]): Unit = {
        def g(s: HashSet[Poset.Index]): Unit = writeHashSet(s, (writeZ _));
        writeISZ(o.nodesInverse, f);
        writeHashMap(o.parents, (writeZ _), (g _))
      };
      def writeGraph[V, E](o: Graph[V, E], f: _root_.scala.Function1[V, Unit], g: _root_.scala.Function1[E, Unit]): Unit = {
        def writeEdge(edge: Graph.Internal.Edge[E]): Unit = _root_.org.sireum.helper.$tmatch(edge) match {
          case Graph.Internal.Edge.Plain((src @ _), (dest @ _)) => {
            writeZ(src);
            writeZ(dest);
            writeNil()
          }
          case Graph.Internal.Edge.Data((src @ _), (dest @ _), (data @ _)) => {
            writeZ(src);
            writeZ(dest);
            g(data)
          }
        };
        val edges: ISZ[Graph.Internal.Edge[E]] = _root_.org.sireum.helper.$assign(o.outgoingEdges.values.flatMap(((es) => es.elements.map(((e) => e)))));
        writeB(o.multi);
        writeISZ(o.nodesInverse, f);
        writeISZ(edges, (writeEdge _))
      };
      def writeUnionFind[T](o: UnionFind[T], f: _root_.scala.Function1[T, Unit]): Unit = {
        writeISZ(o.elementsInverse, f);
        writeISZ(o.parentOf, (writeZ _));
        writeISZ(o.sizeOf, (writeZ _))
      };
      def writeMessage(o: message.Message): Unit = {
        writeZ(o.level.ordinal);
        writeOption(o.posOpt, (writePosition _));
        writeString(o.kind);
        writeString(o.text)
      };
      def writePosition(o: message.Position): Unit;
      def writeDocInfo(o: message.DocInfo): Unit;
      def writeArrayHeader(n: Z): Unit;
      def writeBinary(array: ISZ[U8]): Unit;
      def writeNil(): Unit;
      def writeMapHeader(n: Z): Unit;
      def writeExtTypeHeader(extType: S8, payloadLen: Z): Unit;
      def writePayload(data: ISZ[U8]): Unit
    };
    object Writer {
      object Impl {
        def apply(pooling: B, buf: MSZ[U8], size: Z): Impl = new Impl(_root_.org.sireum.helper.$assign(pooling), _root_.org.sireum.helper.$assign(buf), _root_.org.sireum.helper.$assign(size));
        def unapply(o: Impl): _root_.scala.Option[scala.Tuple3[B, MSZ[U8], Z]] = _root_.scala.Some(scala.Tuple3(_root_.org.sireum.helper.clone(o.pooling), _root_.org.sireum.helper.clone(o.buf), _root_.org.sireum.helper.clone(o.size)))
      };
      @record final class Impl(__pooling: B, __buf: MSZ[U8], __size: Z) extends Writer with _root_.org.sireum.RecordSig {
        private[this] var _pooling = __pooling;
        def pooling = _pooling;
        def getPooling = _pooling;
        private[this] var _buf = __buf;
        def buf = _buf;
        def getBuf = _buf;
        def `buf_=`(buf: MSZ[U8]): this.type = {
          _buf = buf;
          this
        };
        def setBuf(buf: MSZ[U8]): this.type = {
          _buf = buf;
          this
        };
        private[this] var _size = __size;
        def size = _size;
        def getSize = _size;
        def `size_=`(size: Z): this.type = {
          _size = size;
          this
        };
        def setSize(size: Z): this.type = {
          _size = size;
          this
        };
        override def toString: _root_.java.lang.String = if ($hasString)
          super.string.value
        else
          {
            val sb = new _root_.java.lang.StringBuilder();
            sb.append("Impl");
            sb.append('(');
            sb.append(_root_.org.sireum.String.escape(this.pooling));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.buf));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.size));
            sb.append(')');
            sb.toString
          };
        override def string: _root_.org.sireum.String = if ($hasString)
          super.string
        else
          toString;
        override def hashCode: _root_.scala.Int = if ($hasEquals)
          super.hashCode
        else
          _root_.scala.Seq(this.getClass, pooling, buf, size).hashCode;
        override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
          super.equals(o)
        else
          if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
            true
          else
            o match {
              case (o @ ((_): Impl)) => if (this.hashCode.!=(o.hashCode))
                false
              else
                this.pooling.==(o.pooling).&&(this.buf.==(o.buf)).&&(this.size.==(o.size))
              case _ => false
            };
        def apply(pooling: B = this.pooling, buf: MSZ[U8] = this.buf, size: Z = this.size): Impl = new Impl(_root_.org.sireum.helper.$assign(pooling), _root_.org.sireum.helper.$assign(buf), _root_.org.sireum.helper.$assign(size));
        override def $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Impl")), scala.Tuple2("pooling", pooling), scala.Tuple2("buf", buf), scala.Tuple2("size", size));
        override def $clone: Impl = {
          val r: Impl = new Impl(_root_.org.sireum.helper.cloneAssign(this.pooling), _root_.org.sireum.helper.cloneAssign(this.buf), _root_.org.sireum.helper.cloneAssign(this.size));
          r.stringPool = _root_.org.sireum.helper.cloneAssign(stringPool);
          r.docInfoPool = _root_.org.sireum.helper.cloneAssign(docInfoPool);
          r
        };
        var stringPool: HashSMap[String, Z] = _root_.org.sireum.helper.$assign(HashSMap.emptyInit(_root_.org.sireum.Z(1024)));
        var docInfoPool: HashSMap[message.DocInfo, Z] = _root_.org.sireum.helper.$assign(HashSMap.emptyInit(_root_.org.sireum.Z(1024)));
        def result: ISZ[U8] = if (pooling)
          {
            val strings = _root_.org.sireum.helper.$assign(stringPool.keys.elements);
            val poolBufferSize: Z = _root_.org.sireum.helper.$assign({
              var r: Z = _root_.org.sireum.Z(0);
              strings.foreach(((s) => r = _root_.org.sireum.helper.$assign(r.+(s.size.*(_root_.org.sireum.Z(2))))));
              r.+(_root_.org.sireum.Z(4))
            });
            val x$1 = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(((({
              val r = Impl(F, MSZ.create(poolBufferSize, StringContext("0").u8()), 0);
              r.writeExtTypeHeader(StringPoolExtType, strings.size);
              strings.foreach(((s) => r.writeStringNoPool(s)));
              r.writeExtTypeHeader(DocInfoExtType, docInfoPool.size);
              docInfoPool.keys.elements.foreach(((di) => r.writeDocInfoNoPool(di)));
              scala.Tuple2(r.buf, r.size)
            }): @scala.unchecked): scala.Tuple2[MSZ[U8], Z])) match {
              case scala.Tuple2((poolBuf @ _), (poolBufSize @ _)) => scala.Tuple2(_root_.org.sireum.helper.$assign(poolBuf), _root_.org.sireum.helper.$assign(poolBufSize))
            });
            val poolBuf = _root_.org.sireum.helper.$assign(x$1._1);
            val poolBufSize = _root_.org.sireum.helper.$assign(x$1._2);
            val r = _root_.org.sireum.helper.$assign(MSZ.create(poolBufSize.+(size), StringContext("0").u8()));
            var i = _root_.org.sireum.Z(0);
            while (i.<(poolBufSize)) 
              {
                r.update(i, _root_.org.sireum.helper.$assign(poolBuf(i)));
                i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
              }
            ;
            i = _root_.org.sireum.Z(0);
            while (i.<(size)) 
              {
                r.update(i.+(poolBufSize), _root_.org.sireum.helper.$assign(buf(i)));
                i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
              }
            ;
            return _root_.org.sireum.helper.$assign(r.toIS)
          }
        else
          {
            val r = _root_.org.sireum.helper.$assign(MSZ.create(size, StringContext("0").u8()));
            var i = _root_.org.sireum.Z(0);
            while (i.<(size)) 
              {
                r.update(i, _root_.org.sireum.helper.$assign(buf(i)));
                i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
              }
            ;
            return _root_.org.sireum.helper.$assign(r.toIS)
          };
        def addString(s: String): Z = _root_.org.sireum.helper.$tmatch(stringPool.get(s)) match {
          case Some((i @ _)) => return _root_.org.sireum.helper.$assign(i)
          case _ => {
            val i = _root_.org.sireum.helper.$assign(stringPool.size);
            stringPool = _root_.org.sireum.helper.$assign(stringPool.+(s.~>(i)));
            return _root_.org.sireum.helper.$assign(i)
          }
        };
        def addU8(n: U8): Unit = {
          if (size.==(buf.size))
            {
              val newBuf = _root_.org.sireum.helper.$assign(MSZ.create(buf.size.*(_root_.org.sireum.Z(2)).+(_root_.org.sireum.Z(1)), StringContext("0").u8()));
              StringContext("0").z().until(buf.size).foreach(((i) => newBuf.update(i, _root_.org.sireum.helper.$assign(buf(i)))));
              buf = _root_.org.sireum.helper.$assign(newBuf)
            }
          else
            ();
          buf.update(size, _root_.org.sireum.helper.$assign(n));
          size = _root_.org.sireum.helper.$assign(size.+(_root_.org.sireum.Z(1)))
        };
        def addU16(n: U16): Unit = {
          addU8(conversions.U16.toU8(n.>>>(StringContext("8").u16()).&(StringContext("0xFF").u16())));
          addU8(conversions.U16.toU8(n.&(StringContext("0xFF").u16())))
        };
        def addU32(n: U32): Unit = {
          addU8(conversions.U32.toU8(n.>>>(StringContext("24").u32()).&(StringContext("0xFF").u32())));
          addU8(conversions.U32.toU8(n.>>>(StringContext("16").u32()).&(StringContext("0xFF").u32())));
          addU8(conversions.U32.toU8(n.>>>(StringContext("8").u32()).&(StringContext("0xFF").u32())));
          addU8(conversions.U32.toU8(n.&(StringContext("0xFF").u32())))
        };
        def addU64(n: U64): Unit = {
          addU8(conversions.U64.toU8(n.>>>(StringContext("56").u64()).&(StringContext("0xFF").u64())));
          addU8(conversions.U64.toU8(n.>>>(StringContext("48").u64()).&(StringContext("0xFF").u64())));
          addU8(conversions.U64.toU8(n.>>>(StringContext("40").u64()).&(StringContext("0xFF").u64())));
          addU8(conversions.U64.toU8(n.>>>(StringContext("32").u64()).&(StringContext("0xFF").u64())));
          addU8(conversions.U64.toU8(n.>>>(StringContext("24").u64()).&(StringContext("0xFF").u64())));
          addU8(conversions.U64.toU8(n.>>>(StringContext("16").u64()).&(StringContext("0xFF").u64())));
          addU8(conversions.U64.toU8(n.>>>(StringContext("8").u64()).&(StringContext("0xFF").u64())));
          addU8(conversions.U64.toU8(n.&(StringContext("0xFF").u64())))
        };
        def addS8(n: S8): Unit = addU8(conversions.S8.toRawU8(n));
        def addS16(n: S16): Unit = {
          addU8(conversions.S16.toU8(n.>>>(StringContext("8").s16()).&(StringContext("0xFF").s16())));
          addU8(conversions.S16.toU8(n.&(StringContext("0xFF").s16())))
        };
        def addS32(n: S32): Unit = {
          addU8(conversions.S32.toU8(n.>>>(StringContext("24").s32()).&(StringContext("0xFF").s32())));
          addU8(conversions.S32.toU8(n.>>>(StringContext("16").s32()).&(StringContext("0xFF").s32())));
          addU8(conversions.S32.toU8(n.>>>(StringContext("8").s32()).&(StringContext("0xFF").s32())));
          addU8(conversions.S32.toU8(n.&(StringContext("0xFF").s32())))
        };
        def addS64(n: S64): Unit = {
          addU8(conversions.S64.toU8(n.>>>(StringContext("56").s64()).&(StringContext("0xFF").s64())));
          addU8(conversions.S64.toU8(n.>>>(StringContext("48").s64()).&(StringContext("0xFF").s64())));
          addU8(conversions.S64.toU8(n.>>>(StringContext("40").s64()).&(StringContext("0xFF").s64())));
          addU8(conversions.S64.toU8(n.>>>(StringContext("32").s64()).&(StringContext("0xFF").s64())));
          addU8(conversions.S64.toU8(n.>>>(StringContext("24").s64()).&(StringContext("0xFF").s64())));
          addU8(conversions.S64.toU8(n.>>>(StringContext("16").s64()).&(StringContext("0xFF").s64())));
          addU8(conversions.S64.toU8(n.>>>(StringContext("8").s64()).&(StringContext("0xFF").s64())));
          addU8(conversions.S64.toU8(n.&(StringContext("0xFF").s64())))
        };
        def writeU8(n: U8): Unit = if (n.>(StringContext("127").u8()))
          {
            addU8(Code.UINT8);
            addU8(n)
          }
        else
          writeS8(conversions.U8.toS8(n));
        def writeS8(n: S8): Unit = if (n.<(StringContext("1").s8().<<(StringContext("5").s8()).`unary_-`))
          {
            addU8(Code.INT8);
            addS8(n)
          }
        else
          addS8(n);
        def writeU16(n: U16): Unit = if (n.>(StringContext("32767").u16()))
          {
            addU8(Code.UINT16);
            addU16(n)
          }
        else
          writeS16(conversions.U16.toS16(n));
        def writeS16(n: S16): Unit = if (n.<(StringContext("1").s16().<<(StringContext("5").s16()).`unary_-`))
          if (n.<(StringContext("1").s16().<<(StringContext("7").s16()).`unary_-`))
            {
              addU8(Code.INT16);
              addS16(n)
            }
          else
            {
              addU8(Code.INT8);
              addS8(conversions.S16.toS8(n))
            }
        else
          if (n.<(StringContext("1").s16().<<(StringContext("7").s16())))
            addS8(conversions.S16.toS8(n))
          else
            if (n.<(StringContext("1").s16().<<(StringContext("8").s16())))
              {
                addU8(Code.UINT8);
                addU8(conversions.S16.toU8(n))
              }
            else
              {
                addU8(Code.UINT16);
                addU16(conversions.S16.toU16(n))
              };
        def writeU32(n: U32): Unit = if (n.>(StringContext("2147483647").u32()))
          {
            addU8(Code.UINT32);
            addU32(n)
          }
        else
          writeS32(conversions.U32.toS32(n));
        def writeS32(n: S32): Unit = if (n.<(StringContext("1").s32().<<(StringContext("5").s32()).`unary_-`))
          if (n.<(StringContext("1").s32().<<(StringContext("15").s32()).`unary_-`))
            {
              addU8(Code.INT32);
              addS32(n)
            }
          else
            if (n.<(StringContext("1").s32().<<(StringContext("7").s32()).`unary_-`))
              {
                addU8(Code.INT16);
                addS16(conversions.S32.toS16(n))
              }
            else
              {
                addU8(Code.INT8);
                addS8(conversions.S32.toS8(n))
              }
        else
          if (n.<(StringContext("1").s32().<<(StringContext("7").s32())))
            addS8(conversions.S32.toS8(n))
          else
            if (n.<(StringContext("1").s32().<<(StringContext("8").s32())))
              {
                addU8(Code.UINT8);
                addU8(conversions.S32.toU8(n))
              }
            else
              if (n.<(StringContext("1").s32().<<(StringContext("16").s32())))
                {
                  addU8(Code.UINT16);
                  addU16(conversions.S32.toU16(n))
                }
              else
                {
                  addU8(Code.UINT32);
                  addU32(conversions.S32.toU32(n))
                };
        def writeU64(n: U64): Unit = if (n.>(StringContext("9223372036854775807").u64()))
          {
            addU8(Code.UINT64);
            addU64(n)
          }
        else
          writeS64(conversions.U64.toS64(n));
        def writeS64(n: S64): Unit = if (n.<(StringContext("1").s64().<<(StringContext("5").s64()).`unary_-`))
          if (n.<(StringContext("1").s64().<<(StringContext("15").s64()).`unary_-`))
            if (n.<(StringContext("1").s64().<<(StringContext("31").s64()).`unary_-`))
              {
                addU8(Code.INT64);
                addS64(n)
              }
            else
              {
                addU8(Code.INT32);
                addS32(conversions.S64.toS32(n))
              }
          else
            if (n.<(StringContext("1").s64().<<(StringContext("7").s64()).`unary_-`))
              {
                addU8(Code.INT16);
                addS16(conversions.S64.toS16(n))
              }
            else
              {
                addU8(Code.INT8);
                addS8(conversions.S64.toS8(n))
              }
        else
          if (n.<(StringContext("1").s64().<<(StringContext("7").s64())))
            addS8(conversions.S64.toS8(n))
          else
            if (n.<(StringContext("1").s64().<<(StringContext("16").s64())))
              if (n.<(StringContext("1").s64().<<(StringContext("8").s64())))
                {
                  addU8(Code.UINT8);
                  addU8(conversions.S64.toU8(n))
                }
              else
                {
                  addU8(Code.UINT16);
                  addU16(conversions.S64.toU16(n))
                }
            else
              if (n.<(StringContext("1").s64().<<(StringContext("32").s64())))
                {
                  addU8(Code.UINT32);
                  addU32(conversions.S64.toU32(n))
                }
              else
                {
                  addU8(Code.UINT64);
                  addU64(conversions.S64.toU64(n))
                };
        def writeZ(n: Z): Unit = if (_root_.org.sireum.Z(-9223372036854775808L).<=(n).&&(n.<=(_root_.org.sireum.Z(9223372036854775807L))))
          writeS64(conversions.Z.toS64(n))
        else
          if (_root_.org.sireum.Z(0).<=(n).&&(n.<=(StringContext("18446744073709551615").z())))
            writeU64(conversions.Z.toU64(n))
          else
            writeBinary(conversions.Z.toBinary(n));
        def writeF32(n: F32): Unit = {
          addU8(Code.FLOAT32);
          addU32(conversions.F32.toRawU32(n))
        };
        def writeF64(n: F64): Unit = {
          addU8(Code.FLOAT64);
          addU64(conversions.F64.toRawU64(n))
        };
        def writeArrayHeader(n: Z): Unit = {
          StringContext(" requires 0 <= n ∧ n <= z\"4294967295\" ").lUnit();
          if (n.<(_root_.org.sireum.Z(16)))
            addU8(Code.FIXARRAY_PREFIX.|(conversions.Z.toU8(n)))
          else
            if (n.<(_root_.org.sireum.Z(65536)))
              {
                addU8(Code.ARRAY16);
                addS16(conversions.Z.toS16(n))
              }
            else
              {
                addU8(Code.ARRAY32);
                addS32(conversions.Z.toS32(n))
              }
        };
        def writeBinary(array: ISZ[U8]): Unit = {
          StringContext(" requires 0 <= array.size ∧ array.size <= z\"4294967295\" ").lUnit();
          val len = _root_.org.sireum.helper.$assign(array.size);
          if (len.<(_root_.org.sireum.Z(256)))
            {
              addU8(Code.BIN8);
              addU8(conversions.Z.toU8(len))
            }
          else
            if (len.<(_root_.org.sireum.Z(65536)))
              {
                addU8(Code.BIN16);
                addU16(conversions.Z.toU16(len))
              }
            else
              {
                addU8(Code.BIN32);
                addU32(conversions.Z.toU32(len))
              };
          array.foreach(((e) => addU8(e)))
        };
        def writeNil(): Unit = addU8(Code.NIL);
        def writeMapHeader(n: Z): Unit = {
          StringContext(" requires 0 <= n ∧ n <= z\"4294967295\" ").lUnit();
          if (n.<(_root_.org.sireum.Z(16)))
            addU8(Code.FIXMAP_PREFIX.|(conversions.Z.toU8(n)))
          else
            if (n.<(_root_.org.sireum.Z(65536)))
              {
                addU8(Code.MAP16);
                addU16(conversions.Z.toU16(n))
              }
            else
              {
                addU8(Code.MAP32);
                addU32(conversions.Z.toU32(n))
              }
        };
        def writeB(b: B): Unit = addU8(if (b)
          Code.TRUE
        else
          Code.FALSE);
        def writeStringNoPool(s: String): Unit = {
          val size = _root_.org.sireum.helper.$assign(s.size);
          writeZ(size);
          val cis = _root_.org.sireum.helper.$assign(conversions.String.toCis(s));
          StringContext("0").z().until(size).foreach(((i) => writeU32(conversions.C.toU32(cis(i)))))
        };
        def writeString(s: String): Unit = {
          StringContext(" requires 0 <= s.size * 2 ∧ s.size * 2 <= z\"4294967295\" ").lUnit();
          if (pooling)
            {
              val i = _root_.org.sireum.helper.$assign(addString(s));
              writeZ(i)
            }
          else
            writeStringNoPool(s)
        };
        def writeExtTypeHeader(extType: S8, payloadLen: Z): Unit = {
          StringContext(" requires extType >= s8\"0\" ∧ 0 <= payloadLen ∧ payloadLen <= z\"4294967295\"").lUnit();
          if (payloadLen.<(_root_.org.sireum.Z(256)))
            _root_.org.sireum.helper.$tmatch(payloadLen) match {
              case StringContext("1").z() => {
                addU8(Code.FIXEXT1);
                addS8(extType)
              }
              case StringContext("2").z() => {
                addU8(Code.FIXEXT2);
                addS8(extType)
              }
              case StringContext("4").z() => {
                addU8(Code.FIXEXT4);
                addS8(extType)
              }
              case StringContext("8").z() => {
                addU8(Code.FIXEXT8);
                addS8(extType)
              }
              case StringContext("16").z() => {
                addU8(Code.FIXEXT16);
                addS8(extType)
              }
              case _ => {
                addU8(Code.EXT8);
                addU8(conversions.Z.toU8(payloadLen));
                addS8(extType)
              }
            }
          else
            if (payloadLen.<(_root_.org.sireum.Z(65536)))
              {
                addU8(Code.EXT16);
                addU16(conversions.Z.toU16(payloadLen));
                addS8(extType)
              }
            else
              {
                addU8(Code.EXT32);
                addU32(conversions.Z.toU32(payloadLen));
                addS8(extType)
              }
        };
        def writePayload(data: ISZ[U8]): Unit = data.foreach(((e) => addU8(e)));
        def writePosition(o: message.Position): Unit = _root_.org.sireum.helper.$tmatch(o) match {
          case (o @ ((_): message.PosInfo)) if pooling => {
            writeB(T);
            writeDocInfo(o.info);
            writeU64(o.offsetLength)
          }
          case _ => {
            writeB(F);
            writeOption(o.uriOpt, (writeString _));
            writeU32(conversions.Z.toU32(o.beginLine));
            writeU32(conversions.Z.toU32(o.beginColumn));
            writeU32(conversions.Z.toU32(o.endLine));
            writeU32(conversions.Z.toU32(o.endColumn));
            writeU32(conversions.Z.toU32(o.offset));
            writeU32(conversions.Z.toU32(o.length))
          }
        };
        def writeDocInfoNoPool(o: message.DocInfo): Unit = {
          writeOption(o.uriOpt, (writeString _));
          writeISZ(o.lineOffsets, (writeU32 _))
        };
        def writeDocInfo(o: message.DocInfo): Unit = if (pooling)
          {
            val n: Z = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(docInfoPool.get(o)) match {
              case Some((m @ _)) => m
              case _ => {
                val m = _root_.org.sireum.helper.$assign(docInfoPool.size);
                docInfoPool = _root_.org.sireum.helper.$assign(docInfoPool.+(o.~>(m)));
                m
              }
            });
            writeZ(n)
          }
        else
          writeDocInfoNoPool(o)
      }
    };
    @record sealed trait Reader extends _root_.org.sireum.RecordSig {
      def init(): Unit;
      def error(offset: Z, msg: String): Unit;
      def curr: Z;
      def readB(): B;
      def readC(): C = {
        val n = _root_.org.sireum.helper.$assign(readU32());
        return _root_.org.sireum.helper.$assign(conversions.U32.toC(n))
      };
      def readZ(): Z;
      def expectZ(n: Z): Unit;
      @pure def fix8(n: Z): Z = {
        if (n.>(_root_.org.sireum.Z(127)))
          return _root_.org.sireum.helper.$assign(n.-(_root_.org.sireum.Z(256)))
        else
          ();
        return _root_.org.sireum.helper.$assign(n)
      };
      def readZ8(): Z8 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toZ8(fix8(n)))
      };
      def readZ16(): Z16 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toZ16(n))
      };
      def readZ32(): Z32 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toZ32(n))
      };
      def readZ64(): Z64 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toZ64(n))
      };
      def readN(): N = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toN(n))
      };
      def readN8(): N8 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toN8(n))
      };
      def readN16(): N16 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toN16(n))
      };
      def readN32(): N32 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toN32(n))
      };
      def readN64(): N64 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toN64(n))
      };
      def readS8(): S8 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toS8(fix8(n)))
      };
      def readS16(): S16 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toS16(n))
      };
      def readS32(): S32 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toS32(n))
      };
      def readS64(): S64 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toS64(n))
      };
      def readU8(): U8 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toU8(n))
      };
      def readU16(): U16 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toU16(n))
      };
      def readU32(): U32 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toU32(n))
      };
      def readU64(): U64 = {
        val n = _root_.org.sireum.helper.$assign(readZ());
        return _root_.org.sireum.helper.$assign(conversions.Z.toU64(n))
      };
      def readR(): R;
      def readF32(): F32;
      def readF64(): F64;
      def readString(): String;
      def readOption[T](f: _root_.scala.Function0[T]): Option[T] = {
        val isNil = _root_.org.sireum.helper.$assign(skipIfNil());
        if (isNil)
          return _root_.org.sireum.helper.$assign(None[T]())
        else
          {
            val o = _root_.org.sireum.helper.$assign(f());
            return _root_.org.sireum.helper.$assign(Some[T](o))
          }
      };
      def readMOption[T](f: _root_.scala.Function0[T]): MOption[T] = {
        val isNil = _root_.org.sireum.helper.$assign(skipIfNil());
        if (isNil)
          return _root_.org.sireum.helper.$assign(MNone[T]())
        else
          {
            val o = _root_.org.sireum.helper.$assign(f());
            return _root_.org.sireum.helper.$assign(MSome[T](o))
          }
      };
      def readEither[L, R](l: _root_.scala.Function0[L], r: _root_.scala.Function0[R]): Either[L, R] = {
        val isNil = _root_.org.sireum.helper.$assign(skipIfNil());
        if (isNil)
          {
            val o = _root_.org.sireum.helper.$assign(r());
            return _root_.org.sireum.helper.$assign(Either.Right(o))
          }
        else
          {
            val o = _root_.org.sireum.helper.$assign(l());
            return _root_.org.sireum.helper.$assign(Either.Left(o))
          }
      };
      def readMEither[L, R](l: _root_.scala.Function0[L], r: _root_.scala.Function0[R]): MEither[L, R] = {
        val isNil = _root_.org.sireum.helper.$assign(skipIfNil());
        if (isNil)
          {
            val o = _root_.org.sireum.helper.$assign(r());
            return _root_.org.sireum.helper.$assign(MEither.Right(o))
          }
        else
          {
            val o = _root_.org.sireum.helper.$assign(l());
            return _root_.org.sireum.helper.$assign(MEither.Left(o))
          }
      };
      def readISZ[V](f: _root_.scala.Function0[V]): IS[Z, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[Z, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISZ8[V](f: _root_.scala.Function0[V]): IS[Z8, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[Z8, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISZ16[V](f: _root_.scala.Function0[V]): IS[Z16, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[Z16, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISZ32[V](f: _root_.scala.Function0[V]): IS[Z32, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[Z32, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISZ64[V](f: _root_.scala.Function0[V]): IS[Z64, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[Z64, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISN[V](f: _root_.scala.Function0[V]): IS[N, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[N, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISN8[V](f: _root_.scala.Function0[V]): IS[N8, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[N8, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISN16[V](f: _root_.scala.Function0[V]): IS[N16, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[N16, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISN32[V](f: _root_.scala.Function0[V]): IS[N32, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[N32, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISN64[V](f: _root_.scala.Function0[V]): IS[N64, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[N64, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISS8[V](f: _root_.scala.Function0[V]): IS[S8, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[S8, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISS16[V](f: _root_.scala.Function0[V]): IS[S16, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[S16, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISS32[V](f: _root_.scala.Function0[V]): IS[S32, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[S32, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISS64[V](f: _root_.scala.Function0[V]): IS[S64, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[S64, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISU8[V](f: _root_.scala.Function0[V]): IS[U8, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[U8, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISU16[V](f: _root_.scala.Function0[V]): IS[U16, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[U16, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISU32[V](f: _root_.scala.Function0[V]): IS[U32, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[U32, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readISU64[V](f: _root_.scala.Function0[V]): IS[U64, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(IS[U64, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSZ[V](f: _root_.scala.Function0[V]): MS[Z, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[Z, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSZ8[V](f: _root_.scala.Function0[V]): MS[Z8, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[Z8, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSZ16[V](f: _root_.scala.Function0[V]): MS[Z16, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[Z16, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSZ32[V](f: _root_.scala.Function0[V]): MS[Z32, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[Z32, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSZ64[V](f: _root_.scala.Function0[V]): MS[Z64, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[Z64, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSN[V](f: _root_.scala.Function0[V]): MS[N, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[N, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSN8[V](f: _root_.scala.Function0[V]): MS[N8, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[N8, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSN16[V](f: _root_.scala.Function0[V]): MS[N16, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[N16, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSN32[V](f: _root_.scala.Function0[V]): MS[N32, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[N32, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSN64[V](f: _root_.scala.Function0[V]): MS[N64, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[N64, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSS8[V](f: _root_.scala.Function0[V]): MS[S8, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[S8, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSS16[V](f: _root_.scala.Function0[V]): MS[S16, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[S16, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSS32[V](f: _root_.scala.Function0[V]): MS[S32, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[S32, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSS64[V](f: _root_.scala.Function0[V]): MS[S64, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[S64, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSU8[V](f: _root_.scala.Function0[V]): MS[U8, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[U8, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSU16[V](f: _root_.scala.Function0[V]): MS[U16, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[U16, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSU32[V](f: _root_.scala.Function0[V]): MS[U32, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[U32, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMSU64[V](f: _root_.scala.Function0[V]): MS[U64, V] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(MS[U64, V]());
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val o = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.:+(o));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readZS(): ZS = {
        val r = _root_.org.sireum.helper.$assign(readMSZ((readZ _)));
        return _root_.org.sireum.helper.$assign(r)
      };
      def readMap[K, V](f: _root_.scala.Function0[K], g: _root_.scala.Function0[V]): Map[K, V] = {
        val size = _root_.org.sireum.helper.$assign(readMapHeader());
        var r = _root_.org.sireum.helper.$assign(Map.empty[K, V]);
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val key = _root_.org.sireum.helper.$assign(f());
            val value = _root_.org.sireum.helper.$assign(g());
            r = _root_.org.sireum.helper.$assign(r.+(key.~>(value)));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readSet[T](f: _root_.scala.Function0[T]): Set[T] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(Set.empty[T]);
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val value = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.+(value));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readHashMap[K, V](f: _root_.scala.Function0[K], g: _root_.scala.Function0[V]): HashMap[K, V] = {
        val size = _root_.org.sireum.helper.$assign(readMapHeader());
        var r = _root_.org.sireum.helper.$assign(HashMap.emptyInit[K, V](size));
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val key = _root_.org.sireum.helper.$assign(f());
            val value = _root_.org.sireum.helper.$assign(g());
            r = _root_.org.sireum.helper.$assign(r.+(key.~>(value)));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readHashSet[T](f: _root_.scala.Function0[T]): HashSet[T] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(HashSet.emptyInit[T](size));
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val value = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.+(value));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readHashSMap[K, V](f: _root_.scala.Function0[K], g: _root_.scala.Function0[V]): HashSMap[K, V] = {
        val size = _root_.org.sireum.helper.$assign(readMapHeader());
        var r = _root_.org.sireum.helper.$assign(HashSMap.emptyInit[K, V](size));
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val key = _root_.org.sireum.helper.$assign(f());
            val value = _root_.org.sireum.helper.$assign(g());
            r = _root_.org.sireum.helper.$assign(r.+(key.~>(value)));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readHashSSet[T](f: _root_.scala.Function0[T]): HashSSet[T] = {
        val size = _root_.org.sireum.helper.$assign(readArrayHeader());
        var r = _root_.org.sireum.helper.$assign(HashSSet.emptyInit[T](size));
        var i = _root_.org.sireum.Z(0);
        while (i.<(size)) 
          {
            val value = _root_.org.sireum.helper.$assign(f());
            r = _root_.org.sireum.helper.$assign(r.+(value));
            i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
          }
        ;
        return _root_.org.sireum.helper.$assign(r)
      };
      def readStack[T](f: _root_.scala.Function0[T]): Stack[T] = {
        val s = _root_.org.sireum.helper.$assign(readISZ(f));
        return _root_.org.sireum.helper.$assign(Stack(s))
      };
      def readBag[T](f: _root_.scala.Function0[T]): Bag[T] = {
        val map = _root_.org.sireum.helper.$assign(readMap(f, (readZ _)));
        return _root_.org.sireum.helper.$assign(Bag(map))
      };
      def readHashBag[T](f: _root_.scala.Function0[T]): HashBag[T] = {
        val map = _root_.org.sireum.helper.$assign(readHashMap(f, (readZ _)));
        return _root_.org.sireum.helper.$assign(HashBag(map))
      };
      def readPoset[T](f: _root_.scala.Function0[T]): Poset[T] = {
        def g(): HashSet[Poset.Index] = {
          val r = _root_.org.sireum.helper.$assign(readHashSet((readZ _)));
          return _root_.org.sireum.helper.$assign(r)
        };
        val nodesInverse = _root_.org.sireum.helper.$assign(readISZ(f));
        val map = _root_.org.sireum.helper.$assign(readHashMap((readZ _), (g _)));
        val size = _root_.org.sireum.helper.$assign(nodesInverse.size);
        var nodes = _root_.org.sireum.helper.$assign(HashMap.emptyInit[T, Poset.Index](size));
        var parents = _root_.org.sireum.helper.$assign(HashMap.emptyInit[Poset.Index, HashSet[Poset.Index]](size));
        var children = _root_.org.sireum.helper.$assign(HashMap.emptyInit[Poset.Index, HashSet[Poset.Index]](size));
        var i: Z = _root_.org.sireum.Z(0);
        nodesInverse.foreach(((node) => {
          nodes = _root_.org.sireum.helper.$assign(nodes.+(node.~>(nodes.size)));
          parents = _root_.org.sireum.helper.$assign(parents.+(i.~>(Poset.Internal.emptySet)));
          children = _root_.org.sireum.helper.$assign(children.+(i.~>(Poset.Internal.emptySet)));
          i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
        }));
        var r = _root_.org.sireum.helper.$assign(Poset[T](nodes, nodesInverse, parents, children));
        map.entries.foreach(((e) => {
          val x$2 = _root_.org.sireum.helper.$assign(_root_.org.sireum.helper.$tmatch(e: @scala.unchecked) match {
            case scala.Tuple2((n @ _), (s @ _)) => scala.Tuple2(_root_.org.sireum.helper.$assign(n), _root_.org.sireum.helper.$assign(s))
          });
          val n = _root_.org.sireum.helper.$assign(x$2._1);
          val s = _root_.org.sireum.helper.$assign(x$2._2);
          r = _root_.org.sireum.helper.$assign(Poset.Internal.addParents(r, n, s.elements))
        }));
        return _root_.org.sireum.helper.$assign(r)
      };
      def readGraph[V, E](f: _root_.scala.Function0[V], g: _root_.scala.Function0[E]): Graph[V, E] = {
        def readEdge(): Graph.Internal.Edge[E] = {
          val src = _root_.org.sireum.helper.$assign(readZ());
          val dest = _root_.org.sireum.helper.$assign(readZ());
          val isPlain = _root_.org.sireum.helper.$assign(skipIfNil());
          if (isPlain)
            return _root_.org.sireum.helper.$assign(Graph.Internal.Edge.Plain(src, dest))
          else
            {
              val data = _root_.org.sireum.helper.$assign(g());
              return _root_.org.sireum.helper.$assign(Graph.Internal.Edge.Data(src, dest, data))
            }
        };
        val multi = _root_.org.sireum.helper.$assign(readB());
        val nodesInverse = _root_.org.sireum.helper.$assign(readISZ(f));
        val edges = _root_.org.sireum.helper.$assign(readISZ((readEdge _)));
        var r: Graph[V, E] = _root_.org.sireum.helper.$assign(if (multi)
          Graph.emptyMulti
        else
          Graph.empty);
        nodesInverse.foreach(((node) => r = _root_.org.sireum.helper.$assign(r.*(node))));
        edges.foreach(((e) => r = _root_.org.sireum.helper.$assign(Graph.Internal.addEdge(r, e))));
        return _root_.org.sireum.helper.$assign(r)
      };
      def readUnionFind[T](f: _root_.scala.Function0[T]): UnionFind[T] = {
        val elementsInverse = _root_.org.sireum.helper.$assign(readISZ(f));
        val parentOf = _root_.org.sireum.helper.$assign(readISZ((readZ _)));
        val sizeOf = _root_.org.sireum.helper.$assign(readISZ((readZ _)));
        var elements = _root_.org.sireum.helper.$assign(HashMap.emptyInit[T, UnionFind.Index](elementsInverse.size));
        elementsInverse.foreach(((e) => elements = _root_.org.sireum.helper.$assign(elements.+(e.~>(elements.size)))));
        return _root_.org.sireum.helper.$assign(UnionFind(elements, elementsInverse, parentOf, sizeOf))
      };
      def readMessage(): message.Message = {
        val level = _root_.org.sireum.helper.$assign(message.Level.byOrdinal(readZ()).getOrElse(message.Level.InternalError));
        val posOpt = _root_.org.sireum.helper.$assign(readOption((readPosition _)));
        val kind = _root_.org.sireum.helper.$assign(readString());
        val text = _root_.org.sireum.helper.$assign(readString());
        return _root_.org.sireum.helper.$assign(message.Message(level, posOpt, kind, text))
      };
      def readPosition(): message.Position = {
        val isPosInfo = _root_.org.sireum.helper.$assign(readB());
        if (isPosInfo)
          {
            val info = _root_.org.sireum.helper.$assign(readDocInfo());
            val offsetLength = _root_.org.sireum.helper.$assign(readU64());
            return _root_.org.sireum.helper.$assign(message.PosInfo(info, offsetLength))
          }
        else
          {
            val uriOpt = _root_.org.sireum.helper.$assign(readOption((readString _)));
            val beginLine = _root_.org.sireum.helper.$assign(readU32());
            val beginColumn = _root_.org.sireum.helper.$assign(readU32());
            val endLine = _root_.org.sireum.helper.$assign(readU32());
            val endColumn = _root_.org.sireum.helper.$assign(readU32());
            val offset = _root_.org.sireum.helper.$assign(readU32());
            val length = _root_.org.sireum.helper.$assign(readU32());
            return _root_.org.sireum.helper.$assign(message.FlatPos(uriOpt, beginLine, beginColumn, endLine, endColumn, offset, length))
          }
      };
      def readDocInfo(): message.DocInfo;
      def readArrayHeader(): Z;
      def readBinary(): ISZ[U8];
      def skipIfNil(): B;
      def readMapHeader(): Z;
      def readExtTypeHeader(): Option[scala.Tuple2[S8, Z]];
      def readPayload(n: Z): ISZ[U8];
      def skip(n: Z): Unit
    };
    object ErrorMsg {
      def apply(offset: Z, message: String): ErrorMsg = new ErrorMsg(offset, message);
      def unapply(o: ErrorMsg): _root_.scala.Option[scala.Tuple2[Z, String]] = _root_.scala.Some(scala.Tuple2(o.offset, o.message))
    };
    @datatype final class ErrorMsg(__offset: Z, __message: String) extends _root_.org.sireum.DatatypeSig {
      private[this] val _offset = __offset;
      def offset = _offset;
      def getOffset = _offset;
      private[this] val _message = __message;
      def message = _message;
      def getMessage = _message;
      override def toString: _root_.java.lang.String = if ($hasString)
        super.string.value
      else
        {
          val sb = new _root_.java.lang.StringBuilder();
          sb.append("ErrorMsg");
          sb.append('(');
          sb.append(_root_.org.sireum.String.escape(this.offset));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.message));
          sb.append(')');
          sb.toString
        };
      override def string: _root_.org.sireum.String = if ($hasString)
        super.string
      else
        toString;
      override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
        super.hashCode
      else
        _root_.scala.Seq(this.getClass, offset, message).hashCode;
      override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
        super.equals(o)
      else
        if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
          true
        else
          o match {
            case (o @ ((_): ErrorMsg)) => if (this.hashCode.!=(o.hashCode))
              false
            else
              this.offset.==(o.offset).&&(this.message.==(o.message))
            case _ => false
          };
      def apply(offset: Z = this.offset, message: String = this.message): ErrorMsg = new ErrorMsg(offset, message);
      override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "ErrorMsg")), scala.Tuple2("offset", this.offset), scala.Tuple2("message", this.message))
    };
    object Reader {
      object Impl {
        def apply(buf: ISZ[U8], curr: Z): Impl = new Impl(_root_.org.sireum.helper.$assign(buf), _root_.org.sireum.helper.$assign(curr));
        def unapply(o: Impl): _root_.scala.Option[scala.Tuple2[ISZ[U8], Z]] = _root_.scala.Some(scala.Tuple2(_root_.org.sireum.helper.clone(o.buf), _root_.org.sireum.helper.clone(o.curr)))
      };
      @record final class Impl(__buf: ISZ[U8], __curr: Z) extends Reader with _root_.org.sireum.RecordSig {
        private[this] var _buf = __buf;
        def buf = _buf;
        def getBuf = _buf;
        private[this] var _curr = __curr;
        def curr = _curr;
        def getCurr = _curr;
        def `curr_=`(curr: Z): this.type = {
          _curr = curr;
          this
        };
        def setCurr(curr: Z): this.type = {
          _curr = curr;
          this
        };
        override def toString: _root_.java.lang.String = if ($hasString)
          super.string.value
        else
          {
            val sb = new _root_.java.lang.StringBuilder();
            sb.append("Impl");
            sb.append('(');
            sb.append(_root_.org.sireum.String.escape(this.buf));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.curr));
            sb.append(')');
            sb.toString
          };
        override def string: _root_.org.sireum.String = if ($hasString)
          super.string
        else
          toString;
        override def hashCode: _root_.scala.Int = if ($hasEquals)
          super.hashCode
        else
          _root_.scala.Seq(this.getClass, buf, curr).hashCode;
        override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
          super.equals(o)
        else
          if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
            true
          else
            o match {
              case (o @ ((_): Impl)) => if (this.hashCode.!=(o.hashCode))
                false
              else
                this.buf.==(o.buf).&&(this.curr.==(o.curr))
              case _ => false
            };
        def apply(buf: ISZ[U8] = this.buf, curr: Z = this.curr): Impl = new Impl(_root_.org.sireum.helper.$assign(buf), _root_.org.sireum.helper.$assign(curr));
        override def $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "Impl")), scala.Tuple2("buf", buf), scala.Tuple2("curr", curr));
        override def $clone: Impl = {
          val r: Impl = new Impl(_root_.org.sireum.helper.cloneAssign(this.buf), _root_.org.sireum.helper.cloneAssign(this.curr));
          r.pooling = _root_.org.sireum.helper.cloneAssign(pooling);
          r.stringPool = _root_.org.sireum.helper.cloneAssign(stringPool);
          r.docInfoPool = _root_.org.sireum.helper.cloneAssign(docInfoPool);
          r.errorOpt = _root_.org.sireum.helper.cloneAssign(errorOpt);
          r.initialized = _root_.org.sireum.helper.cloneAssign(initialized);
          r
        };
        var pooling: B = _root_.org.sireum.helper.$assign(F);
        var stringPool: MSZ[String] = _root_.org.sireum.helper.$assign(MSZ());
        var docInfoPool: MSZ[message.DocInfo] = _root_.org.sireum.helper.$assign(MSZ());
        var errorOpt: Option[ErrorMsg] = _root_.org.sireum.helper.$assign(None());
        var initialized: B = _root_.org.sireum.helper.$assign(F);
        def init(): Unit = {
          initialized = _root_.org.sireum.helper.$assign(T);
          val r = _root_.org.sireum.helper.$assign(peek());
          pooling = _root_.org.sireum.helper.$assign(Code.isExt(r));
          if (pooling)
            {
              var pOpt = _root_.org.sireum.helper.$assign(readExtTypeHeader());
              _root_.org.sireum.helper.$tmatch(pOpt) match {
                case Some(scala.Tuple2((t @ _), (size @ _))) => {
                  assert(t.==(StringPoolExtType));
                  stringPool = _root_.org.sireum.helper.$assign(MSZ.create(size, _root_.org.sireum.String("")));
                  var i = _root_.org.sireum.Z(0);
                  while (i.<(size)) 
                    {
                      val s = _root_.org.sireum.helper.$assign(readStringNoPool());
                      stringPool.update(i, _root_.org.sireum.helper.$assign(s));
                      i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
                    }
                  
                }
                case _ => ()
              };
              pOpt = _root_.org.sireum.helper.$assign(readExtTypeHeader());
              _root_.org.sireum.helper.$tmatch(pOpt) match {
                case Some(scala.Tuple2((t @ _), (size @ _))) => {
                  assert(t.==(DocInfoExtType));
                  docInfoPool = _root_.org.sireum.helper.$assign(MSZ.create(size, message.DocInfo(None(), ISZ())));
                  var i = _root_.org.sireum.Z(0);
                  while (i.<(size)) 
                    {
                      val docInfo = _root_.org.sireum.helper.$assign(readDocInfoNoPool());
                      docInfoPool.update(i, _root_.org.sireum.helper.$assign(docInfo));
                      i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
                    }
                  
                }
                case _ => ()
              }
            }
          else
            ()
        };
        def peek(): U8 = {
          if (errorOpt.nonEmpty)
            return StringContext("0").u8()
          else
            ();
          if (curr.>=(buf.size))
            {
              error(curr, _root_.org.sireum.String("Attempted to read more byte than available."));
              return StringContext("0").u8()
            }
          else
            ();
          return _root_.org.sireum.helper.$assign(buf(curr))
        };
        def read8(): U8 = {
          assert(initialized, _root_.org.sireum.String("MessagePack.Reader.init() has not been called."));
          val r = _root_.org.sireum.helper.$assign(peek());
          skip(_root_.org.sireum.Z(1));
          return _root_.org.sireum.helper.$assign(r)
        };
        def read16(): U16 = {
          val ch1 = _root_.org.sireum.helper.$assign(read8());
          val ch2 = _root_.org.sireum.helper.$assign(read8());
          return _root_.org.sireum.helper.$assign(conversions.U8.toU16(ch1).<<(StringContext("8").u16()).+(conversions.U8.toU16(ch2)))
        };
        def read32(): U32 = {
          val ch1 = _root_.org.sireum.helper.$assign(read8());
          val ch2 = _root_.org.sireum.helper.$assign(read8());
          val ch3 = _root_.org.sireum.helper.$assign(read8());
          val ch4 = _root_.org.sireum.helper.$assign(read8());
          return _root_.org.sireum.helper.$assign(conversions.U8.toU32(ch1).<<(StringContext("24").u32()).+(conversions.U8.toU32(ch2).<<(StringContext("16").u32())).+(conversions.U8.toU32(ch3).<<(StringContext("8").u32())).+(conversions.U8.toU32(ch4)))
        };
        def read64(): U64 = {
          val ch1 = _root_.org.sireum.helper.$assign(read8());
          val ch2 = _root_.org.sireum.helper.$assign(read8());
          val ch3 = _root_.org.sireum.helper.$assign(read8());
          val ch4 = _root_.org.sireum.helper.$assign(read8());
          val ch5 = _root_.org.sireum.helper.$assign(read8());
          val ch6 = _root_.org.sireum.helper.$assign(read8());
          val ch7 = _root_.org.sireum.helper.$assign(read8());
          val ch8 = _root_.org.sireum.helper.$assign(read8());
          return _root_.org.sireum.helper.$assign(conversions.U8.toU64(ch1).<<(StringContext("56").u64()).+(conversions.U8.toU64(ch2).<<(StringContext("48").u64())).+(conversions.U8.toU64(ch3).<<(StringContext("40").u64())).+(conversions.U8.toU64(ch4).<<(StringContext("32").u64())).+(conversions.U8.toU64(ch5).<<(StringContext("24").u64())).+(conversions.U8.toU64(ch6).<<(StringContext("16").u64())).+(conversions.U8.toU64(ch7).<<(StringContext("8").u64())).+(conversions.U8.toU64(ch8)))
        };
        def error(offset: Z, msg: String): Unit = _root_.org.sireum.helper.$tmatch(errorOpt) match {
          case Some(_) => ()
          case _ => errorOpt = _root_.org.sireum.helper.$assign(Some(ErrorMsg(offset, msg)))
        };
        def readB(): B = {
          val code = _root_.org.sireum.helper.$assign(read8());
          _root_.org.sireum.helper.$tmatch(code) match {
            case Code.TRUE => return _root_.org.sireum.helper.$assign(T)
            case Code.FALSE => return _root_.org.sireum.helper.$assign(F)
            case _ => {
              error(curr.-(_root_.org.sireum.Z(1)), StringContext("Expecting a B, but found code ", ".").s(code));
              return _root_.org.sireum.helper.$assign(F)
            }
          }
        };
        def readZ(): Z = {
          val code = _root_.org.sireum.helper.$assign(read8());
          if (Code.isFixInt(code))
            return _root_.org.sireum.helper.$assign(conversions.S8.toZ(conversions.U8.toRawS8(code)))
          else
            ();
          _root_.org.sireum.helper.$tmatch(code) match {
            case Code.INT8 => {
              val n = _root_.org.sireum.helper.$assign(read8());
              return _root_.org.sireum.helper.$assign(conversions.S8.toZ(conversions.U8.toRawS8(n)))
            }
            case Code.INT16 => {
              val n = _root_.org.sireum.helper.$assign(read16());
              return _root_.org.sireum.helper.$assign(conversions.S16.toZ(conversions.U16.toRawS16(n)))
            }
            case Code.INT32 => {
              val n = _root_.org.sireum.helper.$assign(read32());
              return _root_.org.sireum.helper.$assign(conversions.S32.toZ(conversions.U32.toRawS32(n)))
            }
            case Code.INT64 => {
              val n = _root_.org.sireum.helper.$assign(read64());
              return _root_.org.sireum.helper.$assign(conversions.S64.toZ(conversions.U64.toRawS64(n)))
            }
            case Code.UINT8 => {
              val n = _root_.org.sireum.helper.$assign(read8());
              return _root_.org.sireum.helper.$assign(conversions.U8.toZ(n))
            }
            case Code.UINT16 => {
              val n = _root_.org.sireum.helper.$assign(read16());
              return _root_.org.sireum.helper.$assign(conversions.U16.toZ(n))
            }
            case Code.UINT32 => {
              val n = _root_.org.sireum.helper.$assign(read32());
              return _root_.org.sireum.helper.$assign(conversions.U32.toZ(n))
            }
            case Code.UINT64 => {
              val n = _root_.org.sireum.helper.$assign(read64());
              return _root_.org.sireum.helper.$assign(conversions.U64.toZ(n))
            }
            case _ => if (code.==(Code.BIN8).||(code.==(Code.BIN16)).||(code.==(Code.BIN32)))
              {
                skip(_root_.org.sireum.Z(-1));
                val bin = _root_.org.sireum.helper.$assign(readBinary());
                return _root_.org.sireum.helper.$assign(conversions.Z.fromBinary(bin))
              }
            else
              {
                error(curr.-(_root_.org.sireum.Z(1)), StringContext("Expecting an integer, but found code ", ".").s(code));
                return _root_.org.sireum.Z(0)
              }
          }
        };
        def expectZ(n: Z): Unit = {
          val start = _root_.org.sireum.helper.$assign(curr);
          val m = _root_.org.sireum.helper.$assign(readZ());
          if (n.!=(m))
            error(start, StringContext("Expecting ", ", but found ", ".").s(n, m))
          else
            ()
        };
        def readR(): R = {
          val start = _root_.org.sireum.helper.$assign(curr);
          val s = _root_.org.sireum.helper.$assign(readString());
          _root_.org.sireum.helper.$tmatch(R(s)) match {
            case Some((r @ _)) => return _root_.org.sireum.helper.$assign(r)
            case _ => {
              error(start, StringContext("Expecting a R, but found ", ".").s(s));
              return StringContext("0").r()
            }
          }
        };
        def readF32(): F32 = {
          val code = _root_.org.sireum.helper.$assign(read8());
          _root_.org.sireum.helper.$tmatch(code) match {
            case Code.FLOAT32 => ()
            case _ => {
              error(curr.-(_root_.org.sireum.Z(1)), StringContext("Expecting a F32, but found code ", ".").s(code));
              return _root_.org.sireum.F32(0.0F)
            }
          };
          val n = _root_.org.sireum.helper.$assign(read32());
          return _root_.org.sireum.helper.$assign(conversions.U32.toRawF32(n))
        };
        def readF64(): F64 = {
          val code = _root_.org.sireum.helper.$assign(read8());
          _root_.org.sireum.helper.$tmatch(code) match {
            case Code.FLOAT64 => ()
            case _ => {
              error(curr.-(_root_.org.sireum.Z(1)), StringContext("Expecting a F64, but found code ", ".").s(code));
              return _root_.org.sireum.F64(0.0)
            }
          };
          val n = _root_.org.sireum.helper.$assign(read64());
          return _root_.org.sireum.helper.$assign(conversions.U64.toRawF64(n))
        };
        def readStringNoPool(): String = {
          val size = _root_.org.sireum.helper.$assign(readZ());
          val ms = _root_.org.sireum.helper.$assign(MSZ.create[C](size, _root_.org.sireum.C('\u0000')));
          StringContext("0").z().until(size).foreach(((i) => {
            val c = _root_.org.sireum.helper.$assign(readU32());
            ms.update(i, _root_.org.sireum.helper.$assign(conversions.U32.toC(c)))
          }));
          return _root_.org.sireum.helper.$assign(conversions.String.fromCms(ms))
        };
        def readDocInfo(): message.DocInfo = if (pooling)
          {
            val n = _root_.org.sireum.helper.$assign(readZ());
            return _root_.org.sireum.helper.$assign(docInfoPool(n))
          }
        else
          {
            val r = _root_.org.sireum.helper.$assign(readDocInfoNoPool());
            return _root_.org.sireum.helper.$assign(r)
          };
        def readDocInfoNoPool(): message.DocInfo = {
          val uriOpt = _root_.org.sireum.helper.$assign(readOption((readString _)));
          val lineOffsets = _root_.org.sireum.helper.$assign(readISZ((readU32 _)));
          return _root_.org.sireum.helper.$assign(message.DocInfo(uriOpt, lineOffsets))
        };
        def readString(): String = if (pooling)
          {
            val index = _root_.org.sireum.helper.$assign(readZ());
            return _root_.org.sireum.helper.$assign(stringPool(index))
          }
        else
          {
            val r = _root_.org.sireum.helper.$assign(readStringNoPool());
            return _root_.org.sireum.helper.$assign(r)
          };
        def readArrayHeader(): Z = {
          val code = _root_.org.sireum.helper.$assign(read8());
          if (Code.isFixedArray(code))
            return _root_.org.sireum.helper.$assign(conversions.U8.toZ(code.&(StringContext("0x0F").u8())))
          else
            _root_.org.sireum.helper.$tmatch(code) match {
              case Code.ARRAY16 => {
                val r = _root_.org.sireum.helper.$assign(read16());
                return _root_.org.sireum.helper.$assign(conversions.U16.toZ(r))
              }
              case Code.ARRAY32 => {
                val r = _root_.org.sireum.helper.$assign(read32());
                return _root_.org.sireum.helper.$assign(conversions.U32.toZ(r))
              }
              case _ => {
                error(curr.-(_root_.org.sireum.Z(1)), StringContext("Expecting an array, but found code ", "").s(code));
                return _root_.org.sireum.Z(0)
              }
            }
        };
        def readBinary(): ISZ[U8] = {
          val code = _root_.org.sireum.helper.$assign(read8());
          val len: Z = _root_.org.sireum.helper.$assign({
            var r: Z = _root_.org.sireum.Z(0);
            if (Code.isFixedRaw(code))
              r = _root_.org.sireum.helper.$assign(conversions.U8.toZ(StringContext("0x1F").u8().&(code)))
            else
              _root_.org.sireum.helper.$tmatch(code) match {
                case Code.BIN8 => {
                  val n = _root_.org.sireum.helper.$assign(read8());
                  r = _root_.org.sireum.helper.$assign(conversions.U8.toZ(n))
                }
                case Code.BIN16 => {
                  val n = _root_.org.sireum.helper.$assign(read16());
                  r = _root_.org.sireum.helper.$assign(conversions.U16.toZ(n))
                }
                case Code.BIN32 => {
                  val n = _root_.org.sireum.helper.$assign(read32());
                  r = _root_.org.sireum.helper.$assign(conversions.U32.toZ(n))
                }
                case _ => {
                  error(curr.-(_root_.org.sireum.Z(1)), StringContext("Expecting a binary, but found ", "").s(code));
                  return _root_.org.sireum.helper.$assign(ISZ())
                }
              };
            r
          });
          val a = _root_.org.sireum.helper.$assign(MSZ.create(len, StringContext("0").u8()));
          var i = _root_.org.sireum.Z(0);
          while (i.<(len)) 
            {
              a.update(i, _root_.org.sireum.helper.$assign(read8()));
              i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
            }
          ;
          return _root_.org.sireum.helper.$assign(a.toIS)
        };
        def skipIfNil(): B = {
          if (errorOpt.nonEmpty)
            return _root_.org.sireum.helper.$assign(T)
          else
            ();
          val n = _root_.org.sireum.helper.$assign(peek());
          val r = _root_.org.sireum.helper.$assign(n.==(Code.NIL));
          if (r)
            skip(_root_.org.sireum.Z(1))
          else
            ();
          return _root_.org.sireum.helper.$assign(r)
        };
        def readMapHeader(): Z = {
          val code = _root_.org.sireum.helper.$assign(read8());
          if (Code.isFixedMap(code))
            return _root_.org.sireum.helper.$assign(conversions.U8.toZ(code.&(StringContext("0x0F").u8())))
          else
            _root_.org.sireum.helper.$tmatch(code) match {
              case Code.MAP16 => {
                val r = _root_.org.sireum.helper.$assign(read16());
                return _root_.org.sireum.helper.$assign(conversions.U16.toZ(r))
              }
              case Code.MAP32 => {
                val r = _root_.org.sireum.helper.$assign(read32());
                return _root_.org.sireum.helper.$assign(conversions.U32.toZ(r))
              }
              case _ => {
                error(curr.-(_root_.org.sireum.Z(1)), StringContext("Expecting a map, but found code ", "").s(code));
                return _root_.org.sireum.Z(0)
              }
            }
        };
        def readExtTypeHeader(): Option[scala.Tuple2[S8, Z]] = {
          val code = _root_.org.sireum.helper.$assign(read8());
          _root_.org.sireum.helper.$tmatch(code) match {
            case Code.FIXEXT1 => {
              val extType = _root_.org.sireum.helper.$assign(readS8());
              return _root_.org.sireum.helper.$assign(Some(scala.Tuple2(_root_.org.sireum.helper.$assign(extType), _root_.org.sireum.Z(1))))
            }
            case Code.FIXEXT2 => {
              val extType = _root_.org.sireum.helper.$assign(readS8());
              return _root_.org.sireum.helper.$assign(Some(scala.Tuple2(_root_.org.sireum.helper.$assign(extType), _root_.org.sireum.Z(2))))
            }
            case Code.FIXEXT4 => {
              val extType = _root_.org.sireum.helper.$assign(readS8());
              return _root_.org.sireum.helper.$assign(Some(scala.Tuple2(_root_.org.sireum.helper.$assign(extType), _root_.org.sireum.Z(4))))
            }
            case Code.FIXEXT8 => {
              val extType = _root_.org.sireum.helper.$assign(readS8());
              return _root_.org.sireum.helper.$assign(Some(scala.Tuple2(_root_.org.sireum.helper.$assign(extType), _root_.org.sireum.Z(8))))
            }
            case Code.FIXEXT16 => {
              val extType = _root_.org.sireum.helper.$assign(readS8());
              return _root_.org.sireum.helper.$assign(Some(scala.Tuple2(_root_.org.sireum.helper.$assign(extType), _root_.org.sireum.Z(16))))
            }
            case Code.EXT8 => {
              val n = _root_.org.sireum.helper.$assign(read8());
              val length = _root_.org.sireum.helper.$assign(conversions.U8.toZ(n.&(StringContext("0xFF").u8())));
              val extType = _root_.org.sireum.helper.$assign(readS8());
              return _root_.org.sireum.helper.$assign(Some(scala.Tuple2(_root_.org.sireum.helper.$assign(extType), _root_.org.sireum.helper.$assign(length))))
            }
            case Code.EXT16 => {
              val n = _root_.org.sireum.helper.$assign(read16());
              val length = _root_.org.sireum.helper.$assign(conversions.U16.toZ(n.&(StringContext("0xFFFF").u16())));
              val extType = _root_.org.sireum.helper.$assign(readS8());
              return _root_.org.sireum.helper.$assign(Some(scala.Tuple2(_root_.org.sireum.helper.$assign(extType), _root_.org.sireum.helper.$assign(length))))
            }
            case Code.EXT32 => {
              val length = _root_.org.sireum.helper.$assign(conversions.U32.toZ(read32()));
              val extType = _root_.org.sireum.helper.$assign(readS8());
              return _root_.org.sireum.helper.$assign(Some(scala.Tuple2(_root_.org.sireum.helper.$assign(extType), _root_.org.sireum.helper.$assign(length))))
            }
            case _ => {
              error(curr.-(_root_.org.sireum.Z(1)), StringContext("Expecting an ext type, but found code ", "").s(code));
              return _root_.org.sireum.helper.$assign(None())
            }
          }
        };
        def readPayload(n: Z): ISZ[U8] = {
          val r = _root_.org.sireum.helper.$assign(MSZ.create(n, StringContext("0").u8()));
          var i = _root_.org.sireum.Z(0);
          while (i.<(n)) 
            {
              r.update(i, _root_.org.sireum.helper.$assign(read8()));
              i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)))
            }
          ;
          return _root_.org.sireum.helper.$assign(r.toIS)
        };
        def skip(n: Z): Unit = {
          StringContext(" requires 0 <= curr + n ∧ curr + n <= buf.size ").lUnit();
          curr = _root_.org.sireum.helper.$assign(curr.+(n))
        }
      }
    };
    def writer(pooling: B): Writer.Impl = return _root_.org.sireum.helper.$assign(Writer.Impl(pooling, MS.create(_root_.org.sireum.Z(1024), StringContext("0").u8()), _root_.org.sireum.Z(0)));
    def reader(data: ISZ[U8]): Reader.Impl = return _root_.org.sireum.helper.$assign(Reader.Impl(data, _root_.org.sireum.Z(0)))
  }
}