package org.sireum.ops {
  import org.sireum._

  object StringOps {
    def apply(s: String): StringOps = new StringOps(s);
    def unapply(o: StringOps): _root_.scala.Option[String] = _root_.scala.Some(o.s)
  }

  @datatype final class StringOps(__s: String) extends _root_.org.sireum.DatatypeSig {
    private[this] val _s = __s;
    def s = _s;
    def getS = _s;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("StringOps");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.s));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, s).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): StringOps)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.s.==(o.s)
          case _ => false
        };
    def apply(s: String = this.s): StringOps = new StringOps(s);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "ops", "StringOps")), scala.Tuple2("s", this.s));
    @pure def first: C = {
      StringContext(" requires s.size > 0 ").lUnit();
      return _root_.org.sireum.helper.$assign(conversions.String.toCis(s)(_root_.org.sireum.Z(0)))
    };
    @pure def substring(start: Z, until: Z): String = {
      StringContext(""" requires 0 ≤ start ∧ start < s.size
                  start ≤ until
                  until ≤ s.size
         ensures  result.size ≡ until - start
                  ∀i: [0, result.size) result(i) ≡ s(start + i) """).lUnit();
      var ms = _root_.org.sireum.helper.$assign(MSZ.create[C](until.-(start), _root_.org.sireum.C('\u0000')));
      var i = _root_.org.sireum.helper.$assign(start);
      var j = _root_.org.sireum.Z(0);
      val cis = _root_.org.sireum.helper.$assign(conversions.String.toCis(s));
      while (i.<(until)) 
        {
          ms.update(j, _root_.org.sireum.helper.$assign(cis(i)));
          i = _root_.org.sireum.helper.$assign(i.+(_root_.org.sireum.Z(1)));
          j = _root_.org.sireum.helper.$assign(j.+(_root_.org.sireum.Z(1)))
        }
      ;
      return _root_.org.sireum.helper.$assign(conversions.String.fromCms(ms))
    };
    @pure def startsWith(other: String): B = {
      StringContext(""" ensures  result ≡ ((size >= other.size) ∧
                            ∀i: [0, other.size) s(i) ≡ other(i)) """).lUnit();
      if (s.size.<(other.size))
        return _root_.org.sireum.helper.$assign(F)
      else
        ();
      val cis = _root_.org.sireum.helper.$assign(conversions.String.toCis(s));
      val otherCis = _root_.org.sireum.helper.$assign(conversions.String.toCis(other));
      StringContext("0").z().until(other.size).foreach(((i) => if (otherCis(i).!=(cis(i)))
        return _root_.org.sireum.helper.$assign(F)
      else
        ()));
      return _root_.org.sireum.helper.$assign(T)
    };
    @pure def endsWith(other: String): B = {
      StringContext(""" ensures  result ≡ ((size >= other.size) ∧
                            ∀i: [0, other.size) s(i + other.size - s.size) ≡ other(i)) """).lUnit();
      if (s.size.<(other.size))
        return _root_.org.sireum.helper.$assign(F)
      else
        ();
      val cis = _root_.org.sireum.helper.$assign(conversions.String.toCis(s));
      val otherCis = _root_.org.sireum.helper.$assign(conversions.String.toCis(other));
      val offset = _root_.org.sireum.helper.$assign(s.size.-(other.size));
      other.size.-(_root_.org.sireum.Z(1)).to(_root_.org.sireum.Z(0)).by(_root_.org.sireum.Z(-1)).foreach(((i) => if (otherCis(i).!=(cis(offset.+(i))))
        return _root_.org.sireum.helper.$assign(F)
      else
        ()));
      return _root_.org.sireum.helper.$assign(T)
    };
    @pure def firstToUpper: String = {
      StringContext(""" requires s.size > 0
         ensures  result.size ≡ s.size
                  result(0) ≡ conversions.COps(s(0)).toUpper
                  ∀i: [1, s.size) result(i) ≡ s(i)   """).lUnit();
      val cms = _root_.org.sireum.helper.$assign(conversions.String.toCms(s));
      cms.update(_root_.org.sireum.Z(0), _root_.org.sireum.helper.$assign(COps(cms(_root_.org.sireum.Z(0))).toUpper));
      return _root_.org.sireum.helper.$assign(conversions.String.fromCms(cms))
    };
    @pure def firstToLower: String = {
      StringContext(""" requires s.size > 0
         ensures  result.size ≡ s.size
                  result(0) ≡ conversions.COps(s(0)).toLower
                  ∀i: [1, s.size) result(i) ≡ s(i)   """).lUnit();
      val cms = _root_.org.sireum.helper.$assign(conversions.String.toCms(s));
      cms.update(_root_.org.sireum.Z(0), _root_.org.sireum.helper.$assign(COps(cms(_root_.org.sireum.Z(0))).toLower));
      return _root_.org.sireum.helper.$assign(conversions.String.fromCms(cms))
    };
    @pure def indexOf(c: C): Z = return _root_.org.sireum.helper.$assign(indexOfFrom(c, _root_.org.sireum.Z(0)));
    @pure def indexOfFrom(c: C, offset: Z): Z = {
      if (_root_.org.sireum.Z(0).<=(offset).&&(offset.<(s.size)).`unary_!`)
        return _root_.org.sireum.Z(-1)
      else
        ();
      val cis = _root_.org.sireum.helper.$assign(conversions.String.toCis(s));
      offset.until(s.size).foreach(((i) => if (cis(i).==(c))
        return _root_.org.sireum.helper.$assign(i)
      else
        ()));
      return _root_.org.sireum.Z(-1)
    };
    @pure def lastIndexOf(c: C): Z = return _root_.org.sireum.helper.$assign(lastIndexOfFrom(c, s.size.-(_root_.org.sireum.Z(1))));
    @pure def lastIndexOfFrom(c: C, offset: Z): Z = {
      if (_root_.org.sireum.Z(0).<=(offset).&&(offset.<(s.size)).`unary_!`)
        return _root_.org.sireum.Z(-1)
      else
        ();
      val cis = _root_.org.sireum.helper.$assign(conversions.String.toCis(s));
      offset.to(_root_.org.sireum.Z(0)).by(_root_.org.sireum.Z(-1)).foreach(((i) => if (cis(i).==(c))
        return _root_.org.sireum.helper.$assign(i)
      else
        ()));
      return _root_.org.sireum.Z(-1)
    }
  }
}