package org.sireum {
  object HashSSet {
    @pure def empty[T]: HashSSet[T] = return _root_.org.sireum.helper.$assign(HashSSet(HashSMap.empty));
    @pure def emptyInit[T](initialCapacity: Z): HashSSet[T] = return _root_.org.sireum.helper.$assign(HashSSet(HashSMap.emptyInit(initialCapacity)));
    @pure def ++[I, T](s: IS[I, T]): HashSSet[T] = return _root_.org.sireum.helper.$assign(HashSSet.emptyInit[T](s.zize).++(s));
    def apply[T](map: HashSMap[T, B]): HashSSet[T] = new HashSSet(map);
    def unapply[T](o: HashSSet[T]): _root_.scala.Option[HashSMap[T, B]] = _root_.scala.Some(o.map)
  }

  @datatype final class HashSSet[T](__map: HashSMap[T, B]) extends _root_.org.sireum.DatatypeSig {
    private[this] val _map = __map;
    def map = _map;
    def getMap = _map;
    override def toString: _root_.java.lang.String = string.value;
    override lazy val hashCode: _root_.scala.Int = hash.hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
      true
    else
      o match {
        case (o @ ((_): HashSSet[T] @unchecked)) => isEqual(o)
        case _ => halt("Invalid equality test between ".+(this.getClass).+(" and ").+(o.getClass))
      };
    def apply(map: HashSMap[T, B] = this.map): HashSSet[T] = new HashSSet(map);
    override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "HashSSet")), scala.Tuple2("map", this.map));
    @pure def +(e: T): HashSSet[T] = return _root_.org.sireum.helper.$assign(HashSSet(map.+(e.~>(T))));
    @pure def ++[I](is: IS[I, T]): HashSSet[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      is.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.+(e))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def -(e: T): HashSSet[T] = return _root_.org.sireum.helper.$assign(HashSSet(map.-(e.~>(T))));
    @pure def --[I](is: IS[I, T]): HashSSet[T] = {
      var r = _root_.org.sireum.helper.$assign(this);
      is.foreach(((e) => r = _root_.org.sireum.helper.$assign(r.-(e))));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def contains(e: T): B = return _root_.org.sireum.helper.$assign(map.contains(e));
    @pure def union(other: HashSSet[T]): HashSSet[T] = return _root_.org.sireum.helper.$assign(this.∪(other));
    @pure def ∪(other: HashSSet[T]): HashSSet[T] = return _root_.org.sireum.helper.$assign(this.++(other.elements));
    @pure def intersect(other: HashSSet[T]): HashSSet[T] = return _root_.org.sireum.helper.$assign(this.∩(other));
    @pure def ∩(other: HashSSet[T]): HashSSet[T] = {
      var r = _root_.org.sireum.helper.$assign(HashSSet.emptyInit[T](size));
      other.map.keys.elements.foreach(((e) => if (contains(e))
        r = _root_.org.sireum.helper.$assign(r.+(e))
      else
        ()));
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def \(other: HashSSet[T]): HashSSet[T] = return _root_.org.sireum.helper.$assign(this.--(other.elements));
    @pure def isEqual(other: HashSSet[T]): B = return _root_.org.sireum.helper.$assign(map.isEqual(other.map));
    @pure override def hash: Z = return _root_.org.sireum.helper.$assign(_root_.org.sireum.Z(map.hashCode));
    @pure def isEmpty: B = return _root_.org.sireum.helper.$assign(size.==(StringContext("0").z()));
    @pure def nonEmpty: B = return _root_.org.sireum.helper.$assign(size.!=(StringContext("0").z()));
    @pure def size: Z = return _root_.org.sireum.helper.$assign(map.size);
    @pure def elements: ISZ[T] = return _root_.org.sireum.helper.$assign(map.keys.elements);
    @pure override def string: String = {
      val r = StringContext("""{
      |  """, """
      |}""").st(scala.Tuple2(_root_.org.sireum.helper.$assign(elements), _root_.org.sireum.String(",\n")));
      return _root_.org.sireum.helper.$assign(r.render)
    }
  }
}