package org.sireum.cli {
  import org.sireum._

  @datatype sealed trait CliOpt extends _root_.org.sireum.DatatypeSig {
    @pure def name: String;
    @pure def command: String;
    @pure def description: String;
    @pure def header: String;
    @pure def unlisted: B
  }

  object CliOpt {
    val tqs: String = _root_.org.sireum.String("\"\"\"");
    object Group {
      def apply(name: String, description: String, header: String, unlisted: B, subs: ISZ[CliOpt]): Group = new Group(name, description, header, unlisted, subs);
      def unapply(o: Group): _root_.scala.Option[scala.Tuple5[String, String, String, B, ISZ[CliOpt]]] = _root_.scala.Some(scala.Tuple5(o.name, o.description, o.header, o.unlisted, o.subs))
    };
    @datatype final class Group(__name: String, __description: String, __header: String, __unlisted: B, __subs: ISZ[CliOpt]) extends CliOpt with _root_.org.sireum.DatatypeSig {
      private[this] val _name = __name;
      def name = _name;
      def getName = _name;
      private[this] val _description = __description;
      def description = _description;
      def getDescription = _description;
      private[this] val _header = __header;
      def header = _header;
      def getHeader = _header;
      private[this] val _unlisted = __unlisted;
      def unlisted = _unlisted;
      def getUnlisted = _unlisted;
      private[this] val _subs = __subs;
      def subs = _subs;
      def getSubs = _subs;
      override def toString: _root_.java.lang.String = if ($hasString)
        super.string.value
      else
        {
          val sb = new _root_.java.lang.StringBuilder();
          sb.append("Group");
          sb.append('(');
          sb.append(_root_.org.sireum.String.escape(this.name));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.description));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.header));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.unlisted));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.subs));
          sb.append(')');
          sb.toString
        };
      override def string: _root_.org.sireum.String = if ($hasString)
        super.string
      else
        toString;
      override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
        super.hashCode
      else
        _root_.scala.Seq(this.getClass, name, description, header, unlisted, subs).hashCode;
      override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
        super.equals(o)
      else
        if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
          true
        else
          o match {
            case (o @ ((_): Group)) => if (this.hashCode.!=(o.hashCode))
              false
            else
              this.name.==(o.name).&&(this.description.==(o.description)).&&(this.header.==(o.header)).&&(this.unlisted.==(o.unlisted)).&&(this.subs.==(o.subs))
            case _ => false
          };
      def apply(name: String = this.name, description: String = this.description, header: String = this.header, unlisted: B = this.unlisted, subs: ISZ[CliOpt] = this.subs): Group = new Group(name, description, header, unlisted, subs);
      override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "cli", "Group")), scala.Tuple2("name", this.name), scala.Tuple2("description", this.description), scala.Tuple2("header", this.header), scala.Tuple2("unlisted", this.unlisted), scala.Tuple2("subs", this.subs));
      @pure def command: String = return _root_.org.sireum.helper.$assign(name)
    };
    object Tool {
      def apply(name: String, command: String, description: String, header: String, usage: String, opts: ISZ[Opt], groups: ISZ[OptGroup]): Tool = new Tool(name, command, description, header, usage, opts, groups);
      def unapply(o: Tool): _root_.scala.Option[scala.Tuple7[String, String, String, String, String, ISZ[Opt], ISZ[OptGroup]]] = _root_.scala.Some(scala.Tuple7(o.name, o.command, o.description, o.header, o.usage, o.opts, o.groups))
    };
    @datatype final class Tool(__name: String, __command: String, __description: String, __header: String, __usage: String, __opts: ISZ[Opt], __groups: ISZ[OptGroup]) extends CliOpt with _root_.org.sireum.DatatypeSig {
      private[this] val _name = __name;
      def name = _name;
      def getName = _name;
      private[this] val _command = __command;
      def command = _command;
      def getCommand = _command;
      private[this] val _description = __description;
      def description = _description;
      def getDescription = _description;
      private[this] val _header = __header;
      def header = _header;
      def getHeader = _header;
      private[this] val _usage = __usage;
      def usage = _usage;
      def getUsage = _usage;
      private[this] val _opts = __opts;
      def opts = _opts;
      def getOpts = _opts;
      private[this] val _groups = __groups;
      def groups = _groups;
      def getGroups = _groups;
      override def toString: _root_.java.lang.String = if ($hasString)
        super.string.value
      else
        {
          val sb = new _root_.java.lang.StringBuilder();
          sb.append("Tool");
          sb.append('(');
          sb.append(_root_.org.sireum.String.escape(this.name));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.command));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.description));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.header));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.usage));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.opts));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.groups));
          sb.append(')');
          sb.toString
        };
      override def string: _root_.org.sireum.String = if ($hasString)
        super.string
      else
        toString;
      override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
        super.hashCode
      else
        _root_.scala.Seq(this.getClass, name, command, description, header, usage, opts, groups).hashCode;
      override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
        super.equals(o)
      else
        if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
          true
        else
          o match {
            case (o @ ((_): Tool)) => if (this.hashCode.!=(o.hashCode))
              false
            else
              this.name.==(o.name).&&(this.command.==(o.command)).&&(this.description.==(o.description)).&&(this.header.==(o.header)).&&(this.usage.==(o.usage)).&&(this.opts.==(o.opts)).&&(this.groups.==(o.groups))
            case _ => false
          };
      def apply(name: String = this.name, command: String = this.command, description: String = this.description, header: String = this.header, usage: String = this.usage, opts: ISZ[Opt] = this.opts, groups: ISZ[OptGroup] = this.groups): Tool = new Tool(name, command, description, header, usage, opts, groups);
      override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "cli", "Tool")), scala.Tuple2("name", this.name), scala.Tuple2("command", this.command), scala.Tuple2("description", this.description), scala.Tuple2("header", this.header), scala.Tuple2("usage", this.usage), scala.Tuple2("opts", this.opts), scala.Tuple2("groups", this.groups));
      override def unlisted: B = return _root_.org.sireum.helper.$assign(F)
    };
    object OptGroup {
      def apply(name: String, opts: ISZ[Opt]): OptGroup = new OptGroup(name, opts);
      def unapply(o: OptGroup): _root_.scala.Option[scala.Tuple2[String, ISZ[Opt]]] = _root_.scala.Some(scala.Tuple2(o.name, o.opts))
    };
    @datatype final class OptGroup(__name: String, __opts: ISZ[Opt]) extends _root_.org.sireum.DatatypeSig {
      private[this] val _name = __name;
      def name = _name;
      def getName = _name;
      private[this] val _opts = __opts;
      def opts = _opts;
      def getOpts = _opts;
      override def toString: _root_.java.lang.String = if ($hasString)
        super.string.value
      else
        {
          val sb = new _root_.java.lang.StringBuilder();
          sb.append("OptGroup");
          sb.append('(');
          sb.append(_root_.org.sireum.String.escape(this.name));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.opts));
          sb.append(')');
          sb.toString
        };
      override def string: _root_.org.sireum.String = if ($hasString)
        super.string
      else
        toString;
      override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
        super.hashCode
      else
        _root_.scala.Seq(this.getClass, name, opts).hashCode;
      override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
        super.equals(o)
      else
        if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
          true
        else
          o match {
            case (o @ ((_): OptGroup)) => if (this.hashCode.!=(o.hashCode))
              false
            else
              this.name.==(o.name).&&(this.opts.==(o.opts))
            case _ => false
          };
      def apply(name: String = this.name, opts: ISZ[Opt] = this.opts): OptGroup = new OptGroup(name, opts);
      override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "cli", "OptGroup")), scala.Tuple2("name", this.name), scala.Tuple2("opts", this.opts))
    };
    object Opt {
      def apply(name: String, longKey: String, shortKey: Option[C], tpe: Type, description: String): Opt = new Opt(name, longKey, shortKey, tpe, description);
      def unapply(o: Opt): _root_.scala.Option[scala.Tuple5[String, String, Option[C], Type, String]] = _root_.scala.Some(scala.Tuple5(o.name, o.longKey, o.shortKey, o.tpe, o.description))
    };
    @datatype final class Opt(__name: String, __longKey: String, __shortKey: Option[C], __tpe: Type, __description: String) extends _root_.org.sireum.DatatypeSig {
      private[this] val _name = __name;
      def name = _name;
      def getName = _name;
      private[this] val _longKey = __longKey;
      def longKey = _longKey;
      def getLongKey = _longKey;
      private[this] val _bshortKey: _root_.scala.Boolean = __shortKey.isEmpty.value;
      private[this] val _shortKey: C = __shortKey.getOrElse(null.asInstanceOf[C]);
      def shortKey: Option[C] = if (_bshortKey)
        None()
      else
        Some(_shortKey);
      def getShortKey: Option[C] = shortKey;
      private[this] val _tpe = __tpe;
      def tpe = _tpe;
      def getTpe = _tpe;
      private[this] val _description = __description;
      def description = _description;
      def getDescription = _description;
      override def toString: _root_.java.lang.String = if ($hasString)
        super.string.value
      else
        {
          val sb = new _root_.java.lang.StringBuilder();
          sb.append("Opt");
          sb.append('(');
          sb.append(_root_.org.sireum.String.escape(this.name));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.longKey));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.shortKey));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.tpe));
          sb.append(", ");
          sb.append(_root_.org.sireum.String.escape(this.description));
          sb.append(')');
          sb.toString
        };
      override def string: _root_.org.sireum.String = if ($hasString)
        super.string
      else
        toString;
      override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
        super.hashCode
      else
        _root_.scala.Seq(this.getClass, name, longKey, shortKey, tpe, description).hashCode;
      override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
        super.equals(o)
      else
        if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
          true
        else
          o match {
            case (o @ ((_): Opt)) => if (this.hashCode.!=(o.hashCode))
              false
            else
              this.name.==(o.name).&&(this.longKey.==(o.longKey)).&&(this.shortKey.==(o.shortKey)).&&(this.tpe.==(o.tpe)).&&(this.description.==(o.description))
            case _ => false
          };
      def apply(name: String = this.name, longKey: String = this.longKey, shortKey: Option[C] = this.shortKey, tpe: Type = this.tpe, description: String = this.description): Opt = new Opt(name, longKey, shortKey, tpe, description);
      override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "cli", "Opt")), scala.Tuple2("name", this.name), scala.Tuple2("longKey", this.longKey), scala.Tuple2("shortKey", this.shortKey), scala.Tuple2("tpe", this.tpe), scala.Tuple2("description", this.description))
    };
    @datatype sealed trait Type extends _root_.org.sireum.DatatypeSig;
    object Type {
      object Flag {
        def apply(default: B): Flag = new Flag(default);
        def unapply(o: Flag): _root_.scala.Option[B] = _root_.scala.Some(o.default)
      };
      @datatype final class Flag(__default: B) extends Type with _root_.org.sireum.DatatypeSig {
        private[this] val _default = __default;
        def default = _default;
        def getDefault = _default;
        override def toString: _root_.java.lang.String = if ($hasString)
          super.string.value
        else
          {
            val sb = new _root_.java.lang.StringBuilder();
            sb.append("Flag");
            sb.append('(');
            sb.append(_root_.org.sireum.String.escape(this.default));
            sb.append(')');
            sb.toString
          };
        override def string: _root_.org.sireum.String = if ($hasString)
          super.string
        else
          toString;
        override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
          super.hashCode
        else
          _root_.scala.Seq(this.getClass, default).hashCode;
        override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
          super.equals(o)
        else
          if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
            true
          else
            o match {
              case (o @ ((_): Flag)) => if (this.hashCode.!=(o.hashCode))
                false
              else
                this.default.==(o.default)
              case _ => false
            };
        def apply(default: B = this.default): Flag = new Flag(default);
        override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "cli", "Flag")), scala.Tuple2("default", this.default))
      };
      object Num {
        def apply(sep: Option[C], default: Z, min: Option[Z], max: Option[Z]): Num = new Num(sep, default, min, max);
        def unapply(o: Num): _root_.scala.Option[scala.Tuple4[Option[C], Z, Option[Z], Option[Z]]] = _root_.scala.Some(scala.Tuple4(o.sep, o.default, o.min, o.max))
      };
      @datatype final class Num(__sep: Option[C], __default: Z, __min: Option[Z], __max: Option[Z]) extends Type with _root_.org.sireum.DatatypeSig {
        private[this] val _bsep: _root_.scala.Boolean = __sep.isEmpty.value;
        private[this] val _sep: C = __sep.getOrElse(null.asInstanceOf[C]);
        def sep: Option[C] = if (_bsep)
          None()
        else
          Some(_sep);
        def getSep: Option[C] = sep;
        private[this] val _default = __default;
        def default = _default;
        def getDefault = _default;
        private[this] val _bmin: _root_.scala.Boolean = __min.isEmpty.value;
        private[this] val _min: Z = __min.getOrElse(null.asInstanceOf[Z]);
        def min: Option[Z] = if (_bmin)
          None()
        else
          Some(_min);
        def getMin: Option[Z] = min;
        private[this] val _bmax: _root_.scala.Boolean = __max.isEmpty.value;
        private[this] val _max: Z = __max.getOrElse(null.asInstanceOf[Z]);
        def max: Option[Z] = if (_bmax)
          None()
        else
          Some(_max);
        def getMax: Option[Z] = max;
        override def toString: _root_.java.lang.String = if ($hasString)
          super.string.value
        else
          {
            val sb = new _root_.java.lang.StringBuilder();
            sb.append("Num");
            sb.append('(');
            sb.append(_root_.org.sireum.String.escape(this.sep));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.default));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.min));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.max));
            sb.append(')');
            sb.toString
          };
        override def string: _root_.org.sireum.String = if ($hasString)
          super.string
        else
          toString;
        override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
          super.hashCode
        else
          _root_.scala.Seq(this.getClass, sep, default, min, max).hashCode;
        override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
          super.equals(o)
        else
          if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
            true
          else
            o match {
              case (o @ ((_): Num)) => if (this.hashCode.!=(o.hashCode))
                false
              else
                this.sep.==(o.sep).&&(this.default.==(o.default)).&&(this.min.==(o.min)).&&(this.max.==(o.max))
              case _ => false
            };
        def apply(sep: Option[C] = this.sep, default: Z = this.default, min: Option[Z] = this.min, max: Option[Z] = this.max): Num = new Num(sep, default, min, max);
        override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "cli", "Num")), scala.Tuple2("sep", this.sep), scala.Tuple2("default", this.default), scala.Tuple2("min", this.min), scala.Tuple2("max", this.max))
      };
      object NumChoice {
        def apply(sep: Option[C], choices: ISZ[Z]): NumChoice = new NumChoice(sep, choices);
        def unapply(o: NumChoice): _root_.scala.Option[scala.Tuple2[Option[C], ISZ[Z]]] = _root_.scala.Some(scala.Tuple2(o.sep, o.choices))
      };
      @datatype final class NumChoice(__sep: Option[C], __choices: ISZ[Z]) extends Type with _root_.org.sireum.DatatypeSig {
        private[this] val _bsep: _root_.scala.Boolean = __sep.isEmpty.value;
        private[this] val _sep: C = __sep.getOrElse(null.asInstanceOf[C]);
        def sep: Option[C] = if (_bsep)
          None()
        else
          Some(_sep);
        def getSep: Option[C] = sep;
        private[this] val _choices = __choices;
        def choices = _choices;
        def getChoices = _choices;
        override def toString: _root_.java.lang.String = if ($hasString)
          super.string.value
        else
          {
            val sb = new _root_.java.lang.StringBuilder();
            sb.append("NumChoice");
            sb.append('(');
            sb.append(_root_.org.sireum.String.escape(this.sep));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.choices));
            sb.append(')');
            sb.toString
          };
        override def string: _root_.org.sireum.String = if ($hasString)
          super.string
        else
          toString;
        override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
          super.hashCode
        else
          _root_.scala.Seq(this.getClass, sep, choices).hashCode;
        override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
          super.equals(o)
        else
          if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
            true
          else
            o match {
              case (o @ ((_): NumChoice)) => if (this.hashCode.!=(o.hashCode))
                false
              else
                this.sep.==(o.sep).&&(this.choices.==(o.choices))
              case _ => false
            };
        def apply(sep: Option[C] = this.sep, choices: ISZ[Z] = this.choices): NumChoice = new NumChoice(sep, choices);
        override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "cli", "NumChoice")), scala.Tuple2("sep", this.sep), scala.Tuple2("choices", this.choices))
      };
      object Str {
        def apply(sep: Option[C], default: Option[String]): Str = new Str(sep, default);
        def unapply(o: Str): _root_.scala.Option[scala.Tuple2[Option[C], Option[String]]] = _root_.scala.Some(scala.Tuple2(o.sep, o.default))
      };
      @datatype final class Str(__sep: Option[C], __default: Option[String]) extends Type with _root_.org.sireum.DatatypeSig {
        private[this] val _bsep: _root_.scala.Boolean = __sep.isEmpty.value;
        private[this] val _sep: C = __sep.getOrElse(null.asInstanceOf[C]);
        def sep: Option[C] = if (_bsep)
          None()
        else
          Some(_sep);
        def getSep: Option[C] = sep;
        private[this] val _bdefault: _root_.scala.Boolean = __default.isEmpty.value;
        private[this] val _default: String = __default.getOrElse(null.asInstanceOf[String]);
        def default: Option[String] = if (_bdefault)
          None()
        else
          Some(_default);
        def getDefault: Option[String] = default;
        override def toString: _root_.java.lang.String = if ($hasString)
          super.string.value
        else
          {
            val sb = new _root_.java.lang.StringBuilder();
            sb.append("Str");
            sb.append('(');
            sb.append(_root_.org.sireum.String.escape(this.sep));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.default));
            sb.append(')');
            sb.toString
          };
        override def string: _root_.org.sireum.String = if ($hasString)
          super.string
        else
          toString;
        override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
          super.hashCode
        else
          _root_.scala.Seq(this.getClass, sep, default).hashCode;
        override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
          super.equals(o)
        else
          if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
            true
          else
            o match {
              case (o @ ((_): Str)) => if (this.hashCode.!=(o.hashCode))
                false
              else
                this.sep.==(o.sep).&&(this.default.==(o.default))
              case _ => false
            };
        def apply(sep: Option[C] = this.sep, default: Option[String] = this.default): Str = new Str(sep, default);
        override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "cli", "Str")), scala.Tuple2("sep", this.sep), scala.Tuple2("default", this.default))
      };
      object Choice {
        def apply(name: String, sep: Option[C], elements: ISZ[String]): Choice = new Choice(name, sep, elements);
        def unapply(o: Choice): _root_.scala.Option[scala.Tuple3[String, Option[C], ISZ[String]]] = _root_.scala.Some(scala.Tuple3(o.name, o.sep, o.elements))
      };
      @datatype final class Choice(__name: String, __sep: Option[C], __elements: ISZ[String]) extends Type with _root_.org.sireum.DatatypeSig {
        private[this] val _name = __name;
        def name = _name;
        def getName = _name;
        private[this] val _bsep: _root_.scala.Boolean = __sep.isEmpty.value;
        private[this] val _sep: C = __sep.getOrElse(null.asInstanceOf[C]);
        def sep: Option[C] = if (_bsep)
          None()
        else
          Some(_sep);
        def getSep: Option[C] = sep;
        private[this] val _elements = __elements;
        def elements = _elements;
        def getElements = _elements;
        override def toString: _root_.java.lang.String = if ($hasString)
          super.string.value
        else
          {
            val sb = new _root_.java.lang.StringBuilder();
            sb.append("Choice");
            sb.append('(');
            sb.append(_root_.org.sireum.String.escape(this.name));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.sep));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.elements));
            sb.append(')');
            sb.toString
          };
        override def string: _root_.org.sireum.String = if ($hasString)
          super.string
        else
          toString;
        override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
          super.hashCode
        else
          _root_.scala.Seq(this.getClass, name, sep, elements).hashCode;
        override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
          super.equals(o)
        else
          if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
            true
          else
            o match {
              case (o @ ((_): Choice)) => if (this.hashCode.!=(o.hashCode))
                false
              else
                this.name.==(o.name).&&(this.sep.==(o.sep)).&&(this.elements.==(o.elements))
              case _ => false
            };
        def apply(name: String = this.name, sep: Option[C] = this.sep, elements: ISZ[String] = this.elements): Choice = new Choice(name, sep, elements);
        override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "cli", "Choice")), scala.Tuple2("name", this.name), scala.Tuple2("sep", this.sep), scala.Tuple2("elements", this.elements))
      };
      object Path {
        def apply(multiple: B, default: Option[String]): Path = new Path(multiple, default);
        def unapply(o: Path): _root_.scala.Option[scala.Tuple2[B, Option[String]]] = _root_.scala.Some(scala.Tuple2(o.multiple, o.default))
      };
      @datatype final class Path(__multiple: B, __default: Option[String]) extends Type with _root_.org.sireum.DatatypeSig {
        private[this] val _multiple = __multiple;
        def multiple = _multiple;
        def getMultiple = _multiple;
        private[this] val _bdefault: _root_.scala.Boolean = __default.isEmpty.value;
        private[this] val _default: String = __default.getOrElse(null.asInstanceOf[String]);
        def default: Option[String] = if (_bdefault)
          None()
        else
          Some(_default);
        def getDefault: Option[String] = default;
        override def toString: _root_.java.lang.String = if ($hasString)
          super.string.value
        else
          {
            val sb = new _root_.java.lang.StringBuilder();
            sb.append("Path");
            sb.append('(');
            sb.append(_root_.org.sireum.String.escape(this.multiple));
            sb.append(", ");
            sb.append(_root_.org.sireum.String.escape(this.default));
            sb.append(')');
            sb.toString
          };
        override def string: _root_.org.sireum.String = if ($hasString)
          super.string
        else
          toString;
        override lazy val hashCode: _root_.scala.Int = if ($hasEquals)
          super.hashCode
        else
          _root_.scala.Seq(this.getClass, multiple, default).hashCode;
        override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
          super.equals(o)
        else
          if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
            true
          else
            o match {
              case (o @ ((_): Path)) => if (this.hashCode.!=(o.hashCode))
                false
              else
                this.multiple.==(o.multiple).&&(this.default.==(o.default))
              case _ => false
            };
        def apply(multiple: B = this.multiple, default: Option[String] = this.default): Path = new Path(multiple, default);
        override lazy val $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "cli", "Path")), scala.Tuple2("multiple", this.multiple), scala.Tuple2("default", this.default))
      }
    }
  }
}