package org.sireum.crypto {
  import org.sireum._

  import org.sireum.U8._

  import org.sireum.U64._

  object SHA3 {
    val spongeWords: Z = _root_.org.sireum.Z(25);
    val rounds: Z = _root_.org.sireum.Z(24);
    val rndc: ISZ[U64] = _root_.org.sireum.helper.$assign(ISZ(StringContext("0x0000000000000001").u64(), StringContext("0x0000000000008082").u64(), StringContext("0x800000000000808a").u64(), StringContext("0x8000000080008000").u64(), StringContext("0x000000000000808b").u64(), StringContext("0x0000000080000001").u64(), StringContext("0x8000000080008081").u64(), StringContext("0x8000000000008009").u64(), StringContext("0x000000000000008a").u64(), StringContext("0x0000000000000088").u64(), StringContext("0x0000000080008009").u64(), StringContext("0x000000008000000a").u64(), StringContext("0x000000008000808b").u64(), StringContext("0x800000000000008b").u64(), StringContext("0x8000000000008089").u64(), StringContext("0x8000000000008003").u64(), StringContext("0x8000000000008002").u64(), StringContext("0x8000000000000080").u64(), StringContext("0x000000000000800a").u64(), StringContext("0x800000008000000a").u64(), StringContext("0x8000000080008081").u64(), StringContext("0x8000000000008080").u64(), StringContext("0x0000000080000001").u64(), StringContext("0x8000000080008008").u64()));
    val rotc: ISZ[U64] = _root_.org.sireum.helper.$assign(ISZ(StringContext("1").u64(), StringContext("3").u64(), StringContext("6").u64(), StringContext("10").u64(), StringContext("15").u64(), StringContext("21").u64(), StringContext("28").u64(), StringContext("36").u64(), StringContext("45").u64(), StringContext("55").u64(), StringContext("2").u64(), StringContext("14").u64(), StringContext("27").u64(), StringContext("41").u64(), StringContext("56").u64(), StringContext("8").u64(), StringContext("25").u64(), StringContext("43").u64(), StringContext("62").u64(), StringContext("18").u64(), StringContext("39").u64(), StringContext("61").u64(), StringContext("20").u64(), StringContext("44").u64()));
    val piln: ISZ[Z] = _root_.org.sireum.helper.$assign(ISZ(_root_.org.sireum.Z(10), _root_.org.sireum.Z(7), _root_.org.sireum.Z(11), _root_.org.sireum.Z(17), _root_.org.sireum.Z(18), _root_.org.sireum.Z(3), _root_.org.sireum.Z(5), _root_.org.sireum.Z(16), _root_.org.sireum.Z(8), _root_.org.sireum.Z(21), _root_.org.sireum.Z(24), _root_.org.sireum.Z(4), _root_.org.sireum.Z(15), _root_.org.sireum.Z(23), _root_.org.sireum.Z(19), _root_.org.sireum.Z(13), _root_.org.sireum.Z(12), _root_.org.sireum.Z(2), _root_.org.sireum.Z(20), _root_.org.sireum.Z(14), _root_.org.sireum.Z(22), _root_.org.sireum.Z(9), _root_.org.sireum.Z(6), _root_.org.sireum.Z(1)));
    @pure def rotl(x: U64, y: U64): U64 = return _root_.org.sireum.helper.$assign(x.<<(y).|(x.>>(StringContext("64").u64().-(y))));
    def keccakf(s: MSZ[U64]): Unit = {
      var t = StringContext("0").u64();
      val bc = _root_.org.sireum.helper.$assign(MS.create(_root_.org.sireum.Z(5), StringContext("0").u64()));
      StringContext("0").z().until(rounds).foreach(((round) => {
        _root_.org.sireum.Z(0).until(_root_.org.sireum.Z(5)).foreach(((i) => bc.update(i, _root_.org.sireum.helper.$assign(s(i).|^(s(i.+(_root_.org.sireum.Z(5)))).|^(s(i.+(_root_.org.sireum.Z(10)))).|^(s(i.+(_root_.org.sireum.Z(15)))).|^(s(i.+(_root_.org.sireum.Z(20))))))));
        _root_.org.sireum.Z(0).until(_root_.org.sireum.Z(5)).foreach(((i) => {
          t = _root_.org.sireum.helper.$assign(bc(i.+(_root_.org.sireum.Z(4)).%(_root_.org.sireum.Z(5))).|^(rotl(bc(i.+(_root_.org.sireum.Z(1)).%(_root_.org.sireum.Z(5))), StringContext("1").u64())));
          _root_.org.sireum.Z(0).until(_root_.org.sireum.Z(25)).by(_root_.org.sireum.Z(5)).foreach(((j) => s.update(j.+(i), _root_.org.sireum.helper.$assign(s(j.+(i)).|^(t)))))
        }));
        t = _root_.org.sireum.helper.$assign(s(_root_.org.sireum.Z(1)));
        _root_.org.sireum.Z(0).until(_root_.org.sireum.Z(24)).foreach(((i) => {
          val j = _root_.org.sireum.helper.$assign(piln(i));
          bc.update(_root_.org.sireum.Z(0), _root_.org.sireum.helper.$assign(s(j)));
          s.update(j, _root_.org.sireum.helper.$assign(rotl(t, rotc(i))));
          t = _root_.org.sireum.helper.$assign(bc(_root_.org.sireum.Z(0)))
        }));
        _root_.org.sireum.Z(0).until(_root_.org.sireum.Z(25)).by(_root_.org.sireum.Z(5)).foreach(((j) => {
          _root_.org.sireum.Z(0).until(_root_.org.sireum.Z(5)).foreach(((i) => bc.update(i, _root_.org.sireum.helper.$assign(s(j.+(i))))));
          _root_.org.sireum.Z(0).until(_root_.org.sireum.Z(5)).foreach(((i) => s.update(j.+(i), _root_.org.sireum.helper.$assign(s(j.+(i)).|^(bc(i.+(_root_.org.sireum.Z(1)).%(_root_.org.sireum.Z(5))).`unary_~`.&(bc(i.+(_root_.org.sireum.Z(2)).%(_root_.org.sireum.Z(5)))))))))
        }));
        s.update(_root_.org.sireum.Z(0), _root_.org.sireum.helper.$assign(s(_root_.org.sireum.Z(0)).|^(rndc(round))))
      }))
    };
    @pure def init256: SHA3 = return _root_.org.sireum.helper.$assign(SHA3(_root_.org.sireum.Z(8)));
    @pure def init384: SHA3 = return _root_.org.sireum.helper.$assign(SHA3(_root_.org.sireum.Z(12)));
    @pure def init512: SHA3 = return _root_.org.sireum.helper.$assign(SHA3(_root_.org.sireum.Z(16)));
    @pure def sum256(data: ISZ[U8]): ISZ[U8] = {
      val sha3 = _root_.org.sireum.helper.$assign(init256);
      sha3.update(_root_.org.sireum.helper.$assign(data));
      val r = _root_.org.sireum.helper.$assign(sha3.finalise());
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def sum384(data: ISZ[U8]): ISZ[U8] = {
      val sha3 = _root_.org.sireum.helper.$assign(init384);
      sha3.update(_root_.org.sireum.helper.$assign(data));
      val r = _root_.org.sireum.helper.$assign(sha3.finalise());
      return _root_.org.sireum.helper.$assign(r)
    };
    @pure def sum512(data: ISZ[U8]): ISZ[U8] = {
      val sha3 = _root_.org.sireum.helper.$assign(init512);
      sha3.update(_root_.org.sireum.helper.$assign(data));
      val r = _root_.org.sireum.helper.$assign(sha3.finalise());
      return _root_.org.sireum.helper.$assign(r)
    };
    def apply(capacityWords: Z): SHA3 = new SHA3(_root_.org.sireum.helper.$assign(capacityWords));
    def unapply(o: SHA3): _root_.scala.Option[Z] = _root_.scala.Some(_root_.org.sireum.helper.clone(o.capacityWords))
  }

  import SHA3._

  @record final class SHA3(__capacityWords: Z) extends _root_.org.sireum.RecordSig {
    private[this] var _capacityWords = __capacityWords;
    def capacityWords = _capacityWords;
    def getCapacityWords = _capacityWords;
    override def toString: _root_.java.lang.String = if ($hasString)
      super.string.value
    else
      {
        val sb = new _root_.java.lang.StringBuilder();
        sb.append("SHA3");
        sb.append('(');
        sb.append(_root_.org.sireum.String.escape(this.capacityWords));
        sb.append(')');
        sb.toString
      };
    override def string: _root_.org.sireum.String = if ($hasString)
      super.string
    else
      toString;
    override def hashCode: _root_.scala.Int = if ($hasEquals)
      super.hashCode
    else
      _root_.scala.Seq(this.getClass, capacityWords).hashCode;
    override def equals(o: _root_.scala.Any): _root_.scala.Boolean = if ($hasEquals)
      super.equals(o)
    else
      if (this.eq(o.asInstanceOf[_root_.scala.AnyRef]))
        true
      else
        o match {
          case (o @ ((_): SHA3)) => if (this.hashCode.!=(o.hashCode))
            false
          else
            this.capacityWords.==(o.capacityWords)
          case _ => false
        };
    def apply(capacityWords: Z = this.capacityWords): SHA3 = new SHA3(_root_.org.sireum.helper.$assign(capacityWords));
    override def $content: _root_.scala.Seq[scala.Tuple2[_root_.java.lang.String, _root_.scala.Any]] = _root_.scala.Seq(scala.Tuple2("type", _root_.scala.List[_root_.java.lang.String]("org", "sireum", "crypto", "SHA3")), scala.Tuple2("capacityWords", capacityWords));
    override def $clone: SHA3 = {
      val r: SHA3 = new SHA3(_root_.org.sireum.helper.cloneAssign(this.capacityWords));
      r.saved = _root_.org.sireum.helper.cloneAssign(saved);
      r.byteIndex = _root_.org.sireum.helper.cloneAssign(byteIndex);
      r.wordIndex = _root_.org.sireum.helper.cloneAssign(wordIndex);
      r.s = _root_.org.sireum.helper.cloneAssign(s);
      r
    };
    var saved: U64 = StringContext("0").u64();
    var byteIndex: U64 = StringContext("0").u64();
    var wordIndex: Z = _root_.org.sireum.Z(0);
    var s: MSZ[U64] = _root_.org.sireum.helper.$assign(MS.create(_root_.org.sireum.Z(25), StringContext("0").u64()));
    def update(buf: ISZ[U8]): Unit = {
      assert(byteIndex.<(StringContext("8").u64()));
      assert(wordIndex.<(_root_.org.sireum.Z(25)));
      var oldTail = _root_.org.sireum.helper.$assign(_root_.org.sireum.Z(8).-(conversions.U64.toZ(byteIndex)).%(_root_.org.sireum.Z(8)));
      var len = _root_.org.sireum.helper.$assign(buf.size);
      var index = _root_.org.sireum.Z(0);
      if (len.<(oldTail))
        {
          while (len.>(_root_.org.sireum.Z(0))) 
            {
              saved = _root_.org.sireum.helper.$assign(saved.|(conversions.U8.toU64(buf(index)).<<(byteIndex.*(StringContext("8").u64()))));
              byteIndex = _root_.org.sireum.helper.$assign(byteIndex.+(StringContext("1").u64()));
              index = _root_.org.sireum.helper.$assign(index.+(_root_.org.sireum.Z(1)));
              len = _root_.org.sireum.helper.$assign(len.-(_root_.org.sireum.Z(1)))
            }
          ;
          assert(byteIndex.<(StringContext("8").u64()));
          return ()
        }
      else
        ();
      if (oldTail.>(_root_.org.sireum.Z(0)))
        {
          len = _root_.org.sireum.helper.$assign(len.-(oldTail));
          while (oldTail.>(_root_.org.sireum.Z(0))) 
            {
              saved = _root_.org.sireum.helper.$assign(saved.|(conversions.U8.toU64(buf(index)).<<(byteIndex.*(StringContext("8").u64()))));
              byteIndex = _root_.org.sireum.helper.$assign(byteIndex.+(StringContext("1").u64()));
              index = _root_.org.sireum.helper.$assign(index.+(_root_.org.sireum.Z(1)));
              oldTail = _root_.org.sireum.helper.$assign(oldTail.-(_root_.org.sireum.Z(1)))
            }
          ;
          s.update(wordIndex, _root_.org.sireum.helper.$assign(s(wordIndex).|^(saved)));
          assert(byteIndex.==(StringContext("8").u64()));
          byteIndex = StringContext("0").u64();
          saved = StringContext("0").u64();
          wordIndex = _root_.org.sireum.helper.$assign(wordIndex.+(_root_.org.sireum.Z(1)));
          if (wordIndex.==(spongeWords.-(capacityWords)))
            {
              keccakf(s);
              wordIndex = _root_.org.sireum.Z(0)
            }
          else
            ()
        }
      else
        ();
      assert(byteIndex.==(StringContext("0").u64()));
      val words = _root_.org.sireum.helper.$assign(len./(_root_.org.sireum.Z(8)));
      StringContext("0").z().until(words).foreach(((_ ) => {
        val t = _root_.org.sireum.helper.$assign(conversions.U8.toU64(buf(index)).|(conversions.U8.toU64(buf(index.+(_root_.org.sireum.Z(1)))).<<(StringContext("8").u64())).|(conversions.U8.toU64(buf(index.+(_root_.org.sireum.Z(2)))).<<(StringContext("16").u64())).|(conversions.U8.toU64(buf(index.+(_root_.org.sireum.Z(3)))).<<(StringContext("24").u64())).|(conversions.U8.toU64(buf(index.+(_root_.org.sireum.Z(4)))).<<(StringContext("32").u64())).|(conversions.U8.toU64(buf(index.+(_root_.org.sireum.Z(5)))).<<(StringContext("40").u64())).|(conversions.U8.toU64(buf(index.+(_root_.org.sireum.Z(6)))).<<(StringContext("48").u64())).|(conversions.U8.toU64(buf(index.+(_root_.org.sireum.Z(7)))).<<(StringContext("56").u64())));
        s.update(wordIndex, _root_.org.sireum.helper.$assign(s(wordIndex).|^(t)));
        wordIndex = _root_.org.sireum.helper.$assign(wordIndex.+(_root_.org.sireum.Z(1)));
        if (wordIndex.==(spongeWords.-(capacityWords)))
          {
            keccakf(s);
            wordIndex = _root_.org.sireum.Z(0)
          }
        else
          ();
        index = _root_.org.sireum.helper.$assign(index.+(_root_.org.sireum.Z(8)))
      }));
      var tail = _root_.org.sireum.helper.$assign(len.-(words.*(_root_.org.sireum.Z(8))));
      assert(byteIndex.==(StringContext("0").u64()).&&(tail.<(_root_.org.sireum.Z(8))));
      while (tail.>(_root_.org.sireum.Z(0))) 
        {
          saved = _root_.org.sireum.helper.$assign(saved.|(conversions.U8.toU64(buf(index)).<<(byteIndex.*(StringContext("8").u64()))));
          byteIndex = _root_.org.sireum.helper.$assign(byteIndex.+(StringContext("1").u64()));
          index = _root_.org.sireum.helper.$assign(index.+(_root_.org.sireum.Z(1)));
          tail = _root_.org.sireum.helper.$assign(tail.-(_root_.org.sireum.Z(1)))
        }
      ;
      assert(byteIndex.<(StringContext("8").u64()))
    };
    def finalise(): ISZ[U8] = {
      s.update(wordIndex, _root_.org.sireum.helper.$assign(s(wordIndex).|^(saved.|^(StringContext("0x02").u64().|(StringContext("1").u64().<<(StringContext("2").u64())).<<(byteIndex.*(StringContext("8").u64()))))));
      s.update(spongeWords.-(capacityWords).-(_root_.org.sireum.Z(1)), _root_.org.sireum.helper.$assign(s(spongeWords.-(capacityWords).-(_root_.org.sireum.Z(1))).|^(StringContext("0x8000000000000000").u64())));
      keccakf(s);
      val sb = _root_.org.sireum.helper.$assign(MS.create(capacityWords.*(_root_.org.sireum.Z(4)), StringContext("0").u8()));
      StringContext("0").z().until(capacityWords./(_root_.org.sireum.Z(2))).foreach(((i) => {
        val t = _root_.org.sireum.helper.$assign(s(i));
        sb.update(i.*(_root_.org.sireum.Z(8)), _root_.org.sireum.helper.$assign(conversions.U64.toU8(t.&(StringContext("0xFF").u64()))));
        sb.update(i.*(_root_.org.sireum.Z(8)).+(_root_.org.sireum.Z(1)), _root_.org.sireum.helper.$assign(conversions.U64.toU8(t.>>(StringContext("8").u64()).&(StringContext("0xFF").u64()))));
        sb.update(i.*(_root_.org.sireum.Z(8)).+(_root_.org.sireum.Z(2)), _root_.org.sireum.helper.$assign(conversions.U64.toU8(t.>>(StringContext("16").u64()).&(StringContext("0xFF").u64()))));
        sb.update(i.*(_root_.org.sireum.Z(8)).+(_root_.org.sireum.Z(3)), _root_.org.sireum.helper.$assign(conversions.U64.toU8(t.>>(StringContext("24").u64()).&(StringContext("0xFF").u64()))));
        sb.update(i.*(_root_.org.sireum.Z(8)).+(_root_.org.sireum.Z(4)), _root_.org.sireum.helper.$assign(conversions.U64.toU8(t.>>(StringContext("32").u64()).&(StringContext("0xFF").u64()))));
        sb.update(i.*(_root_.org.sireum.Z(8)).+(_root_.org.sireum.Z(5)), _root_.org.sireum.helper.$assign(conversions.U64.toU8(t.>>(StringContext("40").u64()).&(StringContext("0xFF").u64()))));
        sb.update(i.*(_root_.org.sireum.Z(8)).+(_root_.org.sireum.Z(6)), _root_.org.sireum.helper.$assign(conversions.U64.toU8(t.>>(StringContext("48").u64()).&(StringContext("0xFF").u64()))));
        sb.update(i.*(_root_.org.sireum.Z(8)).+(_root_.org.sireum.Z(7)), _root_.org.sireum.helper.$assign(conversions.U64.toU8(t.>>(StringContext("56").u64()).&(StringContext("0xFF").u64()))))
      }));
      return _root_.org.sireum.helper.$assign(sb.toIS)
    }
  }
}