/*
 * Decompiled with CFR 0.152.
 */
package sh4d3.scala.meta.internal.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scalapb.GeneratedMessage;
import sh4d3.scala.meta.internal.io.InputStreamIO$;
import sh4d3.scala.meta.internal.io.ListFiles;
import sh4d3.scala.meta.internal.semanticdb.TextDocument;
import sh4d3.scala.meta.internal.semanticdb.TextDocuments;
import sh4d3.scala.meta.internal.semanticdb.TextDocuments$;
import sh4d3.scala.meta.io.AbsolutePath;
import sh4d3.scala.meta.io.AbsolutePath$;
import sh4d3.scala.meta.io.RelativePath;
import sh4d3.scala.meta.io.RelativePath$;

public final class PlatformFileIO$ {
    public static PlatformFileIO$ MODULE$;

    static {
        new PlatformFileIO$();
    }

    public byte[] readAllBytes(URI uri) {
        byte[] byArray;
        try (InputStream is = uri.toURL().openStream();){
            byArray = InputStreamIO$.MODULE$.readBytes(is);
        }
        return byArray;
    }

    public byte[] readAllBytes(AbsolutePath path) {
        return Files.readAllBytes(path.toNIO());
    }

    public Seq<TextDocument> readAllDocuments(AbsolutePath path) {
        Seq<TextDocument> seq;
        try (InputStream stream = Files.newInputStream(path.toNIO(), new OpenOption[0]);){
            seq = ((TextDocuments)TextDocuments$.MODULE$.parseFrom(stream)).documents();
        }
        return seq;
    }

    public void write(AbsolutePath path, GeneratedMessage proto, Seq<OpenOption> openOptions) {
        Files.createDirectories(path.toNIO().getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path.toNIO(), (OpenOption[])openOptions.toArray(ClassTag$.MODULE$.apply(OpenOption.class)));){
            proto.writeTo(os);
        }
    }

    public String slurp(AbsolutePath path, Charset charset) {
        return new String(Files.readAllBytes(path.toNIO()), charset);
    }

    public ListFiles listFiles(AbsolutePath path2) {
        return new ListFiles(path2, (List<RelativePath>)((List)((List)Option$.MODULE$.apply((Object)path2.toFile().list()).toList().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))).map((Function1 & Serializable & scala.Serializable)path -> RelativePath$.MODULE$.apply((String)path), List$.MODULE$.canBuildFrom())));
    }

    public boolean isFile(AbsolutePath path) {
        return Files.isRegularFile(path.toNIO(), new LinkOption[0]);
    }

    public boolean isDirectory(AbsolutePath path) {
        return Files.isDirectory(path.toNIO(), new LinkOption[0]);
    }

    public ListFiles listAllFilesRecursively(AbsolutePath root2) {
        Buffer relativeFiles = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Files.walk(root2.toNIO(), new FileVisitOption[0]).collect(Collectors.toList())).asScala()).collect((PartialFunction)new scala.Serializable(root2){
            public static final long serialVersionUID = 0L;
            private final AbsolutePath root$1;

            public final <A1 extends Path, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = Files.isRegularFile(A1, new LinkOption[0]) ? RelativePath$.MODULE$.apply(this.root$1.toNIO().relativize(A1)) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Path x1) {
                Path path = x1;
                boolean bl = Files.isRegularFile(path, new LinkOption[0]);
                return bl;
            }
            {
                this.root$1 = root$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return new ListFiles(root2, (List<RelativePath>)relativeFiles.toList());
    }

    public AbsolutePath jarRootPath(AbsolutePath jarFile, boolean create) {
        FileSystem fs = this.newJarFileSystem(jarFile, create);
        return AbsolutePath$.MODULE$.apply(fs.getPath("/", new String[0]), AbsolutePath$.MODULE$.workingDirectory());
    }

    public boolean jarRootPath$default$2() {
        return false;
    }

    public <T> T withJarFileSystem(AbsolutePath path, boolean create, boolean close, Function1<AbsolutePath, T> f) {
        Object object;
        FileSystem fs = this.newJarFileSystem(path, create);
        AbsolutePath root2 = AbsolutePath$.MODULE$.apply(fs.getPath("/", new String[0]), AbsolutePath$.MODULE$.workingDirectory());
        if (create || close) {
            try {
                object = f.apply((Object)root2);
            }
            finally {
                fs.close();
            }
        } else {
            object = f.apply((Object)root2);
        }
        return (T)object;
    }

    public <T> boolean withJarFileSystem$default$3() {
        return false;
    }

    public FileSystem newJarFileSystem(AbsolutePath path, boolean create) {
        Object object = create && !Files.exists(path.toNIO().getParent(), new LinkOption[0]) ? Files.createDirectories(path.toNIO().getParent(), new FileAttribute[0]) : BoxedUnit.UNIT;
        HashMap<String, String> map = new HashMap<String, String>();
        Object object2 = create ? map.put("create", "true") : BoxedUnit.UNIT;
        URI uri = URI.create(new StringBuilder(4).append("jar:").append(path.toNIO().toUri().toString()).toString());
        return this.newFileSystem(uri, map);
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> map) {
        FileSystem fileSystem;
        try {
            fileSystem = FileSystems.newFileSystem(uri, map);
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            fileSystem = FileSystems.getFileSystem(uri);
        }
        return fileSystem;
    }

    public Map<String, ?> newFileSystem$default$2() {
        return new HashMap();
    }

    private PlatformFileIO$() {
        MODULE$ = this;
    }
}

