package org.sisioh.aws4s.sts

import com.amazonaws._
import com.amazonaws.auth.{ AWSCredentials, AWSCredentialsProvider }
import com.amazonaws.metrics.RequestMetricCollector
import com.amazonaws.services.securitytoken.{ AWSSecurityTokenServiceClient, AWSSecurityTokenServiceClientBuilder }
import com.amazonaws.services.securitytoken.model._
import org.sisioh.aws4s.PimpedType

import scala.util.Try

object AWSSecurityTokenServiceClientFactory {

  @deprecated("it's old method since 1.0.15")
  def create(): AWSSecurityTokenServiceClient =
    new AWSSecurityTokenServiceClient()

  @deprecated("it's old method since 1.0.15")
  def create(clientConfiguration: ClientConfiguration): AWSSecurityTokenServiceClient =
    new AWSSecurityTokenServiceClient(clientConfiguration)

  @deprecated("it's old method since 1.0.15")
  def create(awsCredentials: AWSCredentials): AWSSecurityTokenServiceClient =
    new AWSSecurityTokenServiceClient(awsCredentials)

  def create(awsCredentials: AWSCredentials, clientConfiguration: ClientConfiguration): AWSSecurityTokenServiceClient =
    new AWSSecurityTokenServiceClient(awsCredentials, clientConfiguration)

  def create(awsCredentialsProvider: AWSCredentialsProvider): AWSSecurityTokenServiceClient =
    new AWSSecurityTokenServiceClient(awsCredentialsProvider)

  def create(awsCredentialsProvider: AWSCredentialsProvider,
             clientConfiguration: ClientConfiguration): AWSSecurityTokenServiceClient =
    new AWSSecurityTokenServiceClient(awsCredentialsProvider, clientConfiguration)

  def create(awsCredentialsProvider: AWSCredentialsProvider,
             clientConfiguration: ClientConfiguration,
             requestMetricCollector: RequestMetricCollector): AWSSecurityTokenServiceClient =
    new AWSSecurityTokenServiceClient(awsCredentialsProvider, clientConfiguration, requestMetricCollector)

}

class RichAWSSecurityTokenServiceClient(val underlying: AWSSecurityTokenServiceClient)
    extends AnyVal
    with PimpedType[AWSSecurityTokenServiceClient] {

  def getSessionTokenAsTry(getSessionTokenRequest: GetSessionTokenRequest): Try[GetSessionTokenResult] = Try {
    underlying.getSessionToken(getSessionTokenRequest)
  }

  def decodeAuthorizationMessageAsTry(
      decodeAuthorizationMessageRequest: DecodeAuthorizationMessageRequest
  ): Try[DecodeAuthorizationMessageResult] = Try {
    underlying.decodeAuthorizationMessage(decodeAuthorizationMessageRequest)
  }

  def assumeRoleWithSAMLAsTry(assumeRoleWithSAMLRequest: AssumeRoleWithSAMLRequest): Try[AssumeRoleWithSAMLResult] =
    Try {
      underlying.assumeRoleWithSAML(assumeRoleWithSAMLRequest)
    }

  def assumeRoleWithWebIdentityAsTry(
      assumeRoleWithWebIdentityRequest: AssumeRoleWithWebIdentityRequest
  ): Try[AssumeRoleWithWebIdentityResult] = Try {
    underlying.assumeRoleWithWebIdentity(assumeRoleWithWebIdentityRequest)
  }

  def getFederationTokenAsTry(getFederationTokenRequest: GetFederationTokenRequest): Try[GetFederationTokenResult] =
    Try {
      underlying.getFederationToken(getFederationTokenRequest)
    }

  def assumeRoleAsTry(assumeRoleRequest: AssumeRoleRequest): Try[AssumeRoleResult] = Try {
    underlying.assumeRole(assumeRoleRequest)
  }

  def getSessionTokenAsTry: Try[GetSessionTokenResult] = Try {
    underlying.getSessionToken
  }

  def getCachedResponseMetadataAsTry(request: AmazonWebServiceRequest): Try[ResponseMetadata] = Try {
    underlying.getCachedResponseMetadata(request)
  }

}
