/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.crypto.signature;

import java.security.Signature;
import org.sklsft.commons.crypto.accessors.RsaPrivateKeyAccessor;
import org.sklsft.commons.crypto.exception.SignatureException;
import org.sklsft.commons.crypto.signature.RsaAlgorithms;

public class RsaSigner {
    private RsaPrivateKeyAccessor rsaPrivateKeyAccessor;

    public RsaSigner(RsaPrivateKeyAccessor rsaPrivateKeyAccessor) {
        this.rsaPrivateKeyAccessor = rsaPrivateKeyAccessor;
    }

    public byte[] sign(RsaAlgorithms algorithm, String keyId, byte[] data) {
        try {
            Signature signature = Signature.getInstance(algorithm.getFullName());
            signature.initSign(this.rsaPrivateKeyAccessor.getPrivateKey(keyId));
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            throw new SignatureException("failed to sign", e);
        }
    }
}

