/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.model.patterns;

import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.sklsft.commons.api.exception.repository.ObjectNotFoundException;
import org.sklsft.commons.model.interfaces.Entity;
import org.sklsft.commons.model.patterns.BaseDao;

public abstract class BaseDaoImpl<T extends Entity<U>, U extends Serializable>
implements BaseDao<T, U> {
    @Inject
    protected SessionFactory sessionFactory;
    private Class<T> clazz;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public BaseDaoImpl(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public List<T> loadList() {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(this.clazz);
        return criteria.list();
    }

    @Override
    public abstract List<T> loadListEagerly();

    @Override
    public T load(U id) {
        T obj = this.get(id);
        if (obj == null) {
            throw new ObjectNotFoundException(String.valueOf(this.clazz.getSimpleName()) + ".notFound");
        }
        return obj;
    }

    @Override
    public T get(U id) {
        return (T)((Entity)this.sessionFactory.getCurrentSession().get(this.clazz, id));
    }

    @Override
    public U save(T obj) {
        return (U)this.sessionFactory.getCurrentSession().save(obj);
    }

    @Override
    public void delete(T obj) {
        this.sessionFactory.getCurrentSession().delete(obj);
    }

    @Override
    public void flush() {
        this.sessionFactory.getCurrentSession().flush();
    }

    @Override
    public void evict(T obj) {
        this.sessionFactory.getCurrentSession().evict(obj);
    }

    @Override
    public void clear() {
        this.sessionFactory.getCurrentSession().clear();
    }
}

