/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.model.patterns;

import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.sklsft.commons.api.model.OrderType;
import org.sklsft.commons.text.StringUtils;

public class HibernateCriteriaUtils {
    public static Criteria addStringContainsRestriction(Criteria criteria, String field, String value) {
        if (!StringUtils.isEmpty((Object)value)) {
            criteria = criteria.add(Restrictions.sqlRestriction((String)("normalize(" + field + ") like ?"), (Object)("%" + StringUtils.normalize((String)value) + "%"), (Type)StringType.INSTANCE));
        }
        return criteria;
    }

    public static <T extends Comparable<T>> Criteria addBetweenRestriction(Criteria criteria, String field, T minValue, T maxValue) {
        if (minValue != null) {
            criteria = criteria.add((Criterion)Restrictions.ge((String)field, minValue));
        }
        if (maxValue != null) {
            criteria = criteria.add((Criterion)Restrictions.le((String)field, maxValue));
        }
        return criteria;
    }

    public static Criteria addBooleanRestriction(Criteria criteria, String field, Boolean value) {
        if (value != null) {
            criteria = criteria.add((Criterion)Restrictions.eq((String)field, (Object)value));
        }
        return criteria;
    }

    public static Criteria addOrder(Criteria criteria, String property, OrderType orderType) {
        if (orderType != null) {
            if (orderType.equals((Object)OrderType.ASC)) {
                criteria.addOrder(Order.asc((String)property));
            } else {
                criteria.addOrder(Order.desc((String)property));
            }
        }
        return criteria;
    }
}

