/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.model.patterns;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.sklsft.commons.api.model.OrderType;
import org.sklsft.commons.text.StringUtils;

public class JpaCriteriaUtils {
    public static Predicate getStringContainsRestriction(CriteriaBuilder builder, Expression<String> expression, String value) {
        if (!StringUtils.isEmpty((Object)value)) {
            return builder.like(builder.function("normalize", String.class, new Expression[]{expression}), "%" + StringUtils.normalize((String)value) + "%");
        }
        return null;
    }

    public static void addStringContainsRestriction(CriteriaBuilder builder, List<Predicate> predicates, Expression<String> expression, String value) {
        if (!StringUtils.isEmpty((Object)value)) {
            predicates.add(builder.like(builder.function("normalize", String.class, new Expression[]{expression}), "%" + StringUtils.normalize((String)value) + "%"));
        }
    }

    public static <T extends Comparable<? super T>> void addBetweenRestriction(CriteriaBuilder builder, List<Predicate> predicates, Expression<T> expression, T minValue, T maxValue) {
        if (minValue != null) {
            predicates.add(builder.greaterThanOrEqualTo(expression, minValue));
        }
        if (maxValue != null) {
            predicates.add(builder.lessThanOrEqualTo(expression, maxValue));
        }
    }

    public static void addBooleanRestriction(CriteriaBuilder builder, List<Predicate> predicates, Expression<Boolean> expression, Boolean value) {
        if (value != null) {
            predicates.add(builder.equal(expression, (Object)value));
        }
    }

    public static void addEqualsRestriction(CriteriaBuilder builder, List<Predicate> predicates, Expression<?> expression, Object value) {
        if (value != null) {
            predicates.add(builder.equal(expression, value));
        } else {
            predicates.add(builder.isNull(expression));
        }
    }

    public static void addEqualsIfNotNullRestriction(CriteriaBuilder builder, List<Predicate> predicates, Expression<?> expression, Object value) {
        if (value != null) {
            predicates.add(builder.equal(expression, value));
        }
    }

    public static void addOrder(CriteriaBuilder builder, List<Order> orders, Expression<?> expression, OrderType orderType) {
        if (orderType != null) {
            if (orderType.equals((Object)OrderType.ASC)) {
                orders.add(builder.asc(expression));
            } else {
                orders.add(builder.desc(expression));
            }
        }
    }
}

