/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.model.patterns;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.sklsft.commons.api.exception.repository.ObjectNotFoundException;
import org.sklsft.commons.api.model.OrderType;
import org.sklsft.commons.model.interfaces.Entity;
import org.sklsft.commons.model.patterns.BaseDao;
import org.sklsft.commons.model.patterns.JpaCriteriaUtils;

public abstract class BaseDaoImpl<T extends Entity<U>, U extends Serializable>
implements BaseDao<T, U> {
    @Inject
    protected SessionFactory sessionFactory;
    private Class<T> clazz;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public BaseDaoImpl(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Long count() {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root root = criteria.from(this.clazz);
        criteria.select((Selection)builder.count((Expression)root));
        return (Long)session.createQuery(criteria).getSingleResult();
    }

    @Override
    public List<T> loadList() {
        Session session = this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.clazz);
        Root root = criteria.from(this.clazz);
        criteria.select((Selection)root);
        ArrayList<Order> orders = new ArrayList<Order>();
        JpaCriteriaUtils.addOrder(builder, orders, root.get("id"), OrderType.DESC);
        criteria.orderBy(orders);
        return session.createQuery(criteria).getResultList();
    }

    @Override
    public abstract List<T> loadListEagerly();

    @Override
    public T load(U id) {
        T obj = this.get(id);
        if (obj == null) {
            throw new ObjectNotFoundException(this.clazz.getSimpleName() + ".notFound");
        }
        return obj;
    }

    @Override
    public T get(U id) {
        return (T)((Entity)this.sessionFactory.getCurrentSession().get(this.clazz, id));
    }

    @Override
    public U save(T obj) {
        return (U)this.sessionFactory.getCurrentSession().save(obj);
    }

    @Override
    public void delete(T obj) {
        this.sessionFactory.getCurrentSession().delete(obj);
    }

    @Override
    public void flush() {
        this.sessionFactory.getCurrentSession().flush();
    }

    @Override
    public void evict(T obj) {
        this.sessionFactory.getCurrentSession().evict(obj);
    }

    @Override
    public void clear() {
        this.sessionFactory.getCurrentSession().clear();
    }
}

