/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.jms.aspect.logging;

import java.lang.reflect.Method;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.sklsft.commons.log.AccessLogger;
import org.sklsft.commons.log.aspects.LoggingAspectTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.jms.annotation.JmsListener;

@Aspect
@Order(value=2)
public class JmsLoggingAspect
extends LoggingAspectTemplate {
    private static final Logger logger = LoggerFactory.getLogger(AccessLogger.class);

    protected Object getRequestBody(ProceedingJoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        try {
            for (Object arg : args) {
                if (arg instanceof TextMessage) {
                    return ((TextMessage)arg).getText();
                }
                if (!(arg instanceof BytesMessage)) continue;
                BytesMessage message = (BytesMessage)arg;
                int lentgh = (int)message.getBodyLength();
                byte[] content = new byte[lentgh];
                message.readBytes(content);
                return new String(content);
            }
            logger.warn("could not get message content due to missing message argument");
            return null;
        }
        catch (JMSException e) {
            logger.error("could not get message content : " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected Object getResponseBody(Object proceed) {
        return null;
    }

    @Pointcut(value="@annotation(org.springframework.jms.annotation.JmsListener)")
    protected void onPointcut() {
    }

    protected String getFallbackTransactionType(Method proxiedMethod) {
        return proxiedMethod.getAnnotation(JmsListener.class).destination();
    }
}

