/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.log;

import java.io.IOException;
import org.sklsft.commons.api.exception.TechnicalError;
import org.sklsft.commons.crypto.serialization.Serializer;
import org.sklsft.commons.log.AccessLogMessage;
import org.sklsft.commons.log.InterfaceCallLogMessage;
import org.sklsft.commons.log.TransactionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogger {
    private static final Logger logger = LoggerFactory.getLogger((String)"ACCESS_LOG");
    private Serializer serializer;

    public AccessLogger(Serializer serializer) {
        this.serializer = serializer;
    }

    public void logRequest(String transactionType, String message, Object requestPayload) {
        AccessLogMessage accessMessage = new AccessLogMessage();
        accessMessage.setTransactionStage(TransactionStage.REQUEST);
        accessMessage.setTransactionType(transactionType);
        accessMessage.setMessage(message);
        accessMessage.setRequestPayload(requestPayload);
        try {
            String serialized = this.serializer.serialize((Object)accessMessage);
            logger.info(serialized);
        }
        catch (IOException e) {
            throw new TechnicalError("failed to log request : " + e.getMessage());
        }
    }

    public void logResponse(String transactionType, String message, Object responsePayload, Long responseTimeMillis, String responseStatus, String responseLabel) {
        AccessLogMessage accessMessage = new AccessLogMessage();
        accessMessage.setTransactionStage(TransactionStage.RESPONSE);
        accessMessage.setTransactionType(transactionType);
        accessMessage.setMessage(message);
        accessMessage.setResponsePayload(responsePayload);
        accessMessage.setResponseTimeMillis(responseTimeMillis);
        accessMessage.setResponseStatus(responseStatus);
        accessMessage.setResponseLabel(responseLabel);
        try {
            String serialized = this.serializer.serialize((Object)accessMessage);
            logger.info(serialized);
        }
        catch (IOException e) {
            throw new TechnicalError("failed to log response : " + e.getMessage());
        }
    }

    public void logInterfaceCall(String interfaceName, String interfaceChannel, Object sentPayload) {
        InterfaceCallLogMessage accessMessage = new InterfaceCallLogMessage();
        accessMessage.setTransactionStage(TransactionStage.INTERFACE_CALL);
        accessMessage.setInterfaceName(interfaceName);
        accessMessage.setInterfaceChannel(interfaceChannel);
        accessMessage.setSentPayload(sentPayload);
        try {
            String serialized = this.serializer.serialize((Object)accessMessage);
            logger.info(serialized);
        }
        catch (IOException e) {
            throw new TechnicalError("failed to log request : " + e.getMessage());
        }
    }

    public void logInterfaceCallback(String interfaceName, String interfaceChannel, Object receivedPayload, Long responseTimeMillis, String responseStatus, String responseLabel) {
        InterfaceCallLogMessage accessMessage = new InterfaceCallLogMessage();
        accessMessage.setTransactionStage(TransactionStage.INTERFACE_CALLBACK);
        accessMessage.setInterfaceName(interfaceName);
        accessMessage.setInterfaceChannel(interfaceChannel);
        accessMessage.setReceivedPayload(receivedPayload);
        accessMessage.setResponseTimeMillis(responseTimeMillis);
        accessMessage.setResponseStatus(responseStatus);
        accessMessage.setResponseLabel(responseLabel);
        try {
            String serialized = this.serializer.serialize((Object)accessMessage);
            logger.info(serialized);
        }
        catch (IOException e) {
            throw new TechnicalError("failed to log request : " + e.getMessage());
        }
    }
}

