/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.log;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.sklsft.commons.api.exception.ApplicationException;
import org.sklsft.commons.api.exception.TechnicalError;
import org.sklsft.commons.crypto.serialization.Serializer;
import org.sklsft.commons.log.ErrorLogMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLogger {
    private static final Logger logger = LoggerFactory.getLogger((String)"ERROR_LOG");
    private Serializer serializer;

    public ErrorLogger(Serializer serializer) {
        this.serializer = serializer;
    }

    public void logApplicationException(ApplicationException e) {
        ErrorLogMessage errorLogMessage = new ErrorLogMessage();
        errorLogMessage.setErrorStatus(e.getHttpErrorCode());
        errorLogMessage.setErrorLabel(e.getMessage());
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        errorLogMessage.setErrorTrace(stringWriter.toString());
        try {
            String serialized = this.serializer.serialize((Object)errorLogMessage);
            logger.error(serialized);
        }
        catch (IOException ioe) {
            throw new TechnicalError("failed to log request : " + ioe.getMessage(), (Throwable)e);
        }
    }

    public void logException(Exception e) {
        ErrorLogMessage errorLogMessage = new ErrorLogMessage();
        errorLogMessage.setErrorStatus("500");
        errorLogMessage.setErrorLabel(e.getMessage());
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        errorLogMessage.setErrorTrace(stringWriter.toString());
        try {
            String serialized = this.serializer.serialize((Object)errorLogMessage);
            logger.error(serialized);
        }
        catch (IOException ioe) {
            throw new TechnicalError("failed to log request : " + ioe.getMessage(), (Throwable)e);
        }
    }
}

