/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.log.aspects;

import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.sklsft.commons.log.context.RequestChannels;
import org.sklsft.commons.log.context.RequestContext;
import org.sklsft.commons.log.context.RequestContextHolder;
import org.sklsft.commons.text.StringUtils;

public abstract class RequestContextAspectTemplate {
    private RequestChannels channel;

    public RequestContextAspectTemplate(RequestChannels channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="onPointcut()")
    public Object handle(ProceedingJoinPoint joinPoint) throws Throwable {
        String transactionId = UUID.randomUUID().toString();
        String correlationId = this.getCorrelationId((JoinPoint)joinPoint);
        if (StringUtils.isEmpty((Object)correlationId)) {
            correlationId = transactionId;
        }
        RequestContextHolder.bind(new RequestContext(transactionId, correlationId, this.channel));
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            RequestContextHolder.unbind();
        }
    }

    protected abstract void onPointcut();

    protected abstract String getCorrelationId(JoinPoint var1);
}

