/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.log.aspects;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.sklsft.commons.aop.AspectJUtils;
import org.sklsft.commons.log.AccessLogger;
import org.sklsft.commons.log.aspects.annotations.ClientLoggingInterceptorPointcut;
import org.sklsft.commons.log.aspects.annotations.LoggingAspectPointcut;
import org.sklsft.commons.log.context.RequestChannels;
import org.sklsft.commons.text.StringUtils;

public abstract class OneWayPublisherLoggingInterceptorTemplate {
    private RequestChannels interfaceChannel;
    private AccessLogger accessLogger;
    private boolean traceSentBody = true;

    public void setAccessLogger(AccessLogger accessLogger) {
        this.accessLogger = accessLogger;
    }

    public void setTraceSentBody(boolean traceSentBody) {
        this.traceSentBody = traceSentBody;
    }

    public OneWayPublisherLoggingInterceptorTemplate(RequestChannels interfaceChannel) {
        this.interfaceChannel = interfaceChannel;
    }

    @Around(value="onPointcut()")
    public Object handleLogging(ProceedingJoinPoint joinPoint) throws Throwable {
        Method proxiedMethod = AspectJUtils.getProxiedMethodImplementation((ProceedingJoinPoint)joinPoint);
        String transactionType = this.getTransactionType(proxiedMethod);
        Object body = null;
        if (this.traceSentBody(proxiedMethod)) {
            body = this.getSentBody(joinPoint);
        }
        Object proceed = joinPoint.proceed();
        this.accessLogger.logInterfaceCall(transactionType, this.interfaceChannel, body);
        return proceed;
    }

    protected abstract void onPointcut();

    protected abstract Object getSentBody(ProceedingJoinPoint var1);

    protected boolean traceSentBody(Method proxiedMethod) {
        boolean result = this.traceSentBody;
        if (result && proxiedMethod.isAnnotationPresent(ClientLoggingInterceptorPointcut.class)) {
            result = proxiedMethod.getAnnotation(ClientLoggingInterceptorPointcut.class).traceSentBody();
        }
        return result;
    }

    private String getTransactionType(Method proxiedMethod) {
        String result = null;
        if (proxiedMethod.isAnnotationPresent(LoggingAspectPointcut.class)) {
            result = proxiedMethod.getAnnotation(LoggingAspectPointcut.class).value();
        }
        if (StringUtils.isEmpty(result)) {
            return this.getFallbackTransactionType(proxiedMethod);
        }
        return result;
    }

    protected abstract String getFallbackTransactionType(Method var1);
}

