/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.log;

import org.sklsft.commons.log.AccessLogMessage;
import org.sklsft.commons.log.InterfaceCallLogMessage;
import org.sklsft.commons.log.TransactionStage;
import org.sklsft.commons.log.context.RequestChannels;
import org.sklsft.commons.text.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogger {
    private static final Logger logger = LoggerFactory.getLogger((String)"ACCESS_LOG");
    private static final Logger classLogger = LoggerFactory.getLogger(AccessLogger.class);
    private Serializer serializer;

    public AccessLogger(Serializer serializer) {
        this.serializer = serializer;
    }

    public void logRequest(String transactionType, Object requestBody) {
        AccessLogMessage accessMessage = new AccessLogMessage();
        accessMessage.setTransactionStage(TransactionStage.REQUEST);
        accessMessage.setTransactionType(transactionType);
        if (requestBody != null) {
            if (String.class.isAssignableFrom(requestBody.getClass())) {
                accessMessage.setRequestBody((String)requestBody);
            } else {
                accessMessage.setRequestBody(this.serializer.serialize(requestBody));
            }
        }
        try {
            String serialized = this.serializer.serialize((Object)accessMessage);
            logger.info(serialized);
        }
        catch (Exception e) {
            classLogger.error("failed to log request : " + e.getMessage(), (Throwable)e);
        }
    }

    public void logResponse(String transactionType, Object responseBody, Long responseTimeMillis, String responseStatus, String responseLabel) {
        AccessLogMessage accessMessage = new AccessLogMessage();
        accessMessage.setTransactionStage(TransactionStage.RESPONSE);
        accessMessage.setTransactionType(transactionType);
        if (responseBody != null) {
            if (String.class.isAssignableFrom(responseBody.getClass())) {
                accessMessage.setRequestBody((String)responseBody);
            } else {
                accessMessage.setRequestBody(this.serializer.serialize(responseBody));
            }
        }
        accessMessage.setResponseTimeMillis(responseTimeMillis);
        accessMessage.setResponseStatus(responseStatus);
        accessMessage.setResponseLabel(responseLabel);
        try {
            String serialized = this.serializer.serialize((Object)accessMessage);
            logger.info(serialized);
        }
        catch (Exception e) {
            classLogger.error("failed to log response : " + e.getMessage(), (Throwable)e);
        }
    }

    public void logInterfaceCall(String interfaceName, RequestChannels interfaceChannel, Object sentBody) {
        InterfaceCallLogMessage accessMessage = new InterfaceCallLogMessage();
        accessMessage.setTransactionStage(TransactionStage.INTERFACE_CALL);
        accessMessage.setInterfaceName(interfaceName);
        accessMessage.setInterfaceChannel(interfaceChannel);
        if (sentBody != null) {
            if (String.class.isAssignableFrom(sentBody.getClass())) {
                accessMessage.setSentBody((String)sentBody);
            } else {
                accessMessage.setSentBody(this.serializer.serialize(sentBody));
            }
        }
        try {
            String serialized = this.serializer.serialize((Object)accessMessage);
            logger.info(serialized);
        }
        catch (Exception e) {
            classLogger.error("failed to log interface call : " + e.getMessage(), (Throwable)e);
        }
    }

    public void logInterfaceAnswer(String interfaceName, RequestChannels interfaceChannel, Object receivedBody, Long responseTimeMillis, String responseStatus, String responseLabel) {
        InterfaceCallLogMessage accessMessage = new InterfaceCallLogMessage();
        accessMessage.setTransactionStage(TransactionStage.INTERFACE_ANSWER);
        accessMessage.setInterfaceName(interfaceName);
        accessMessage.setInterfaceChannel(interfaceChannel);
        if (receivedBody != null) {
            if (String.class.isAssignableFrom(receivedBody.getClass())) {
                accessMessage.setReceivedBody((String)receivedBody);
            } else {
                accessMessage.setReceivedBody(this.serializer.serialize(receivedBody));
            }
        }
        accessMessage.setResponseTimeMillis(responseTimeMillis);
        accessMessage.setResponseStatus(responseStatus);
        accessMessage.setResponseLabel(responseLabel);
        try {
            String serialized = this.serializer.serialize((Object)accessMessage);
            logger.info(serialized);
        }
        catch (Exception e) {
            classLogger.error("failed to log interface answer : " + e.getMessage(), (Throwable)e);
        }
    }
}

