/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.log.context;

import org.sklsft.commons.log.context.RequestContext;
import org.slf4j.MDC;

public class RequestContextHolder {
    private static final String TRANSACTION_ID = "transactionId";
    private static final String CORRELATION_ID = "correlationId";
    private static final String CHANNEL = "channel";
    private static ThreadLocal<RequestContext> allContexts = new ThreadLocal();

    public static void bind(RequestContext context) {
        allContexts.set(context);
        MDC.put((String)TRANSACTION_ID, (String)context.getTransactionId());
        MDC.put((String)CORRELATION_ID, (String)context.getCorrelationId());
        MDC.put((String)CHANNEL, context.getChannel() != null ? context.getChannel().name() : null);
    }

    public static void unbind() {
        allContexts.remove();
        MDC.remove((String)TRANSACTION_ID);
        MDC.remove((String)CORRELATION_ID);
        MDC.remove((String)CHANNEL);
    }

    public static RequestContext getContextOrNull() {
        return allContexts.get();
    }
}

