/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.log.aspects;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.sklsft.commons.aop.AspectJUtils;
import org.sklsft.commons.api.exception.ApplicationException;
import org.sklsft.commons.log.AccessLogger;
import org.sklsft.commons.log.ErrorLogger;
import org.sklsft.commons.log.aspects.annotations.LoggingAspectPointcut;
import org.sklsft.commons.text.StringUtils;

public abstract class LoggingAspectTemplate {
    protected AccessLogger accessLogger;
    protected ErrorLogger errorLogger;
    private boolean traceRequestBody = true;
    private boolean traceResponseBody = true;

    public void setAccessLogger(AccessLogger accessLogger) {
        this.accessLogger = accessLogger;
    }

    public void setErrorLogger(ErrorLogger errorLogger) {
        this.errorLogger = errorLogger;
    }

    public void setTraceRequestBody(boolean traceRequestBody) {
        this.traceRequestBody = traceRequestBody;
    }

    public void setTraceResponseBody(boolean traceResponseBody) {
        this.traceResponseBody = traceResponseBody;
    }

    @Around(value="onPointcut()")
    public Object handleLogging(ProceedingJoinPoint joinPoint) throws Throwable {
        long start = System.currentTimeMillis();
        Method proxiedMethod = AspectJUtils.getProxiedMethodImplementation((ProceedingJoinPoint)joinPoint);
        String transactionType = this.getTransactionType(proxiedMethod);
        Object body = null;
        if (this.traceRequestBody(proxiedMethod)) {
            body = this.getRequestBody(joinPoint);
        }
        this.accessLogger.logRequest(transactionType, body);
        try {
            Object proceed = joinPoint.proceed();
            long elapsedTime = System.currentTimeMillis() - start;
            Object responseBody = null;
            if (this.traceResponseBody(proxiedMethod)) {
                responseBody = this.getResponseBody(proceed);
            }
            this.accessLogger.logResponse(transactionType, responseBody, elapsedTime, "200", "OK");
            return proceed;
        }
        catch (ApplicationException e) {
            long elapsedTime = System.currentTimeMillis() - start;
            this.accessLogger.logResponse(transactionType, null, elapsedTime, e.getHttpErrorCode(), e.getMessage());
            this.errorLogger.logApplicationException(e);
            throw e;
        }
        catch (Exception e) {
            long elapsedTime = System.currentTimeMillis() - start;
            this.accessLogger.logResponse(transactionType, null, elapsedTime, "500", e.getMessage());
            this.errorLogger.logException(e);
            throw e;
        }
    }

    protected Object getResponseBody(Object proceed) {
        return proceed;
    }

    protected abstract void onPointcut();

    protected abstract Object getRequestBody(ProceedingJoinPoint var1);

    protected boolean traceRequestBody(Method proxiedMethod) {
        boolean result = this.traceRequestBody;
        if (result && proxiedMethod.isAnnotationPresent(LoggingAspectPointcut.class)) {
            result = proxiedMethod.getAnnotation(LoggingAspectPointcut.class).traceRequestBody();
        }
        return result;
    }

    protected boolean traceResponseBody(Method proxiedMethod) {
        boolean result = this.traceResponseBody;
        if (result && proxiedMethod.isAnnotationPresent(LoggingAspectPointcut.class)) {
            result = proxiedMethod.getAnnotation(LoggingAspectPointcut.class).traceResponseBody();
        }
        return result;
    }

    private String getTransactionType(Method proxiedMethod) {
        String result = null;
        if (proxiedMethod.isAnnotationPresent(LoggingAspectPointcut.class)) {
            result = proxiedMethod.getAnnotation(LoggingAspectPointcut.class).value();
        }
        if (StringUtils.isEmpty(result)) {
            return this.getFallbackTransactionType(proxiedMethod);
        }
        return result;
    }

    protected abstract String getFallbackTransactionType(Method var1);
}

