/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mapper.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.sklsft.commons.mapper.beans.AccessibleField;
import org.sklsft.commons.mapper.beans.MappableBean;

public class MappableBeanFactory {
    public static <T> MappableBean<T> getMappableBean(Class<T> beanClass) {
        MappableBean bean = new MappableBean();
        bean.beanClass = beanClass;
        bean.accessibleFields = MappableBeanFactory.getAccessibleFields(beanClass);
        return bean;
    }

    private static Map<String, AccessibleField> getAccessibleFields(Class<?> beanClass) {
        Field[] fields;
        HashMap<String, AccessibleField> result = new HashMap<String, AccessibleField>();
        for (Field field : fields = beanClass.getDeclaredFields()) {
            try {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), beanClass);
                if (propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null) continue;
                result.put(field.getName(), new AccessibleField(field, propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod()));
            }
            catch (IntrospectionException e) {
                // empty catch block
            }
        }
        return result;
    }
}

