/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mapper.beans;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class AccessibleField {
    public Field field;
    public Method getter;
    public Method setter;
    public List<Class<?>> genericParameters;

    public AccessibleField(Field field, Method getter, Method setter) {
        this.field = field;
        this.getter = getter;
        this.setter = setter;
        this.genericParameters = this.getGenericParameters();
    }

    public Object getValue(Object object) {
        try {
            return this.getter.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setValue(Object fieldValue, Object object) {
        try {
            this.setter.invoke(object, fieldValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isCompatibleWith(AccessibleField field2) {
        if (this.isParameterized()) {
            return false;
        }
        if (field2.isParameterized()) {
            return false;
        }
        return field2.field.getType().equals(this.field.getType());
    }

    private List<Class<?>> getGenericParameters() {
        ArrayList result = new ArrayList(1);
        if (this.isParameterized()) {
            Type[] types;
            ParameterizedType parameterizedType = (ParameterizedType)this.setter.getGenericParameterTypes()[0];
            Type[] typeArray = types = parameterizedType.getActualTypeArguments();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                result.add((Class)type);
                ++n2;
            }
        }
        return result;
    }

    public boolean isIterable() {
        return Iterable.class.isAssignableFrom(this.field.getType());
    }

    public Class<?> getIterableClass() {
        return this.genericParameters.get(0);
    }

    public boolean isParameterized() {
        return this.field.getType().getTypeParameters().length > 0;
    }
}

