/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mapper.impl;

import org.sklsft.commons.mapper.beans.AccessibleField;
import org.sklsft.commons.mapper.beans.MappableBean;
import org.sklsft.commons.mapper.beans.MappableBeanFactory;
import org.sklsft.commons.mapper.interfaces.Mapper;

public class BasicMapperImpl<T, U>
implements Mapper<T, U> {
    private final MappableBean<T> mappableBean1;
    private final MappableBean<U> mappableBean2;

    public BasicMapperImpl(Class<T> clazz1, Class<U> clazz2) {
        this.mappableBean1 = MappableBeanFactory.getMappableBean(clazz1);
        this.mappableBean2 = MappableBeanFactory.getMappableBean(clazz2);
    }

    @Override
    public T mapFrom(T obj1, U obj2) {
        for (AccessibleField field1 : this.mappableBean1.accessibleFieldsMap.values()) {
            String fieldName = field1.field.getName();
            AccessibleField field2 = this.mappableBean2.accessibleFieldsMap.get(fieldName);
            if (field2 == null || !field1.isCompatibleWith(field2)) continue;
            field1.setValue(field2.getValue(obj2), obj1);
        }
        return obj1;
    }

    @Override
    public U mapTo(T obj1, U obj2) {
        for (AccessibleField field2 : this.mappableBean2.accessibleFieldsMap.values()) {
            String fieldName = field2.field.getName();
            AccessibleField field1 = this.mappableBean1.accessibleFieldsMap.get(fieldName);
            if (field1 == null || !field2.isCompatibleWith(field1)) continue;
            field2.setValue(field1.getValue(obj1), obj2);
        }
        return obj2;
    }
}

