/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mapper.impl;

import org.sklsft.commons.api.exception.TechnicalError;
import org.sklsft.commons.mapper.interfaces.Mapper;

public abstract class AbstractMapper<T, U>
implements Mapper<T, U> {
    private Class<T> clazz1;
    private Class<U> clazz2;

    public AbstractMapper(Class<T> clazz1, Class<U> clazz2) {
        this.clazz1 = clazz1;
        this.clazz2 = clazz2;
    }

    public Class<T> getClazz1() {
        return this.clazz1;
    }

    public Class<U> getClazz2() {
        return this.clazz2;
    }

    @Override
    public abstract T mapFrom(T var1, U var2);

    @Override
    public T mapFrom(U obj2) {
        try {
            return this.mapFrom(this.clazz1.newInstance(), obj2);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TechnicalError("error.unknown", (Throwable)e);
        }
    }

    @Override
    public abstract U mapTo(T var1, U var2);

    @Override
    public U mapTo(T obj1) {
        try {
            return this.mapTo(obj1, this.clazz2.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TechnicalError("error.unknown", (Throwable)e);
        }
    }
}

