/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mapper.impl;

import java.util.Iterator;
import org.sklsft.commons.api.annotations.compare.DeepCompare;
import org.sklsft.commons.mapper.beans.AccessibleField;
import org.sklsft.commons.mapper.impl.DeepComparator;

public class AccessibleFieldComparator {
    private final AccessibleField accessibleField;

    public AccessibleFieldComparator(AccessibleField accessibleField) {
        this.accessibleField = accessibleField;
    }

    public boolean areEqual(Object obj1, Object obj2) {
        Object val1 = this.accessibleField.getValue(obj1);
        Object val2 = this.accessibleField.getValue(obj2);
        if (val1 == null) {
            return val2 == null;
        }
        if (val2 == null) {
            return val1 == null;
        }
        Class<?> clazz = this.accessibleField.field.getType();
        if (this.accessibleField.field.isAnnotationPresent(DeepCompare.class)) {
            if (this.accessibleField.isIterable()) {
                Class<?> iterableClass = this.accessibleField.getIterableClass();
                return this.areIteratorsDeeplyEqual(iterableClass, ((Iterable)val1).iterator(), ((Iterable)val2).iterator());
            }
            DeepComparator deepComparator = new DeepComparator(clazz);
            return deepComparator.areEqual(val1, val2);
        }
        if (this.accessibleField.isIterable()) {
            return this.areIteratorsEqual(((Iterable)val1).iterator(), ((Iterable)val2).iterator());
        }
        return val1.equals(val2);
    }

    private boolean areIteratorsDeeplyEqual(Class<?> iterableClass, Iterator ite1, Iterator ite2) {
        DeepComparator deepComparator = new DeepComparator(iterableClass);
        while (ite1.hasNext()) {
            Object obj2;
            if (!ite2.hasNext()) {
                return false;
            }
            Object obj1 = ite1.next();
            if (deepComparator.areEqual(obj1, obj2 = ite2.next())) continue;
            return false;
        }
        return true;
    }

    private boolean areIteratorsEqual(Iterator ite1, Iterator ite2) {
        while (ite1.hasNext()) {
            Object obj2;
            if (!ite2.hasNext()) {
                return false;
            }
            Object obj1 = ite1.next();
            if (obj1.equals(obj2 = ite2.next())) continue;
            return false;
        }
        return true;
    }
}

