/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mapper.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sklsft.commons.api.annotations.compare.Deep;
import org.sklsft.commons.api.annotations.compare.Ignored;
import org.sklsft.commons.mapper.beans.AccessibleField;
import org.sklsft.commons.mapper.beans.MappableBean;
import org.sklsft.commons.mapper.beans.MappableBeanFactory;
import org.sklsft.commons.mapper.interfaces.Copier;

public class DeepCopier<T>
implements Copier<T> {
    private final MappableBean<T> mappableBean;
    private Class<T> clazz;
    private Map<Class<?>, Copier<?>> copiers = new HashMap();

    public DeepCopier(Class<T> clazz) {
        this.clazz = clazz;
        this.mappableBean = MappableBeanFactory.getMappableBean(clazz);
    }

    @Override
    public T copy(Object src, boolean copyIgnoredFields) {
        T dest;
        if (src == null) {
            return null;
        }
        if (!this.clazz.isAssignableFrom(src.getClass())) {
            throw new IllegalArgumentException("Cannot copy an instance of : " + src.getClass().getName() + " in a : " + this.clazz.getName());
        }
        try {
            dest = this.clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate a : " + this.clazz.getName());
        }
        for (AccessibleField accessibleField : this.mappableBean.accessibleFields) {
            if (!copyIgnoredFields && accessibleField.field.isAnnotationPresent(Ignored.class)) continue;
            if (accessibleField.field.isAnnotationPresent(Deep.class)) {
                Copier<?> copier;
                if (accessibleField.isCollection) {
                    copier = this.getCopier(accessibleField.genericParameters.get(0));
                    Collection srcCollection = (Collection)accessibleField.getValue(src);
                    try {
                        Collection destCollection = (Collection)srcCollection.getClass().newInstance();
                        for (Object e : srcCollection) {
                            destCollection.add(copier.copy(e, copyIgnoredFields));
                        }
                        accessibleField.setValue(destCollection, dest);
                        continue;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Cannot instantiate a : " + srcCollection.getClass().getName());
                    }
                }
                if (accessibleField.isMap) {
                    copier = this.getCopier(accessibleField.genericParameters.get(1));
                    Map srcMap = (Map)accessibleField.getValue(src);
                    try {
                        Map destMap = (Map)srcMap.getClass().newInstance();
                        Iterator iterator = srcMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry;
                            Map.Entry entry2 = entry = iterator.next();
                            destMap.put(entry2.getKey(), copier.copy(entry2.getValue()));
                        }
                        accessibleField.setValue(destMap, dest);
                        continue;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Cannot instantiate a : " + srcMap.getClass().getName());
                    }
                }
                Class<?> fieldClass = accessibleField.fieldClass;
                Copier<?> copier2 = this.getCopier(fieldClass);
                accessibleField.setValue(copier2.copy(accessibleField.getValue(src), copyIgnoredFields), dest);
                continue;
            }
            if (accessibleField.isCollection) {
                Collection srcCollection = (Collection)accessibleField.getValue(src);
                try {
                    Collection destCollection = (Collection)srcCollection.getClass().newInstance();
                    for (Object e : srcCollection) {
                        destCollection.add(e);
                    }
                    accessibleField.setValue(destCollection, dest);
                    continue;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException("Cannot instantiate a : " + srcCollection.getClass().getName());
                }
            }
            if (accessibleField.isMap) {
                Map srcMap = (Map)accessibleField.getValue(src);
                try {
                    Map destMap = (Map)srcMap.getClass().newInstance();
                    for (Object object : srcMap.entrySet()) {
                        Map.Entry entry = (Map.Entry)object;
                        destMap.put(entry.getKey(), entry.getValue());
                    }
                    accessibleField.setValue(destMap, dest);
                    continue;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException("Cannot instantiate a : " + srcMap.getClass().getName());
                }
            }
            accessibleField.setValue(accessibleField.getValue(src), dest);
        }
        return dest;
    }

    @Override
    public T copy(Object src) {
        return this.copy(src, false);
    }

    private Copier<?> getCopier(Class<?> clazz) {
        if (!this.copiers.containsKey(clazz)) {
            this.copiers.put(clazz, new DeepCopier(clazz));
        }
        return this.copiers.get(clazz);
    }
}

