/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mapper.impl;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.sklsft.commons.mapper.beans.AccessibleField;
import org.sklsft.commons.mapper.beans.MappableBean;
import org.sklsft.commons.mapper.beans.MappableBeanFactory;
import org.sklsft.commons.mapper.interfaces.ObjectArrayToBeanMapper;

public class ObjectArrayToBeanMapperImpl<T>
implements ObjectArrayToBeanMapper<T> {
    private final MappableBean<T> mappableBean;

    public ObjectArrayToBeanMapperImpl(Class<T> clazz) {
        this.mappableBean = MappableBeanFactory.getMappableBean(clazz);
    }

    @Override
    public T mapFrom(T obj, Object[] objectArray, int startField) {
        for (int i = 0; i < objectArray.length; ++i) {
            AccessibleField accessibleField = this.mappableBean.accessibleFields.get(i + startField);
            Object value = objectArray[i];
            if (Long.class.isAssignableFrom(accessibleField.fieldClass) && BigDecimal.class.isAssignableFrom(value.getClass())) {
                value = ((BigDecimal)value).longValue();
            }
            if (Integer.class.isAssignableFrom(accessibleField.fieldClass) && BigDecimal.class.isAssignableFrom(value.getClass())) {
                value = ((BigDecimal)value).intValue();
            }
            if (Short.class.isAssignableFrom(accessibleField.fieldClass) && BigDecimal.class.isAssignableFrom(value.getClass())) {
                value = ((BigDecimal)value).shortValue();
            }
            if (Boolean.class.isAssignableFrom(accessibleField.fieldClass) && BigDecimal.class.isAssignableFrom(value.getClass())) {
                value = ((BigDecimal)value).shortValue() > 0;
            }
            if (LocalDate.class.isAssignableFrom(accessibleField.fieldClass) && Date.class.isAssignableFrom(value.getClass())) {
                value = ((Date)value).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            accessibleField.setValue(value, obj);
        }
        return obj;
    }

    @Override
    public T mapFrom(T obj, Object[] objectArray) {
        return this.mapFrom(obj, objectArray, 0);
    }
}

