/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mapper.impl;

import org.sklsft.commons.mapper.beans.AccessibleField;
import org.sklsft.commons.mapper.beans.MappableBean;
import org.sklsft.commons.mapper.beans.MappableBeanFactory;
import org.sklsft.commons.mapper.impl.DbObjectToObjectConverter;
import org.sklsft.commons.mapper.interfaces.ObjectArrayToBeanMapper;

public class ObjectArrayToBeanMapperImpl<T>
implements ObjectArrayToBeanMapper<T> {
    private final MappableBean<T> mappableBean;

    public ObjectArrayToBeanMapperImpl(Class<T> clazz) {
        this.mappableBean = MappableBeanFactory.getMappableBean(clazz);
    }

    @Override
    public T mapFrom(T obj, Object[] objectArray, int startField) {
        for (int i = 0; i < objectArray.length; ++i) {
            AccessibleField accessibleField = this.mappableBean.accessibleFields.get(i + startField);
            Object dbValue = objectArray[i];
            Object value = DbObjectToObjectConverter.getObjectFromDbObject(dbValue, accessibleField.fieldClass);
            accessibleField.setValue(value, obj);
        }
        return obj;
    }

    @Override
    public T mapFrom(T obj, Object[] objectArray) {
        return this.mapFrom(obj, objectArray, 0);
    }
}

