/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mapper.beans;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AccessibleField {
    public Field field;
    public Method getter;
    public Method setter;
    public Class<?> fieldClass;
    public boolean isParameterized;
    public List<Class<?>> genericParameters;
    public boolean isList;
    public boolean isSet;
    public boolean isCollection;
    public boolean isMap;

    public AccessibleField(Field field, Method getter, Method setter) {
        this.field = field;
        this.getter = getter;
        this.setter = setter;
        this.fieldClass = field.getType();
        this.isParameterized = this.isParameterized();
        this.genericParameters = this.getGenericParameters();
        this.isList = this.isList();
        this.isSet = this.isSet();
        this.isCollection = this.isList || this.isSet;
        this.isMap = this.isMap();
    }

    public Object getValue(Object object) {
        try {
            return this.getter.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setValue(Object fieldValue, Object object) {
        try {
            this.setter.invoke(object, fieldValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isCompatibleWith(AccessibleField field2) {
        if (this.isParameterized()) {
            return false;
        }
        if (field2.isParameterized()) {
            return false;
        }
        return field2.field.getType().equals(this.field.getType());
    }

    private boolean isParameterized() {
        return this.field.getType().getTypeParameters().length > 0;
    }

    private List<Class<?>> getGenericParameters() {
        ArrayList result = new ArrayList(1);
        if (this.isParameterized()) {
            Type[] types;
            ParameterizedType parameterizedType = (ParameterizedType)this.setter.getGenericParameterTypes()[0];
            for (Type type : types = parameterizedType.getActualTypeArguments()) {
                result.add((Class)type);
            }
        }
        return result;
    }

    private boolean isList() {
        return List.class.isAssignableFrom(this.field.getType());
    }

    private boolean isSet() {
        return Set.class.isAssignableFrom(this.field.getType());
    }

    private boolean isMap() {
        return Map.class.isAssignableFrom(this.field.getType());
    }
}

