/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mapper.impl;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.Hibernate;
import org.sklsft.commons.api.annotations.compare.Ignored;
import org.sklsft.commons.mapper.beans.AccessibleField;
import org.sklsft.commons.mapper.beans.MappableBean;
import org.sklsft.commons.mapper.beans.MappableBeanFactory;
import org.sklsft.commons.mapper.interfaces.Copier;

public class EntityCopier<T>
implements Copier<T> {
    private final MappableBean<T> mappableBean;
    private Class<T> clazz;
    private Map<Class<?>, Copier<?>> copiers = new HashMap();

    public EntityCopier(Class<T> clazz) {
        this.clazz = clazz;
        this.mappableBean = MappableBeanFactory.getMappableBean(clazz);
    }

    @Override
    public T copy(Object src, boolean copyIgnoredFields) {
        T dest;
        if (src == null) {
            return null;
        }
        if (!this.clazz.isAssignableFrom(src.getClass())) {
            throw new IllegalArgumentException("Cannot copy an instance of : " + src.getClass().getName() + " in a : " + this.clazz.getName());
        }
        try {
            dest = this.clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate a : " + this.clazz.getName());
        }
        for (AccessibleField accessibleField : this.mappableBean.accessibleFields) {
            if (!copyIgnoredFields && accessibleField.field.isAnnotationPresent(Ignored.class) && accessibleField.field.isAnnotationPresent(Id.class)) continue;
            if (accessibleField.isSet) {
                Copier<?> copier = this.getCopier(accessibleField.genericParameters.get(0));
                Set srcCollection = (Set)accessibleField.getValue(src);
                HashSet destCollection = new HashSet();
                for (Object obj : srcCollection) {
                    destCollection.add(copier.copy(obj, copyIgnoredFields));
                }
                accessibleField.setValue(destCollection, dest);
                continue;
            }
            if (accessibleField.field.isAnnotationPresent(ManyToOne.class) || accessibleField.field.isAnnotationPresent(OneToOne.class)) {
                Hibernate.initialize((Object)accessibleField.getValue(src));
            }
            if (accessibleField.field.isAnnotationPresent(ManyToOne.class) && CascadeType.ALL.equals((Object)accessibleField.field.getAnnotation(ManyToOne.class).cascade()) || accessibleField.field.isAnnotationPresent(OneToOne.class) && CascadeType.ALL.equals((Object)accessibleField.field.getAnnotation(OneToOne.class).cascade())) {
                Class<?> fieldClass = accessibleField.fieldClass;
                Copier<?> copier = this.getCopier(fieldClass);
                accessibleField.setValue(copier.copy(accessibleField.getValue(src), copyIgnoredFields), dest);
                continue;
            }
            accessibleField.setValue(accessibleField.getValue(src), dest);
        }
        return dest;
    }

    @Override
    public T copy(Object src) {
        return this.copy(src, false);
    }

    private Copier<?> getCopier(Class<?> clazz) {
        if (!this.copiers.containsKey(clazz)) {
            this.copiers.put(clazz, new EntityCopier(clazz));
        }
        return this.copiers.get(clazz);
    }
}

