/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mvc.ajax;

import org.sklsft.commons.api.exception.ApplicationException;
import org.sklsft.commons.mvc.ajax.AjaxMethodAspect;
import org.sklsft.commons.mvc.ajax.AjaxMethodTemplate;
import org.sklsft.commons.mvc.messages.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxMethodExecutor {
    private static final Logger logger = LoggerFactory.getLogger(AjaxMethodAspect.class);
    private MessageHandler messageHandler;

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void executeAjaxMethod(String value, AjaxMethodTemplate template) {
        try {
            logger.info(value);
            Object result = template.execute();
            this.messageHandler.displayInfo(String.valueOf(value) + ".success");
            logger.info("completed");
            template.redirectOnComplete(result);
        }
        catch (ApplicationException e) {
            this.messageHandler.displayError(e.getMessage());
            logger.error("failed : " + ((Object)((Object)e)).getClass().getSimpleName() + " - " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.messageHandler.displayError(String.valueOf(value) + ".failure");
            logger.error("failed : " + e.getClass().getSimpleName() + " - " + e.getMessage(), (Throwable)e);
        }
    }
}

