/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mvc.ajax;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.sklsft.commons.api.exception.ApplicationException;
import org.sklsft.commons.mvc.annotations.AjaxMethod;
import org.sklsft.commons.mvc.messages.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AjaxMethodAspect {
    private static final Logger logger = LoggerFactory.getLogger(AjaxMethodAspect.class);
    private MessageHandler messageHandler;

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    @Pointcut(value="@annotation(org.sklsft.commons.mvc.annotations.AjaxMethod)")
    private void ajaxMethods() {
    }

    @Around(value="ajaxMethods()")
    public void execute(ProceedingJoinPoint joinPoint) throws Throwable {
        Method proxiedMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        AjaxMethod ajaxMethod = proxiedMethod.getAnnotation(AjaxMethod.class);
        String value = ajaxMethod.value();
        try {
            logger.info(value);
            joinPoint.proceed();
            this.messageHandler.displayInfo(value + ".success");
            logger.info("completed");
        }
        catch (ApplicationException e) {
            this.messageHandler.displayError(e.getMessage());
            logger.error("failed : " + ((Object)((Object)e)).getClass().getSimpleName() + " - " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.messageHandler.displayError(value + ".failure");
            logger.error("failed : " + e.getClass().getSimpleName() + " - " + e.getMessage(), (Throwable)e);
        }
    }
}

