/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mvc.ajax;

import org.sklsft.commons.api.exception.ApplicationException;
import org.sklsft.commons.api.exception.TechnicalError;
import org.sklsft.commons.log.AccessLogger;
import org.sklsft.commons.log.ErrorLogger;
import org.sklsft.commons.mvc.ajax.AjaxMethodTemplate;
import org.sklsft.commons.mvc.messages.MessageHandler;

public class AjaxMethodExecutor {
    private MessageHandler messageHandler;
    private AccessLogger accessLogger;
    private ErrorLogger errorLogger;

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void setAccessLogger(AccessLogger accessLogger) {
        this.accessLogger = accessLogger;
    }

    public void setErrorLogger(ErrorLogger errorLogger) {
        this.errorLogger = errorLogger;
    }

    public void executeAjaxMethod(String value, AjaxMethodTemplate template) {
        long start = System.currentTimeMillis();
        try {
            this.accessLogger.logRequest(value, null);
            Object result = template.execute();
            long elapsedTime = System.currentTimeMillis() - start;
            this.accessLogger.logResponse(value, null, Long.valueOf(elapsedTime), "200", "OK");
            this.messageHandler.displayInfo(value + ".success");
            template.redirectOnComplete(result);
        }
        catch (ApplicationException e) {
            long elapsedTime = System.currentTimeMillis() - start;
            this.accessLogger.logResponse(value, null, Long.valueOf(elapsedTime), e.getHttpErrorCode(), e.getMessage());
            this.errorLogger.logException((Exception)((Object)e));
            this.messageHandler.displayError(e.getMessage());
        }
        catch (Exception e) {
            long elapsedTime = System.currentTimeMillis() - start;
            this.accessLogger.logResponse(value, null, Long.valueOf(elapsedTime), "500", e.getMessage());
            this.errorLogger.logException(e);
            this.messageHandler.displayError(value + ".failure");
        }
        catch (Throwable e) {
            throw new TechnicalError("error.unknown");
        }
    }
}

