/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mvc.ajax;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.sklsft.commons.mvc.ajax.AjaxMethodExecutor;
import org.sklsft.commons.mvc.ajax.AjaxMethodTemplate;
import org.sklsft.commons.mvc.annotations.AjaxMethod;

@Aspect
public class AjaxMethodAspect {
    private AjaxMethodExecutor executor;

    public void setExecutor(AjaxMethodExecutor executor) {
        this.executor = executor;
    }

    @Pointcut(value="@annotation(org.sklsft.commons.mvc.annotations.AjaxMethod)")
    private void ajaxMethods() {
    }

    @Around(value="ajaxMethods()")
    public void execute(final ProceedingJoinPoint joinPoint) throws Throwable {
        Method proxiedMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        AjaxMethod ajaxMethod = proxiedMethod.getAnnotation(AjaxMethod.class);
        String value = ajaxMethod.value();
        this.executor.executeAjaxMethod(value, new AjaxMethodTemplate(){

            @Override
            public void redirectOnComplete(Object result) {
            }

            @Override
            public Object execute() throws Throwable {
                return joinPoint.proceed();
            }
        });
    }
}

