/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mvc.loading;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.sklsft.commons.api.exception.repository.ObjectNotFoundException;
import org.sklsft.commons.api.exception.rights.AccessDeniedException;
import org.sklsft.commons.mvc.loading.PageLoadExceptionHandler;

@Aspect
public class PageLoadAspect {
    private PageLoadExceptionHandler exceptionHandler;

    public void setExceptionHandler(PageLoadExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Around(value="@annotation(org.sklsft.commons.mvc.annotations.PageLoad)")
    public void execute(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            joinPoint.proceed();
        }
        catch (ObjectNotFoundException e) {
            this.exceptionHandler.redirectOnMissingResource();
        }
        catch (AccessDeniedException e) {
            this.exceptionHandler.redirectOnAccessDenied();
        }
        catch (Exception e) {
            this.exceptionHandler.redirectOnException();
        }
    }
}

