/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mvc.messages;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.sklsft.commons.mvc.messages.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsfMessageHandler
implements MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(JsfMessageHandler.class);

    @Override
    public void displayInfo(String message) {
        this.displayMessage(message, FacesMessage.SEVERITY_INFO);
    }

    @Override
    public void displayWarning(String message) {
        this.displayMessage(message, FacesMessage.SEVERITY_WARN);
    }

    @Override
    public void displayError(String message) {
        this.displayMessage(message, FacesMessage.SEVERITY_ERROR);
    }

    protected void displayMessage(String message, FacesMessage.Severity severity) {
        String translatedMessage = this.getTranslatedMessage(message);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(severity, translatedMessage, null));
    }

    private String getTranslatedMessage(String message) {
        if (message == null) {
            message = "error.unknown";
        }
        String translatedMessage = message;
        try {
            translatedMessage = ResourceBundle.getBundle("GlobalMessages", FacesContext.getCurrentInstance().getViewRoot().getLocale()).getString(message);
        }
        catch (MissingResourceException e) {
            logger.warn("No message found for " + message);
        }
        return translatedMessage;
    }
}

