/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.mvc.ui.converters;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.apache.commons.codec.binary.Base64;
import org.sklsft.commons.text.serialization.JsonSerializer;

public class JsonSerializingConverter<T>
implements Converter {
    private JsonSerializer serializer;
    private Class<T> clazz;

    public JsonSerializingConverter(Class<T> clazz, JsonSerializer serializer) {
        this.clazz = clazz;
        this.serializer = serializer;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        try {
            return this.serializer.deserialize(new String(Base64.decodeBase64((String)value)), this.clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return "";
        }
        try {
            return Base64.encodeBase64URLSafeString((byte[])this.serializer.serialize(value).getBytes());
        }
        catch (Exception e) {
            return "";
        }
    }
}

