/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.client.exception;

import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.sklsft.commons.api.exception.ApplicationException;
import org.sklsft.commons.api.exception.ErrorReport;
import org.sklsft.commons.api.exception.TechnicalError;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseErrorHandler;

public class ErrorReportHandler
implements ResponseErrorHandler {
    private ObjectMapper objectMapper;

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return !response.getStatusCode().equals((Object)HttpStatus.OK);
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        ErrorReport errorReport = (ErrorReport)this.objectMapper.readValue(response.getBody(), ErrorReport.class);
        this.convertErrorReport(errorReport);
    }

    private void convertErrorReport(ErrorReport errorReport) {
        ApplicationException exception;
        try {
            exception = (ApplicationException)Class.forName(errorReport.getExceptionClassName()).newInstance();
            exception.setMessage(errorReport.getMessage());
        }
        catch (Exception e) {
            exception = new TechnicalError("error.unknown");
        }
        throw exception;
    }
}

