/*
 * Decompiled with CFR 0.152.
 */
package org.sklsft.commons.rest.client.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class RestClientLoggerInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(RestClientLoggerInterceptor.class);
    private String requestIdHeaderKey = "request-id";
    private boolean handleRequestId = true;
    private boolean traceRequestHeaders = false;
    private boolean traceRequestBody = true;
    private boolean traceResponseHeaders = false;
    private boolean traceResponseBody = false;

    public void setRequestIdHeaderKey(String requestIdHeaderKey) {
        this.requestIdHeaderKey = requestIdHeaderKey;
    }

    public void setHandleRequestId(boolean handleRequestId) {
        this.handleRequestId = handleRequestId;
    }

    public void setTraceRequestHeaders(boolean traceRequestHeaders) {
        this.traceRequestHeaders = traceRequestHeaders;
    }

    public void setTraceRequestBody(boolean traceRequestBody) {
        this.traceRequestBody = traceRequestBody;
    }

    public void setTraceResponseHeaders(boolean traceResponseHeaders) {
        this.traceResponseHeaders = traceResponseHeaders;
    }

    public void setTraceResponseBody(boolean traceResponseBody) {
        this.traceResponseBody = traceResponseBody;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.traceRequest(request, body);
        long start = System.currentTimeMillis();
        ClientHttpResponse response = execution.execute(request, body);
        long elapsedTime = System.currentTimeMillis() - start;
        this.traceResponse(request, response, elapsedTime);
        return response;
    }

    private void traceRequest(HttpRequest request, byte[] body) throws IOException {
        String logged = "HTTP request sent : Method=" + request.getMethod() + ", URI=" + request.getURI();
        if (this.handleRequestId) {
            logged = logged + ", RequestId=" + (String)request.getHeaders().get((Object)this.requestIdHeaderKey).get(0);
        }
        if (this.traceRequestHeaders) {
            logged = logged + ", Headers=" + request.getHeaders();
        }
        if (this.traceRequestBody && !request.getMethod().equals((Object)HttpMethod.GET)) {
            logged = logged + ", Body=" + new String(body, "UTF-8");
        }
        logger.info(logged);
    }

    private void traceResponse(HttpRequest request, ClientHttpResponse response, long elapsedTime) throws IOException {
        String logged = "HTTP response received : Status=" + response.getStatusCode();
        logged = this.handleRequestId ? logged + ", RequestId=" + (String)request.getHeaders().get((Object)this.requestIdHeaderKey).get(0) : logged + ", Method=" + request.getMethod() + ", URI=" + request.getURI();
        if (this.traceResponseHeaders) {
            logged = logged + ", Headers=" + response.getHeaders();
        }
        if (this.traceResponseBody && response.getBody() != null) {
            String responseBody = StreamUtils.copyToString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8);
            logged = logged + ", Body=" + responseBody;
        }
        logged = logged + ", Time=" + elapsedTime + " ms";
        logger.info(logged);
    }
}

